/* shellexec.c -- a simple interface to Windows32 ShellExecute. This
   combined with WinExec extension, is a life-saver!

   Mumit Khan <khan@xraylith.wisc.edu>  */

#ifdef _WIN32

#include <tcl.h>
#include <windows.h>

#ifdef __CYGWIN__
#include <limits.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
extern int cygwin_conv_to_full_win32_path (const char *path, char *win32_path);
#endif

static int
shellexec_command (ClientData clientData, Tcl_Interp *interp,
		   int argc, char *argv[])
{
  char *operation;
  char *file;
  char *param;
  char *dir;
  char *tmpbuf;
  int ret;

  if (argc < 3 || argc > 5)
    {
      Tcl_AppendResult(interp, "wrong # args:  should be \"", argv[0], 
                       " operation file ?parameters? ?directory?\"", NULL);

      return TCL_ERROR;
    }

  operation = (*argv[1]) ? argv[1] : NULL;
  file = argv[2];
  
  if (argc > 3)
    param = (*argv[3]) ? argv[3] : NULL;
  else
    param = NULL;

  if (argc > 4)
    dir = (*argv[4]) ? argv[4] : NULL;
  else
    dir = NULL;


#ifdef __CYGWIN__
  /* We need to make sure that file and pathnames are native! But there
     is caveat: caveat: cygwin_conv_to_full_win32_path returns odd result
     when the filename is not absolute and we're not on the system drive. */

  tmpbuf = (char *) alloca (PATH_MAX + 1);

  if (file[0] == '/' || file[0] == '\\' 
      || (file[0] == '.' 
          && (! file[1] ||  file[1] == '/' || file[1] == '\\')))
    {
      if (cygwin_conv_to_full_win32_path (file, tmpbuf))
	file = argv[2];
      else
	{
	  file = (char *) alloca (strlen (tmpbuf) + 1);
	  strcpy (file, tmpbuf);
	}
    }

  if (dir)
    {
      if (cygwin_conv_to_full_win32_path (dir, tmpbuf))
	dir = argv[4];
      else 
        {
	  dir = (char *) alloca (strlen (tmpbuf) + 1);
	  strcpy (dir, tmpbuf);
	  /* FIXME/HACK: This is to get around the Cygwin API problem
	     where //c returns c:, not c:/. Argh.  */
	  if (isalpha (dir[0]) && dir[1] == ':' && dir[2] == '\0')
	    strcat (dir, "\\");
        }
    }

#endif

  ret = (int)ShellExecute(NULL, operation, file, param, dir, SW_SHOWNORMAL);
  if (ret <= 32)
    {
      Tcl_AppendResult(interp, strerror (ret), NULL);
      return TCL_ERROR;
    }
  return TCL_OK;
}

static char version_string[] = "0.9";

int __declspec(dllexport)
Shellexec_Init (Tcl_Interp *interp)
{
  if (Tcl_PkgRequire(interp, "Tcl", TCL_VERSION, 0) == NULL 
      || Tcl_PkgProvide (interp, "shellexec", version_string) != TCL_OK)
    return TCL_ERROR;

  if (Tcl_CreateCommand (interp, "shellexec", shellexec_command,
			 NULL, NULL) == NULL)
    return TCL_ERROR;

  return TCL_OK;
}

#endif /* _WIN32 */

