dnl--------------------------------------------------------------------
dnl Copyright 1996-1998 Mumit Khan <khan@xraylith.wisc.edu>
dnl All rights reserved.
dnl
dnl You can use and distribute this software under the terms of the license
dnl you should have received along with this software.
dnl--------------------------------------------------------------------
dnl
dnl "EXTENDED" FORTRAN. This is the kind that accepts .F files and
dnl pre-processes the files before actually compiling it.
dnl
dnl CXRL_LANG_EXT_FORTRAN()
AC_DEFUN(CXRL_LANG_EXT_FORTRAN,
[define([AC_LANG], [EXT_FORTRAN])dnl
ac_ext=F
ac_cpp='echo $FC_CPP -D__DUMMY_CPP_DEFINE__ $CPPFLAGS 1>&AC_FD_CC;
$FC_CPP $CPPFLAGS'
ac_compile='echo ${FC-f77} -c -D__DUMMY_CPP_DEFINE__ $FFLAGS $CPPFLAGS fconftest.$ac_ext 1>&AC_FD_CC;
${FC-f77} -c -D__DUMMY_CPP_DEFINE__ $FFLAGS $CPPFLAGS fconftest.$ac_ext 1>&AC_FD_CC 2>&AC_FD_CC'
ac_link='echo ${FC-f77} -o conftest $FFLAGS $CPPFLAGS $LDFLAGS fconftest.$ac_ext $LIBS 1>&AC_FD_CC;
${FC-f77} -o conftest $FFLAGS $CPPFLAGS $LDFLAGS fconftest.$ac_ext $LIBS 1>&AC_FD_CC 2>&AC_FD_CC'
])
dnl
dnl FORTRAN 77. This is the kind that accepts .f files. 
dnl
dnl CXRL_LANG_FORTRAN()
AC_DEFUN(CXRL_LANG_FORTRAN,
[define([AC_LANG], [FORTRAN])dnl
ac_ext=f
ac_cpp='echo No CPP defined for .f files;'
ac_compile='echo ${FC-f77} -c $FFLAGS fconftest.$ac_ext 1>&AC_FD_CC;
${FC-f77} -c $FFLAGS fconftest.$ac_ext 1>&AC_FD_CC 2>&AC_FD_CC'
ac_link='echo ${FC-f77} -o conftest $FFLAGS $LDFLAGS fconftest.$ac_ext $LIBS 1>&AC_FD_CC;
${FC-f77} -o conftest $FFLAGS $LDFLAGS fconftest.$ac_ext $LIBS 1>&AC_FD_CC 2>&AC_FD_CC'
])
dnl
dnl
dnl CXRL_TRY_F77_COMPILE(SUBROUTINE-BODY,
dnl             [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
AC_DEFUN(CXRL_TRY_F77_COMPILE,
[
AC_LANG_SAVE
CXRL_LANG_FORTRAN
cat > fconftest.$ac_ext <<EOF
        program conftest
       	stop
       	end
c
c test subroutine.
c       	
        subroutine tsub
        [$1]
       	return
       	end
EOF
if AC_TRY_EVAL(ac_compile); then
  ifelse([$2], , :, [rm -rf fconftest*
  $2])
ifelse([$3], , , [else
  rm -rf fconftest*
  $3
])dnl
fi
AC_LANG_RESTORE
rm -f fconftest*]
)
dnl
dnl CXRL_TRY_F77_LINK(SUBROUTINE-BODY,
dnl             [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
AC_DEFUN(CXRL_TRY_F77_LINK,
[
AC_LANG_SAVE
CXRL_LANG_FORTRAN
cat > fconftest.$ac_ext <<EOF
        program conftest
       	stop
       	end
c
c test subroutine.
c       	
        subroutine tsub
        [$1]
       	return
       	end
EOF
if AC_TRY_EVAL(ac_link); then
  ifelse([$2], , :, [rm -rf fconftest*
  $2])
ifelse([$3], , , [else
  rm -rf fconftest*
  $3
])dnl
fi
AC_LANG_RESTORE
rm -f fconftest*]
)
dnl
dnl
dnl CXRL_CHECK_BRAINDEAD_FC_DRIVER([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
AC_DEFUN(CXRL_CHECK_BRAINDEAD_FC_DRIVER,
[
AC_LANG_SAVE
CXRL_LANG_EXT_FORTRAN
# check for braindead FORTRAN compiler driver.
#
# create the include file and such things
#
rm -rf fconftest*
cat > fconftest.inc << EOF
c
c this is a FORTRAN header.
c
#if unix
c
c unix comments.
c
#elif vms
c
c vms comments.
c
#elif mac
c
c MAC comments.
c
#endif
EOF
cat > fconftest.$ac_ext <<EOF
#include "fconftest.inc"
        program fconftest
       	stop
       	end
c
c test subroutine.
c       	
        subroutine tsub
        call foosub
       	return
       	end
EOF
cxrl_nm_check='(${NM-nm} fconftest.o | grep -i foosub) 1>&AC_FD_CC 2>&AC_FD_CC'
if eval $ac_compile && eval $cxrl_nm_check; then
  ifelse([$1], , :, [rm -rf fconftest*
  $1])
ifelse([$2], , , [else
  rm -rf fconftest*
  $2
])dnl
fi
AC_LANG_RESTORE
rm -f fconftest*]
)
dnl
dnl ### Checking for FORTRAN library functions
dnl
dnl CXRL_CHECK_F77_SUBROUTINE(SUBROUTINE, DECL, SUBROUTINE-ARGS,
dnl		[ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
AC_DEFUN(CXRL_CHECK_F77_SUBROUTINE,
[AC_MSG_CHECKING([for F77 SUBROUTINE $1])
AC_CACHE_VAL(cxrl_cv_f77_func_$1,
[CXRL_TRY_F77_LINK([
	$2
	call $1($3)
],
  eval "cxrl_cv_f77_funcc_$1=yes", eval "cxrl_cv_f77_funcc_$1=no")])dnl
if eval "test \"`echo '$cxrl_cv_f77_funcc_'$1`\" = yes"; then
  AC_MSG_RESULT(yes)
  ifelse([$4], , :, [$4])
else
  AC_MSG_RESULT(no)
ifelse([$5], , , [$5
])dnl
fi
])
dnl
dnl Use extra_libpaths variable, if any, set in configure.in via
dnl --with-extra-libraries=dirs switch.
dnl
AC_DEFUN(CXRL_PACKAGE_TCL,
[
dnl If we find Tcl, set the variables found in tclConfig.sh; otherwise set 
dnl no_tcl=yes.
dnl Uses cxrl_ vars as temps to allow command line to override cache and checks.
AC_MSG_CHECKING([for tclConfig.sh])
AC_ARG_WITH(tclConfig,
  [  --with-tclConfig=path   full path to Tcl configuration file tclConfig.sh
                          Example path: /usr/local/lib/tclConfig.sh])

if test "x$with_tclConfig" = xno -o "x$with_tclConfig" = yes; then
  AC_MSG_ERROR([Must specify full path to tclConfig.sh])
fi
dnl user not specified; search standard dirs
if test -z "$with_tclConfig"; then
  AC_CACHE_VAL(cxrl_cv_path_tclConfig,
  [ cxrl_cv_path_tclConfig=""
  cxrl_places=" \
	  $extra_libpaths \
	  $src_root/lib \
	  $build_root/lib \
	  $prefix/lib \
	  /usr/local/lib \
	  /opt/local/lib \
	  /opt/lib \
	  /usr/lib"
  for dir in $cxrl_places; do
    if test -r $dir/tclConfig.sh ; then
      cxrl_cv_path_tclConfig=$dir/tclConfig.sh
      break
    fi
  done

  if test -z "$cxrl_cv_path_tclConfig" ; then
    cxrl_cv_path_tclConfig=""
  fi])dnl
else
  if test -r $with_tclConfig; then
    cxrl_cv_path_tclConfig=$with_tclConfig
  fi
fi
if test -n "$cxrl_cv_path_tclConfig"; then
  AC_MSG_RESULT($cxrl_cv_path_tclConfig)
  . $cxrl_cv_path_tclConfig
  no_tcl=no
  AC_SUBST(TCL_VERSION)
  AC_SUBST(TCL_INCDIR)
  AC_SUBST(TCL_LIBDIR)
  AC_SUBST(TCL_LIB_SPEC)
  AC_SUBST(TCL_DL_LIBS)
else
  AC_MSG_RESULT([Not found])
  AC_MSG_ERROR([Please install Tcl 7.5 or greater and retry.
If you have tclConfig.sh on system, use --with-tclConfig=path option])
fi
])
dnl
dnl Use extra_libpaths variable, if any, set in configure.in via
dnl --with-extra-libraries=dirs switch.
dnl
AC_DEFUN(CXRL_PACKAGE_TK,
[AC_REQUIRE([CXRL_PACKAGE_TCL])dnl
dnl If we find Tk, set the variables found in tkConfig.sh; otherwise set 
dnl no_tk=yes.
dnl Uses cxrl_ vars as temps to allow command line to override cache and checks.
AC_MSG_CHECKING([for tkConfig.sh])

AC_ARG_WITH(tkConfig,
  [  --with-tkConfig=path   full path to Tk configuration file tkConfig.sh
                          Example path: /usr/local/lib/tkConfig.sh])

if test "x$with_tkConfig" = xno -o "x$with_tkConfig" = yes; then
  AC_MSG_ERROR([Must specify full path to tkConfig.sh])
fi
dnl user not specified; search standard dirs
if test -z "$with_tkConfig"; then
  AC_CACHE_VAL(cxrl_cv_path_tkConfig,
  [ cxrl_cv_path_tkConfig=""
  cxrl_places=" \
	  $extra_libpaths \
	  $TCL_PREFIX/lib \
	  $TCL_PACKAGE_PATH \
	  $src_root/lib \
	  $build_root/lib \
	  $prefix/lib \
	  /usr/local/lib \
	  /opt/local/lib \
	  /opt/lib \
	  /usr/lib"
  for dir in $cxrl_places; do
    if test -r $dir/tkConfig.sh ; then
      cxrl_cv_path_tkConfig=$dir/tkConfig.sh
      break
    fi
  done

  if test -z "$cxrl_cv_path_tkConfig" ; then
    cxrl_cv_path_tkConfig=""
  fi])dnl
else
  if test -r $with_tkConfig; then
    cxrl_cv_path_tkConfig=$with_tkConfig
  fi
fi
if test -n "$cxrl_cv_path_tkConfig"; then
  AC_MSG_RESULT($cxrl_cv_path_tkConfig)
  . $cxrl_cv_path_tkConfig
  AC_SUBST(TK_VERSION)
  AC_SUBST(TK_INCDIR)
  AC_SUBST(TK_LIBDIR)
  AC_SUBST(TK_LIB_SPEC)
else
  AC_MSG_RESULT([Not found])
  AC_MSG_ERROR([Please install Tk 4.1 or greater and retry
If you have tkConfig.sh on system, use --with-tkConfig=path option])
fi
])
dnl
dnl INCOMPLETE
dnl
AC_DEFUN(CXRL_PACKAGE_BLT,
[AC_REQUIRE([CXRL_PACKAGE_TK])dnl
AC_MSG_CHECKING(for BLT include file blt.h)
blt_ok=yes
if test -z "$BLT_INCDIR"; then
    AC_CACHE_VAL(cxrl_cv_incdir_blt,
    [ cxrl_cv_incdir_blt=""
    cxrl_places="$ADD_bltINCS \
	    $extra_incpaths \
	    $build_root/include \
	    $TCL_PREFIX/include \
	    $prefix/include \
	    /usr/local/include \
	    /usr/include/blt \
	    /usr/include \
	    $PWD/../blt2.1 \
	    $PWD/../blt \
	    $src_root/src/packages/blt2.1 \
	    $src_root/src/packages/blt"
    for dir in $cxrl_places; do
	if test -r $dir/blt.h ; then
	    cxrl_cv_incdir_blt=$dir
	    break
	fi
    done

    if test -z "$cxrl_cv_incdir_blt" ; then
	AC_MSG_WARN([couldn't find BLT include files. Please fix Config.mk])
	cxrl_cv_incdir_blt="$TCL_PREFIX/include"
	blt_ok=no
    fi])dnl
    BLT_INCDIR="$cxrl_cv_incdir_blt"
fi
AC_MSG_RESULT([Setting BLT_INCDIR as $BLT_INCDIR])
AC_SUBST(BLT_INCDIR)

# Try to get the version numbers from blt.h.

AC_MSG_CHECKING(for BLT version)
if test -n "$blt_ok" = "yes"; then
  blt_major_version=`grep BLT_MAJOR_VERSION $BLT_INCDIR/blt.h | \
    sed 's/^#define.*BLT_MAJOR_VERSION.*\([0-9]*\)/\1/'`
  blt_minor_version=`grep BLT_MINOR_VERSION $BLT_INCDIR/blt.h | \
    sed 's/^#define.*BLT_MINOR_VERSION.*\([0-9]*\)/\1/'`
fi

if test -z "$blt_major_version" -o -z "$blt_minor_version"; then
  AC_MSG_WARN([Trouble getting BLT major and/or minor versions from blt.h])
fi

BLT_VERSION="${blt_major_version}.${blt_minor_version}"
AC_SUBST(BLT_VERSION)
AC_MSG_RESULT([$BLT_VERSION])

dnl user not specified; search standard dirs
if test -z "$with_tkConfig"; then
  AC_CACHE_VAL(cxrl_cv_path_tkConfig,
  [ cxrl_cv_path_tkConfig=""
  cxrl_places=" \
	  $TCL_PREFIX/lib \
	  $TCL_PACKAGE_PATH \
	  $src_root/lib \
	  $build_root/lib \
	  $prefix/lib \
	  /usr/local/lib \
	  /opt/local/lib \
	  /opt/lib \
	  /usr/lib"
  for dir in $cxrl_places; do
    if test -r $dir/tkConfig.sh ; then
      cxrl_cv_path_tkConfig=$dir/tkConfig.sh
      break
    fi
  done

  if test -z "$cxrl_cv_path_tkConfig" ; then
    cxrl_cv_path_tkConfig=""
  fi])dnl
else
  if test -r $with_tkConfig; then
    cxrl_cv_path_tkConfig=$with_tkConfig
  fi
fi
if test -n "$cxrl_cv_path_tkConfig"; then
  AC_MSG_RESULT($cxrl_cv_path_tkConfig)
  . $cxrl_cv_path_tkConfig
else
  AC_MSG_RESULT([Not found])
  AC_MSG_ERROR([Please install Tk 4.1 or greater and retry
If you have tkConfig.sh on system, use --with-tkConfig=path option])
fi
])
dnl ----------------------------------------------------------------------
dnl
dnl Check to see if C++ runtime library is ISO compliant. 
dnl FIXME: This is obviously very simplistic, and trivially fooled.
dnl
dnl CXRL_CXX_ISO_COMPLIANT_LIBRARY
AC_DEFUN(CXRL_CXX_ISO_COMPLIANT_LIBRARY, [
  AC_REQUIRE([AC_PROG_CXX])
  AC_MSG_CHECKING([if C++ library is ISO compliant])
  AC_CACHE_VAL(cxrl_cv_cxx_iso_compliant_library, [
    AC_LANG_SAVE
    AC_LANG_CPLUSPLUS
    rm -f conftest.h
    cat >> conftest.h << EOF
#ifdef __DECCXX
# define __USE_STD_IOSTREAM
#endif
EOF
    for inc in algorithm bitset cassert cctype cerrno cfloat ciso646 \
	climits clocale cmath complex csetjmp csignal cstdarg cstddef \
	cstdio cstdlib cstring ctime cwchar cwctype deque exception \
	fstream functional iomanip ios iosfwd iostream istream iterator \
	limits list locale map memory new numeric ostream queue set \
	sstream stack stdexcept streambuf string strstream typeinfo \
	utility valarray vector; do
      echo "#include <$inc>" >> conftest.h
    done
    AC_TRY_LINK([#include "conftest.h"], [
        std::bitset<50> flags;
        flags.set();
        int digits = std::numeric_limits<unsigned long>::digits;
        digits = 0;
      ],
      cxrl_cv_cxx_iso_compliant_library=yes,
      cxrl_cv_cxx_iso_compliant_library=no
    )
    AC_LANG_RESTORE
  ])
  AC_MSG_RESULT($cxrl_cv_cxx_iso_compliant_library)
  if test $cxrl_cv_cxx_iso_compliant_library = yes; then
    AC_DEFINE(CXX_ISO_COMPLIANT_LIBRARY)
  fi
])
dnl
dnl
dnl
AC_DEFUN(CXRL_PROG_CXX, 
[ 
AC_PROG_CXX
CXRL_PROG_CXX_SUNPRO
CXRL_PROG_CXX_COMPAQ

if test $cxrl_cv_prog_cxx_sunpro = yes; then
  SUNPRO_CXX=yes
else
  SUNPRO_CXX=
fi
if test $cxrl_cv_prog_cxx_compaq = yes; then
  COMPAQ_CXX=yes
else
  COMPAQ_CXX=
fi
AC_SUBST(SUNPRO_CXX)
AC_SUBST(COMPAQ_CXX)
])dnl
dnl
dnl
dnl
AC_DEFUN(CXRL_PROG_CXX_SUNPRO,
[AC_CACHE_CHECK(whether we are using Sun Workshop C++, cxrl_cv_prog_cxx_sunpro,
[dnl The semicolon is to pacify NeXT's syntax-checking cpp.
cat > conftest.C <<EOF
#ifdef __SUNPRO_CC
  yes;
#endif
EOF
if AC_TRY_COMMAND(${CXX-CC} -E conftest.C) | egrep yes >/dev/null 2>&1;
then
  cxrl_cv_prog_cxx_sunpro=yes
else
  cxrl_cv_prog_cxx_sunpro=no
fi])])
dnl
dnl
AC_DEFUN(CXRL_PROG_CXX_COMPAQ,
[AC_CACHE_CHECK(whether we are using Compaq C++, cxrl_cv_prog_cxx_compaq,
[dnl The semicolon is to pacify NeXT's syntax-checking cpp.
cat > conftest.C <<EOF
#ifdef __DECCXX
  yes;
#endif
EOF
if AC_TRY_COMMAND(${CXX-CC} -E conftest.C) | egrep yes >/dev/null 2>&1;
then
  cxrl_cv_prog_cxx_compaq=yes
else
  cxrl_cv_prog_cxx_compaq=no
fi])])
dnl
dnl See whether we need a declaration for a function.
dnl CXRL_NEED_DECLARATION(FUNCTION [, EXTRA-HEADER-FILES])
AC_DEFUN(CXRL_NEED_DECLARATION,
[AC_MSG_CHECKING([whether $1 must be declared])
AC_CACHE_VAL(cxrl_cv_decl_needed_$1,
[AC_TRY_COMPILE([
#ifndef __cplusplus
#include <stdio.h>
#ifdef STRING_WITH_STRINGS
# include <string.h>
# include <strings.h>
#else
# ifdef HAVE_STRING_H
#  include <string.h>
# else
#  ifdef HAVE_STRINGS_H
#   include <strings.h>
#  endif
# endif
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifndef HAVE_RINDEX
#define rindex strrchr
#endif
#ifndef HAVE_INDEX
#define index strchr
#endif
#else /* __cplusplus */
#include <cstdio>
#include <cstring>
#include <cstdlib>
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#endif /* __cplusplus */
$2],
[char *(*pfn) = (char *(*)) $1],
eval "cxrl_cv_decl_needed_$1=no", eval "cxrl_cv_decl_needed_$1=yes")])
if eval "test \"`echo '$cxrl_cv_decl_needed_'$1`\" = yes"; then
  AC_MSG_RESULT(yes)
  cxrl_tr_decl=NEED_DECLARATION_`echo $1 | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
  AC_DEFINE_UNQUOTED($cxrl_tr_decl)
else
  AC_MSG_RESULT(no)
fi
])dnl
dnl
dnl Check multiple functions to see whether each needs a declaration.
dnl CXRL_NEED_DECLARATIONS(FUNCTION... [, EXTRA-HEADER-FILES])
AC_DEFUN(CXRL_NEED_DECLARATIONS,
[for ac_func in $1
do
CXRL_NEED_DECLARATION($ac_func, $2)
done
])
