//
// menu-item.cc: Items in a MENU 
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1994-1996 Mumit Khan
//

// =================================================================== //

#ifdef __BORLANDC__
# include <iostream>
# include <assert>
#else
# include <iostream>
# include <cassert>
#endif

#include "menu-item.h"
#include "utils.h"

// =================================================================== //

MenuItem::MenuItem(
    const string& name, const MenuItemType type, const string& submenu
) : 
   name_(name), 
   type_(type), 
   submenu_(submenu) 
{ }

MenuItem::~MenuItem() { }

void MenuItem::dump() const {
    cerr 
        << "Dumping item \"" << name() << "\"..." << endl
	<< "\ttype: " << type() << endl
	<< "\tsubmenu: " << submenu() << endl
	<< "done." << endl;
}

// =================================================================== //

TextMenuItem::TextMenuItem(
    const string& name, const string& text, const string& submenu
) : 
    MenuItem(name, TEXT_ITEM, submenu), 
    text_(text)  
{ }

TextMenuItem::~TextMenuItem() { }


void TextMenuItem::dump() const {
    MenuItem::dump();
}

// =================================================================== //

SkipMenuItem::SkipMenuItem(
    const string& name, const string& submenu
) : MenuItem(name, SKIP_ITEM, submenu) { }

SkipMenuItem::~SkipMenuItem() { }

void SkipMenuItem::dump() const {
    MenuItem::dump();
}
// =================================================================== //

DataMenuItem::DataMenuItem(
    const string& name, const string& record, const string& prompt, 
    const string& submenu, const char* flag, unsigned i_flags, int owner1, 
    int owner2
) : 
    MenuItem(name, DATA_ITEM, submenu),
    record_(record),
    prompt_(prompt),
    flag_(strcpy_with_alloc(flag)),
    i_flags_(i_flags),
    owner1_(owner1),
    owner2_(owner2)
{ }

DataMenuItem::~DataMenuItem() { 
    delete[] flag_;
}

void DataMenuItem::dump() const {
    MenuItem::dump();
}

// =================================================================== //

