//
// variable.h: 
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1994-1996 Mumit Khan
//

#ifndef excon_batch_variable_h
#define excon_batch_variable_h

/***************************************************************************/

#include "xrtypes.h"		// for boolean typedef.

/****************************************************************************/

class Stq;
class Value;

/****************************************************************************/

//
//  VARIABLES
//

class Var {
public:
    Var(const char* name, const char* type, Value* val);
    ~Var();
    Var* clone(const char* str) const; 
    Var* clone() const;
    const char* getname() const;
    const char* gettype() const;
    const Value* getval() const;
    Value* genval() const;
    void setval(Value* val);	// deletes the old (ie., current) one.
    void addprop(const char* name);
    bool hasprop(const char* name) const;

private:
    char* name_;		// VARIABLE NAME
    char* type_;		// "integer" OR "real" OR "text" 
				// OR "filename" OR "boolean"
    Value* val_;		// DEFAULT VALUE
    Stq* properties_;		// PROPERTIES (LIST OF char*s)
};


inline const char* Var::getname() const { return name_; }
inline const char* Var::gettype() const { return type_; }
inline const Value* Var::getval() const { return val_; }

/****************************************************************************/

#endif/*excon_batch_variable_h*/
