//
// menu-page.h: MENU pages interface
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1994-1996 Mumit Khan
//

#ifndef lib_menu_page_h
#define lib_menu_page_h

// =================================================================== //

#include <string>
#include <map>
#include <list>

#include "xrtypes.h"
#include "menu-item.h"

// =================================================================== //
//
// MenuPage defines a unique page in the MENU that contains the list of
// MenuItems to be edited/viewed. Typically a MENU has a list of "top
// level" MenuPage's that correspond to various tools' entry points;
// these top level pages then guide the user thru all the other lower
// level pages via navigation buttons.
//
// MenuPage as implemented is not only just a container for a list of 
// MenuItems, it also maintains the logical Relation on various MenuItems
// in the page. These relations are defined by the "SET" statements in
// the current MENU description, and there is one per page that is 
// evaluated on demand.
//
// =================================================================== //

class Menu;
class Relation;
class Beamline;

class MenuPage {
public:
    MenuPage(const Menu* menu, const string& name, const string& title, 
	const string& type = nil
    );
    virtual ~MenuPage();

    void add_item(MenuItem*);
    const MenuItem* find_item(const string& item_name) const;
    const list<string>& get_items() const;
    const char* name() const;
    const char* title() const;
    const char* type() const;

    void set_relation(Relation*);
    int evaluate_flags(const Beamline*);
    bool get_flag_value(const string&) const;

    void dump() const;

private:
    const Menu* menu_;
    string name_;
    string title_;
    string type_;
    map< string, void*, less<string> > item_tab_;
    list<string> item_list_;
    Relation* relation_;
};

// =================================================================== //

#endif/*lib_menu_page_h*/
