C +++
C
C Source: src/utils/post/mirinfo.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: mirinfo.F
C Revision 1.8  1992/01/24  17:49:06  cwelnak
C stupid mistake
C
C Revision 1.7  1992/01/16  09:49:33  cwelnak
C 6000 changes
C
C Revision 1.6  91/07/06  19:43:52  khan
C Grenoble Changes ...
C 
C Revision 1.5  91/04/05  15:50:45  cwelnak
C changed quotes in #includes
C 
C Revision 1.4  91/03/25  15:56:11  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.3  91/03/15  16:04:45  khan
C Getting  ready for sun port...
C 
C Revision 1.2  91/01/25  16:47:27  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:43  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		MIRINFO
C
C	PURPOSE		Returns a readable file of a mirror definition
C			in shadow.
C
C---
     	PROGRAM		MIRINFO
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../../include/common.blk'
c	INCLUDE         './../../include/namelist.blk'
c
c
#	include		<common.blk>
#	include		<namelist.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
     	INCLUDE		'SHADOW$INC:NAMELIST.BLK/LIST'
#endif
     	CHARACTER *40	MIRFIL
     	CHARACTER *80	COMMENT,TITLE
     	CHARACTER *71	TOPLIN
     	DATA	TOPLIN	/
     $'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'/
     	CHARACTER * 32 		FILE_IN,FILE_OUT
     	CHARACTER * 60		FILETEXT
     	CHARACTER * 17		DATETEXT
     	CHARACTER *20		TYPE (12)
     	DATA	TYPE(1)	/'SPHERICAL   '/
     	DATA	TYPE(2)	/'ELLIPTICAL  '/
     	DATA	TYPE(3) /'TOROIDAL    '/
     	DATA	TYPE(4) /'PARABOLICAL '/
     	DATA	TYPE(5)	/'PLANE       '/
     	DATA	TYPE(6) /'CODLING sLIT'/
     	DATA	TYPE(7)	/'HYPERBOLICAL'/
     	DATA	TYPE(8)	/'CONICAL     '/
     	DATA	TYPE(9)	/'POLYNOMIAL  '/
     	GO TO 1
20	WRITE(6,*) 'Error reading the NAMELIST.'
     	STOP
10     	WRITE(6,*) 'Error opening: ',MIRFIL
1	CONTINUE
C#if vms
C     	CALL	LIB$ERASE_PAGE (1,1)
C#endif 
	CALL CLSCREEN
    	WRITE(6,*) 
     $	'-------------------- M I R I N F O ----------------------'
     	WRITE(6,*) 
     $	'                  vs. 3.0 - May 1993 '
     	WRITE(6,*) ' '
     	WRITE(6,*) 
     $'MINFO> Mirror descriptor file. It must be an END.xx type.'
     	WRITE(6,*) 'MINFO> Please input filename: '
     	READ (5,1000)	MIRFIL
1000	FORMAT	(A)
     	IDUMM = 1
     	CALL	RWNAME ( MIRFIL,'R_OE', IDUMM)
     	IF (IDUMM.EQ.-1) GO TO 20
     	IF (IDUMM.EQ.-2) GO TO 10
     	IF (IDUMM.NE.0) STOP 'File non in standard format'
     	WRITE(6,*) 'MINFO> File read correctly.'
     	WRITE(6,*) 'MINFO> Title ?'
     	READ (5,1000) TITLE
     	WRITE(6,*) 'MINFO> Comment ?'
     	READ (5,1000) COMMENT
     	WRITE(6,*) 'MINFO> Output file ?'
     	READ (5,1000)	FILE_OUT
     	WRITE(6,*) 'MINFO> Prepare output to file : ',FILE_OUT
#ifdef vms
     	OPEN (20,FILE=FILE_OUT,STATUS='NEW',CARRIAGECONTROL='LIST')
#else
     	OPEN (20,FILE=FILE_OUT,STATUS='UNKNOWN')
	REWIND(20)
#endif
     	WRITE (20,*) TOPLIN
     	WRITE (20,*) '********************   MIRROR  DESCRIPTION   ',
     $'********************'
     	WRITE (20,*) TOPLIN
     	WRITE (20,*) TITLE
     	WRITE (20,*) COMMENT
     	WRITE (20,*) TOPLIN
     	WRITE (20,*) 'Input file specified:',MIRFIL
#ifdef vms
     	CALL	FILEINFO  (MIRFIL)
     	CALL	NEXTFILE  (FILETEXT,DATETEXT)
#else
	filetext = ' '
	datetext = ' '
	call get_file_text(filetext,MIRFIL)
#endif 
	WRITE (20,1500)	FILETEXT
1500	FORMAT (1X,'Full file Specification :',A)
     	WRITE (20,1501)	DATETEXT
1501	FORMAT (1X,'Creation Date           :',A)
     	WRITE (20,*)	TOPLIN
     	WRITE (20,2001) TYPE(FMIRR)
2001	FORMAT (/,1X,
C      123456789 123456789 123456789 123456789 
     $'Surface figure was defined as:',T40,A)
     	IF (FCYL.EQ.0) THEN
     	  WRITE (20,*)
     $'Cylindrical figure                      NO'
     	ELSE
     	  WRITE (20,*)
     $'Cylindrical figure                      YES'
     	  WRITE (20,*)
     $'Cylinder axis angle from X-axis        ',CIL_ANG*TODEG
     	END IF

	IF (F_ROUGHNESS.EQ.1) THEN
	WRITE (20,*) 
     $'Roughness on from                      ',FILE_ROUGH
	WRITE (20,*)
     $'RMS in Y (angstroms)                   ',ROUGH_Y
	WRITE (20,*)
     $'RMS in X (angstroms)                   ',ROUGH_X
	ENDIF

     	IF (F_REFRAC.EQ.0) THEN
     	  WRITE (20,*)
     $'Element type                            REFLECTOR'
     	ELSE
     	  WRITE (20,*)
     $'Element type                            REFRACTOR'
     	END IF


     	IF (F_GRATING.EQ.0.AND.F_CRYSTAL.EQ.0) THEN
	  IF (F_FACET.EQ.1) THEN
	    WRITE (20,*) 
     $'Element type                       Faceted Mirror'
	    WRITE (20,*) 
     $'Facet size (X)                         ',RFAC_LENX
	    WRITE (20,*) 
     $'Facet size (Y)                         ',RFAC_LENY
	    WRITE (20,*) 
     $'Facet polynomial from                  ',FILE_FAC
	    IF (F_POLSEL.EQ.3) THEN
	    WRITE (20,*) 
     $'Intercept used                         CLOSEST'
	    ELSE IF (F_POLSEL.EQ.2) THEN
	    WRITE (20,*) 
     $'Intercept used                         2nd CLOSEST'
	    ELSE IF (F_POLSEL.EQ.1) THEN
	    WRITE (20,*) 
     $'Intercept used                         2nd FARTHEST'
	    ELSE IF (F_POLSEL.EQ.4) THEN
	    WRITE (20,*) 
     $'Intercept used                         FARTHEST'
	    ENDIF
          ELSE IF (F_KOMA.EQ.1) THEN
	  WRITE (20,*) 
     $'Element type                Multi-bounce Tube Array'
	    IF (F_KOMA_CA.EQ.1) THEN
	  WRITE (20,*)
     $'Paramters from                              ',FILE_KOMA_CA
	  WRITE (20,*) 
     $'Tube radii specified as (r(Z))**2'
	    ELSE
	  WRITE (20,*)
     $'Paramters from                              ',FILE_KOMA
	  WRITE (20,*) 
     $'Tube radii specified as r(Z)'
	    ENDIF
	  ENDIF
     	ELSE IF (F_CRYSTAL.EQ.1) THEN
     	WRITE (20,*)
     $'Element type                            CRYSTAL'
     	WRITE (20,*)
     $'Lattice Spacing                        ',D_SPACING
     	WRITE (20,*)
     $'Bragg Reflection from                  ',FILE_REFL
     	IF (F_MOSAIC.EQ.1) THEN
     	WRITE (20,*)
     $'MOSAIC Crystal selected                '
     	WRITE (20,*)
     $'Mosaic crystal spread (st. dev)  [DEG] ',SPREAD_MOS*TODEG
     	WRITE (20,*)
     $'Mosaic crystal thickness [cm]          ',THICKNESS
     	ELSE IF (F_MOSAIC.NE.1) THEN
     	   IF (F_BRAGG_A.EQ.1) THEN
     	   WRITE (20,*)
     $'Asymmetric Cut angle                   ',A_BRAGG*TODEG
     	   END IF
	   IF (F_JOHANSSON.EQ.1) THEN
     	WRITE (20,*)
     $'JOHANSSON Geometry selected            '
	   WRITE (20,*)
     $'Johansson radius                        ',R_JOHANSSON
	   END IF
	END IF
        ELSE IF (F_GRATING.EQ.1) THEN
     	 IF (FZP.EQ.1) THEN
     	   WRITE (20,*)
     $'Element type                 Fresnel Zone Plate'
     	 END IF
     	  WRITE (20,*)
     $'Element type                            GRATING'
     	  WRITE (20,*)
     $'Order choosen ( inside are < 0 )       ',ORDER
     	 IF (F_CENTRAL.EQ.1) THEN
     	  WRITE (20,*)
     $'Automatic Tuning                        YES'
     	  IF (F_MONO.EQ.0.AND.F_CRYSTAL.EQ.0) THEN
     	WRITE (20,*)
     $'Mount                                   SEYA / TGM'
     	  ELSE IF (F_MONO.EQ.0.AND.F_CRYSTAL.EQ.1) THEN
     	WRITE (20,*)
     $'Mount                                   BRAGG'
     	  ELSE IF (F_MONO.EQ.1) THEN
     	  WRITE (20,*)
     $'Mount                                   ERG'
     	  ELSE IF (F_MONO.EQ.2) THEN
     	  WRITE (20,*)
     $'Mount                                   Const. INCIDENCE'
     	  ELSE IF (F_MONO.EQ.3) THEN
     	  WRITE (20,*)
     $'Mount                                   Const. DIFFRACTION'
     	  ELSE IF (F_MONO.EQ.4) THEN
     	  WRITE (20,*)
     $'Mount                                   Const. BLAZE'
     	  END IF
     	  IF (F_PHOT_CENT.EQ.0) WRITE (20,*)
     $'Grating tuned at  [ eV ]              ',PHOT_CENT
     	  IF (F_PHOT_CENT.EQ.1) WRITE (20,*)
     $'Grating tuned at  [ Angstroms ]       ',R_LAMBDA
     	 ELSE
     	  WRITE (20,*)
     $'Automatic Tuning                        NO'
     	 END IF
     	 IF (F_RULING.EQ.0.AND.F_CRYSTAL.EQ.0) THEN
     	  WRITE (20,*)
     $'Constant ruling [ lines/cm ]           ',RULING
     	 ELSE IF (F_RULING.EQ.1) THEN
     	  WRITE (20,*)
     $'Uniform ruling. At pole [ lines/cm ]   ',RULING
     	 ELSE IF (F_RULING.EQ.2) THEN
     	   WRITE (20,*)
     $'Holographic grating. Recording Wavelength: ',HOLO_W
     	   WRITE (20,2002)
2002	FORMAT (1X,'Input Slit Dist.',T20,'Exit Slit Dist.',
     $	       T40,'Input Slit Angle',T60,'Exit Slit Angle')
     	   WRITE (20,2003)  HOLO_R1,HOLO_R2,HOLO_DEL,HOLO_GAM
2003	FORMAT (1X,G16.9,T20,G16.9,T40,G16.9,T60,G16.9)
     	   WRITE (20,*) 'Input  Slit rotation angle ',HOLO_RT1*TODEG
     	   WRITE (20,*) 'Output Slit rotation angle ',HOLO_RT2*TODEG
     	  IF (F_PW.EQ.0) WRITE (20,*) 'Spherical / Spherical'
     	  IF (F_PW.EQ.1) WRITE (20,*) 'Plane     / Spherical'
     	  IF (F_PW.EQ.2) WRITE (20,*) 'Spherical / Plane'
     	  IF (F_PW.EQ.3) WRITE (20,*) 'Plane     / Plane'
     	  IF (F_PW_C.EQ.0) WRITE (20,*)  'Spherical   / Spherical'
     	  IF (F_PW_C.EQ.1) WRITE (20,*)  'Cylindrical / Spherical'
     	  IF (F_PW_C.EQ.2) WRITE (20,*)  'Spherical   / Cylindrical'
     	  IF (F_PW_C.EQ.3) WRITE (20,*)  'Cylindrical / Cylindrical'
     	  IF (F_VIRTUAL.EQ.0) WRITE (20,*) 'Real      / Real'
     	  IF (F_VIRTUAL.EQ.1) WRITE (20,*) 'Real      / Virtual'
     	  IF (F_VIRTUAL.EQ.2) WRITE (20,*) 'Virtual   / Real'
     	  IF (F_VIRTUAL.EQ.3) WRITE (20,*) 'Virtual   / Virtual'
     	 ELSE IF (F_RULING.EQ.5) THEN
     	  WRITE (20,*) 
     $'Mechanically ruled grating. Polinomial Coefficients: '
     	  WRITE (20,*) 'Zero order term Coefficient: ',RULING
     	  WRITE (20,*) 'First                        ',RUL_A1
     	  WRITE (20,*) 'Second                       ',RUL_A2
     	  WRITE (20,*) 'Third                        ',RUL_A3
     	  WRITE (20,*) 'Fourth                       ',RUL_A4
     	 ELSE IF (F_RULING.EQ.3) THEN
     	  WRITE (20,*) '"Oriental fan" type grating.'
     	  WRITE (20,*) 'Fan pole angle from Y axis         ',AZIM_FAN
     	  WRITE (20,*) '        distance from grating pole ',DIST_FAN
     	  WRITE (20,*) 'Coma correction factor             ',COMA_FAC
     	  WRITE (20,*) 'Line density at grating pole       ',RULING
     	 END IF
     	END IF
     	IF (F_REFRAC.EQ.1) THEN
     	  WRITE (20,*)
     $'Relative Index of Refraction           ',ALFA
     	END IF
     	IF (F_REFLEC.EQ.0) THEN
     	  WRITE (20,*)
     $'Reflectivity                            OFF'
     	ELSE
	 IF (F_REFL.EQ.0) THEN
     	  WRITE (20,*)
     $'Reflectivity      ON     coefficients from: ',FILE_REFL
	 ELSE IF (F_REFL.EQ.1) THEN
	  WRITE (20,*)
     $'Reflectivity      ON     coefficients from TT:'
	 ELSE IF (F_REFL.EQ.2) THEN
	  WRITE (20,*)
     $'Multilayer        ON     coefficients and geometry from : ',
     $FILE_REFL
	 END IF
     	 IF (F_REFLEC.EQ.1) WRITE (20,*)
     $'Polarization dependence                 YES'
     	 IF (F_REFLEC.EQ.2) WRITE (20,*)
     $'Polarization dependence                 NO'
     	END IF
     	IF (FHIT_C.EQ.0) THEN
     	  WRITE (20,*)
     $'Mirror dimensions                       UNLIMITED'
     	ELSE
     	 IF (FSHAPE.EQ.1) THEN
     	  WRITE (20,*)
     $'Mirror dimensions ( rectangular ):'
     	WRITE (20,2005)
2005	FORMAT 
     $(1X,T10,'X plus',T30,'X minus',T50,'Y plus',T70,'Y minus')
     	WRITE (20,2004) RWIDX1,RWIDX2,RLEN1,RLEN2
2004	FORMAT (1X,T10,G12.5,T30,G12.5,T50,G12.5,T70,G12.5)
     	 ELSE IF (FSHAPE.EQ.2) THEN
     	  WRITE (20,*)
     $'Mirror dimensions ( elliptical ) :'
        WRITE (20,2006)
2006	FORMAT (1X,T10,'Major Axis',T30,'Minor axis')
     	WRITE (20,2004) RWIDX2,RLEN2
     	 ELSE IF (FSHAPE.EQ.3) THEN
     	  WRITE (20,*)
     $'Mirror dimensions ( elliptical + hole )'
     	WRITE (20,*) 'A. Outside border:'
        WRITE (20,2006)
     	WRITE (20,2004) RWIDX2,RLEN2
     	WRITE (20,*) 'B. Inner border :'
     	WRITE (20,2006)
     	WRITE (20,2004) RWIDX1,RLEN1
     	 END IF
     	END IF
     	WRITE (20,*) TOPLIN
     	 WRITE (20,*) 'Central Axis parameters :'
     	 WRITE (20,*) 
     $'Source Plane Distance                   ',T_SOURCE
     	 WRITE (20,*)
     $'Image  Plane                            ',T_IMAGE
     	 WRITE (20,*)
     $'Incidence Angle                         ',T_INCIDENCE*TODEG
     	 WRITE (20,*)
     $'Reflection/Diffraction Angle            ',T_REFLECTION*TODEG
     	WRITE (20,*) ' '
     	IF (F_EXT.EQ.1) THEN
     	  WRITE (20,*)
     $'Mirror parameters                       EXTERNAL'
     	ELSE
     	  WRITE (20,*)
     $'Mirror parameters                       COMPUTED'
     	IF (F_DEFAULT.EQ.1) THEN
     	  WRITE (20,*)
     $'Same configuration as Central Axis      YES'
     	ELSE
     	 WRITE (20,*)
     $'Same configuration as Central Axis      NO'
     	END IF
     	  WRITE (20,*)
     $'Objective focus at                      ',SSOUR
     	  WRITE (20,*)
     $'Image focus at                          ',SIMAG
     	  WRITE (20,*)
     $'Incidence angle                         ',THETA*TODEG
     	END IF
     	WRITE (20,*) 'Parameters used follow:'
     	IF (FMIRR.EQ.1) THEN
     	WRITE (20,2010) RMIRR
2010	FORMAT (1X,'Spherical Radius ',T40,G16.9)
     	ELSE IF (FMIRR.EQ.2) THEN
     	WRITE (20,*)'   Semi-major axis  ', AXMAJ
     	WRITE (20,*)'   Semi-minor axis  ', AXMIN
     	WRITE (20,*)'   Semi-focal-length', SQRT(AXMAJ**2-AXMIN**2)
	ECCENT = SQRT(AXMAJ**2-AXMIN**2)/AXMAJ
     	WRITE (20,*)'   Eccentricity     ', ECCENT
C     	WRITE (20,*)'   Semi-focal-length',AFOCI
C     	WRITE (20,*)'   Eccentricity     ', ECCENT
     	ELSE IF (FMIRR.EQ.3) THEN
     	WRITE (20,*)'   Major Radius (optical)    ', R_MAJ+R_MIN
     	WRITE (20,*)'   Minor Radius              ', R_MIN
     	ELSE IF (FMIRR.EQ.4) THEN
     	WRITE (20,*)'   Parabola Param. ', PARAM
     	ELSE IF (FMIRR.EQ.5) THEN
     	WRITE (20,*)'   Plane mirror '
     	ELSE IF (FMIRR.EQ.6) THEN
     	WRITE (20,*)'   Codling Slit'
     	ELSE IF (FMIRR.EQ.7) THEN
     	WRITE (20,*)'   Semi-major axis  ', AXMAJ
     	WRITE (20,*)'   Semi-minor axis  ', AXMIN
	AFOCI = SQRT(AXMIN**2+AXMAJ**2)
	ECCENT = AFOCI/ABS(AXMAJ)
     	WRITE (20,*)'   Semi-focal-length',AFOCI
     	WRITE (20,*)'   Eccentricity     ', ECCENT
     	ELSE IF (FMIRR.EQ.8) THEN
     	WRITE (20,*)'   Cone half-angle  ',CONE_A*TODEG
	ELSE IF (FMIRR.EQ.9) THEN
	WRITE (20,*)'   Polynomial Coeff file   ',FILE_MIR
     	END IF
     	IF (FSTAT.EQ.0) THEN
     	WRITE (20,*)
     $'Source of this O.E. moved               NO'
     	ELSE
     	WRITE (20,*)
     $'Source of this O.E. moved               YES'
     	WRITE (20,*) 'In SOURCE reference frame: '
     	WRITE (20,*) 'Source Movement X: ',X_SOUR
     	WRITE (20,*) '                Y: ',Y_SOUR
     	WRITE (20,*) '                Z: ',Z_SOUR
     	WRITE (20,*) 'Source rotat  X: ',X_SOUR_ROT*TODEG
     	WRITE (20,*) '              Y: ',Y_SOUR_ROT*TODEG
     	WRITE (20,*) '              Z: ',Z_SOUR_ROT*TODEG
     	WRITE (20,*) 'In MIRROR reference frame: '
     	WRITE (20,*) 'Source distance    ',RDSOUR
     	WRITE (20,*) '       rotation    ',ALPHA_S*TODEG
     	WRITE (20,*) 'Incidence angle    ',RTHETA*TODEG
     	WRITE (20,*) 'Source offset X: ',OFF_SOUX
     	WRITE (20,*) '              Y: ',OFF_SOUY
     	WRITE (20,*) '              Z: ',OFF_SOUZ
     	END IF
     	IF (F_MOVE.EQ.0) THEN
     	WRITE (20,*)
     $'Mirror at pole position ( no mov. )     YES'
C       123456789 123456789 123456789 123456789 123456789
     	ELSE
     	WRITE (20,*)
     $'Mirror moved from pole. Parameters :'
     	WRITE (20,*) 'Displacement along X:   ',OFFX
     	WRITE (20,*) '                   Y:   ',OFFY
     	WRITE (20,*) '                   Z:   ',OFFZ
     	WRITE (20,*) 'Rotation around X:   ',X_ROT*TODEG
     	WRITE (20,*) '                Y:   ',Y_ROT*TODEG
     	WRITE (20,*) '                Z:   ',Z_ROT*TODEG
     	END IF
     	WRITE (20,*) TOPLIN
     	WRITE (20,*)
     $'***************                 E N',
     $' D                  ***************'
     	WRITE (20,*) TOPLIN
     	CLOSE (20)
     	END

	 BLOCK DATA
	 IMPLICIT        REAL*8          (A-E,G-H,O-Z)
	 IMPLICIT        INTEGER*4       (F,I-N)
	 COMMON  /MATHBLK/ PI,TWOPI,PIHALF,TODEG,TORAD,ORIGIN(3),
     $			 X_VRS(3),Y_VRS(3),Z_VRS(3),TOCM,TOANGS

         DATA    PI      /  3.1415 92653 58979 32384 62643 D0 /
         DATA    PIHALF  /  1.5707 96326 79489 66192 31322 D0 /
	 DATA    TWOPI   /  6.2831 85307 17958 64679 25287 D0 /
         DATA 	 TODEG   / 57.2957 79513 08232 08767 98155 D0 /
         DATA    TORAD   /  0.0174 53292 51994 32957 69237 D0 /
	 DATA    TOCM    /  1.239 852    D-4                  /
       	 DATA    TOANGS  /  1.239 852    D+4                  /
	 END

