C +++
C
C Source: src/utils/post/ffresnel.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: ffresnel.F
C Revision 1.6  1992/01/15  16:41:53  cwelnak
C 6000 changes
C
C Revision 1.5  1991/07/06  19:43:52  khan
C Grenoble Changes ...
C
C Revision 1.4  91/04/05  15:50:39  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  15:55:56  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:47:10  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:39  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		FFRESNEL
C
C	PURPOSE		To compute the diffracted image generated by the interf.
C			of a given ray file.
C
C---
     	PROGRAM		FFRESNEL
     	IMPLICIT	REAL*8	(A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
C     	IMPLICIT	REAL*8	(A-H,O-Z)
     	CHARACTER*80	INFILE1,RSTRING
     	DIMENSION	RAY(18,N_DIM)
     	DIMENSION	RDIS(1001)
     	COMPLEX*16	ARG_S,ARG_P,JEI,
     $			STOREX(1001),STOREY(1001),STOREZ(1001)
        REAL*8      	TWOPI, TORAD
     	DATA	TWOPI 	/  6.2831 85307 17958 64769 25287 D0 /
	DATA    TORAD   /  0.0174 53292 51994 32957 69237 D0 /
C
     	JEI	=   (0.0D0,1.0D0)
     	
	CALL CLSCREEN
     	WRITE(6,*) 'Define integration limits [ cm ].'
1     	RMIN	=   RNUMBER	('From               ')
     	RMAX	=   RNUMBER	(' to                ')
	NP	=   IRINT	('No. of points      ')
	STEP	=   ABS(RMAX-RMIN)/(NP-1)
     	IF (NP.GT.1001) THEN
     	  STEP = (RMAX-RMIN)/1000
     	  WRITE(6,*) 'Too small a step. Smallest allowed is ',STEP
     	  GO TO 1
     	END IF
     	ALPHA	=   
     $RNUMBER	('Integration direction [ 0 = x, 90 = z ] ? ')
     	DIST	=  RNUMBER	('Distance from plane [ cm ] ? ')
     	INFILE1 =  RSTRING	('Ray input file ? ')
     	KLOSS	=  IRINT		
     $('[ 0 ] to discard losses, [ 1 ] to keep them. ')
C
	CALL	RBEAM18	(INFILE1,RAY,NCOL,NP1,IFLAG,IERR)
	IF (IERR.NE.0)	STOP 'Error in reading ray file.'
	IF (NCOL.NE.18)	STOP	
     $'The ray file doesn"t contain polarization and phase information.'
	IOVER	=  IYES		
     $	    ('Do you want to override the wavelength in the file ? ')
	IF (IOVER.EQ.1) THEN
     	  WAVE	=  RNUMBER	('New wavelength [ Angs ]  ? ')
     	  QNEW	=   WAVE*1.0D-8
     	  QNEW	=   TWOPI/QNEW
	END IF

C
C Starts integration loop
C
     	WRITE(6,*) 'Files read OK. '
     	FACTOR	=   RNUMBER	('Conversion to [ cm ] factor (*) ? ')
	F_INC	=   IRINT	
     $('Include the S- and P- phase shifts in the computations ?')
	KOUNT	=   0
C First set up the array of image location 
	DO I = 1, NP
	  RDIS(I)	= RMIN + (I-1)*STEP
	  STOREX(I)	= (0.0D0,0.0D0)
	  STOREY(I)	= (0.0D0,0.0D0)
	  STOREZ(I)	= (0.0D0,0.0D0)
	END DO

     	DO J=1,NP1

     	 IF (KLOSS.EQ.0) THEN
     	   IF (RAY(10,J).LT.0.0D0) GO TO 100
     	 END IF
	 IF (IOVER.EQ.0) THEN
	   QVEC	= RAY(11,J)
	 ELSE
	   QVEC = QNEW
	 END IF
     	 KOUNT = KOUNT + 1

     	 DO K=1,NP
     	   RR_X	=   RDIS(K)*COS(TORAD*ALPHA)
     	   RR_Z	=   RDIS(K)*SIN(TORAD*ALPHA)
     	   VEC1 =   RR_X - RAY(1,J)*FACTOR
     	   VEC2 =   RR_Z - RAY(3,J)*FACTOR
     	   RR	=   SQRT(VEC1**2 + DIST**2 + VEC2**2)
     	   R 	=   RAY (13,J)*FACTOR
** Common factor in front of the exponential :
	   FACTOR_INC	= RAY(5,J) + DIST/RR
	   FACTOR_NOR	= FACTOR_INC*QVEC/TWOPI/R/RR
** Exponential factor :
	   IF (F_INC.EQ.1) THEN
     	     ARG_S	=   ((RR+R)*QVEC + RAY(14,J))*JEI
     	     ARG_P	=   ((RR+R)*QVEC + RAY(15,J))*JEI
	   ELSE
	     ARG_S	=   (RR+R)*QVEC*JEI
     	     ARG_P	=   (RR+R)*QVEC*JEI
	   END IF

     	   ARG_S	=   EXP(ARG_S)
	   ARG_S	=   FACTOR_NOR*ARG_S
     	   ARG_P	=   EXP(ARG_P)
	   ARG_P	=   FACTOR_NOR*ARG_P

     	   STOREX(K) = STOREX(K) + (ARG_S*RAY(7,J) + ARG_P*RAY(16,J))
     	   STOREY(K) = STOREY(K) + (ARG_S*RAY(8,J) + ARG_P*RAY(17,J))
     	   STOREZ(K) = STOREZ(K) + (ARG_S*RAY(9,J) + ARG_P*RAY(18,J))

     	 END DO
100	END DO
#ifdef vms
	OPEN	(20, FILE='FFPAR',STATUS='NEW',CARRIAGECONTROL='LIST')
#else
     	OPEN	(20, FILE='FFPAR', STATUS='UNKNOWN')
	REWIND (20)
#endif
     	  WRITE (20,*) 'From ',RMIN,' to ',RMAX
	  WRITE (20,*) '     Step ',STEP
     	  WRITE (20,*) 'Wavelength ',WAVE,' angs.'
     	  WRITE (20,*) 'Image located at ',DIST
	  WRITE (20,*) 'Integration direction ',ALPHA
     	  WRITE (20,*) 'Scale factor [ units ] * ',FACTOR,' = [ cm ]'
     	 IF (KLOSS.EQ.0) THEN
     	  WRITE (20,*) 'Losses: NOT INCLUDED'
     	 ELSE
     	  WRITE (20,*) 'Losses:     INCLUDED'
     	 END IF
	 IF (F_INC.EQ.1) THEN
	  WRITE (20,*) 'S- and P- phase shifts :     INCLUDED'
	 ELSE
	  WRITE (20,*) 'S- and P- phase shifts : NOT INCLUDED'
	 END IF
     	  WRITE (20,*) 'Files used: ',INFILE1
     	CLOSE   (20)
#ifdef vms
     	OPEN	(20, FILE='FFRESNEL', STATUS='NEW')
#else
     	OPEN	(20, FILE='FFRESNEL', STATUS='UNKNOWN')
	REWIND (20)
#endif
     	DO K=1,NP
     	  RIMAG = (ABS(STOREX(K)))**2 + (ABS(STOREY(K)))**2
     $		  + (ABS(STOREZ(K)))**2
     	  WRITE (20,*) RDIS(K),RIMAG/KOUNT
     	END DO
     	CLOSE 	(20)
     	END
