C +++
C
C Source: src/trace/rotsour.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: rotsour.F
C Revision 1.7  1991/07/06  20:07:38  khan
C Grenoble and after. Minor changes
C
C Revision 1.6  91/04/05  15:06:03  cwelnak
C changed quotes on #includes
C 
C Revision 1.5  91/03/22  10:56:10  cwelnak
C SUN version INCLUDE to #include
C 
C Revision 1.4  90/11/13  14:01:58  khan
C Cleanup and SAVE statements
C 
C Revision 1.3  90/07/19  21:38:03  khan
C Put #ifdef's to make it work on BOTH VMS and Ultrix
C 
C Revision 1.2  90/07/14  22:51:19  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.1  90/07/10  14:56:51  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	ROT_SOUR
C
C	PURPOSE		Applies the roto-translation of the SOURCE movements
C			to the beam. This allows a complete decoupling
C			of the system.
C
C	ARGUMENT	[ I ]	RAY	: the beam, as computed by 
C					  SOURCE.
C			[ O ] 	RAY	: the beam, after the source 
C					  movement
C
C---
     	SUBROUTINE	ROT_SOUR (RAY,AP)

#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif

     	DIMENSION	RAY(12,N_DIM), AP(3,N_DIM)
     	DIMENSION	P_IN(3),V_IN(3),P_OUT(3),V_OUT(3),
     $			A_IN(3),A_OUT(3),AP_IN(3),AP_OUT(3)

D	OPEN (33,FILE='ROT_SOUR_IN',STATUS='NEW',FORM='UNFORMATTED')
D	WRITE (33)	RAY_IN
D	CLOSE (33)
     	
     	DO  10 I=1,NPOINT

     	P_IN(1)	=    RAY(1,I)
     	P_IN(2)	=    RAY(2,I)
     	P_IN(3)	=    RAY(3,I)
     	V_IN(1)	=    RAY(4,I)
     	V_IN(2)	=    RAY(5,I)
     	V_IN(3)	=    RAY(6,I)
     	A_IN(1)	=    RAY(7,I)
     	A_IN(2)	=    RAY(8,I)
     	A_IN(3)	=    RAY(9,I)

     	P_OUT(1)=    (P_IN(1) + X_SOUR)*U_SOUR(1) +
     $		     (P_IN(2) + Y_SOUR)*U_SOUR(2) +
     $		     (P_IN(3) + Z_SOUR)*U_SOUR(3)

     	P_OUT(2)=    (P_IN(1) + X_SOUR)*V_SOUR(1) +
     $		     (P_IN(2) + Y_SOUR)*V_SOUR(2) +
     $		     (P_IN(3) + Z_SOUR)*V_SOUR(3)

     	P_OUT(3)=    (P_IN(1) + X_SOUR)*W_SOUR(1) +
     $		     (P_IN(2) + Y_SOUR)*W_SOUR(2) +
     $		     (P_IN(3) + Z_SOUR)*W_SOUR(3)

     	V_OUT(1)=    V_IN(1)*U_SOUR(1) +
     $		     V_IN(2)*U_SOUR(2) +
     $		     V_IN(3)*U_SOUR(3)

     	V_OUT(2)=    V_IN(1)*V_SOUR(1) +
     $		     V_IN(2)*V_SOUR(2) +
     $		     V_IN(3)*V_SOUR(3)

     	V_OUT(3)=    V_IN(1)*W_SOUR(1) +
     $		     V_IN(2)*W_SOUR(2) +
     $		     V_IN(3)*W_SOUR(3)

     	A_OUT(1)=    A_IN(1)*U_SOUR(1) +
     $		     A_IN(2)*U_SOUR(2) +
     $		     A_IN(3)*U_SOUR(3)

     	A_OUT(2)=    A_IN(1)*V_SOUR(1) +
     $		     A_IN(2)*V_SOUR(2) +
     $		     A_IN(3)*V_SOUR(3)

     	A_OUT(3)=    A_IN(1)*W_SOUR(1) +
     $		     A_IN(2)*W_SOUR(2) +
     $		     A_IN(3)*W_SOUR(3)

     	RAY(1,I)	=    P_OUT(1)
     	RAY(2,I)	=    P_OUT(2)
     	RAY(3,I)	=    P_OUT(3)
     	RAY(4,I)	=    V_OUT(1)
     	RAY(5,I)	=    V_OUT(2)
     	RAY(6,I)	=    V_OUT(3)
     	RAY(7,I)	=    A_OUT(1)
     	RAY(8,I)	=    A_OUT(2)
     	RAY(9,I)	=    A_OUT(3)

** Same procedure for AP
	IF (NCOL.EQ.18) THEN
	  AP_IN(1)	= AP(1,I)
	  AP_IN(2)	= AP(2,I)
	  AP_IN(3)	= AP(3,I)

     	  AP_OUT(1)=    AP_IN(1)*U_SOUR(1) +
     $		        AP_IN(2)*U_SOUR(2) +
     $		        AP_IN(3)*U_SOUR(3)

     	  AP_OUT(2)=    AP_IN(1)*V_SOUR(1) +
     $		        AP_IN(2)*V_SOUR(2) +
     $		        AP_IN(3)*V_SOUR(3)

     	  AP_OUT(3)=    AP_IN(1)*W_SOUR(1) +
     $		        AP_IN(2)*W_SOUR(2) +
     $		        AP_IN(3)*W_SOUR(3)

	  AP(1,I)	= AP_OUT(1)
	  AP(2,I)	= AP_OUT(2)
	  AP(3,I)	= AP_OUT(3)
	END IF

10   	CONTINUE

D	OPEN (33,FILE='ROT_SOUR_OUT',STATUS='NEW',FORM='UNFORMATTED')
D	WRITE (33)	RAY
D	CLOSE (33)

     	END
