	subroutine menu_init (unit,unit2,filename)
	implicit integer (a-z)
c++
c	subroutine menu_init (unit,unit2,filename)
c
c  Loads a list of menu definitions into memory
c  Erases any previous menu definitions
c
c	unit		- input/integer
c			  fortran i/o unit to use (permanently open)
c
c	unit2		- input/integer
c			  fortran i/o unit to use for load/save commands
c
c	filename	- input/string
c			  filename
c--
	character*(*) filename
c
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "syn.inc"
#       include "menu.inc"
#       include "nl1data.inc"
#       include "verb.inc"
#       include "io.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'syn.inc'
	include 'menu.inc'
	include 'nl1data.inc'
	include 'verb.inc'
	include 'io.inc'
#endif
c
c  copy fortran unit number to use
c
	menu_unit=unit
	menu_unit2=unit2
c
c  zero counters
c
	n_menu=0
	n_detail=0
	n_nl1data=0
	n_syn=0
	n_verb=0
c
c  open table file
c
#ifdef vms
	open (unit=menu_unit,name=filename,defaultfile='.MEN',
     *			status='old',readonly)
#else
	open (unit=menu_unit,file=filename,status='old')
#endif
c
c  skip section of file for defaults
c
	call new_record1 ('===',0,0)
c
c  get the synonyms/enumerated types
c
	call read_synonyms
c
c  get the always loaded
c
	call new_record1 (' ',0,0)
c
c  get verbs/modifiers
c
	call read_verb
c
c  get menu definitions
c
	call read_menu
c
	return
	end
