//
// variable.cc: variables in EXCON
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1991-1996 Mumit Khan
//
//

#include <cstdio>
#include <cstdlib>
#include <cstring>

//
// On Linux/glibc2, gettext macro causes problems with Value::gettext()
// in value.h, so we just undefine it here.
//
#ifdef gettext
# undef gettext
#endif

#include "utils.h"
#include "value.h"
#include "variable.h"

using namespace std;

/***************************************************************************/

Var::Var(const char* name, const char* type, Value* val) {
    // WARNING: COPIES ARE MADE OF name AND type; NOT FOR val
    name_ = strcpy_with_alloc(name);
    type_ = strcpy_with_alloc(type);
    val_ = val; 
    properties_ = new Stq;
}

Var::~Var () {
    delete[] name_; name_ = 0;
    delete[] type_; type_ = 0;
    delete val_; val_ = 0;

    // pop()'ing deletes the StqItem in the list. 
    unsigned size = properties_->size();
    while(size--) {
	char* prop = (char*)properties_->pop();
	delete[] prop; prop = 0;
    }
    delete properties_; properties_ = 0;
}

// CREATE A AND RETURN A VALUE OF THE RIGHT TYPE
Value* Var::genval() const {
    Value* newval = 0;
    switch (type_[0]) {
	case 'i' : 
	    newval = new IntegerValue (0);
	    break;
	case 'r' : 
	    newval = new RealValue (0.0);
	    break;
	case 'f' : // FALL THRU
	case 't' : 
	    newval = new TextValue ("INIT!");
	    break;
	case 'b' : 
	    newval = new BooleanValue (0);
	    break;
	default:
	    assume(0);
	    break;
    }
    return newval;
}

Var* Var::addprop(const char* name) {
    char* prop = strcpy_with_alloc(name);
    properties_->enq (prop);
    return this;
}

// RETURN true (1) IF THE VARIABLE HAS THIS PROPERTY...OTHERWISE RETURN false
bool Var::hasprop(const char* name) const {
    bool hasproperty = false;
    for (int i=1;i<=properties_->size();i++) {
	char* prop = (char*)properties_->cycle();
	if (strcmp(prop,name)==0) 
	    hasproperty = true;
    }
    return hasproperty;
}

Var* Var::clone (const char* str) const {
    // RETURN 0 IF str CANNOT IS OF THE WRONG TYPE
    Value* newval = val_->clone (str);
    if (newval == 0) 
	return 0;
    Var* newvar = new Var (name_, type_, newval);
    // COPY PROPERTIES
    for (int i=1;i<=properties_->size();i++) {
	char* prop = (char*)properties_->cycle();
	newvar->addprop (prop);
    }
    return newvar;
}

Var* Var::clone() const {
    Value* newval = val_->clone();
    Var* newvar = new Var (name_, type_, newval);
    // COPY PROPERTIES
    for (int i=1;i<=properties_->size();i++) {
	char* prop = (char*)properties_->cycle();
	newvar->addprop (prop);
    }
    return newvar;
}


void Var::setval(Value* val) { 
    delete val_;  
    val_ = val; 
}

/***************************************************************************/
