C +++
C
C Source: src/lib/zbrent.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: zbrent.f
C Revision 1.2  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.1  90/07/10  14:57:46  khan
C Initial revision
C 
C 
C ---

C   IMSL ROUTINE NAME   - ZBRENT                                        ZBRT0010
C                                                                       ZBRT0020
C-----------------------------------------------------------------------ZBRT0030
C                                                                       ZBRT0040
C   COMPUTER            - VAX/DOUBLE                                    ZBRT0050
C                                                                       ZBRT0060
C   LATEST REVISION     - JANUARY 1, 1978                               ZBRT0070
C                                                                       ZBRT0080
C   PURPOSE             - ZERO OF A FUNCTION WHICH CHANGES SIGN IN A    ZBRT0090
C                           GIVEN INTERVAL (BRENT ALGORITHM)            ZBRT0100
C                                                                       ZBRT0110
C   USAGE               - CALL ZBRENT (F,EPS,NSIG,A,B,MAXFN,IER)        ZBRT0120
C                                                                       ZBRT0130
C   ARGUMENTS    F      - AN EXTERNAL FUNCTION SUBPROGRAM F(X)          ZBRT0140
C                           PROVIDED BY THE USER WHICH COMPUTES F FOR   ZBRT0150
C                           ANY X IN THE INTERVAL (A,B). (INPUT)        ZBRT0160
C                           F MUST APPEAR IN AN EXTERNAL STATEMENT IN   ZBRT0170
C                           THE CALLING PROGRAM                         ZBRT0180
C                EPS    - FIRST CONVERGENCE CRITERION (INPUT).  A ROOT, ZBRT0190
C                           B, IS ACCEPTED IF ABS(F(B)) IS LESS THAN OR ZBRT0200
C                           EQUAL TO EPS.  EPS MAY BE SET TO ZERO.      ZBRT0210
C                NSIG   - SECOND CONVERGENCE CRITERION (INPUT).  A ROOT,ZBRT0220
C                           B, IS ACCEPTED IF THE CURRENT APPROXIMATION ZBRT0230
C                           AGREES WITH THE TRUE SOLUTION TO NSIG       ZBRT0240
C                           SIGNIFICANT DIGITS.                         ZBRT0250
C                A,B    - ON INPUT, THE USER MUST SUPPLY TWO POINTS, A  ZBRT0260
C                           AND B, SUCH THAT F(A) AND F(B) ARE OPPOSITE ZBRT0270
C                           IN SIGN.                                    ZBRT0280
C                           ON OUTPUT, BOTH A AND B ARE ALTERED.  B     ZBRT0290
C                           WILL CONTAIN THE BEST APPROXIMATION TO THE  ZBRT0300
C                           ROOT OF F. SEE REMARK 1.                    ZBRT0310
C                MAXFN  - ON INPUT, MAXFN SHOULD CONTAIN AN UPPER BOUND ZBRT0320
C                           ON THE NUMBER OF FUNCTION EVALUATIONS       ZBRT0330
C                           REQUIRED FOR CONVERGENCE.  ON OUTPUT, MAXFN ZBRT0340
C                           WILL CONTAIN THE ACTUAL NUMBER OF FUNCTION  ZBRT0350
C                           EVALUATIONS USED.                           ZBRT0360
C                IER    - ERROR PARAMETER. (OUTPUT)                     ZBRT0370
C                         TERMINAL ERROR                                ZBRT0380
C                           IER = 129 INDICATES THE ALGORITHM FAILED TO ZBRT0390
C                             CONVERGE IN MAXFN EVALUATIONS.            ZBRT0400
C                           IER = 130 INDICATES F(A) AND F(B) HAVE THE  ZBRT0410
C                             SAME SIGN.                                ZBRT0420
C                                                                       ZBRT0430
C   PRECISION/HARDWARE  - SINGLE AND DOUBLE/H32                         ZBRT0440
C                       - SINGLE/H36,H48,H60                            ZBRT0450
C                                                                       ZBRT0460
C   REQD. IMSL ROUTINES - UERTST,UGETIO                                 ZBRT0470
C                                                                       ZBRT0480
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           ZBRT0490
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      ZBRT0500
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  ZBRT0510
C                                                                       ZBRT0520
C   REMARKS  1.  ON EXIT FROM ZBRENT, WHEN IER=0, A AND B SATISFY THE   ZBRT0530
C                FOLLOWING,                                             ZBRT0540
C                F(A)*F(B) .LE.0,                                       ZBRT0550
C                ABS(F(B)) .LE. ABS(F(A)), AND                          ZBRT0560
C                EITHER ABS(F(B)) .LE. EPS OR                           ZBRT0570
C                ABS(A-B) .LE. MAX(ABS(B),0.1)*10.0**(-NSIG).           ZBRT0580
C                THE PRESENCE OF 0.1 IN THIS ERROR CRITERION CAUSES     ZBRT0590
C                LEADING ZEROES TO THE RIGHT OF THE DECIMAL POINT TO BE ZBRT0600
C                COUNTED AS SIGNIFICANT DIGITS. SCALING MAY BE REQUIRED ZBRT0610
C                IN ORDER TO ACCURATELY DETERMINE A ZERO OF SMALL       ZBRT0620
C                MAGNITUDE.                                             ZBRT0630
C            2.  ZBRENT IS GUARANTEED TO REACH CONVERGENCE WITHIN       ZBRT0640
C                K = (ALOG((B-A)/D)+1.0)**2 FUNCTION EVALUATIONS WHERE  ZBRT0650
C                  D=MIN(OVER X IN (A,B) OF                             ZBRT0660
C                    MAX(ABS(X),0.1)*10.0**(-NSIG)).                    ZBRT0670
C                THIS IS AN UPPER BOUND ON THE NUMBER OF EVALUATIONS.   ZBRT0680
C                RARELY DOES THE ACTUAL NUMBER OF EVALUATIONS USED BY   ZBRT0690
C                ZBRENT EXCEED SQRT(K). D CAN BE COMPUTED AS FOLLOWS,   ZBRT0700
C                  P = AMIN1(ABS(A),ABS(B))                             ZBRT0710
C                  P = AMAX1(0.1,P)                                     ZBRT0720
C                  IF ((A-0.1)*(B-0.1).LT.0.0) P = 0.1                  ZBRT0730
C                  D = P*10.0**(-NSIG)                                  ZBRT0740
C                                                                       ZBRT0750
C   COPYRIGHT           - 1977 BY IMSL, INC. ALL RIGHTS RESERVED.       ZBRT0760
C                                                                       ZBRT0770
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN ZBRT0780
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    ZBRT0790
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        ZBRT0800
C                                                                       ZBRT0810
C-----------------------------------------------------------------------ZBRT0820
C                                                                       ZBRT0830
      SUBROUTINE ZBRENT (F,EPS,NSIG,A,B,MAXFN,IER)                      ZBRT0840
C                                  SPECIFICATIONS FOR ARGUMENTS         ZBRT0850
      INTEGER            NSIG,MAXFN,IER                                 ZBRT0860
      DOUBLE PRECISION   F,EPS,A,B                                      ZBRT0870
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   ZBRT0880
      INTEGER            IC                                             ZBRT0890
      DOUBLE PRECISION   ZERO,HALF,ONE,THREE,TEN,                       ZBRT0900
     1                   T,FA,FB,C,FC,D,E,TOL,RM,S,P,Q,R,RONE,TEMP      ZBRT0910
      DATA               ZERO/0.0D0/,HALF/.5D0/,ONE/1.0D0/,THREE/3.0D0/,ZBRT0920
     1                   TEN/10.0D0/                                    ZBRT0930
C                                  FIRST EXECUTABLE STATEMENT           ZBRT0940
      IER = 0                                                           ZBRT0950
      T = TEN**(-NSIG)                                                  ZBRT0960
      IC = 2                                                            ZBRT0970
      S = A                                                             ZBRT0980
      FA = F(S)                                                         ZBRT0990
      S = B                                                             ZBRT1000
      FB = F(S)                                                         ZBRT1010
C                                  TEST FOR SAME SIGN                   ZBRT1020
      IF (FA*FB.GT.ZERO) GO TO 50                                       ZBRT1030
    5 C = A                                                             ZBRT1040
      FC = FA                                                           ZBRT1050
      D = B-C                                                           ZBRT1060
      E = D                                                             ZBRT1070
   10 IF (DABS(FC).GE.DABS(FB)) GO TO 15                                ZBRT1080
      A = B                                                             ZBRT1090
      B = C                                                             ZBRT1100
      C = A                                                             ZBRT1110
      FA = FB                                                           ZBRT1120
      FB = FC                                                           ZBRT1130
      FC = FA                                                           ZBRT1140
   15 CONTINUE                                                          ZBRT1150
      TOL = T*DMAX1(DABS(B),0.1D0)                                      ZBRT1160
      RM = (C-B)*HALF                                                   ZBRT1170
C                                  TEST FOR FIRST CONVERGENCE CRITERIA  ZBRT1180
      IF (DABS(FB).LE.EPS) GO TO 40                                     ZBRT1190
C                                  TEST FOR SECOND CONVERGENCE CRITERIA ZBRT1200
      IF (DABS(C-B).LE.TOL) GO TO 40                                    ZBRT1210
C                                  CHECK EVALUATION COUNTER             ZBRT1220
      IF (IC.GE.MAXFN) GO TO 45                                         ZBRT1230
C                                  IS BISECTION FORCED                  ZBRT1240
      IF (DABS(E).LT.TOL) GO TO 30                                      ZBRT1250
      IF (DABS(FA).LE.DABS(FB)) GO TO 30                                ZBRT1260
      S = FB/FA                                                         ZBRT1270
      IF (A.NE.C) GO TO 20                                              ZBRT1280
C                                  LINEAR INTERPOLATION                 ZBRT1290
      P = (C-B)*S                                                       ZBRT1300
      Q = ONE-S                                                         ZBRT1310
      GO TO 25                                                          ZBRT1320
C                                  INVERSE QUADRATIC INTERPOLATION      ZBRT1330
   20 Q = FA/FC                                                         ZBRT1340
      R = FB/FC                                                         ZBRT1350
      RONE = R-ONE                                                      ZBRT1360
      P = S*((C-B)*Q*(Q-R)-(B-A)*RONE)                                  ZBRT1370
      Q = (Q-ONE)*RONE*(S-ONE)                                          ZBRT1380
   25 IF (P.GT.ZERO) Q = -Q                                             ZBRT1390
      IF (P.LT.ZERO) P = -P                                             ZBRT1400
      S = E                                                             ZBRT1410
      E = D                                                             ZBRT1420
C                                  IF ABS(P/Q).GE.75*ABS(C-B) THEN      ZBRT1430
C                                     FORCE BISECTION                   ZBRT1440
      IF (P+P.GE.THREE*RM*Q) GO TO 30                                   ZBRT1450
C                                  IF ABS(P/Q).GE..5*ABS(S) THEN FORCE  ZBRT1460
C                                     BISECTION. S = THE VALUE OF P/Q   ZBRT1470
C                                     ON THE STEP BEFORE THE LAST ONE   ZBRT1480
      IF (P+P.GE.DABS(S*Q)) GO TO 30                                    ZBRT1490
      D = P/Q                                                           ZBRT1500
      GO TO 35                                                          ZBRT1510
C                                  BISECTION                            ZBRT1520
   30 E = RM                                                            ZBRT1530
      D = E                                                             ZBRT1540
C                                  INCREMENT B                          ZBRT1550
   35 A = B                                                             ZBRT1560
      FA = FB                                                           ZBRT1570
      TEMP = D                                                          ZBRT1580
      IF (DABS(TEMP).LE.HALF*TOL) TEMP = DSIGN(HALF*TOL,RM)             ZBRT1590
      B = B+TEMP                                                        ZBRT1600
      S = B                                                             ZBRT1610
      FB = F(S)                                                         ZBRT1620
      IC = IC+1                                                         ZBRT1630
      IF (FB*FC.LE.ZERO) GO TO 10                                       ZBRT1640
      GO TO 5                                                           ZBRT1650
C                                  CONVERGENCE OF B                     ZBRT1660
   40 A = C                                                             ZBRT1670
      MAXFN = IC                                                        ZBRT1680
      GO TO 9005                                                        ZBRT1690
C                                  MAXFN EVALUATIONS                    ZBRT1700
   45 IER = 129                                                         ZBRT1710
      A = C                                                             ZBRT1720
      MAXFN = IC                                                        ZBRT1730
      GO TO 9000                                                        ZBRT1740
C                                  TERMINAL ERROR - F(A) AND F(B) HAVE  ZBRT1750
C                                  THE SAME SIGN                        ZBRT1760
   50 IER = 130                                                         ZBRT1770
      MAXFN = IC                                                        ZBRT1780
 9000 CONTINUE                                                          ZBRT1790
      CALL UERTST (IER,6HZBRENT)                                        ZBRT1800
 9005 RETURN                                                            ZBRT1810
      END                                                               ZBRT1820
