/*
 * 
 * Author: Mumit Khan <khan@xraylith.wisc.edu>
 *
 * Source: src/utils/io/hash.h
 *
 * Log:	hash.h
 * Revision 1.3  90/08/30  18:03:05  khan
 * About to add my own hashing routines.
 * 
 * Revision 1.2  90/08/21  20:50:47  khan
 * Added allocation rules to the hash tables. Specified at creation 
 * time.
 * 
 * Revision 1.1  90/08/18  18:41:46  khan
 * Initial revision
 * 
 *
 */

/*
 * All the hashing stuff for EXCON parameter reader/writer. I was using the
 * ones provided in libc (in ultrix, sysv), but standard BSD (aos) doesn't
 * seem to have it, so I'm doing it myself.
 */

#ifndef _HASH_H
#define _HASH_H



/*
 * The bucket structure for storing the hash key and data. Each bucket is a
 * linked list of items that hash onto the same entry in the hash table.
 */

typedef struct _hbucket_rec {
    char	*key;
    char	*data;
    struct _hbucket_rec	*next;
} hbucket_rec, *hbucket;

/* 
 * The hash table itself. buckets is the array of buckets in the hash
 * table 
 */

typedef struct _htable_rec {
    hbucket_rec	**buckets;
    int		num_buckets;		
    int		num_entries;
    int		alloc_rules;		/* allocate mem for key/data/both? */
} htable_rec, *htable; 


#define NULLBUCKET (hbucket) 0


/* The public routines. */

/* 
 * The allocation rules to be supplied when creating the hash table. When
 * ALLOCATE_NONE is specified, no room is created for either the key or 
 * the data item when adding an item to the hash table, and the hash table
 * key and data point to the actual arguments supplied. For this reason,
 * whenever stuff is added to the table, the address must be supplied, 
 * instead of by value.
 */ 

#define ALLOCATE_KEY	0x1
#define ALLOCATE_DATA	0x2
#define ALLOCATE_BOTH	(ALLOCATE_KEY | ALLOCATE_DATA)
#define ALLOCATE_NONE	~(ALLOCATE_KEY | ALLOCATE_DATA)

hbucket find_hitem ();
hbucket add_hitem ();
hbucket remove_hitem ();
hbucket get_hbucket ();

void delete_htable ();

htable make_htable ();
int hash_key ();

#endif /*_HASH_H*/
