C +++
C
C Source: src/source/id/undul_user_io.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: undul_user_io.F
C Revision 1.4  1991/07/06  20:03:58  khan
C Grenoble and after. Minor changes
C
C Revision 1.3  90/10/30  00:01:48  khan
C Fix Ultrix -> VMS things that got screwed up in VMS -> Ultrix.
C 
C Revision 1.2  90/07/17  23:04:56  khan
C Fixed STATUS=NEW in OPEN statements to UNKNOWN for Unix.
C Substitue pre_rad.blk for PRE_RAD.BLK
C 
C Revision 1.1  90/07/17  15:36:39  khan
C Initial revision
C 
C 
C ---
C+++
C	SUBROUTINE		UNDUL_USER_IO
C
C	PURPOSE			Act as a user friendly input routine 
C				to obtain parameters otherwise defined
C				using a NAMELIST file
C
C	INPUT			see NAMELIST
C
C	OUTPUT			Parameters passed through COMMON block
C
C---
	SUBROUTINE 		UNDUL_USER_IO

	IMPLICIT REAL*8		(A-H,O-Z)
	CHARACTER *80 		RSTRING
C
#if defined(unix) || HAVE_F77_CPP
#	include 	"pre_rad.blk"
#elif defined(vms)
	INCLUDE		'PRE_RAD.BLK/LIST'
#endif 

C
C
	DATA	PI	/  3.1415 92653 58979 32384 62643 D0 /
	DATA	PIHALF	/  1.5707 96326 79489 66192 31322 D0 /
	DATA	TWOPI	/  6.2831 85307 17958 64769 25287 D0 /
	DATA	TODEG	/ 57.2957 79513 08232 08767 98155 D0 /
	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852    D-4		     /
	DATA	TOANGS	/  1.239 852    D+4		     /
C
	c     = 2.998D8		!M/SEC
	e     = 1.602D-19	!COULOMB
	h     = 6.626D-34	!PLANCK'S CONSTANT  JOULE*SEC
	hh    = H/E		!  "         "	    eV*sec
	hbar  = H/TWOPI		!  "         "      joule*sec
	hhbar = HH/TWOPI	!  "	     "	    eV*sec
     	EPSI    = 8.854D-12	!FARAD/METER
     	EPSI_FAC = 16.0D0*PI**3*EPSI*C
     	EPSI_FAC = 1/EPSI_FAC	! {4 pi epsi_0 * 4 pi^2}
C
C23456789112345678921234567893123456789412345678951234567896123456789712
C  read file generated from EPATH
C
     	WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
	WRITE(6,*) ' '
	WRITE(6,*) 'Define Radiation Computational parameters:'
     	WRITE(6,*) ' '
     	WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
     	WRITE(6,*) ' '
	FTRAJ   = RSTRING
     $	('      Enter name of trajectory file from EPATH  (input ) :')
     	WRITE(6,*) ' '
     	WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
C
C Read in trajectory file
C
	CALL	UREAD
C
C Let the user know the parameters from the trajectory file.
C
	  WRITE(6,*) ' '
     	  WRITE(6,*) 'Undulator case.'
	  WRITE(6,*) 
     $	  'Trajectory computed by EPATH with following parameters:'
	  WRITE(6,*) ' '
     	  WRITE(6,*) 'Number of points       :',NPoint
	  WRITE(6,*) 'Undulator wavelength   :',RLAU, 'meters'
	  WRITE(6,*) 'Deflection parameter   :',RK
	  WRITE(6,*) 'Peak magnetic field    :',B0,	'tesla'
	  WRITE(6,*) 'Electron energy	 :',ER/1.602D-19/1.D9, 'GeV'
	  WRITE(6,*) 'Gamma		       :',GA0
     	  WRITE(6,*) '******'
	  WRITE(6,*) 'Fundamental energy     :',ENERGY1/1.602D-19, 'eV'
	  WRITE(6,*) 'Fundamental wavelength :',RLA1*1.0d10, 'Angstrom'
     	  WRITE(6,*) '******'
C
C23456789112345678921234567893123456789412345678951234567896123456789712
C  band pass case:  energy range: EMIN,EMAX,ESTEP
C
     	WRITE(6,*) ' '
     	WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
     	WRITE(6,*) 'Parameters for Radiation Computation. Please note',
     $' value of first harmonic from above table.'
	WRITE(6,*) ' '
     	NCOMP	= IRINT  ('  Enter number of periods: ')
	EMIN    = RNUMBER('        spectrum starting energy [ eV ] : ')
	EMAX    = RNUMBER('                 final           [ eV ] : ')
     	RCURR	= RNUMBER('        electron current         [ A  ] : ')
C
C Inquires about constant bandpass or constant energy interval
C
     	WRITE(6,*) ' '
     	WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
	WRITE(6,*) ' '
     	WRITE(6,*) '      Enter [ 0 ] for constant bandpass'
     	WRITE(6,*) '            [ 1 ]              energy interval'
     	WRITE(6,*) ' '
     	ICOMP	= IRINT ('Choice: ')
     	IF (ICOMP.EQ.0) THEN
     	   BPASS = 
     $       RNUMBER ('      Bandpass [ e.g., for 1% enter 0.01 ] ? ')
     	END IF
C
C Define now angles; 
C
     	WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
     	WRITE(6,*) ' '
	WRITE(6,*)	
     $'Coordinate system uses for describing angular distribution:'
	WRITE(6,*)	'     enter [ 1 ] to use polar     angles'
	WRITE(6,*)	'           [ 2 ]        Cartesian angles'
     	IANGLE	= IRINT ('Choice: ')
     	WRITE(6,*) ' '
	IF (IANGLE.EQ.1) THEN
	   WRITE(6,*)	'The POLAR angle is between radiation and ',
     $	   'undulator axis:'
     	   THEMIN    = RNUMBER('     Minimum POLAR angle [ urad ]: ')
     	   THEMAX    = RNUMBER('     Maximum POLAR angle [ urad ]: ')
	   WRITE(6,*) 'The azmuthal angle is measured from the X-axis:'
	   PHIMIN    = RNUMBER('     Minimum AZMUTHAL angle [ deg ]: ')
	   PHIMAX    = RNUMBER('     Maximum AZMUTHAL angle [ deg ]: ')
C
C Convert all angles to radians
C
	   THEMAX	= THEMAX * 1.0D-6
	   THEMIN	= THEMIN * 1.0D-6
	   PHIMAX	= PHIMAX * TORAD
	   PHIMIN	= PHIMIN * TORAD
C
C Compute power only within the angular limits specified:
C
	   IAPERTURE	= 2	
	ELSE IF (IANGLE.EQ.2) THEN
C selects the cartesian case     	   
	   WRITE(6,*) 'Angle between radiation and undulator axis ',
     $	   'IN undulator plane (i.e., orthogonal to magnetic field) '
     	   WRITE(6,*) '(i.e., in the HORIZONTAL plane)'
	   PHIMIN    = RNUMBER('      from [ urad ]: ')
	   PHIMAX    = RNUMBER('      to   [ urad ]: ')
C
     	   WRITE(6,*) 'Angle between radiation and undulator axis ',
     $ 'NORMAL to undulator plane (i.e., parallel to magnetic field) '
     	   WRITE(6,*) '(i.e., in the VERTICAL plane)'
	   THEMIN    = RNUMBER('      from [ urad ]: ')
	   THEMAX    = RNUMBER('      to   [ urad ]: ')
C
C  convert units (mrad to rad)
C
	   PHIMIN   = PHIMIN*1.0D-6
	   PHIMAX   = PHIMAX*1.0D-6
	   THEMIN   = THEMIN*1.0D-6
	   THEMAX   = THEMAX*1.0D-6
C
C Compute power only within the angular limits specified:  
C
	   IAPERTURE	= 4	
	END IF

     	WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
	WRITE(6,*) ' '
	NE = IRINT ('Enter number of mesh points in energy (odd): ')
	NT = IRINT ('                            in theta  (odd): ')
	NP = IRINT ('                            in phi    (odd): ')
     	WRITE(6,*) ' '
     	WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
     	WRITE(6,*) ' '
C
C Inquire about electron beam divergence
C
	WRITE(6,*)	' '
	I_EDIV	= IYES('Include electron beam divergences [Y/N] ? ')
	IF (I_EDIV.EQ.1) THEN
	  EDIVX	= RNUMBER 
     $('Sigma of electron divergence in the horizontal plane [urad]: ')
	  EDIVY	= RNUMBER
     $('                                    vertical               : ')
	  EDIVX	= EDIVX*1.0D-6
	  EDIVY	= EDIVY*1.0D-6
	END IF
C
C Inquire about output file
C
     	WRITE(6,*) ' '
     	WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
     	WRITE(6,*) ' '
	WRITE(6,*) ' '
     	FOUT=RSTRING('File for data output [e.g., SPECTR.DAT ] ? ')
	IINT =
     $	  IYES('Do you want to integrate the data over the angles ? ')
	IF (IINT.EQ.1) 
     $	  FINT	= RSTRING('File to store angle integrated data: ')
C
C Inquire about frequency of testing cpu time
C
     	WRITE(6,*) ' '
     	WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
     	WRITE(6,*) ' '
	WRITE(6,*) ' '
     	WRITE(6,*) 'The program may output to the screen an update of ',
     $ 'the computations. Please enter how often ', 
     $ '(i.e., every 25, 50, ...) points do you want a report. '
     	NCHECK = IRINT('Report output every ... ? ')
     	WRITE(6,*) ' '
     	WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
     	WRITE(6,*) ' '
	WRITE(6,*) ' '
     	WRITE(6,*) 'All preliminaries completed. Press <Enter> to go.'
	CALL	UREAD
     	IDUMM	=   IRINT ('> ')
	RETURN
	END

