#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C	SUBROUTINE	POLY
C
C	PURPOSE		To compute the intercepts with a general
C			polinomial surface of order up to 4. This
C			include as a special case the torus and all
C          		the conics. However, the calculations are more
C			complex here and the simpler conic and torus
C			case should be used whenever possible
C
C	ALGORITHM	Uses ZRPOLY. The coefficient of the distance
C			of the source point to the surface are computed
C			and passed to ZRPOLY.
C
C	INPUT		XIN:	ray origin 
C			VIN:	ray direction
C			I_RES:  -1, ripple case
C				 1, ordinary case
C
C			NDEG is in common blk
C
C	OUTPUT		ANSWER  distance from point to intercept
C			I_RES	flag: 0 successfull
C				     -1 complex
C
C---
     	SUBROUTINE SPOLY(XIN, VIN, ANSWER, I_RES)
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
	INCLUDE         'SHADOW$INC:COMMON.BLK/LIST'
#endif

     	COMPLEX*16	H_OUTPUT(4)
	INTEGER N_TEST
	DIMENSION	TEST1(4),TEST2(4)
      	DIMENSION	XIN(3), VIN(3)
     	DIMENSION	COEFF(5),TCOEFF(5)
	ANSWER	=   0.0D0
      	X0	= XIN(1)
     	 Y0	= XIN(2)
     	  Z0	= XIN(3)
     	X1	= VIN(1)
     	 Y1	= VIN(2)
     	  Z1	= VIN(3) 
C
     	GO TO (1,2,3,4,5) NDEG+1
5	CONTINUE
C
C This is the  4th degree case
C
     	CTMP	=   0.0D0 
     	CTMP	=   CTMP + PCOEFF(4,0,0) *X1**4
     	CTMP	=   CTMP + PCOEFF(0,4,0) *Y1**4
     	CTMP	=   CTMP + PCOEFF(0,0,4) *Z1**4
     	CTMP	=   CTMP + PCOEFF(0,3,1) *Z1 *Y1**3 
     	CTMP	=   CTMP + PCOEFF(1,0,3) *X1 *Z1**3 
     	CTMP	=   CTMP + PCOEFF(1,3,0) *X1 *Y1**3 
     	CTMP	=   CTMP + PCOEFF(3,0,1) *X1**3 *Z1 
     	CTMP	=   CTMP + PCOEFF(3,1,0) *X1**3 *Y1 
     	CTMP	=   CTMP + PCOEFF(0,1,3) *Y1 *Z1**3 
     	CTMP	=   CTMP + PCOEFF(2,0,2) *X1**2 *Z1**2 
     	CTMP	=   CTMP + PCOEFF(2,2,0) *X1**2 *Y1**2 
     	CTMP	=   CTMP + PCOEFF(0,2,2) *Y1**2 *Z1**2 
     	CTMP	=   CTMP + PCOEFF(1,1,2) *X1 *Y1 *Z1**2 
     	CTMP	=   CTMP + PCOEFF(1,2,1) *X1 *Y1**2 *Z1 
     	CTMP	=   CTMP + PCOEFF(2,1,1) *X1**2 *Y1 *Z1 
C
     	TCOEFF (5) = CTMP
4	CONTINUE
C
C 3th degree
C
     	CTMP	=   0.0D0
     	CTMP	=   CTMP + 4* PCOEFF(4,0,0) *X0 *X1**3 
     	CTMP	=   CTMP + 4* PCOEFF(0,4,0) *Y0 *Y1**3 
     	CTMP	=   CTMP + 4* PCOEFF(0,0,4) *Z0 *Z1**3
     	CTMP	=   CTMP +    PCOEFF(0,0,3) *Z1**3
     	CTMP	=   CTMP +    PCOEFF(0,3,0) *Y1**3
     	CTMP	=   CTMP +    PCOEFF(3,0,0) *X1**3
     	CTMP	=   CTMP +    PCOEFF(0,1,2) *Y1 *Z1**2
     	CTMP	=   CTMP +    PCOEFF(0,1,3) *Y0 *Z1**3
     	CTMP	=   CTMP +    PCOEFF(0,2,1) *Y1**2 *Z1
     	CTMP	=   CTMP +    PCOEFF(0,3,1) *Y1**3 *Z0
     	CTMP	=   CTMP +    PCOEFF(1,0,2) *X1 *Z1**2
     	CTMP	=   CTMP +    PCOEFF(1,0,3) *X0 *Z1**3
     	CTMP	=   CTMP +    PCOEFF(1,2,0) *X1 *Y1**2
     	CTMP	=   CTMP +    PCOEFF(1,3,0) *X0 *Y1**3
     	CTMP	=   CTMP +    PCOEFF(2,0,1) *X1**2 *Z1
     	CTMP	=   CTMP +    PCOEFF(2,1,0) *X1**2 *Y1 
     	CTMP	=   CTMP +    PCOEFF(3,0,1) *X1**3 *Z0
     	CTMP	=   CTMP +    PCOEFF(3,1,0) *X1**3 *Y0
     	CTMP	=   CTMP + 3* PCOEFF(0,1,3) *Y1 *Z0 *Z1**2
     	CTMP	=   CTMP + 2* PCOEFF(0,2,2) *Y1 *Y0 *Z1**2
     	CTMP	=   CTMP + 2* PCOEFF(0,2,2) *Y1**2 *Z0 *Z1
     	CTMP	=   CTMP + 3* PCOEFF(0,3,1) *Y0 *Y1**2 *Z1
     	CTMP	=   CTMP + 3* PCOEFF(1,0,3) *X1 *Z0 *Z1**2
     	CTMP	=   CTMP +    PCOEFF(1,1,1) *X1 *Y1 *Z1
     	CTMP	=   CTMP +    PCOEFF(1,1,2) *X0 *Y1 *Z1**2
     	CTMP	=   CTMP +    PCOEFF(1,1,2) *X1 *Y0 *Z1**2
     	CTMP	=   CTMP +    PCOEFF(1,2,1) *X0 *Y1**2 *Z1
     	CTMP	=   CTMP +    PCOEFF(1,2,1) *X1 *Y1**2 *Z0
     	CTMP	=   CTMP + 3* PCOEFF(1,3,0) *X1 *Y0 *Y1**2
     	CTMP	=   CTMP + 2* PCOEFF(2,0,2) *X0 *X1 *Z1**2
     	CTMP	=   CTMP + 2* PCOEFF(2,0,2) *X1**2 *Z0 *Z1
     	CTMP	=   CTMP +    PCOEFF(2,1,1) *X1**2 *Y0 *Z1
     	CTMP	=   CTMP +    PCOEFF(2,1,1) *X1**2 *Y1 *Z0
     	CTMP	=   CTMP + 2* PCOEFF(2,2,0) *X0 *X1 *Y1**2
     	CTMP	=   CTMP + 2* PCOEFF(2,2,0) *X1**2 *Y0 *Y1
     	CTMP	=   CTMP + 3* PCOEFF(3,0,1) *X0 *X1**2 *Z1
     	CTMP	=   CTMP + 3* PCOEFF(3,1,0) *X0 *X1**2 *Y1
     	CTMP	=   CTMP + 2* PCOEFF(1,1,2) *X1 *Y1 *Z0 *Z1
     	CTMP	=   CTMP + 2* PCOEFF(1,2,1) *X1 *Y0 *Y1 *Z1
     	CTMP	=   CTMP + 2* PCOEFF(2,1,1) *X0 *X1 *Y1 *Z1
C     	
     	TCOEFF (4) = CTMP
3	CONTINUE
C
C 2nd degree
C
     	CTMP	=   0.0D0
     	CTMP	=   CTMP + 6*PCOEFF(4,0,0) *X0**2 *X1**2 
     	CTMP	=   CTMP + 6*PCOEFF(0,4,0) *Y0**2 *Y1**2 
     	CTMP	=   CTMP + 6*PCOEFF(0,0,4) *Z0**2 *Z1**2
     	CTMP	=   CTMP +   PCOEFF(0,0,2) *Z1**2
     	CTMP	=   CTMP +   PCOEFF(0,2,0) *Y1**2
     	CTMP	=   CTMP +   PCOEFF(2,0,0) *X1 *X1
     	CTMP	=   CTMP +   PCOEFF(0,0,3) *3*Z1**2*Z0
     	CTMP	=   CTMP +   PCOEFF(0,1,1) *Y1 *Z1
     	CTMP	=   CTMP +   PCOEFF(0,1,2) *Y0 *Z1**2
     	CTMP	=   CTMP +   PCOEFF(0,2,1) *Y1**2 *Z0
     	CTMP	=   CTMP +   PCOEFF(0,2,2) *Y0**2 *Z1**2
     	CTMP	=   CTMP +   PCOEFF(0,2,2) *Y1**2 *Z0**2
     	CTMP	=   CTMP +   PCOEFF(0,3,0) *3*Y0 *Y1**2
     	CTMP	=   CTMP +   PCOEFF(1,0,1) *X1 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,0,2) *X0 *Z1**2
     	CTMP	=   CTMP +   PCOEFF(1,1,0) *X1 *Y1
     	CTMP	=   CTMP +   PCOEFF(1,2,0) *X0 *Y1**2
     	CTMP	=   CTMP +   PCOEFF(2,0,1) *X1**2 *Z0
     	CTMP	=   CTMP +   PCOEFF(2,0,2) *X0**2 *Z1**2
     	CTMP	=   CTMP +   PCOEFF(2,0,2) *X1**2 *Z0**2
     	CTMP	=   CTMP +   PCOEFF(2,1,0) *X1**2 *Y0
     	CTMP	=   CTMP +   PCOEFF(2,2,0) *X0**2 *Y1**2
     	CTMP	=   CTMP +   PCOEFF(2,2,0) *X1**2 *Y0**2
     	CTMP	=   CTMP +   PCOEFF(3,0,0) *3*X0 *X1**2
     	CTMP	=   CTMP +   PCOEFF(0,1,2) *2*Y1 *Z0 *Z1
     	CTMP	=   CTMP +   PCOEFF(0,1,3) *3*Y0 *Z0 *Z1**2
     	CTMP	=   CTMP +   PCOEFF(0,1,3) *3*Y1 *Z0**2 *Z1
     	CTMP	=   CTMP +   PCOEFF(0,2,1) *2*Y0 *Y1 *Z1
     	CTMP	=   CTMP +   PCOEFF(0,3,1) *3*Y0 *Y1**2 *Z0
     	CTMP	=   CTMP +   PCOEFF(0,3,1) *3*Y0**2 *Y1 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,0,2) *2*X1 *Z0 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,0,3) *3*X0 *Z0 *Z1**2
     	CTMP	=   CTMP +   PCOEFF(1,0,3) *3*X1 *Z0**2 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,1,1) *X0 *Y1 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,1,1) *X1 *Y0 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,1,1) *X1 *Y1 *Z0
     	CTMP	=   CTMP +   PCOEFF(1,1,2) *X0 *Y0 *Z1**2
     	CTMP	=   CTMP +   PCOEFF(1,1,2) *X1 *Y1 *Z0**2
     	CTMP	=   CTMP +   PCOEFF(1,2,0) *2*X1 *Y0 *Y1
     	CTMP	=   CTMP +   PCOEFF(1,2,1) *X0 *Y1**2 *Z0
     	CTMP	=   CTMP +   PCOEFF(1,2,1) *X1 *Y0**2 *Y1
     	CTMP	=   CTMP +   PCOEFF(1,3,0) *3*X0 *Y0 *Y1**2
     	CTMP	=   CTMP +   PCOEFF(1,3,0) *3*X1 *Y0**2 *Y1
     	CTMP	=   CTMP +   PCOEFF(2,0,1) *2*X0 *X1 *Z1
     	CTMP	=   CTMP +   PCOEFF(2,1,0) *2*X0 *X1 *Y1
     	CTMP	=   CTMP +   PCOEFF(2,1,1) *X0**2 *Y1 *Z1
     	CTMP	=   CTMP +   PCOEFF(2,1,1) *X1**2 *Y0 *Z0
     	CTMP	=   CTMP +   PCOEFF(3,0,1) *3*X0 *X1**2 *Z0
     	CTMP	=   CTMP +   PCOEFF(3,0,1) *3*X0**2 *X1 *Z1
     	CTMP	=   CTMP +   PCOEFF(3,1,0) *3*X0 *X1**2 *Y0
     	CTMP	=   CTMP +   PCOEFF(3,1,0) *3*X0**2 *X1 *Y1
     	CTMP	=   CTMP +   PCOEFF(0,2,2) *4*Y0 *Y1 *Z0 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,1,2) *2*X0 *Y1 *Z0 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,1,2) *2*X1 *Y0 *Z0 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,2,1) *2*X0 *Y0 *Y1 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,2,1) *2*X1 *Y0 *Y1 *Z0
     	CTMP	=   CTMP +   PCOEFF(2,0,2) *4*X0 *X1 *Z0 *Z1
     	CTMP	=   CTMP +   PCOEFF(2,1,1) *2*X0 *X1 *Y0 *Z1
     	CTMP	=   CTMP +   PCOEFF(2,1,1) *2*X0 *X1 *Y1 *Z0
     	CTMP	=   CTMP +   PCOEFF(2,2,0) *4*X0 *X1 *Y0 *Y1
C
     	TCOEFF (3) = CTMP
2	CONTINUE
C
C 1st degree
C
     	CTMP	=   0.0D0
     	CTMP	=   CTMP + 4* PCOEFF(4,0,0) *X0**3 *X1 
     	CTMP	=   CTMP + 4* PCOEFF(0,4,0) *Y0**3 *Y1
     	CTMP	=   CTMP + 4* PCOEFF(0,0,4) *Z0**3 *Z1 
     	CTMP	=   CTMP +    PCOEFF(0,0,1) *Z1
     	CTMP	=   CTMP +    PCOEFF(0,1,0) *Y1
     	CTMP	=   CTMP +    PCOEFF(1,0,0) *X1
     	CTMP	=   CTMP + 2* PCOEFF(0,0,2) *Z0 *Z1
     	CTMP	=   CTMP + 3* PCOEFF(0,0,3) *Z0**2 *Z1
     	CTMP	=   CTMP +    PCOEFF(0,1,1) *Y0 *Z1
     	CTMP	=   CTMP +    PCOEFF(0,1,1) *Y1 *Z0
     	CTMP	=   CTMP +    PCOEFF(0,1,2) *Y1 *Z0**2
     	CTMP	=   CTMP +    PCOEFF(0,1,3) *Y0 *Z0**3
     	CTMP	=   CTMP + 2* PCOEFF(0,2,0) *Y0 *Y1
     	CTMP	=   CTMP +    PCOEFF(0,2,1) *Y0**2 *Z1
     	CTMP	=   CTMP + 3* PCOEFF(0,3,0) *Y0**2 *Y1
     	CTMP	=   CTMP +    PCOEFF(0,3,1) *Y0**3 *Z1
     	CTMP	=   CTMP +    PCOEFF(1,0,1) *X0 *Z1
     	CTMP	=   CTMP +    PCOEFF(1,0,1) *X1 *Z0
     	CTMP	=   CTMP +    PCOEFF(1,0,2) *X1 *Z0**2
     	CTMP	=   CTMP +    PCOEFF(1,0,3) *X1 *Z0**3
     	CTMP	=   CTMP +    PCOEFF(1,1,0) *X0 *Y1
     	CTMP	=   CTMP +    PCOEFF(1,1,0) *X1 *Y0
     	CTMP	=   CTMP +    PCOEFF(1,2,0) *X1 *Y0**2
     	CTMP	=   CTMP +    PCOEFF(1,3,0) *X1 *Y0**3
     	CTMP	=   CTMP + 2* PCOEFF(2,0,0) *X0 *X1
     	CTMP	=   CTMP +    PCOEFF(2,0,1) *X0**2 *Z1
     	CTMP	=   CTMP +    PCOEFF(2,1,0) *X0**2 *Y1
     	CTMP	=   CTMP + 3* PCOEFF(3,0,0) *X0**2 *X1
     	CTMP	=   CTMP +    PCOEFF(3,0,1) *X0**3 *Z1
     	CTMP	=   CTMP +    PCOEFF(3,1,0) *X0**3 *Y1
     	CTMP	=   CTMP + 2* PCOEFF(0,1,2) *Y0 *Z0 *Z1
     	CTMP	=   CTMP + 3* PCOEFF(0,1,3) *Y0 *Z0**2 *Z1
     	CTMP	=   CTMP + 2* PCOEFF(0,2,1) *Y0 *Y1 *Z0
     	CTMP	=   CTMP + 2* PCOEFF(0,2,2) *Y0 *Y1 *Z0**2
     	CTMP	=   CTMP + 2* PCOEFF(0,2,2) *Y0**2 *Z0 *Z1
     	CTMP	=   CTMP + 3* PCOEFF(0,3,1) *Y0**2 *Y1 *Z0
     	CTMP	=   CTMP + 2* PCOEFF(1,0,2) *X0 *Z0 *Z1
     	CTMP	=   CTMP + 3* PCOEFF(1,0,3) *X0 *Z0**2 *Z1
     	CTMP	=   CTMP +    PCOEFF(1,1,1) *X0 *Y0 *Z1
     	CTMP	=   CTMP +    PCOEFF(1,1,1) *X0 *Y1 *Z0
     	CTMP	=   CTMP +    PCOEFF(1,1,1) *X1 *Y0 *Z0
     	CTMP	=   CTMP +    PCOEFF(1,1,2) *X0 *Y1 *Z0**2
     	CTMP	=   CTMP +    PCOEFF(1,1,2) *X1 *Y0 *Z0**2
     	CTMP	=   CTMP + 2* PCOEFF(1,2,0) *X0 *Y0 *Y1
     	CTMP	=   CTMP +    PCOEFF(1,2,1) *X0 *Y0**2 *Z1
     	CTMP	=   CTMP +    PCOEFF(1,2,1) *X1 *Y0**2 *Z0
     	CTMP	=   CTMP + 3* PCOEFF(1,3,0) *X0 *Y0**2 *Y1
     	CTMP	=   CTMP + 2* PCOEFF(2,0,1) *X0 *X1 *Z0
     	CTMP	=   CTMP + 2* PCOEFF(2,0,2) *X0 *X1 *Z0**2
     	CTMP	=   CTMP + 2* PCOEFF(2,0,2) *X0**2 *Z0 *Z1
     	CTMP	=   CTMP + 2* PCOEFF(2,1,0) *X0 *X1 *Y0
     	CTMP	=   CTMP +    PCOEFF(2,1,1) *X0**2 *Y0 *Z1
     	CTMP	=   CTMP +    PCOEFF(2,1,1) *X0**2 *Y1 *Z0
     	CTMP	=   CTMP + 2* PCOEFF(2,2,0) *X0 *X1 *Y0**2
     	CTMP	=   CTMP + 2* PCOEFF(2,2,0) *X0**2 *Y0 *Y1
     	CTMP	=   CTMP + 3* PCOEFF(3,0,1) *X0**2 *X1 *Z0
     	CTMP	=   CTMP + 3* PCOEFF(3,1,0) *X0**2 *X1 *Y0
     	CTMP	=   CTMP + 2* PCOEFF(1,1,2) *X0 *Y0 *Z0 *Z1
     	CTMP	=   CTMP + 2* PCOEFF(1,2,1) *X0 *Y0 *Y1 *Z0
     	CTMP	=   CTMP + 2* PCOEFF(2,1,1) *X0 *X1 *Y0 *Z0
C
     	TCOEFF  (2) = CTMP
1	CONTINUE
C
C 0th degree
C
     	CTMP	=   0.0D0
     	CTMP	=   CTMP +   PCOEFF(0,0,0) 
     	CTMP	=   CTMP +   PCOEFF(4,0,0) *X0**4 
     	CTMP	=   CTMP +   PCOEFF(0,4,0) *Y0**4 
     	CTMP	=   CTMP +   PCOEFF(0,0,4) *Z0**4
     	CTMP	=   CTMP +   PCOEFF(0,0,1) *Z0
     	CTMP	=   CTMP +   PCOEFF(0,0,2) *Z0**2
     	CTMP	=   CTMP +   PCOEFF(0,0,3) *Z0**3
     	CTMP	=   CTMP +   PCOEFF(0,1,0) *Y0
     	CTMP	=   CTMP +   PCOEFF(0,2,0) *Y0**2
     	CTMP	=   CTMP +   PCOEFF(0,3,0) *Y0**3
     	CTMP	=   CTMP +   PCOEFF(1,0,0) *X0
     	CTMP	=   CTMP +   PCOEFF(2,0,0) *X0**2
     	CTMP	=   CTMP +   PCOEFF(3,0,0) *X0**3
     	CTMP	=   CTMP +   PCOEFF(0,1,1) *Y0 *Z0
     	CTMP	=   CTMP +   PCOEFF(0,1,2) *Y0 *Z0**2
     	CTMP	=   CTMP +   PCOEFF(0,1,3) *Y0 *Z0**3
     	CTMP	=   CTMP +   PCOEFF(0,2,1) *Y0**2 *Z0
     	CTMP	=   CTMP +   PCOEFF(0,2,2) *Y0**2 *Z0**2
     	CTMP	=   CTMP +   PCOEFF(0,3,1) *Y0**3 *Z0
     	CTMP	=   CTMP +   PCOEFF(1,0,1) *X0 *Z0
     	CTMP	=   CTMP +   PCOEFF(1,0,2) *X0 *Z0**2
     	CTMP	=   CTMP +   PCOEFF(1,0,3) *X0 *Z0**3
     	CTMP	=   CTMP +   PCOEFF(1,1,0) *X0 *Y0
     	CTMP	=   CTMP +   PCOEFF(1,2,0) *X0 *Y0**2
     	CTMP	=   CTMP +   PCOEFF(1,3,0) *X0 *Y0**3
     	CTMP	=   CTMP +   PCOEFF(2,0,1) *X0**2 *Z0
     	CTMP	=   CTMP +   PCOEFF(2,0,2) *X0**2 *Z0**2
     	CTMP	=   CTMP +   PCOEFF(2,1,0) *X0**2 *Y0
     	CTMP	=   CTMP +   PCOEFF(2,2,0) *X0**2 *Y0**2
     	CTMP	=   CTMP +   PCOEFF(3,0,1) *X0**3 *Z0
     	CTMP	=   CTMP +   PCOEFF(3,1,0) *X0**3 *Y0
     	CTMP	=   CTMP +   PCOEFF(1,1,1) *X0 *Y0 *Z0
     	CTMP	=   CTMP +   PCOEFF(1,1,2) *X0 *Y0 *Z0**2
     	CTMP	=   CTMP +   PCOEFF(1,2,1) *X0 *Y0**2 *Z0
     	CTMP	=   CTMP +   PCOEFF(2,1,1) *X0**2 *Y0 *Z0
C
     	TCOEFF (1) = CTMP
D	TYPE *,'TCOEFF = ',TCOEFF
C
C Inverts array for ZRPOLY
C
     	DO I=NDEG+1,1,-1
     	  COEFF(NDEG-I+2) = TCOEFF(I)
     	END DO
D	TYPE *,COEFF
     	CALL 	ZRPOLY (COEFF,NDEG,H_OUTPUT,IER)
C
C Tests for success;
C
D     	TYPE *,IER
     	IF (IER.EQ.130) THEN
C
C if IER=130 degree declared too large; try again;
C
     	  MOVE = 0
     	 DO WHILE (IER.NE.0)
     	   MOVE = MOVE + 1
     	  IF (MOVE.EQ.4) CALL LEAVE ('POLY','ERROR IN POLY',0)
     	  DO I=1,NDEG
     	    TCOEFF(I) = COEFF(I+1)
     	  END DO
     	  DO I=1,NDEG
     	    COEFF(I)=TCOEFF(I)
     	  END DO
D	TYPE *,'MOVE = ',MOVE,COEFF
     	   CALL 	ZRPOLY (COEFF,NDEG,H_OUTPUT,IER)
D	TYPE *,IER
     	 END DO
     	ELSE IF (IER.EQ.131) THEN
C
C fatal error
C
          CALL LEAVE ('POLY','Fatal error.',0)
     	END IF
C
C Tests for reality of intercepts 
C
     	 CHECK = 1
D	TYPE *,H_OUTPUT
     	DO I=1,NDEG
	  TEST1(I)	=DIMAG(H_OUTPUT(I))
     	  CHECK	= CHECK*TEST1(I)	! Complex part
     	END DO
     	IF (CHECK.NE.0.0D0) THEN
C
C All the solutions are complex; the beam is completely out of
C of the mirror.
C
     	  I_RES	= -1
     	  RETURN
     	END IF
C
C At least a good ray;
C
	IF (I_RES.LT.0) THEN
C
C Ripple case : take the closest intercept
C
     	  ANSWER	= 1.0D30
     	  DO I=1,NDEG
       	   TEST = ABS (DIMAG(H_OUTPUT(I)))
     	   IF (TEST.LT.1.0E-14) THEN
	     IF (ABS(DREAL(H_OUTPUT(I))).LT.ABS(ANSWER))
     $     	     ANSWER = DREAL ( H_OUTPUT(I) )
     	   END IF
     	  END DO
	ELSE
C
C Ordinary case : looks for the maximum of the real values; this will set the
C intercept at the fartest sheet of the surface
C
     	  ANSWER	= -1.0D30
     	  DO I=1,NDEG
       	   TEST = ABS (DIMAG(H_OUTPUT(I)))
     	   IF (TEST.LT.1.0E-14) THEN
     	     ANSWER = DMAX1( ANSWER,DREAL ( H_OUTPUT(I) ))
     	   END IF
     	  END DO
	END IF

C
C Seperate the F_POLSEL case with the usual Shadow treatment
C
 
	IF (F_POLSEL.NE.0) THEN
	  N_TEST	= 0
	  DO 299 I = 1, NDEG
		TEMP=DREAL(H_OUTPUT(I))
	    IF (TEST1(I).EQ.0.0D0.AND.TEMP.GE.0.0D0) THEN
         IF (F_KOMA.NE.1) THEN
	      N_TEST		= N_TEST + 1
	      TEST2(N_TEST)	= TEMP
  	 ELSE
	    IF (TEMP.GE.1.0D-10) THEN
	      N_TEST		= N_TEST + 1
	      TEST2(N_TEST)	= TEMP
	    ENDIF
	  END IF
	    ENDIF
299	  CONTINUE
C
C Sort the real intercept in ascending order.
C
	  DO I = 1, N_TEST
	    IMIN	= I
	    AMIN	= TEST2(I)
	    DO J = I, N_TEST
	      IF (TEST2(J).LT.AMIN) THEN
	        AMIN	= TEST2(J)
	        IMIN	= J
	      END IF
	    END DO
	    XTEMP	= TEST2(I)
	    TEST2(I)	= TEST2(IMIN)
	    TEST2(IMIN)	= XTEMP
	  END DO
C
C Pick the output according to F_TORUS.
C
	  IF (F_POLSEL.EQ.4) THEN
	    ANSWER	= TEST2(N_TEST)
	  ELSE IF (F_POLSEL.EQ.1) THEN
	   IF (N_TEST.GT.1) THEN
	    ANSWER	= TEST2(N_TEST-1)
	   ELSE
	    I_RES	= -1
	    RETURN
	   END IF
	  ELSE IF (F_POLSEL.EQ.2) THEN
	   IF (N_TEST.GT.1) THEN
	    ANSWER	= TEST2(2)
	   ELSE
	    I_RES	= -1
	    RETURN
	   END IF
	  ELSE IF (F_POLSEL.EQ.3) THEN
	    ANSWER	= TEST2(1)
	  END IF
	END IF

     	IF (ANSWER.GT.0.0D0.AND.ANSWER.LT.1.0D+20) THEN
     	 I_RES = 1
     	 RETURN
     	ELSE
     	 I_RES	= - 1
     	 RETURN
     	END IF
     	END
