C +++
C
C Source: src/trace/imref.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: imref.F
C Revision 1.7  1991/07/06  20:07:38  khan
C Grenoble and after. Minor changes
C
C Revision 1.6  91/04/05  15:05:48  cwelnak
C changed quotes on #includes
C 
C Revision 1.5  91/03/21  16:19:04  cwelnak
C SUN version -- INCLUDE to #include
C 
C Revision 1.4  90/11/13  14:01:48  khan
C Cleanup and SAVE statements
C 
C Revision 1.3  90/07/19  21:37:49  khan
C Put #ifdef's to make it work on BOTH VMS and Ultrix
C 
C Revision 1.2  90/07/14  22:51:08  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.1  90/07/10  14:56:15  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE 	IMREF
C
C	PURPOSE		Defines the reference frame for IMAGE and SCREEN
C			computes some variables
C
C---
	SUBROUTINE 	IMREF
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
     	DIMENSION	UX_SC(3),WY_SC(3),VZ_SC(3)
C
     	WRITE(6,*)'Call to IMREF'
C
C   Defines some useful variables
C
     	IF (F_PLATE.EQ.1) THEN
     	 THETA_I  =   PIHALF - T_REFLECTION
     	 ALPHA_I  =   0.0D0
     	ELSE
      	 THETA_I  =   THETA_I*TORAD
     	 ALPHA_I  =   ALPHA_I*TORAD
     	END IF

     	SINTHE_I  =   SIN( THETA_I )
     	COSTHE_I  =   COS( THETA_I )
     	SINAL_I   =   SIN( ALPHA_I )
     	COSAL_I   =   COS( ALPHA_I )
C
C   Generates the versor normal to the 'continuation' plane.
C   The angles for the grating case have been established in setsour.
C
     	VNIMAG(1)   =   .0D0
     	VNIMAG(2)   =   SIN( T_REFLECTION )
     	VNIMAG(3)   =   COS( T_REFLECTION )
C
C   Computes the image center for STAR
C
     		RIMCEN(1) =  VNIMAG(1)*T_IMAGE
		RIMCEN(2) =  VNIMAG(2)*T_IMAGE
		RIMCEN(3) =  VNIMAG(3)*T_IMAGE
C
C   Computes the image plane coefficients fo STAR
c
     	C_STAR(1)  =   VNIMAG(1)
     	C_STAR(2)  =   VNIMAG(2)
     	C_STAR(3)  =   VNIMAG(3)
C
C   Computes now the other versors
C
     	UXIM(1)	=   1.0D0
     	UXIM(2) =    .0D0
     	UXIM(3) =    .0D0

     	VZIM(1) =    .0D0
     	VZIM(2) = - COS( T_REFLECTION )
     	VZIM(3) =   SIN( T_REFLECTION )
C
C   Same thing for PLATE
C
     	C_PLATE(1)  = - SINAL_I*COSTHE_I
     	C_PLATE(2)  =   COSAL_I*COSTHE_I
     	C_PLATE(3)  =   SINTHE_I

     	WY_PL(1) =   C_PLATE(1)
     	WY_PL(2) =   C_PLATE(2)
     	WY_PL(3) =   C_PLATE(3)

     	CALL CROSS (C_PLATE,Z_VRS,UX_PL)
     	CALL NORM (UX_PL,UX_PL)
     	CALL CROSS (UX_PL,C_PLATE,VZ_PL)
     	CALL NORM (VZ_PL,VZ_PL)

C
C In the case of the screen, the screen x-versor is always parallel
C to X_VRS. This will also take care ot the normal incidence case
C F.C.-19mar84
C
     	UX_SC(1)	=  UXIM(1)
     	UX_SC(2)	=  UXIM(2)
     	UX_SC(3)	=  UXIM(3)
     	IF (F_SCREEN.EQ.1) THEN
     	 DO 11 I=1,2
     	  IF (I.EQ.1) THEN
     	    WY_SC(1)  =   0.0D0
     	     WY_SC(2)  =   SIN(T_REFLECTION)
     	      WY_SC(3)  =   COS(T_REFLECTION)
     	  ELSE
     	    WY_SC(1)  =   0.0D0
     	     WY_SC(2)  =   SIN(T_INCIDENCE)
     	      WY_SC(3)  = - COS(T_INCIDENCE)
     	  END IF

     	   CALL CROSS 	(UX_SC,WY_SC,VZ_SC)
     	   CALL NORM 	(VZ_SC,VZ_SC)

     	   UX_SCR(1,I)  =   UX_SC(1)
     	    UX_SCR(2,I)  =   UX_SC(2)
     	     UX_SCR(3,I)  =   UX_SC(3)
     	   VZ_SCR(1,I)   =   VZ_SC(1)
     	    VZ_SCR(2,I)   =   VZ_SC(2)
     	     VZ_SCR(3,I)   =   VZ_SC(3)
     	   WY_SCR(1,I)   =   WY_SC(1)
     	    WY_SCR(2,I)   =   WY_SC(2)
     	     WY_SCR(3,I)   =   WY_SC(3)
11     	 CONTINUE

     	ELSE
     	END IF

     	WRITE(6,*)'Exit from IMREF'

     	END
