C +++
C
C Source: src/source/id/uwrite.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: uwrite.F
C Revision 1.6  1992/01/22  22:23:47  cwelnak
C 6000 changes and VMS devel update
C
C Revision 1.5  91/07/06  20:03:58  khan
C Grenoble and after. Minor changes
C 
C Revision 1.4  90/10/30  00:01:53  khan
C Fix Ultrix -> VMS things that got screwed up in VMS -> Ultrix.
C 
C Revision 1.3  90/07/18  19:41:43  khan
C Minor bug fix.
C 
C Revision 1.2  90/07/17  23:05:00  khan
C Fixed STATUS=NEW in OPEN statements to UNKNOWN for Unix.
C Substitue pre_rad.blk for PRE_RAD.BLK
C 
C Revision 1.1  90/07/17  15:36:41  khan
C Initial revision
C 
C 
C ---

C+++
C
C	SUBROUTINE		UWRITE
C
C	PURPOSE			To write the RN and CDF files.
C
C	INPUT:			RN0,RN1,RN2,POL_DEG
C				CDF0,CDF1,CDF2
C---
	SUBROUTINE	UWRITE	(RN0,RN1,RN2,POL_DEG,CDF0,CDF1,CDF2,
     $				 	UPHI,UTHETA,UENER)
	
	IMPLICIT	REAL*8	(A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#	include 	"pre_rad.blk"
#elif defined(vms)
	INCLUDE		'PRE_RAD.BLK/LIST'
#endif

	DIMENSION	UPHI(31,31,51),UTHETA(31,51),UENER(51)
	DIMENSION	RN0(31,31,51),RN1(31,51),RN2(51)
	DIMENSION	CDF0(31,31,51),CDF1(31,51),CDF2(51)
	DIMENSION	POL_DEG(31,31,51)

	CHARACTER*80	RSTRING,FNAME1,FNAME2,SPECFILE
	CHARACTER*60	NAME
	CHARACTER*17	DATE
C
	DATA		FNAME1	/ '     ' /
	DATA		FNAME2	/ '     ' /
	DATA		SPECFILE/ '     ' /
C
C Read in parameters of trajectory file.
C
	   CALL	UREAD
C
C Write RN file
C
	   WRITE(6,*) 'Number of optimizations finished : ',ITER
	   WRITE(6,*) ' '
	   ITYPE = 1
	   IFLAG = IYES ('Do you want to write out spectra ? ')
	   IF (IFLAG.EQ.0) GO TO 10
	   FNAME1 = RSTRING ('Name of file for storing spectra: ')
	   CALL RW_UNDUL ( NP,NT,NE, UPHI, UTHETA, UENER,
     $         RN0, RN1, RN2, POL_DEG,
     $	       FNAME1, ITYPE, IANGLE)
C
10	  CONTINUE

C
C Write CDF file
C
	 ITYPE = 2
	 IFLAG = IYES ('Do you want to create a SHADOW file ? ')
	 IF (IFLAG.EQ.0) GO TO 30
	 FNAME2 = RSTRING ('Name of (binary) file for SHADOW: ')

C
C SHADOW defines the degree of polarization by |E| instead of |E|^2
C i.e.  P = |Ex|/(|Ex|+|Ey|)   instead of   |Ex|^2/(|Ex|^2+|Ey|^2)
C
	 DO 19 K = 1, NE
	   DO 29 J = 1, NT
	     DO 39 I = 1, NP
		TEMP	       = POL_DEG(I,J,K)
		POL_DEG(I,J,K) = SQRT(TEMP)/(SQRT(TEMP)+SQRT(1.D0-TEMP))
39	     CONTINUE
29	   CONTINUE
19	 CONTINUE

	 CALL RW_UNDUL ( NP,NT,NE, UPHI, UTHETA, UENER,
     $       CDF0, CDF1, CDF2, POL_DEG, 
     $       FNAME2, ITYPE, IANGLE)

C
C Create and write a log file.
C
30      SPECFILE	= RSTRING('File name for parameter info : ')
#ifdef vms
      	OPEN  (29,FILE=SPECFILE,STATUS='NEW',CARRIAGECONTROL='LIST')
#else
      	OPEN  (29,FILE=SPECFILE,STATUS='UNKNOWN')
	REWIND (29)
#endif
      	WRITE (29,99)
      	WRITE (29,*) 'Trajectory computed by EPATH with following ',
     $	   'parameters:'
      	WRITE (29,*) 'Number of points : ',
     $					NPoint
      	WRITE (29,*) 'Wavelen. (und)   : ',
     $					RLAU,             ' meters'
      	WRITE (29,*) 'Fundamental wvl  : ',
     $					RLA1*1.0d10,      ' angstroms'
      	WRITE (29,*) 'Fund.    energy  : ',
     $					ENERGY1/1.602D-19,' eV'
      	WRITE (29,*) 'K is             : ',
     $					RK
      	WRITE (29,*) 'Gamma            : ',
     $					GA0
      	WRITE (29,*) 'Beta0            : ',
     $					BETA0,            ' C units'    
     	WRITE (29,*) 'Field B0         : ',
     $					B0,               ' tesla'
	WRITE (29,*) 'Electron energy  : ',
     $					ER/1.602d-19/1.D9,'GeV'
      	WRITE (29,99)
      	WRITE (29,*) 'Read ',NPoint,' trajectory records from ',
     $FTRAJ(1:LTRIM(FTRAJ))
	WRITE (29,*) 'Number periods used in ERAD: ',NCOMP
     	WRITE (29,*) 'Total power radiated in the limits [ W ]: ',
     $					TOTPOWER
     	IF (ICOMP.EQ.0) THEN
     	   write (29,99)
     	   write (29,*) 'Working with band-pass case (units eV) .'
     	   write (29,*) 'band-pass = ',bpass
     	   write (29,*) 'Limits: ',EMIN,EMAX
C     	   write (29,*) 'Step  : ',ESTEP,' Number of points: ',NE
     	   write (29,*) 'Number of points: ',NE
     	   write (29,99)
	ELSE
     	   write (29,99)
     	   write (29,*) 'Working with constant dE (units eV) .'
     	   write (29,*) 'Energy interval = ',ESTEP
     	   write (29,*) 'Limits: ',EMIN,EMAX
C     	   write (29,*) 'Step  : ',ESTEP,' Number of points: ',NE
     	   write (29,*) 'Number of points: ',NE
     	   write (29,99)
C     	   write (29,*) 'Piecewise spectrum choosen: ', KIND(IHARM+1)
C     	   write (29,*) 'From Harmonic: ',N_HARM1,' to ',N_HARM2
C     	   write (29,*) 'Width ',WIDTH,' and Number of points ',NCOMP
	END IF
	  IF (IANGLE.EQ.1) THEN
	      WRITE (29,*) 'POLAR ANGLES CHOSEN    '
	  WRITE (29,*)'Azimutal angle (units rad) .'
     	  WRITE (29,*) 'Limits: ',PHIMIN,PHIMAX
C     	  WRITE (29,*) 'Step  : ',PHISTEP,' Number of points: ',NP
     	  WRITE (29,*) 'Number of points: ',NP
     	  WRITE (29,99)
	  WRITE (29,*)'Polar angle (units mrad) .'
     	  WRITE (29,*) 'Limits: ',THEMIN*1.0D3,THEMAX*1.0D3
C     	  WRITE (29,*) 'Step  : ',THESTEP*1.0D3,' Number of points: ',NT
     	  WRITE (29,*) 'Number of points: ',NT
     	  WRITE (29,*) 'Spectra written into (binary) file: '
	  WRITE (29,*) FNAME1
	  ELSE IF (IANGLE.EQ.2) THEN
	      WRITE (29,*) 'CARTESIAN ANGLES CHOSEN '
	  WRITE (29,*)'Horizontal angle (units mrad) .'
     	  WRITE (29,*) 'Limits: ',PHIMIN*1.0D3,PHIMAX*1.0D3
C     	  WRITE (29,*) 'Step  : ',PHISTEP*1.0D3,' Number of points: ',NP
     	  WRITE (29,*) 'Number of points: ',NP
     	  WRITE (29,99)
	  WRITE (29,*)'Vertical angle (units mrad) .'
     	  WRITE (29,*) 'Limits: ',THEMIN*1.0D3,THEMAX*1.0D3
C     	  WRITE (29,*) 'Step  : ',THESTEP*1.0D3,' Number of points: ',NT
     	  WRITE (29,*) 'Number of points: ',NT
	  WRITE (29,*) 'File for SHADOW (binary) written to:'
	  WRITE (29,*) FNAME2
	  END IF
	  IF (ICOMP.EQ.0) THEN
	    WRITE (29,*) 'in units: PHOTONS/SEC/%Bandpass/RAD**2 '
	  ELSE
	    WRITE (29,*) 'in units: PHOTONS/SEC/eV/RAD**2 '
	  END IF
    	  WRITE (29,99)
C
C
    	WRITE (29,99)
	CLOSE (29)
C
     	write(6,*) '----------------------------',
     $'-----------------------------------------------'
     	write(6,*) ' '
     	write(6,*) 'Files:'
     	write(6,*) specfile
     	write(6,*) fname1
	write(6,*) fname2
     	WRITE(6,*) 'written to disk.'
     	write(6,*) '----------------------------',
     $'-----------------------------------------------'
     	write(6,*) ' '
99	FORMAT (1X,/,'---------------------------------------------',/)
1000	FORMAT	(1X, 3(1X,G12.5), 1X, G15.8)
1010	FORMAT	(1X, 3(1X,G12.5), 3(1X, G15.8) )
1020	FORMAT	(1X, 3(1X,G12.5), 2(1X, G15.8) )
C
	RETURN
	END
