C +++
C
C Source: src/utils/post/old-graphics/h2kol.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: h2kol.F
C Revision 1.6  1991/07/06  19:43:52  khan
C Grenoble Changes ...
C
C Revision 1.5  91/04/05  15:50:41  cwelnak
C changed quotes in #includes
C 
C Revision 1.4  91/03/25  16:05:51  khan
C Added () around PARAMETER statement stuff.
C 
C Revision 1.3  91/03/25  15:56:01  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:47:15  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:41  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C
C	PROGRAM		H2KOL
C
C	PURPOSE		Generates an histogram from a 2-d table
C
C	Link using GRA:GRALIB.LNK or GRA:TDSHARE.LNK
C---
     	PROGRAM		H2KOL
	IMPLICIT        REAL*8          (A-E,G-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#	include 	<dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
C
C CHECK/FIXME:
C The X and Y vectors need to "REAL" for VMS for the Topdrawer calls,
C but REAL*8 for Unix and the rest of the civilized world.
C
	REAL		XARRAY, YARRAY
#endif
        REAL*8		RNUMBER
	CHARACTER*80	FILEIN,RSTRING,FILOUT
     	DIMENSION	XIN (2,10000)
     	DIMENSION	XARRAY(100),YARRAY(100),XTEMP(100)
C
#ifndef vms
	CHARACTER*1024	PRIMVS
	CHARACTER*1024	PRIMVSPATH
#endif

     	FILEIN	=  RSTRING  ('Input file ? ')
C
     	NCOL = IRINT   ('Column to analyze       [ 1 or 2 ] ? ')
     	CENTER = RNUMBER ('Center  ? ')
     	WIDTH	= RNUMBER ('Width ? ')
     	NBIN 	= IRINT ('Number of bins          [ max=100 ] ? ')
     	WRITE(6,*)'Normalization kind. Enter :'
     	WRITE(6,*)'0	for no normalization'
     	WRITE(6,*)'1	to normalize to 1         [ at the peak ]'
     	WRITE(6,*)'2	to the total counts       [ divide by N ] '
     	WRITE(6,*)'3	use the other col. to fill in the bins '
     	NORM	=  IRINT ('<?>')
     	IF (NORM.EQ.3) THEN
     	  IF (NCOL.EQ.1) NFILL = 2
     	  IF (NCOL.EQ.2) NFILL = 1
     	END IF
C
C Read-in the file
C
#ifdef vms
	OPEN (UNIT=20,FILE=FILEIN,STATUS='OLD',READONLY)
#else
	OPEN (UNIT=20,FILE=FILEIN,STATUS='OLD')
#endif
     	DO  11 I=1,10000
     	READ (20,*,ERR=111,END=111) XIN(1,I),XIN(2,I)
11     	CONTINUE
111     CLOSE (UNIT=20)
     	NPOINT 	= I - 1
	WRITE(6,*)'Read ',NPOINT
C
#ifdef vms
	WRITE(6,*)'Output options :'
	WRITE(6,*)'  [ 0 ] store histogram in a file'
	WRITE(6,*)'  [ 1 ] plot histogram on screen'
	WRITE(6,*)'  [ 2 ] both'
	IOUT	= IRINT ('Then ? ')
	IF (IOUT.EQ.1.OR.IOUT.EQ.2) THEN
	  CALL	SET_SCREEN	(' ',0,ITERM)
	END IF
#else
          WRITE(6,*) 'Display type:'
#if HAVE_XWINDOWS
          WRITE(6,*) '  [ 0 ] Xwindow'
#endif
          WRITE(6,*) '  [ 1 ] Tektronix'
          WRITE(6,*) '  [ 2 ] Postscript file'
          WRITE(6,*) '  [ 3 ] ASCII file (X,Y) pairs (no graphics)'
          ITERM = IRINT ('Terminal type:  ')
#if !HAVE_XWINDOWS
	IF (ITERM.EQ.0) THEN
	    WRITE (*,*) 'No X Windows support. Using Postscript file'
	    ITERM=2
	ENDIF
#endif
	IF (ITERM.LT.0 .OR. ITERM.GT.3) THEN
	    WRITE (*,*) 'Invalid device Id. Using Postscript file'
	    ITERM=2
	ENDIF
C
	  IOUT = 0
#endif
C
C Clear the arrays
C
     	DO 12 I=1,100
     	  XARRAY(I)  =   0.0
     	  YARRAY(I)  =   0.0
	  XTEMP(I)   =   0.0
12     	CONTINUE
C
C Fill in the bins
C
     	  XLOW	=   CENTER - WIDTH/2
     	  STEP	=   WIDTH/(NBIN - 1)
     	  XSTART	=   XLOW - STEP/2
     	DO 13 I=1,NPOINT
     	  ARG	=   (XIN(NCOL,I) - XSTART)/STEP
     	  JBIN	=   INT (ARG) + 1
C     	   IF (JBIN.OR.1.AND.JBIN.LE.NBIN) THEN
     	   IF (JBIN.LE.NBIN) THEN
     	    IF (NORM.NE.3) THEN
     	  YARRAY(JBIN) = YARRAY(JBIN) + 1.0
     	    ELSE
     	  YARRAY(JBIN) = YARRAY(JBIN) + XIN(NFILL,I)
     	    END IF
     	   END IF
13     	CONTINUE
C
C Prepare the arrays for writing
C
     	DO 14 I=1,NBIN
     	  XARRAY(I) =   (I-1)*STEP + XLOW
14     	CONTINUE
     	IF (NORM.EQ.0.OR.NORM.EQ.3) GO TO 10
C
C Normalize the arrays
C
     	  COUNTS	=   0.0
     	  YMAX		= - 1.0
     	DO 16 I=1,NBIN
     	  YMAX	=   MAX(YMAX,YARRAY(I))
     	  COUNTS=   COUNTS + YARRAY(I)
16     	CONTINUE
C
     	IF (NORM.EQ.1)   RNORM  =   YMAX
     	IF (NORM.EQ.2)   RNORM  =   COUNTS
     	DO 17 I=1,NBIN
     	  YARRAY(I) =   YARRAY(I)/RNORM
17     	CONTINUE
C
10	CONTINUE
#ifdef vms
	IF (IOUT.EQ.0.OR.IOUT.EQ.2) THEN
     	  OPEN (20,FILE='H2KOL',STATUS='NEW',INITIALSIZE=20)
     	    DO 18 I=1,NBIN
     	      WRITE (20,*)	XARRAY(I),YARRAY(I)
18     	    CONTINUE
     	  CLOSE (20)
	END IF
	IF (IOUT.EQ.1.OR.IOUT.EQ.2) THEN
	  CALL TDNEWP
	  CALL TDHIST (NBIN,XARRAY,YARRAY)
	  CALL	SET_SCREEN	(' ',1,ITERM)
	END IF
C
#else
	IF (ITERM.EQ.3) THEN			! ASCII X,Y pairs only
	   FILOUT = RSTRING('Output file name?')
	   OPEN (20,FILE=FILOUT,STATUS='UNKNOWN')
	   DO 55 I=1,NBIN
	      WRITE (20,*) XARRAY(I),YARRAY(I)
55	   CONTINUE
	   CLOSE (20)

	ELSE
     	  OPEN (20,FILE='h2kol.dat',STATUS='UNKNOWN')
C
C write the xtemp array for primvs purposes
C
          X1LOW = CENTER - 0.6125*WIDTH
          X1UPP = CENTER + 0.6125*WIDTH
          Y1LOW = 0.0
	  Y1UPP = -1.0
          XTEMP(1) = XSTART
          DO 51 I = 2,NBIN+1
            XTEMP(I) = XTEMP(I-1) + STEP
	    Y1UPP = MAX(Y1UPP,YARRAY(I-1))
51        CONTINUE
	  Y1UPP = 1.2*Y1UPP
          WRITE(20,*) XTEMP(1), 0.0
          DO 53 I = 1,NBIN+1
            WRITE(20,*) XTEMP(I), YARRAY(I)
            WRITE(20,*) XTEMP(I+1), YARRAY(I)
53        CONTINUE
          WRITE(20,*) XTEMP(NBIN+1), 0.0
          CLOSE(20)

          OPEN (23,FILE='h2kol.prm',STATUS='UNKNOWN')
          WRITE(23,*) '# Primvs command file to plot output of H2KOL'
          IF (ITERM.EQ.0) THEN
            WRITE(23,*) '# Initialize Xwindow display'
            WRITE(23,*) ' '
            WRITE(23,*) 'initpage(xwin)'
          ELSE IF (ITERM.EQ.1) THEN
            WRITE(23,*) '# Initialize Tektronix display'
            WRITE(23,*) ' '
            WRITE(23,*) 'initpage(tekt)'
          ELSE IF (ITERM.EQ.2) THEN
            WRITE(23,*) '# Initialize postscript file '
            WRITE(23,*) ' '
	    WRITE(23,*) 'setcolor(0)'
            WRITE(23,*) 'initpage(ps,"h2kol.ps")'
          ENDIF
          WRITE(23,*) '# Set limits on viewing window, plot, and '
          WRITE(23,*) '# character size.'
          WRITE(23,*) 'regionr(0.1,0.1,0.9,0.9,1.0)'
          WRITE(23,3030) X1LOW,X1UPP,Y1LOW,Y1UPP
	  WRITE(23,*) 'color(green)'
          WRITE(23,*) 'scalechr(0.8)'
          WRITE(23,*) ' '
          WRITE(23,*) '# Plot histogram from h2kol.dat and draw axes'
          WRITE(23,*) 'plotl("h2kol.dat")'
          WRITE(23,*) 'box("bcnst",0,0,"bcnstv",0,0)'
          WRITE(23,*) 'closepage'
          WRITE(23,*) 'exit'
 
3030    FORMAT ('xyrange(',E15.8,',',E15.8,',',E15.8,',',E15.8,')')
 
	IFLAG = 0
	CALL PROGPATH ('primvs', PRIMVS, IFLAG)
	PRIMVSPATH = PRIMVS(1:IBLANK(PRIMVS)) // ' -i h2kol.prm'
	WRITE(*,*) 'Executing program: ' // 
     $		PRIMVSPATH(1:IBLANK(PRIMVSPATH))
#if !defined(_WIN32)
	CALL SYSTEM (PRIMVSPATH)
#else
	IFLAG = 0
	CALL RUNPRIMVS (PRIMVS(1:IBLANK(PRIMVS)),'h2kol.prm', iflag)
#endif

	ENDIF

#endif
     	STOP
C
     	END
