C +++
C
C Source: src/trace/restart.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: restart.F
C Revision 1.8  1991/07/06  20:07:38  khan
C Grenoble and after. Minor changes
C
C Revision 1.7  91/04/05  15:06:01  cwelnak
C changed quotes on #includes
C 
C Revision 1.6  91/03/22  10:48:08  cwelnak
C SUN version -- INLCUDE to #inlcude
C 
C Revision 1.5  90/11/13  14:01:56  khan
C Cleanup and SAVE statements
C 
C Revision 1.4  90/07/19  21:38:00  khan
C Put #ifdef's to make it work on BOTH VMS and Ultrix
C 
C Revision 1.3  90/07/14  22:51:17  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.2  90/07/14  12:14:44  khan
C Added Binary Flag to WRITE_OFF (default in VMS).
C 
C Revision 1.1  90/07/10  14:56:48  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	RESTART
C
C	PURPOSE		Rotates the beam from the IMAGE refernece
C			frame to the MIRROR reference frame. The source
C			is thus positioned at T_SOURCE from pole and at
C			at angle T_INCIDENCE.
C
C	ARGUMENTS	[ I ]	RAY	: the beam as obtained from the
C					  last IMAGE plane.
C			[ O ]   RAY	: The same beam but in new RF
C
C	PARAMETERS	In Common blocks
C
C---
	SUBROUTINE 	RESTART (RAY,PHASE,AP)

#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif

	DIMENSION 	RAY(12,N_DIM), AP(3,N_DIM), PHASE(3,N_DIM),
     $			TEMP_1(9),TEMP_2(9), TEMP_1P(3),TEMP_2P(3)

     	WRITE(6,*)'Call to RESTART'
C
C rotate of the absolute source movements
C
     	IF (FSTAT.EQ.1) THEN
     	  CALL	ROT_SOUR (RAY,AP)
	  IFLAG	= 0
     	  CALL	WRITE_OFF ('ROT_SOUR',RAY,PHASE,AP,NCOL,NPOINT,IFLAG,
     $                     0,IERR)
     	 IF (IERR.NE.0) CALL LEAVE 
     $		('RESTART','Error writing ROT_SOUR',IERR)
     	END IF
C	
C Rotate now the general ray in the new mirror reference frame.
C First we take care of the axial position of the mirror (ALPHA), then
C we bring the old image (TEMP_1) in the new mirror reference frame (NEW).
C This is equivalent to say that we do first a rotation around the image
C normal and after we bring it on the mirror. This is done both for
C the ray direction cosine and polarization vectors.
C TEMP_1 and TEMP_2 are utility vectors.
C
	DO 100 ITIME = 1,NPOINT
      	  IF (RAY(10,ITIME).LT.-1.0D6) THEN
     		GO TO 100
     	  ELSE
      	  END IF

		TEMP_1(1) =   RAY(1,ITIME)*COSAL + RAY(3,ITIME)*SINAL
		TEMP_1(2) =   RAY(2,ITIME)
		TEMP_1(3) = - RAY(1,ITIME)*SINAL + RAY(3,ITIME)*COSAL
C
C The former were the positions onto the image plane. Now we compute the
C new directions and the polarization vector in the new RF.
C
		TEMP_1(4) =   RAY(4,ITIME)*COSAL + RAY(6,ITIME)*SINAL
		TEMP_1(5) =   RAY(5,ITIME)
		TEMP_1(6) = - RAY(4,ITIME)*SINAL + RAY(6,ITIME)*COSAL

		TEMP_1(7) =   RAY(7,ITIME)*COSAL + RAY(9,ITIME)*SINAL
		TEMP_1(8) =   RAY(8,ITIME)
		TEMP_1(9) = - RAY(7,ITIME)*SINAL + RAY(9,ITIME)*COSAL
C
C We rotate now of the incidence angle, as in SOURCE, and we re-origin
C at the "real" source position.
C
		TEMP_2(1) =   TEMP_1(1) + PSREAL(1)
		TEMP_2(2) =   TEMP_1(2)*SINTHR + TEMP_1(3)*COSTHR 
     $					  + PSREAL(2)
		TEMP_2(3) = - TEMP_1(2)*COSTHR + TEMP_1(3)*SINTHR 
     $					  + PSREAL(3)

		TEMP_2(4) =   TEMP_1(4)
		TEMP_2(5) =   TEMP_1(5)*SINTHR + TEMP_1(6)*COSTHR
		TEMP_2(6) = - TEMP_1(5)*COSTHR + TEMP_1(6)*SINTHR

		TEMP_2(7) =   TEMP_1(7)
		TEMP_2(8) =   TEMP_1(8)*SINTHR + TEMP_1(9)*COSTHR
		TEMP_2(9) = - TEMP_1(8)*COSTHR + TEMP_1(9)*SINTHR
C
C Have to rotate now of the source rotation angle around Z. Use
C again TEMP_1 for convenience.
C
     		TEMP_1(1) =   TEMP_2(1)*COSAL_S - TEMP_2(2)*SINAL_S
     		TEMP_1(2) =   TEMP_2(1)*SINAL_S + TEMP_2(2)*COSAL_S
     		TEMP_1(3) =   TEMP_2(3)
     		TEMP_1(4) =   TEMP_2(4)*COSAL_S - TEMP_2(5)*SINAL_S
     		TEMP_1(5) =   TEMP_2(4)*SINAL_S + TEMP_2(5)*COSAL_S
     		TEMP_1(6) =   TEMP_2(6)
     		TEMP_1(7) =   TEMP_2(7)*COSAL_S - TEMP_2(8)*SINAL_S
     		TEMP_1(8) =   TEMP_2(7)*SINAL_S + TEMP_2(8)*COSAL_S
     		TEMP_1(9) =   TEMP_2(9)

C Create now the final array.

     		RAY(1,ITIME)  =   TEMP_1(1)
		RAY(2,ITIME)  =   TEMP_1(2)
     		RAY(3,ITIME)  =   TEMP_1(3)
		RAY(4,ITIME)  =   TEMP_1(4)
		RAY(5,ITIME)  =   TEMP_1(5)
		RAY(6,ITIME)  =   TEMP_1(6)
     		RAY(7,ITIME)  =   TEMP_1(7)
		RAY(8,ITIME)  =   TEMP_1(8)
     		RAY(9,ITIME)  =   TEMP_1(9)
C
C The other elements, I=10,12 are not changed
C
C Same procedure for AP
C
	IF (NCOL.EQ.18) THEN
		TEMP_1P(1) =   AP(1,ITIME)*COSAL + AP(3,ITIME)*SINAL
		TEMP_1P(2) =   AP(2,ITIME)
		TEMP_1P(3) = - AP(1,ITIME)*SINAL + AP(3,ITIME)*COSAL

		TEMP_2P(1) =   TEMP_1P(1)
		TEMP_2P(2) =   TEMP_1P(2)*SINTHR + TEMP_1P(3)*COSTHR
		TEMP_2P(3) = - TEMP_1P(2)*COSTHR + TEMP_1P(3)*SINTHR

     		TEMP_1P(1) =   TEMP_2P(1)*COSAL_S - TEMP_2P(2)*SINAL_S
     		TEMP_1P(2) =   TEMP_2P(1)*SINAL_S + TEMP_2P(2)*COSAL_S
     		TEMP_1P(3) =   TEMP_2P(3)

		AP(1,ITIME)	= TEMP_1P(1)
		AP(2,ITIME)	= TEMP_1P(2)
		AP(3,ITIME)	= TEMP_1P(3)
	END IF

100	CONTINUE

     	WRITE(6,*)'Exit from RESTART'

	END
