C +++
C
C Source: src/tools/math/ortho2.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	ortho2.f
C Revision 1.2  90/11/13  14:03:07  khan
C Cleanup and SAVE statements
C 
C Revision 1.1  90/07/17  13:54:59  khan
C Initial revision
C 
C 
C ---

C+++
C
C	PROGRAM		OTEST
C
C---
     	PROGRAM		OTEST
     	DIMENSION	RCOEFF(11,11)
     	EXTERNAL	SCALAR
     	CHARACTER*50	OUTFIL
     	REAL*8	RCOEFF
     	WRITE(6,*)'Order ?'
     	READ(5,*)KORD
     	CALL	ORTHOCOEFF (KORD,RCOEFF)
     	WRITE(6,*)'File ?'
     	READ(5,*)OUTFIL
     	OPEN (20,FILE=OUTFIL,STATUS='UNKNOWN')
C     	OPEN (20,FILE=OUTFIL,STATUS='NEW')
     	DO 10 I =1,2
     	 IF (I.EQ.1) ICHAN = 6
     	 IF (I.EQ.2) ICHAN = 20
     	   WRITE (ICHAN,*)  'ORDER : ',KORD
     	  DO 5 J=1,KORD
     	   WRITE (ICHAN,*) (RCOEFF(J,K),K=1,KORD-1)
5         CONTINUE
10      CONTINUE
     	WRITE(6,*)'Testing Orthogonality'
     	WRITE (20,*) 'Testing Orthogonality'
     	IORD = KORD
     	DO  20 LL=2,IORD
C
C Tests for orthogonality between order KORD and the lower polinomials
C
     	TOT	=   SCALAR (KORD,LL,RCOEFF)
     	WRITE(6,*)'Scalar product between M = ',IORD,' and N = ',LL
     	WRITE(6,*)'is		',TOT
     	WRITE (20,*) 'Scalar product between M = ',IORD,' and N = ',LL
     	WRITE (20,*) 'is	',TOT
20      CONTINUE
     	CLOSE (20)
     	STOP
     	END
C++++
C	SUBROUTINE	ORTHOCOEFF
C
C	PURPOSE		Compute the coefficients for orthonormal poli
C			nomials in the base:
C
C			 ( X + Y )**M
C
C			Weigth is 1.
C
C	DOMAIN		X: -1,1		Y: -1,1
C
C	ALGORITHM	The coefficients are found in ascending order,
C			accordingly to the orthogonalization procedure.
C---
     	SUBROUTINE	ORTHOCOEFF	(IORD,RCOEFF)
     	IMPLICIT	REAL*8		(A-H,O-Z)
     	EXTERNAL	AVAL,IDKR,SUM
     	DIMENSION	RCOEFF		(11,11)
     	DIMENSION	AMAT		(11,11)
     	DIMENSION	BMAT		(11,11)
     	DIMENSION	WORK		(200)
     	IF (IORD.GT.10)	STOP	'Order too high.'
     	RCOEFF (1,1)	= .0D0
     	DO 60 MM=2,IORD
C
C Build the matrix of the coefficients of the system of linear equations
C
C	AMAT * X + BMAT = 0
C
C Initialize the BMAT array
C
     	DO 30 IKL=1,11
     	 DO 25 JKL=1,11
     	  BMAT(IKL,JKL) = IDKR(IKL,JKL)
25       CONTINUE
30      CONTINUE
C
C Scans the row, from 1 to (order-1)
C
     	  DO 40 LL=1,MM-1
     	    BMAT (LL,MM) = - AVAL(LL,MM) - SUM (MM,LL,RCOEFF)
     	   DO 35 JJ=1,MM-1
     	    AMAT (LL,JJ) =   AVAL(JJ,LL) + SUM (JJ,LL,RCOEFF)
35         CONTINUE
40        CONTINUE
        IDGT	=   0
C	OPEN (33,FILE='MATRIX',STATUS='NEW')
C	WRITE (33,*) '======================================'
C	WRITE (33,*) 'ORDER :',MM,' OF ',IORD
C	WRITE (33,*)	'AMATRIX'
C	DO IX = 1,IORD
C	WRITE (33,1000) (AMAT(IX,IY),IY=1,IORD)
C	CONTINUE
C	WRITE (33,*)	'BMATRIX'
C	DO IX=1,IORD
C	WRITE (33,1000)	(BMAT(IX,IY),IY=1,IORD)
C	CONTINUE
C	WRITE	(33,*)	'OLD COEFFICIENTS'
C	DO IX=1,IORD
C	WRITE (33,1000) (RCOEFF(IX,IY),IY=1,IORD)
C	CONTINUE
C1000	FORMAT	(1X,10(1X,G11.4))
     	CALL	LEQT2F	(AMAT,11,MM-1,11,BMAT,IDGT,WORK,IER)
     	IF (IER.NE.0)	WRITE(6,*)'Error IMSL : ',IER
     	 DO 50 K=1,MM-1
     	   RCOEFF (MM,K) = BMAT(K,MM)
     	   RCOEFF (K,MM) = RCOEFF(MM,K)
50       CONTINUE 
C	WRITE (33,*)	'NEW B MATRIX'
C	DO IX=1,IORD
C	WRITE (33,1000)	(BMAT(IX,IY),IY=1,IORD)
C	CONTINUE
C	WRITE (33,*)	'NEW COEFFICIENTS'
C	DO IX=1,IORD
C	WRITE (33,1000) (RCOEFF(IX,IY),IY=1,IORD)
C	CONTINUE
60   	CONTINUE 
     	END
C+++
C	FUNCTION	AVAL	(I,J)
C
C	PURPOSE		This function returns the value of the integral
C			of
C				( x + y )**(i+j)
C			over the domain x=-1,1, y=-1,1
C
C	ALGORITHM	if (i+j) is odd, the integral is 0;
C
C			else,
C				2**(i+j) + (-2)**(i+j)
C                       AVAL = ------------------------
C				    (i+j)*(i+j+1)
C---
     	FUNCTION	AVAL	(I,J)
     	IMPLICIT	REAL*8	(A-H,O-Z)
     	IF (MOD(I+J,2).EQ.1) THEN
     	  AVAL	=  0.0D0
     	  RETURN
     	ELSE
C
C	  A1   =   2**(I+J) + (-2)**(I+J)
C
C	  However, if (i+j) is even, we can write:
C
     	  A1	=    2**(I+J+1)
     	  A3	=   (I+J-1)*(I+J)
     	  AVAL	=   A1/A3
     	END IF
     	RETURN
     	END
C+++
C	FUNCTION	IDKR	(IX,IY)
C
C	PURPOSE		Kronecker Delta
C			 = 0	if ix <=> iy
C			 = 1    if ix  =  iy
C---
     	FUNCTION	IDKR	(IX,IY)
     	IMPLICIT	INTEGER*4	(A-Z)
     	IDKR	=   0
     	IF	(IX.EQ.IY)	IDKR = 1
     	RETURN
     	END
C+++
C	FUNCTION	SUM	(L,M,RCOEFF)
C
C	PURPOSE		To simplify the formalism for the computation
C			of the matrix coefficients.
C
C	ALGORITHM	SUM computes the following sum
C
C			C(M,i)*RCOEFF(i,L)  i=1,L-1
C
C---
     	FUNCTION	SUM	(M,L,RCOEFF)
     	IMPLICIT	REAL*8	(A-H,O-Z)
     	DIMENSION	RCOEFF	(11,11)
     	EXTERNAL	AVAL
     	SUM	=   .0D0
     	IF (L.EQ.1)	RETURN
     	DO 10 I=1,L-1
     	  SUM	=   SUM + AVAL(M,I)*RCOEFF(I,L)
10      CONTINUE 
     	RETURN
     	END
C+++
C	FUNCTION	SCALAR (I1,I2,RCOEFF)
C
C	PURPOSE		Computes the inner product of two polinomials
C
C---
     	FUNCTION	SCALAR	(M,L,RCOEFF)
     	IMPLICIT	REAL*8	(A-H,O-Z)
     	EXTERNAL	AVAL
     	DIMENSION	RCOEFF(11,11)
     	VAL1	=    AVAL(M,L)
     	VAL2	=   0.0D0
     	VAL3	=   0.0D0
     	VAL4	=   0.0D0
     	DO 10 I=1,L-1
     	  VAL2	=   VAL2 + RCOEFF(L,I)*AVAL(M,I)
10      CONTINUE 
     	DO 20 J=1,M-1
     	  VAL3	=   VAL3 + RCOEFF(M,J)*AVAL(J,L)
20      CONTINUE 
     	DO 30 J=1,M-1
     	 DO 25 I=1,L-1
     	   VAL4	=   VAL4 + RCOEFF(M,J)*RCOEFF(L,I)*AVAL(J,I)
25       CONTINUE 
30      CONTINUE 
     	SCALAR	=   VAL1 + VAL2 + VAL3 + VAL4
     	RETURN
     	END
