C +++
C
C Source: src/tools/math/ortho1.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	ortho1.f
C Revision 1.2  90/11/13  14:03:06  khan
C Cleanup and SAVE statements
C 
C Revision 1.1  90/07/17  13:54:59  khan
C Initial revision
C 
C 
C ---

C+++
C	Program		POLORTHO
C
C	Purpose:	To fit a discrete array of data with orthogonal
C			polinomial of any degree.
C
C	Algorithm	Least square fit using modified Legendre 
C			polinomials in discrete form
C			
C			IMSL's DCADRE is used for the integration and
C			a spline fit if data are not equispaced.
C
C	Limitations	The input array data must be in
C			ascending X order: X(I+1).GT.X(I)
C---
     	PROGRAM		POLORTHO
     	DIMENSION	X(1000),Y(1000),A(20),XOUT(1000),YOUT(1000)
	DIMENSION	SPL (999,3)
     	CHARACTER*40	INFILE,OUTFIL
	EXTERNAL	BPOL,F_INT
100	TYPE *,'Input file ?'
     	READ (5,1000)	INFILE
1000	FORMAT (A)
     	TYPE *,'Output file ?'
     	READ (5,1000)	OUTFIL
     	OPEN (20,FILE=INFILE,STATUS='OLD',READONLY,ERR=100)
     	DO 99 I = 1,1000
     	READ (20,*,ERR=110,END=111)	X(I),Y(I)
 99	CONTINUE
110	TYPE *,'Error reading data file.'
     	CALL	EXIT
111	CLOSE (20)
     	NN = I - 1
     	TYPE *,'Read ',NN,' records.'
	TYPE *,'Is the X-array equispaced ?'
	ACCEPT *,IANSW
	IF (IANSW.NE.1) THEN
	 TYPE *,'X(1) = ',X(1)
	 TYPE *,'X(end) = ',X(NN)
	 TYPE *,'Change limits ?'
	 ACCEPT *,IANSW
	  IF (IANSW.EQ.1) THEN
	   TYPE *,'Xmin, Xmax ?'
	   ACCEPT *,XMIN,XMAX
	  ELSE
	    XMIN	=  X(1)
	    XMAX	=  X(NN)
	  END IF
	 TYPE *,'Rescaling step ?'
	 ACCEPT *,STEP
	   NCOM	=  (XMAX - XMIN)/STEP + 1
	 CALL	ICSCCU( X,Y,NN,SPL,999,IER)
	  IF (IER.NE.0) TYPE *,'ERROR FROM ICSCCU ',IER
	 DO 199 I=1,NCOM
	   XOUT(I)	=   XMIN + (I-1)*STEP
 199	CONTINUE
	 CALL	ICSEVU (X,Y,NN,SPL,999,XOUT,YOUT,NCOM,IER)
	  IF (IER.NE.0) TYPE *,'ERROR FROM ICSEVU ',IER
	 DO 299 I=1,NCOM
	   Y(I) = YOUT(I)
	   X(I) = XOUT(I)
 299	CONTINUE
     	  DELTA =  XMAX - XMIN
     	 OPEN (20,FILE='SPLFIT',STATUS='UNKNOWN')
C     	 OPEN (20,FILE='SPLFIT',STATUS='NEW')
     	  DO 399 I=1,NCOM
     	   WRITE (20,*) X(I),Y(I)
 399	CONTINUE
     	 CLOSE (20)
	ELSE
	  XMIN	=  X(1)
	  XMAX	=  X(NN)
     	  DELTA	=  XMAX - XMIN
	  STEP	=  DELTA/(NN-1)
	  NCOM	=  NN
	END IF
     	 TYPE *,'Polinomial degree ?'
     	 ACCEPT *,NPOL
     	RSTEP  = 1.0/(NCOM-1)
     	DO 499 I=1,NCOM
     	X(I) = RSTEP*(I-1)
 499	CONTINUE
     	CALL	LEGENDRE (X,Y,NCOM,NPOL,A)
     	TYPE *,'Computation done.'
     	TYPE *,'Output step ?'
     	ACCEPT *,STEP
     	OPEN (20,FILE=OUTFIL,STATUS='UNKNOWN')
C     	OPEN (20,FILE=OUTFIL,STATUS='NEW')
     	 DO 599 I=0,NPOL
     	  WRITE (20,*)	A(I+1)
 599	CONTINUE
     	CLOSE (20)
     	NOUT = DELTA/STEP + 1
	OPEN (20,FILE='POLFIT',STATUS='UNKNOWN')
C	OPEN (20,FILE='POLFIT',STATUS='NEW')
	DO 699 I=1,NOUT
	   YARG = 0.0
     	   X(I) = XMIN + (I-1)*STEP
     	   XARG	= (X(I) - XMIN)/DELTA
	 DO 799 J =1,NPOL+1
	   YARG = YARG + A(J)*BPOL(XARG,J-1)
 799	CONTINUE
	WRITE (20,*)	X(I),YARG
 699	CONTINUE
	CLOSE (20)
     	TYPE *,'All done.'
     	CALL	EXIT
     	END

C+++
C	FUNCTION	BPOL (X,J)
C
C	Purpose		Computes the shifted Legendre polinomials of 
C			degree J at point X
C
C	Algorithm	Direct definition of the shifted Legendre
C			polinomials.
C
C	Limits		Argument domain must be within [ 0,1 ]
C
C---
     	FUNCTION	BPOL (X,J)
     	DIMENSION	XTEMP (20)
     	IF (X.GT.1.0.OR.X.LT.0.0)	TYPE *,'Invalid argument ',X,J
	XTEMP(1)	=   1				!	ZERO DEGREE
	XTEMP(2)	=   1 - 2*X
	XTEMP(3)	=   1 - 6*X + 6*X**2
	XTEMP(4)	=   1 - 12*X + 30*X**2 - 20*X**3
	XTEMP(5)	=   1 - 20*X + 90*X**2 - 140*X**3 + 70*X**4
     	IF (J.LT.5) THEN
     	  BPOL	= XTEMP(J+1)
     	  RETURN
     	END IF
c
c uses recurrence formulae for terms greater than 4
c
     	DO 99 I=6,J+1
     	 XTEMP(I) = XTEMP(I-1) + XTEMP(I-2)
 99	CONTINUE
     	BPOL = XTEMP(I-1)
     	RETURN
     	END

C+++
C	SUBROUTINE	LEGENDRE
C
C	Purpose		To find the coefficient of the best fit to a
C			set of data by means of Legendre Polinomials
C
C	Algorithm	1.) Fits a smooth spline to data array.
C			2.) Ths spline is used to define F_INT
C			3.) DCADRE is used to evaluate the projection of
C			    F_INT onto P(J)
C
C	Limitations     The X-array must be between [ 0,1 ]
C
C---
     	SUBROUTINE	LEGENDRE (X,Y,NP,NORD,COEFF)
     	DIMENSION	COEFF (20)
     	DIMENSION	X(1000),Y(1000)
     	COMMON	/LEG	/SPL(1000,999),X1(1000),Y1(1000),NPOINT,I
     	EXTERNAL	F_INT,DCADRE
     	TYPE *,'Call to LEGENDRE'
     	DO 99 I =1,NP
     	  X1(I) = X(I)
     	  Y1(I) = Y(I)
 99	CONTINUE
     	NPOINT = NP
     	CALL	ICSCCU	(X,Y,NP,SPL,999,IER)
     	IF (IER.NE.0)	TYPE *,'Error ICSCCU -- LEGENDRE'
     	AERR = 0.0
     	RERR = 1.0E-4
     	DO 199 I = 0,NORD
     	  VAL  =	DCADRE	(F_INT,X(1),X(NP),AERR,RERR,ERROR,IER)
     	 IF (IER.NE.0)	TYPE *,'Error ',IER,' DCADRE'
     	  COEFF(I+1) = VAL*(2*I+1)
 199	CONTINUE
     	RETURN
     	END
C+++
C	Function	F_INT (x)
C
C	Purpose		This function returns the integrand function for
C			the expansion of a spline function in a set of
C			Legendre polinomials
C
C	Algorithm	Direct definition
C
C	Limitations	Argument domain [ 0,1 ]
C
C---
     	FUNCTION	F_INT(XVAR)
     	EXTERNAL	BPOL
     	COMMON	/LEG	/SPL(1000,999),X(1000),Y(1000),NP,JJ
     	DIMENSION	U(1),V(1)
     	U(1)	=   XVAR
     	CALL	ICSEVU	(X,Y,NP,SPL,999,U,V,1,IER)
     	IF (IER.NE.0) TYPE *,'Error ICSEVU ( F_INT) '
     	F_INT	=   V(1)*BPOL(XVAR,JJ)
     	RETURN
     	END
