C +++
C
C Source: src/source/source_bound.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: source_bound.F
C Revision 1.8  1991/07/06  19:59:53  khan
C Elliptical Undulator by Sylvia Difonzo
C
C Revision 1.7  91/04/05  14:03:32  cwelnak
C changed quotes on #include
C 
C Revision 1.6  91/03/20  16:45:24  cwelnak
C SUN version -- changes INCLUDE to #include
C 
C Revision 1.5  90/11/09  14:17:34  cwelnak
C Added three forgotten variables ro SAVE statement.
C 
C Revision 1.4  90/11/09  14:13:26  khan
C Added SAVE statements...
C 
C Revision 1.3  90/07/19  20:53:11  khan
C Put Preprocessor/conditionals to make it work on both VMS and Ultrix.
C 
C Revision 1.2  90/07/14  22:39:19  khan
C All global include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.1  90/07/10  14:57:05  khan
C Initial revision
C 
C 
C ---

C+++
C	SUBROUTINE		SOURCE_BOUND
C
C	Purpose			To optimize the source generation by
C				rejecting the rays generated outside a
C				given region. The three directions are
C				considered to be ``uncoupled''.
C
C	Algorithm		Acceptance/rejection method.
C
C---
     	SUBROUTINE	SOURCE_BOUND	(POS, DIR, IFLAG)
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
C
C Save the values that the caller expects to be there next time this
C routine is called. The following chunk is basically an unnamed COMMON
C block (w/out the corruption of the namespace, of course).
C
	SAVE		IX, IY, IZ, XMIN, YMIN, ZMIN,
     $ 			NX, NX1, NY, NY1, NZ, NZ1,
     $			XS, X1S, YS, Y1S, ZS, Z1S,
     $                  X1MIN, Y1MIN, Z1MIN
     	DIMENSION	POS(3), DIR(3)
     	DIMENSION	IX(101,101), IY(101,101), IZ(101,101)
C	
C checks for initialization
C
     	IF (IFLAG.LT.0) THEN
#ifdef vms
     	  OPEN	(30, FILE=FILE_BOUND, STATUS='OLD', READONLY, 
     $		     FORM='UNFORMATTED', IOSTAT=IERR)
#else
     	  OPEN	(30, FILE=FILE_BOUND, STATUS='OLD',
     $		     FORM='UNFORMATTED', IOSTAT=IERR)
#endif
     	 IF (IERR.NE.0) THEN
     	   WRITE(6,*)'Error opening file: ',S_BOUND
     	   STOP
     	 END IF
     	  READ (30,ERR=101)	NX, XMIN, XS
     	  READ (30,ERR=101)	NX1, X1MIN, X1S
     	  READ (30,ERR=101)	NY, YMIN, YS
     	  READ (30,ERR=101)	NY1, Y1MIN, Y1S
     	  READ (30,ERR=101)	NZ, ZMIN, ZS
     	  READ (30,ERR=101)	NZ1, Z1MIN, Z1S
     	  DO 11 I=1,NX
     	   READ (30,ERR=101)	(IX(I,J),J=1,NX1)
11     	  CONTINUE
     	  DO 21 I=1,NY
     	   READ (30,ERR=101)	(IY(I,J),J=1,NY1)
21     	  CONTINUE
     	  DO 31 I=1,NZ
     	   READ (30,ERR=101)	(IZ(I,J),J=1,NZ1)
31     	  CONTINUE
     	  CLOSE (30)
     	 WRITE(6,*)'Phase space boundaries file read succesfully.'
     	  RETURN
101	 WRITE(6,*)'Error reading from file ',S_BOUND
     	 STOP
     	 ELSE IF (IFLAG.EQ.1) THEN
C
C Normal entry
C Tests for ''good'' hits; if a bad one fund, return
C
     	  IFLAG = -1
	  IF (XS.NE.0) THEN
     	    JX  = (POS(1) - XMIN)/XS + 1
	  ELSE
	    JX	= 1
	  END IF
	  IF (X1S.NE.0) THEN
     	    JX1 = (DIR(1) - X1MIN)/X1S + 1
	  ELSE
	    JX1	= 1
	  END IF
C
C tests first for bounds limits; if outside any, no sense trying more.
C
     	 IF (JX.LT.1.OR.JX.GT.NX) RETURN
c     	  IFLAG = -11
     	 IF (JX1.LT.1.OR.JX1.GT.NX1) RETURN
C
C within bounds; test for acceptance
C
D     	  IFLAG = -101
     	 IF ( IX(JX,JX1).EQ.0) RETURN
C
C ''x'' is OK; continue with Y,Z
C 
D     	 IFLAG = -2
	  IF (YS.NE.0) THEN
     	    JY  = (POS(2) - YMIN)/YS + 1
	  ELSE
	    JY	= 1
	  END IF
	  IF (Y1S.NE.0) THEN
     	    JY1 = (DIR(2) - Y1MIN)/Y1S + 1
	  ELSE
	    JY1	= 0
	  END IF
     	 IF (JY.LT.1.OR.JY.GT.NY) RETURN
D     	 IFLAG = -21
     	 IF (JY1.LT.1.OR.JY1.GT.NY1) RETURN
D     	 IFLAG = -201
     	 IF ( IY(JY,JY1).EQ.0) RETURN
D     	 IFLAG = -3
	  IF (ZS.NE.0) THEN
     	    JZ  = (POS(3) - ZMIN)/ZS + 1
	  ELSE
	    JZ	= 1
	  END IF
	  IF (Z1S.NE.0) THEN
     	    JZ1 = (DIR(3) - Z1MIN)/Z1S + 1
	  ELSE
	    JZ1 =1
	  END IF
     	 IF (JZ.LT.1.OR.JZ.GT.NZ) RETURN
D     	 IFLAG = -31
     	 IF (JZ1.LT.1.OR.JZ1.GT.NZ1) RETURN
D     	 IFLAG = -301
     	 IF ( IZ(JZ,JZ1).EQ.0) RETURN
C
C the ray is acceptable;
C
     	 IFLAG = 1
     	 RETURN
     	END IF
     	END
