C+++
C
C-------------------------------
C          SHADOW
C   Center for X-ray Lithography
C  University of Wisconsin-Madison
C 3731 Schneider Dr.,Stoughton, WI,53589
C-------------------------------
C
C Initial revision   Di Fonzo - Singh
C
C---

C+++
C SUBROUTINE ROTATE
C
C PURPOSE: GENERATE THE EULERIAN ANGLES FROM THE ELECTRON COORDINATES TO
C THE SHADOW REFERENCE FRAME.
C
C----
         SUBROUTINE ROTATE (VIN,PSI,THETA,PHI,VOUT)
          IMPLICIT  REAL*8 (A-H,O-Z)
          DIMENSION VIN(3), VOUT(3)
C
C To avoid useles recalculations
C
          COSPSI = COS (PSI)
          COSTHE = COS (THETA)
          COSPHI = COS (PHI)
          SINPSI = SIN (PSI)
          SINTHE = SIN (THETA)
          SINPHI = SIN (PHI)
C
          VOUT(1)= (COSPSI*COSPHI-COSTHE*SINPHI*SINPSI)*VIN(1)+
     $    (-SINPSI*COSPHI-COSTHE*SINPHI*COSPSI)*VIN(2)+
     $    (SINTHE*SINPHI)*VIN(3)
C
          VOUT(2)= (COSPSI*SINPHI+COSTHE*COSPHI*SINPSI)*VIN(1)+
     $    (-SINPSI*SINPHI+COSTHE*COSPHI*COSPSI)*VIN(2)+
     $    (-SINTHE*COSPHI)*VIN(3)
C
          VOUT(3)= (SINTHE*SINPSI)*VIN(1)+(SINTHE*COSPSI)*VIN(2)
     $    +COSTHE*VIN(3)
          END
