C+++
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C	SUBROUTINE		READ_NML
C
C	PURPOSE			To read in LOADxx a standard NAMELIST 
C				file
C	inputs		N0	Disk file #
C			N1 	Internal OE number
C---
     	SUBROUTINE	READ_NML (INFILE, WHAT, N1, N0, IFLAG)
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../../include/common.blk'
c	INCLUDE         './../../include/namelist.blk'
c
c
#	include		<common.blk>
#	include		<namelist.blk>
#	include		"parms.inc"
#elif defined(vms)
     	INCLUDE		'shade:common.blk'
     	INCLUDE		'shade:namelist.blk'
	INCLUDE		'parms.inc'
#endif
     	CHARACTER*(*)	INFILE,WHAT
     	CHARACTER*80	NEWNAME
     	CALL	DESPACE	(INFILE,NEWNAME,KLEN)
     	WRITE	(NEWNAME(KLEN+1:KLEN+3), 1030) '.',N0
     	LFIL = KLEN + 3
	MESSAGE = 'Reading from file ' // NEWNAME (1:LFIL)
	CALL SIMPLEMESSAGE 
d    	WRITE (*,*)'Reading from file ',NEWNAME(1:LFIL)
1030	FORMAT (A,I2.2)
     	N2	=  0
     	IFLAG	=  0
     	IF (WHAT.EQ.'OE') THEN
     	  CALL	RWNAME (NEWNAME(1:LFIL), 'R_OE', IFLAG)
     	 IF (IFLAG.LT.0) RETURN
C    	  CALL	STORE_I ('OE','FSYST', N1, N2, FSYST)
     	  CALL	STORE_EI ('OE','FMIRR', N1, N2, FMIRR)
     	  CALL	STORE_EI ('OE','F_TORUS', N1, N2, F_TORUS)
     	  CALL	STORE_Y ('OE','FCYL', N1, N2, FCYL)
     	  CALL	STORE_EI ('OE','F_EXT', N1, N2, F_EXT)
     	  CALL	STORE_EI ('OE','FSTAT', N1, N2, FSTAT)
     	  CALL	STORE_EI ('OE','FWRITE', N1, N2, FWRITE)
     	  CALL	STORE_Y ('OE','F_SCREEN', N1, N2, F_SCREEN)
     	  CALL	STORE_Y ('OE','FSLIT', N1, N2, FSLIT)
     	  CALL	STORE_Y ('OE','F_RIPPLE', N1, N2, F_RIPPLE)
     	  CALL	STORE_Y ('OE','F_MOVE', N1, N2, F_MOVE)
      	  CALL	STORE_EI ('OE','F_G_S', N1, N2, F_G_S)
     	  CALL	STORE_EI ('OE','F_R_RAN', N1, N2, F_R_RAN)
     	  CALL	STORE_EI ('OE','F_GRATING', N1, N2, F_GRATING)
      	  CALL	STORE_EI ('OE','F_SIDE', N1, N2, F_SIDE)
     	  CALL	STORE_Y ('OE','F_CENTRAL', N1, N2, F_CENTRAL)
     	  CALL	STORE_EI ('OE','F_CONVEX', N1, N2, F_CONVEX)
     	  CALL	STORE_EI ('OE','F_REFLEC', N1, N2, F_REFLEC)
      	  CALL	STORE_EI ('OE','F_RUL_ABS', N1, N2, F_RUL_ABS)
      	  CALL	STORE_EI ('OE','F_RULING', N1, N2, F_RULING)
     	  CALL	STORE_EI ('OE','F_PW', N1, N2, F_PW)
     	  CALL	STORE_EI ('OE','F_PW_C', N1, N2, F_PW_C)
     	  CALL	STORE_EI ('OE','F_VIRTUAL', N1, N2, F_VIRTUAL)
     	  CALL	STORE_EI ('OE','FSHAPE', N1, N2, FSHAPE)
     	  CALL	STORE_Y ('OE','FHIT_C', N1, N2, FHIT_C)
     	  CALL	STORE_EI ('OE','F_MONO', N1, N2, F_MONO)
      	  CALL	STORE_EI ('OE','F_REFRAC', N1, N2, F_REFRAC)
     	  CALL	STORE_EI ('OE','F_DEFAULT', N1, N2, F_DEFAULT)
     	  CALL	STORE_EI ('OE','F_REFL', N1, N2, F_REFL)
     	  CALL	STORE_EI ('OE','F_HUNT', N1, N2, F_HUNT)
     	  CALL  STORE_Y ('OE','F_BRAGG_A', N1, N2, F_BRAGG_A)
          CALL  STORE_Y ('OE','F_MOSAIC', N1, N2, F_MOSAIC)
          CALL  STORE_Y ('OE','F_JOHANSSON', N1, N2, F_JOHANSSON)
     	  CALL	STORE_Y ('OE','F_CRYSTAL', N1, N2, F_CRYSTAL)
     	  CALL	STORE_Y ('OE','F_THICK', N1, N2, F_THICK)
     	  CALL	STORE_EI ('OE','F_PHOT_CENT', N1, N2, F_PHOT_CENT)
	  CALL  STORE_Y ('OE','F_ROUGHNESS', N1, N2, F_ROUGHNESS)
	  CALL  STORE_Y ('OE','F_ANGLE', N1, N2, F_ANGLE)
     	  CALL 	STORE_I ('OE','N_PLATES', N1, N2, N_PLATES)
          CALL  STORE_I ('OE','MOSAIC_SEED', N1, N2, MOSAIC_SEED)
     	  CALL	STORE_Y ('OE','F_PLATE', N1, N2, F_PLATE)
     	  CALL	STORE_Y ('OE','FZP', N1, N2, FZP)
     	  CALL	STORE_R ('OE','CIL_ANG', N1, N2, CIL_ANG)
     	  CALL	STORE_R ('OE','ELL_THE', N1, N2, ELL_THE)
     	  CALL	STORE_R ('OE','ALPHA', N1, N2, ALPHA)
     	  CALL	STORE_R ('OE','SSOUR', N1, N2, SSOUR)
     	  CALL	STORE_R ('OE','THETA', N1, N2, THETA)
     	  CALL	STORE_R ('OE','SIMAG', N1, N2, SIMAG)
     	  CALL	STORE_R ('OE','RDSOUR', N1, N2, RDSOUR)
     	  CALL	STORE_R ('OE','RTHETA', N1, N2, RTHETA)
     	  CALL	STORE_R ('OE','R_IND_OBJ', N1, N2, R_IND_OBJ)
     	  CALL	STORE_R ('OE','R_IND_IMA', N1, N2, R_IND_IMA)
      	  CALL	STORE_R ('OE','OFF_SOUX', N1, N2, OFF_SOUX)
     	  CALL	STORE_R ('OE','OFF_SOUY', N1, N2, OFF_SOUY)
     	  CALL	STORE_R ('OE','OFF_SOUZ', N1, N2, OFF_SOUZ)
     	  CALL	STORE_R ('OE','ALPHA_S', N1, N2, ALPHA_S)
      	  CALL	STORE_R ('OE','RLEN1', N1, N2, RLEN1)
     	  CALL	STORE_R ('OE','RLEN2', N1, N2, RLEN2)
     	  CALL	STORE_R ('OE','RMIRR', N1, N2, RMIRR)
     	  CALL	STORE_R ('OE','AXMAJ', N1, N2, AXMAJ)
     	  CALL	STORE_R ('OE','AXMIN', N1, N2, AXMIN)
     	  CALL	STORE_R ('OE','CONE_A', N1, N2, CONE_A)
      	  CALL	STORE_R ('OE','R_MAJ', N1, N2, R_MAJ)
     	  CALL	STORE_R ('OE','R_MIN', N1, N2, R_MIN)
     	  CALL	STORE_R ('OE','RWIDX1', N1, N2, RWIDX1)
     	  CALL	STORE_R ('OE','RWIDX2', N1, N2, RWIDX2)
     	  CALL	STORE_R ('OE','PARAM', N1, N2, PARAM)
     	  CALL	STORE_R ('OE','HUNT_H', N1, N2, HUNT_H)
     	  CALL	STORE_R ('OE','HUNT_L', N1, N2, HUNT_L)
      	  CALL	STORE_R ('OE','BLAZE', N1, N2, BLAZE)
     	  CALL	STORE_R ('OE','RULING', N1, N2, RULING)
     	  CALL	STORE_R ('OE','ORDER', N1, N2, ORDER)
     	  CALL	STORE_R ('OE','PHOT_CENT', N1, N2, PHOT_CENT)
     	  CALL	STORE_R ('OE','X_ROT', N1, N2, X_ROT)
     	  CALL	STORE_R ('OE','A_BRAGG', N1, N2, A_BRAGG)
     	  CALL	STORE_R ('OE','D_SPACING', N1, N2, D_SPACING)
      	  CALL	STORE_R ('OE','Y_ROT', N1, N2, Y_ROT)
     	  CALL	STORE_R ('OE','Z_ROT', N1, N2, Z_ROT)
     	  CALL	STORE_R ('OE','OFFX', N1, N2, OFFX)
     	  CALL	STORE_R ('OE','OFFY', N1, N2, OFFY)
     	  CALL	STORE_R ('OE','OFFZ', N1, N2, OFFZ)
     	  CALL	STORE_R ('OE','SLLEN', N1, N2, SLLEN)
     	  CALL	STORE_R ('OE','SLWID', N1, N2, SLWID)
     	  CALL	STORE_R ('OE','SLTILT', N1, N2, SLTILT)
          CALL  STORE_R ('OE','SPREAD_MOS', N1, N2, SPREAD_MOS)
          CALL  STORE_R ('OE','THICKNESS', N1, N2, THICKNESS)
          CALL  STORE_R ('OE','R_JOHANSSON', N1, N2, R_JOHANSSON)
     	  CALL	STORE_R ('OE','COD_LEN', N1, N2, COD_LEN)
      	  CALL	STORE_R ('OE','COD_WID', N1, N2, COD_WID)
      	  CALL	STORE_R ('OE','X_SOUR', N1, N2, X_SOUR)
     	  CALL	STORE_R ('OE','Y_SOUR', N1, N2, Y_SOUR)
     	  CALL	STORE_R ('OE','Z_SOUR', N1, N2, Z_SOUR)
     	  CALL	STORE_R ('OE','X_SOUR_ROT', N1, N2, X_SOUR_ROT)
     	  CALL	STORE_R ('OE','Y_SOUR_ROT', N1, N2, Y_SOUR_ROT)
      	  CALL	STORE_R ('OE','Z_SOUR_ROT', N1, N2, Z_SOUR_ROT)
     	  CALL	STORE_R ('OE','R_LAMBDA', N1, N2, R_LAMBDA)
     	  CALL	STORE_R ('OE','THETA_I', N1, N2, THETA_I)
     	  CALL	STORE_R ('OE','ALPHA_I', N1, N2, ALPHA_I)
      	  CALL	STORE_R ('OE','T_INCIDENCE', N1, N2, T_INCIDENCE)
     	  CALL	STORE_R ('OE','T_SOURCE', N1, N2, T_SOURCE)
     	  CALL	STORE_R ('OE','T_IMAGE', N1, N2, T_IMAGE)
     	  CALL	STORE_R ('OE','T_REFLECTION', N1, N2, T_REFLECTION)
     	  CALL	STORE_A	('OE','FILE_SOURCE', N1, N2, FILE_SOURCE)
      	  CALL	STORE_A	('OE','FILE_RIP', N1, N2, FILE_RIP)
     	  CALL	STORE_A	('OE','FILE_REFL', N1, N2, FILE_REFL)
     	  CALL	STORE_A	('OE','FILE_MIR', N1, N2, FILE_MIR)
     	  CALL	STORE_A	('OE','FILE_ROUGH', N1, N2, FILE_ROUGH)
      	  CALL	STORE_R ('OE','HOLO_R1', N1, N2, HOLO_R1)
     	  CALL	STORE_R ('OE','HOLO_R2', N1, N2, HOLO_R2)
     	  CALL	STORE_R ('OE','HOLO_DEL', N1, N2, HOLO_DEL)
     	  CALL	STORE_R ('OE','HOLO_GAM', N1, N2, HOLO_GAM)
     	  CALL	STORE_R ('OE','HOLO_W', N1, N2, HOLO_W)
     	  CALL	STORE_R ('OE','HOLO_RT1', N1, N2, HOLO_RT1)
     	  CALL	STORE_R ('OE','HOLO_RT2', N1, N2, HOLO_RT2)
     	  CALL	STORE_R ('OE','AZIM_FAN', N1, N2, AZIM_FAN)
     	  CALL	STORE_R ('OE','DIST_FAN', N1, N2, DIST_FAN)
     	  CALL	STORE_R ('OE','COMA_FAC', N1, N2, COMA_FAC)
     	  CALL	STORE_R ('OE','ALFA', N1, N2, ALFA)
     	  CALL	STORE_R ('OE','GAMMA', N1, N2, GAMMA)
     	  CALL	STORE_R ('OE','RUL_A1', N1, N2, RUL_A1)
     	  CALL	STORE_R ('OE','RUL_A2', N1, N2, RUL_A2)
     	  CALL	STORE_R ('OE','RUL_A3', N1, N2, RUL_A3)
     	  CALL	STORE_R ('OE','RUL_A4', N1, N2, RUL_A4)
	  CALL  STORE_EI('OE','F_POLSEL', N1, N2, F_POLSEL)
	  CALL  STORE_Y ('OE','F_FACET', N1, N2, F_FACET)
	  CALL  STORE_EI('OE','F_FAC_ORIENT', N1, N2, F_FAC_ORIENT)
	  CALL  STORE_EI('OE','F_FAC_LATT', N1, N2, F_FAC_LATT)
	  CALL  STORE_R ('OE','RFAC_LENX', N1, N2, RFAC_LENX)
	  CALL  STORE_R ('OE','RFAC_LENY', N1, N2, RFAC_LENY)
	  CALL  STORE_R ('OE','RFAC_PHAX', N1, N2, RFAC_PHAX)
	  CALL  STORE_R ('OE','RFAC_PHAY', N1, N2, RFAC_PHAY)
	  CALL  STORE_R ('OE','RFAC_DELX1', N1, N2, RFAC_DELX1)
	  CALL  STORE_R ('OE','RFAC_DELX2', N1, N2, RFAC_DELX2)
	  CALL  STORE_R ('OE','RFAC_DELY1', N1, N2, RFAC_DELY1)
	  CALL  STORE_R ('OE','RFAC_DELY2', N1, N2, RFAC_DELY2)
          CALL  STORE_A ('OE','FILE_FAC', N1, N2, FILE_FAC)
          CALL  STORE_Y ('OE','F_SEGMENT', N1, N2, F_SEGMENT)
          CALL  STORE_I ('OE','ISEG_XNUM', N1, N2, ISEG_XNUM)
          CALL  STORE_I ('OE','ISEG_YNUM', N1, N2, ISEG_YNUM)
          CALL  STORE_A ('OE','FILE_SEGMENT', N1, N2, FILE_SEGMENT)
          CALL  STORE_A ('OE','FILE_SEGP', N1, N2, FILE_SEGP)
          CALL  STORE_R ('OE','SEG_LENX', N1, N2, SEG_LENX)
          CALL  STORE_R ('OE','SEG_LENY', N1, N2, SEG_LENY)
	  CALL  STORE_Y ('OE','F_KOMA', N1, N2, F_KOMA)
	  CALL  STORE_A ('OE','FILE_KOMA', N1, N2, FILE_KOMA)
	  CALL  STORE_Y ('OE','F_EXIT_SHAPE', N1, N2, F_EXIT_SHAPE)
	  CALL  STORE_Y ('OE','F_INC_MNOR_ANG', N1, N2, F_INC_MNOR_ANG)
	  CALL  STORE_R ('OE','ZKO_LENGTH', N1, N2, ZKO_LENGTH)
	  CALL  STORE_R ('OE','RKOMA_CX', N1, N2, RKOMA_CX)
	  CALL  STORE_R ('OE','RKOMA_CY', N1, N2, RKOMA_CY)
	  CALL  STORE_Y ('OE','F_KOMA_CA', N1, N2, F_KOMA_CA)
	  CALL  STORE_A ('OE','FILE_KOMA_CA', N1, N2, FILE_KOMA_CA)
	  CALL  STORE_Y ('OE','F_KOMA_BOUNCE', N1, N2, F_KOMA_BOUNCE)
      	  CALL	STORE_R ('OE','X_RIP_AMP', N1, N2, X_RIP_AMP)
     	  CALL	STORE_R ('OE','X_RIP_WAV', N1, N2, X_RIP_WAV)
     	  CALL	STORE_R ('OE','X_PHASE', N1, N2, X_PHASE)
      	  CALL	STORE_R ('OE','Y_RIP_AMP', N1, N2, Y_RIP_AMP)
     	  CALL	STORE_R ('OE','Y_RIP_WAV', N1, N2, Y_RIP_WAV)
     	  CALL	STORE_R ('OE','Y_PHASE', N1, N2, Y_PHASE)
	  CALL  STORE_R ('OE','ROUGH_X', N1, N2, ROUGH_X)
	  CALL  STORE_R ('OE','ROUGH_Y', N1, N2, ROUGH_Y)
          CALL	STORE_I	('OE','OE_NUMBER', N1, N2, N1)
     	  CALL	STORE_I ('OE','N_SCREEN', N1 ,N2, N_SCREEN)
     	  NOLD = N1
	  IF (F_RIPPLE.EQ.1.OR.F_ROUGHNESS.EQ.1.OR.F_FACET.EQ.1.OR.
     *        F_KOMA.EQ.1.OR.F_SEGMENT.EQ.1) THEN
		FDUMMY = 1
	  ELSE
		FDUMMY = 0
	  ENDIF
	  CALL  STORE_Y ('OE','FDUMMY', N1, N2, FDUMMY)
     	 DO N2=1,N_SCREEN
c
c  Add a screen template if does not yet exist
c
     	   NEW_SCR = N2
	   CALL ADDSCR 	( N1, NEW_SCR, NEW_SCR)
     	   CALL	STORE_R ('SCR','THICK', N1, N2, THICK(N2))
     	   CALL	STORE_R ('SCR','RX_SLIT', N1, N2, RX_SLIT(N2))
     	   CALL	STORE_R ('SCR','RZ_SLIT', N1, N2, RZ_SLIT(N2))
     	   CALL	STORE_R ('SCR','CX_SLIT', N1, N2, CX_SLIT(N2))
     	   CALL	STORE_R ('SCR','CZ_SLIT', N1, N2, CZ_SLIT(N2))
     	   CALL	STORE_R ('SCR','SL_DIS', N1, N2, SL_DIS(N2))
     	   CALL	STORE_I ('SCR','SCR_NUMBER',N1,N2,SCR_NUMBER(N2))
#if HP_F77_BUGGY_NAMELIST
     	   CALL	STORE_A	('SCR','FILABS', N1, N2, FILABS(N2))
     	   CALL	STORE_A	('SCR','FILSCR', N1, N2, FILSCR(N2))
#else
     	   CALL	STORE_A	('SCR','FILE_ABS', N1, N2, FILE_ABS(N2))
     	   CALL	STORE_A	('SCR','FILE_SCR_EXT', N1, N2, FILE_SCR_EXT(N2))
#endif
     	   CALL	STORE_EI ('SCR','I_SCREEN', N1, N2, I_SCREEN(N2))
     	   CALL	STORE_Y ('SCR','I_ABS', N1, N2, I_ABS(N2))
     	   CALL	STORE_EI ('SCR','I_STOP', N1, N2, I_STOP(N2))
      	   CALL	STORE_Y ('SCR','I_SLIT', N1, N2, I_SLIT(N2))
     	   CALL	STORE_EI ('SCR','K_SLIT', N1, N2, K_SLIT(N2))
     	 END DO
     	  N1 = NOLD
C
C-----------------------------------------------------------------------
C
C SOURCE CASE
C
     	ELSE IF (WHAT.EQ.'SOURCE') THEN
     	  CALL	RWNAME ( NEWNAME(1:LFIL), 'R_SOUR', IFLAG)
     	 IF (IFLAG.LT.0) RETURN
     	  CALL	STORE_Y	('SRC','F_NEW', N1, N2, F_NEW)
     	  CALL	STORE_EI ('SRC','FDISTR', N1, N2, FDISTR)
     	  CALL	STORE_EI ('SRC','FGRID', N1, N2, FGRID)
     	  CALL	STORE_EI ('SRC','FSOUR', N1, N2, FSOUR)
     	  CALL	STORE_EI ('SRC','FSOURCE_DEPTH', N1, N2, FSOURCE_DEPTH)
      	  CALL	STORE_EI ('SRC','F_COHER', N1, N2, F_COHER)
     	  CALL	STORE_EI ('SRC','F_COLOR', N1, N2, F_COLOR)
     	  CALL	STORE_EI ('SRC','F_PHOT', N1, N2, F_PHOT)
     	  CALL	STORE_EI ('SRC','F_POL', N1, N2, F_POL)
     	  CALL	STORE_Y	('SRC','F_BOUND_SOUR', N1, N2, F_BOUND_SOUR)
     	  CALL	STORE_Y	('SRC','F_POLAR', N1, N2, F_POLAR)
    	  CALL	STORE_Y	('SRC','F_OPD', N1, N2, F_OPD)
    	  CALL	STORE_EI('SRC','F_WIGGLER', N1, N2, F_WIGGLER)
    	  CALL	STORE_EI('SRC','F_SR_TYPE', N1, N2, F_SR_TYPE)
      	  CALL	STORE_I	('SRC','IDO_VX', N1, N2, IDO_VX)
     	  CALL	STORE_I	('SRC','IDO_VZ', N1, N2, IDO_VZ)
     	  CALL	STORE_I	('SRC','IDO_X_S', N1, N2, IDO_X_S)
     	  CALL	STORE_I	('SRC','IDO_Y_S', N1, N2, IDO_Y_S)
      	  CALL	STORE_I	('SRC','IDO_Z_S', N1, N2, IDO_Z_S)
      	  CALL	STORE_I	('SRC','IDO_XL', N1, N2, IDO_XL)
      	  CALL	STORE_I	('SRC','IDO_XN', N1, N2, IDO_XN)
      	  CALL	STORE_I	('SRC','IDO_ZL', N1, N2, IDO_ZL)
      	  CALL	STORE_I	('SRC','IDO_ZN', N1, N2, IDO_ZN)
     	  CALL	STORE_I	('SRC','ISTAR1', N1, N2, ISTAR1)
     	  CALL	STORE_I	('SRC','NPOINT', N1, N2, NPOINT)
     	  CALL	STORE_I	('SRC','N_CIRCLE', N1, N2, N_CIRCLE)
     	  CALL	STORE_I	('SRC','N_COLOR', N1, N2, N_COLOR)
     	  CALL	STORE_I	('SRC','N_CONE', N1, N2, N_CONE)
      	  CALL	STORE_R	('SRC','CONV_FACT', N1, N2, CONV_FACT)
      	  CALL	STORE_R	('SRC','CONE_MAX', N1, N2, CONE_MAX)
     	  CALL	STORE_R	('SRC','CONE_MIN', N1, N2, CONE_MIN)
     	  CALL	STORE_R	('SRC','EPSI_DX', N1, N2, EPSI_DX)
     	  CALL	STORE_R	('SRC','EPSI_DZ', N1, N2, EPSI_DZ)
     	  CALL	STORE_R	('SRC','EPSI_X', N1, N2, EPSI_X)
     	  CALL	STORE_R	('SRC','EPSI_Z', N1, N2, EPSI_Z)
     	  CALL	STORE_R	('SRC','HDIV1', N1, N2, HDIV1)
     	  CALL	STORE_R	('SRC','HDIV2', N1, N2, HDIV2)
     	  CALL	STORE_R	('SRC','PH1', N1, N2, PH1)
     	  CALL	STORE_R	('SRC','PH2', N1, N2, PH2)
     	  CALL	STORE_R	('SRC','PH3', N1, N2, PH3)
     	  CALL	STORE_R	('SRC','PH4', N1, N2, PH4)
     	  CALL	STORE_R	('SRC','PH5', N1, N2, PH5)
     	  CALL	STORE_R	('SRC','PH6', N1, N2, PH6)
     	  CALL	STORE_R	('SRC','PH7', N1, N2, PH7)
     	  CALL	STORE_R	('SRC','PH8', N1, N2, PH8)
     	  CALL	STORE_R	('SRC','PH9', N1, N2, PH9)
     	  CALL	STORE_R	('SRC','PH10', N1, N2, PH10)
     	  CALL	STORE_R	('SRC','RL1', N1, N2, RL1)
     	  CALL	STORE_R	('SRC','RL2', N1, N2, RL2)
     	  CALL	STORE_R	('SRC','RL3', N1, N2, RL3)
     	  CALL	STORE_R	('SRC','RL4', N1, N2, RL4)
     	  CALL	STORE_R	('SRC','RL5', N1, N2, RL5)
     	  CALL	STORE_R	('SRC','RL6', N1, N2, RL6)
     	  CALL	STORE_R	('SRC','RL7', N1, N2, RL7)
     	  CALL	STORE_R	('SRC','RL8', N1, N2, RL8)
     	  CALL	STORE_R	('SRC','RL9', N1, N2, RL9)
     	  CALL	STORE_R	('SRC','RL10', N1, N2, RL10)
     	  CALL	STORE_R	('SRC','SIGXL1', N1, N2, SIGXL1)
     	  CALL	STORE_R	('SRC','SIGXL2', N1, N2, SIGXL2)
     	  CALL	STORE_R	('SRC','SIGXL3', N1, N2, SIGXL3)
     	  CALL	STORE_R	('SRC','SIGXL4', N1, N2, SIGXL4)
     	  CALL	STORE_R	('SRC','SIGXL5', N1, N2, SIGXL5)
     	  CALL	STORE_R	('SRC','SIGXL6', N1, N2, SIGXL6)
     	  CALL	STORE_R	('SRC','SIGXL7', N1, N2, SIGXL7)
     	  CALL	STORE_R	('SRC','SIGXL8', N1, N2, SIGXL8)
     	  CALL	STORE_R	('SRC','SIGXL9', N1, N2, SIGXL9)
     	  CALL	STORE_R	('SRC','SIGXL10', N1, N2, SIGXL10)
     	  CALL	STORE_R	('SRC','SIGZL1', N1, N2, SIGZL1)
     	  CALL	STORE_R	('SRC','SIGZL2', N1, N2, SIGZL2)
     	  CALL	STORE_R	('SRC','SIGZL3', N1, N2, SIGZL3)
     	  CALL	STORE_R	('SRC','SIGZL4', N1, N2, SIGZL4)
     	  CALL	STORE_R	('SRC','SIGZL5', N1, N2, SIGZL5)
     	  CALL	STORE_R	('SRC','SIGZL6', N1, N2, SIGZL6)
     	  CALL	STORE_R	('SRC','SIGZL7', N1, N2, SIGZL7)
     	  CALL	STORE_R	('SRC','SIGZL8', N1, N2, SIGZL8)
     	  CALL	STORE_R	('SRC','SIGZL9', N1, N2, SIGZL9)
     	  CALL	STORE_R	('SRC','SIGZL10', N1, N2, SIGZL10)
     	  CALL	STORE_R	('SRC','BENER', N1, N2, BENER)
      	  CALL	STORE_R	('SRC','POL_ANGLE', N1, N2, POL_ANGLE)
     	  CALL	STORE_R	('SRC','POL_DEG', N1, N2, POL_DEG)
     	  CALL	STORE_R	('SRC','R_ALADDIN', N1, N2, R_ALADDIN)
     	  CALL	STORE_R	('SRC','R_MAGNET', N1, N2, R_MAGNET)
     	  CALL	STORE_R	('SRC','SIGDIX', N1, N2, SIGDIX)
     	  CALL	STORE_R	('SRC','SIGDIZ', N1, N2, SIGDIZ)
      	  CALL	STORE_R	('SRC','SIGMAX', N1, N2, SIGMAX)
     	  CALL	STORE_R	('SRC','SIGMAY', N1, N2, SIGMAY)
     	  CALL	STORE_R	('SRC','SIGMAZ', N1, N2, SIGMAZ)
     	  CALL	STORE_R	('SRC','VDIV1', N1, N2, VDIV1)
     	  CALL	STORE_R	('SRC','VDIV2', N1, N2, VDIV2)
     	  CALL	STORE_R	('SRC','WXSOU', N1, N2, WXSOU)
     	  CALL	STORE_R	('SRC','WYSOU', N1, N2, WYSOU)
     	  CALL	STORE_R	('SRC','WZSOU', N1, N2, WZSOU)
     	  CALL	STORE_R	('SRC','PLASMA_ANGLE', N1, N2, PLASMA_ANGLE)
          CALL	STORE_A	('SRC','FILE_BOUND', N1, N2, FILE_BOUND)
          CALL	STORE_A	('SRC','FILE_SOURCE', N1, N2, FILE_SOURCE)
          CALL	STORE_A	('SRC','FILE_TRAJ', N1, N2, FILE_TRAJ)
     	END IF
     	RETURN
     	END
C+++
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C	SUBROUTINE		WRITE_NML
C
C	PURPOSE			To WRITE in LOADxx a standard NAMELIST 
C				file
C
C	INPUTS		N0	Disk file
C			N1	Internal OE #
C---
     	SUBROUTINE	WRITE_NML (INFILE, WHAT, N1, N0, IFLAG)
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../../include/common.blk'
c	INCLUDE         './../../include/namelist.blk'
c
c
#	include		<common.blk>
#	include		<namelist.blk>
#	include		"parms.inc"
#elif defined(vms)
     	INCLUDE		'shade:common.blk'
     	INCLUDE		'shade:namelist.blk'
	INCLUDE		'parms.inc'
#endif
     	CHARACTER*(*)	INFILE,WHAT
     	CHARACTER*80	NEWNAME
     	CALL	DESPACE	(INFILE,NEWNAME,KLEN)
     	WRITE	(NEWNAME(KLEN+1:KLEN+3), 1030) '.',N0
1030	FORMAT (A,I2.2)
     	N2	=  0
     	IFLAG	=  0
     	LFIL = KLEN + 3
	MESSAGE = 'Writing to file ' // NEWNAME (1:LFIL)
	CALL SIMPLEMESSAGE 
d    	WRITE (*,*)'Writing to file ',NEWNAME(1:LFIL)
     	IF (WHAT.EQ.'OE') THEN
	  IF (FDUMMY.EQ.0) THEN
		F_RIPPLE = 0
		F_FACET = 0
		F_ROUGHNESS = 0
		F_KOMA = 0
		F_SEGMENT = 0
	  ENDIF

C    	  CALL	WHAT_I ('OE','FSYST', N1, N2, FSYST)
     	  CALL	WHAT_I ('OE','FMIRR', N1, N2, FMIRR)
     	  CALL	WHAT_I ('OE','F_TORUS', N1, N2, F_TORUS)
     	  CALL	WHAT_Y ('OE','FCYL', N1, N2, FCYL)
     	  CALL	WHAT_I ('OE','F_EXT', N1, N2, F_EXT)
     	  CALL	WHAT_I ('OE','FSTAT', N1, N2, FSTAT)
     	  CALL	WHAT_I ('OE','FWRITE', N1, N2, FWRITE)
     	  CALL	WHAT_Y ('OE','FSLIT', N1, N2, FSLIT)
     	  CALL	WHAT_Y ('OE','F_RIPPLE', N1, N2, F_RIPPLE)
     	  CALL	WHAT_Y ('OE','F_MOVE', N1, N2, F_MOVE)
      	  CALL	WHAT_I ('OE','F_G_S', N1, N2, F_G_S)
     	  CALL	WHAT_I ('OE','F_R_RAN', N1, N2, F_R_RAN)
     	  CALL	WHAT_I ('OE','F_GRATING', N1, N2, F_GRATING)
      	  CALL	WHAT_I ('OE','F_SIDE', N1, N2, F_SIDE)
     	  CALL	WHAT_Y ('OE','F_CENTRAL', N1, N2, F_CENTRAL)
     	  CALL	WHAT_I ('OE','F_CONVEX', N1, N2, F_CONVEX)
     	  CALL	WHAT_I ('OE','F_REFLEC', N1, N2, F_REFLEC)
      	  CALL	WHAT_I ('OE','F_RUL_ABS', N1, N2, F_RUL_ABS)
      	  CALL	WHAT_I ('OE','F_RULING', N1, N2, F_RULING)
     	  CALL	WHAT_I ('OE','F_PW', N1, N2, F_PW)
     	  CALL	WHAT_I ('OE','F_PW_C', N1, N2, F_PW_C)
     	  CALL	WHAT_I ('OE','F_VIRTUAL', N1, N2, F_VIRTUAL)
     	  CALL	WHAT_I ('OE','FSHAPE', N1, N2, FSHAPE)
     	  CALL	WHAT_Y ('OE','FHIT_C', N1, N2, FHIT_C)
     	  CALL	WHAT_I ('OE','F_MONO', N1, N2, F_MONO)
      	  CALL	WHAT_I ('OE','F_REFRAC', N1, N2, F_REFRAC)
     	  CALL	WHAT_I ('OE','F_DEFAULT', N1, N2, F_DEFAULT)
     	  CALL	WHAT_I ('OE','F_REFL', N1, N2, F_REFL)
     	  CALL	WHAT_I ('OE','F_HUNT', N1, N2, F_HUNT)
     	  CALL	WHAT_Y ('OE','F_BRAGG_A', N1, N2, F_BRAGG_A)
     	  CALL	WHAT_Y ('OE','F_CRYSTAL', N1, N2, F_CRYSTAL)
          CALL  WHAT_Y ('OE','F_MOSAIC', N1, N2, F_MOSAIC)
          CALL  WHAT_Y ('OE','F_JOHANSSON', N1, N2, F_JOHANSSON)
     	  CALL	WHAT_Y ('OE','F_THICK', N1, N2, F_THICK)
     	  CALL	WHAT_I ('OE','F_PHOT_CENT', N1, N2, F_PHOT_CENT)
     	  CALL	WHAT_Y ('OE','F_ROUGHNESS', N1, N2, F_ROUGHNESS)
     	  CALL	WHAT_Y ('OE','F_ANGLE', N1, N2, F_ANGLE)
     	  CALL 	WHAT_I ('OE','N_PLATES', N1, N2, N_PLATES)
          CALL  WHAT_I ('OE','MOSAIC_SEED', N1, N2, MOSAIC_SEED)
     	  CALL	WHAT_Y ('OE','F_PLATE', N1, N2, F_PLATE)
     	  CALL	WHAT_Y ('OE','FZP', N1, N2, FZP)
     	  CALL	WHAT_R ('OE','CIL_ANG', N1, N2, CIL_ANG)
     	  CALL	WHAT_R ('OE','ELL_THE', N1, N2, ELL_THE)
     	  CALL	WHAT_R ('OE','ALPHA', N1, N2, ALPHA)
     	  CALL	WHAT_R ('OE','SSOUR', N1, N2, SSOUR)
     	  CALL	WHAT_R ('OE','THETA', N1, N2, THETA)
     	  CALL	WHAT_R ('OE','SIMAG', N1, N2, SIMAG)
     	  CALL	WHAT_R ('OE','RDSOUR', N1, N2, RDSOUR)
     	  CALL	WHAT_R ('OE','RTHETA', N1, N2, RTHETA)
     	  CALL	WHAT_R ('OE','R_IND_OBJ', N1, N2, R_IND_OBJ)
     	  CALL	WHAT_R ('OE','R_IND_IMA', N1, N2, R_IND_IMA)
      	  CALL	WHAT_R ('OE','OFF_SOUX', N1, N2, OFF_SOUX)
     	  CALL	WHAT_R ('OE','OFF_SOUY', N1, N2, OFF_SOUY)
     	  CALL	WHAT_R ('OE','OFF_SOUZ', N1, N2, OFF_SOUZ)
     	  CALL	WHAT_R ('OE','ALPHA_S', N1, N2, ALPHA_S)
      	  CALL	WHAT_R ('OE','RLEN1', N1, N2, RLEN1)
     	  CALL	WHAT_R ('OE','RLEN2', N1, N2, RLEN2)
     	  CALL	WHAT_R ('OE','RMIRR', N1, N2, RMIRR)
     	  CALL	WHAT_R ('OE','AXMAJ', N1, N2, AXMAJ)
     	  CALL	WHAT_R ('OE','AXMIN', N1, N2, AXMIN)
     	  CALL	WHAT_R ('OE','CONE_A', N1, N2, CONE_A)
      	  CALL	WHAT_R ('OE','R_MAJ', N1, N2, R_MAJ)
     	  CALL	WHAT_R ('OE','R_MIN', N1, N2, R_MIN)
     	  CALL	WHAT_R ('OE','RWIDX1', N1, N2, RWIDX1)
     	  CALL	WHAT_R ('OE','RWIDX2', N1, N2, RWIDX2)
     	  CALL	WHAT_R ('OE','PARAM', N1, N2, PARAM)
     	  CALL	WHAT_R ('OE','HUNT_H', N1, N2, HUNT_H)
     	  CALL	WHAT_R ('OE','HUNT_L', N1, N2, HUNT_L)
      	  CALL	WHAT_R ('OE','BLAZE', N1, N2, BLAZE)
     	  CALL	WHAT_R ('OE','RULING', N1, N2, RULING)
     	  CALL	WHAT_R ('OE','ORDER', N1, N2, ORDER)
     	  CALL	WHAT_R ('OE','PHOT_CENT', N1, N2, PHOT_CENT)
     	  CALL	WHAT_R ('OE','X_ROT', N1, N2, X_ROT)
     	  CALL	WHAT_R ('OE','A_BRAGG', N1, N2, A_BRAGG)
     	  CALL	WHAT_R ('OE','D_SPACING', N1, N2, D_SPACING)
      	  CALL	WHAT_R ('OE','Y_ROT', N1, N2, Y_ROT)
     	  CALL	WHAT_R ('OE','Z_ROT', N1, N2, Z_ROT)
     	  CALL	WHAT_R ('OE','OFFX', N1, N2, OFFX)
     	  CALL	WHAT_R ('OE','OFFY', N1, N2, OFFY)
     	  CALL	WHAT_R ('OE','OFFZ', N1, N2, OFFZ)
     	  CALL	WHAT_R ('OE','SLLEN', N1, N2, SLLEN)
     	  CALL	WHAT_R ('OE','SLWID', N1, N2, SLWID)
     	  CALL	WHAT_R ('OE','SLTILT', N1, N2, SLTILT)
          CALL  WHAT_R ('OE','SPREAD_MOS', N1, N2, SPREAD_MOS)
          CALL  WHAT_R ('OE','THICKNESS', N1, N2, THICKNESS)
          CALL  WHAT_R ('OE','R_JOHANSSON', N1, N2, R_JOHANSSON)
     	  CALL	WHAT_R ('OE','COD_LEN', N1, N2, COD_LEN)
      	  CALL	WHAT_R ('OE','COD_WID', N1, N2, COD_WID)
      	  CALL	WHAT_R ('OE','X_SOUR', N1, N2, X_SOUR)
     	  CALL	WHAT_R ('OE','Y_SOUR', N1, N2, Y_SOUR)
     	  CALL	WHAT_R ('OE','Z_SOUR', N1, N2, Z_SOUR)
     	  CALL	WHAT_R ('OE','X_SOUR_ROT', N1, N2, X_SOUR_ROT)
     	  CALL	WHAT_R ('OE','Y_SOUR_ROT', N1, N2, Y_SOUR_ROT)
      	  CALL	WHAT_R ('OE','Z_SOUR_ROT', N1, N2, Z_SOUR_ROT)
     	  CALL	WHAT_R ('OE','R_LAMBDA', N1, N2, R_LAMBDA)
     	  CALL	WHAT_R ('OE','THETA_I', N1, N2, THETA_I)
     	  CALL	WHAT_R ('OE','ALPHA_I', N1, N2, ALPHA_I)
      	  CALL	WHAT_R ('OE','T_INCIDENCE', N1, N2, T_INCIDENCE)
     	  CALL	WHAT_R ('OE','T_SOURCE', N1, N2, T_SOURCE)
     	  CALL	WHAT_R ('OE','T_IMAGE', N1, N2, T_IMAGE)
     	  CALL	WHAT_R ('OE','T_REFLECTION', N1, N2, T_REFLECTION)
     	  CALL	WHAT_A	('OE','FILE_SOURCE', N1, N2, FILE_SOURCE)
      	  CALL	WHAT_A	('OE','FILE_RIP', N1, N2, FILE_RIP)
     	  CALL	WHAT_A	('OE','FILE_REFL', N1, N2, FILE_REFL)
     	  CALL	WHAT_A	('OE','FILE_MIR', N1, N2, FILE_MIR)
     	  CALL	WHAT_A	('OE','FILE_ROUGH', N1, N2, FILE_ROUGH)
      	  CALL	WHAT_R ('OE','HOLO_R1', N1, N2, HOLO_R1)
     	  CALL	WHAT_R ('OE','HOLO_R2', N1, N2, HOLO_R2)
     	  CALL	WHAT_R ('OE','HOLO_DEL', N1, N2, HOLO_DEL)
     	  CALL	WHAT_R ('OE','HOLO_GAM', N1, N2, HOLO_GAM)
     	  CALL	WHAT_R ('OE','HOLO_W', N1, N2, HOLO_W)
     	  CALL	WHAT_R ('OE','HOLO_RT1', N1, N2, HOLO_RT1)
     	  CALL	WHAT_R ('OE','HOLO_RT2', N1, N2, HOLO_RT2)
     	  CALL	WHAT_R ('OE','AZIM_FAN', N1, N2, AZIM_FAN)
     	  CALL	WHAT_R ('OE','DIST_FAN', N1, N2, DIST_FAN)
     	  CALL	WHAT_R ('OE','COMA_FAC', N1, N2, COMA_FAC)
     	  CALL	WHAT_R ('OE','ALFA', N1, N2, ALFA)
     	  CALL	WHAT_R ('OE','GAMMA', N1, N2, GAMMA)
     	  CALL	WHAT_R ('OE','RUL_A1', N1, N2, RUL_A1)
     	  CALL	WHAT_R ('OE','RUL_A2', N1, N2, RUL_A2)
     	  CALL	WHAT_R ('OE','RUL_A3', N1, N2, RUL_A3)
     	  CALL	WHAT_R ('OE','RUL_A4', N1, N2, RUL_A4)
	  CALL  WHAT_I ('OE','F_POLSEL', N1, N2, F_POLSEL)
	  CALL  WHAT_Y ('OE','F_FACET', N1, N2, F_FACET)
	  CALL  WHAT_I ('OE','F_FAC_ORIENT', N1, N2, F_FAC_ORIENT)
	  CALL  WHAT_I ('OE','F_FAC_LATT', N1, N2, F_FAC_LATT)
	  CALL  WHAT_R ('OE','RFAC_LENX', N1, N2, RFAC_LENX)
	  CALL  WHAT_R ('OE','RFAC_LENY', N1, N2, RFAC_LENY)
	  CALL  WHAT_R ('OE','RFAC_PHAX', N1, N2, RFAC_PHAX)
	  CALL  WHAT_R ('OE','RFAC_PHAY', N1, N2, RFAC_PHAY)
	  CALL  WHAT_R ('OE','RFAC_DELX1', N1, N2, RFAC_DELX1)
	  CALL  WHAT_R ('OE','RFAC_DELX2', N1, N2, RFAC_DELX2)
	  CALL  WHAT_R ('OE','RFAC_DELY1', N1, N2, RFAC_DELY1)
	  CALL  WHAT_R ('OE','RFAC_DELY2', N1, N2, RFAC_DELY2)
          CALL  WHAT_A ('OE','FILE_FAC', N1, N2, FILE_FAC)
          CALL  WHAT_Y ('OE','F_SEGMENT', N1, N2, F_SEGMENT)
          CALL  WHAT_I ('OE','ISEG_XNUM', N1, N2, ISEG_XNUM)
          CALL  WHAT_I ('OE','ISEG_YNUM', N1, N2, ISEG_YNUM)
          CALL  WHAT_A ('OE','FILE_SEGMENT', N1, N2, FILE_SEGMENT)
          CALL  WHAT_A ('OE','FILE_SEGP', N1, N2, FILE_SEGP)
          CALL  WHAT_R ('OE','SEG_LENX', N1, N2, SEG_LENX)
          CALL  WHAT_R ('OE','SEG_LENY', N1, N2, SEG_LENY)
          CALL  WHAT_Y ('OE','F_KOMA', N1, N2, F_KOMA)
	  CALL  WHAT_A ('OE','FILE_KOMA', N1, N2, FILE_KOMA)
	  CALL  WHAT_Y ('OE','F_EXIT_SHAPE', N1, N2, F_EXIT_SHAPE)
	  CALL  WHAT_Y ('OE','F_INC_MNOR_ANG', N1, N2, F_INC_MNOR_ANG)
	  CALL  WHAT_R ('OE','ZKO_LENGTH', N1, N2, ZKO_LENGTH)
	  CALL  WHAT_R ('OE','RKOMA_CX', N1, N2, RKOMA_CX)
	  CALL  WHAT_R ('OE','RKOMA_CY', N1, N2, RKOMA_CY)
	  CALL  WHAT_Y ('OE','F_KOMA_CA', N1, N2, F_KOMA_CA)
      	  CALL  WHAT_A ('OE','FILE_KOMA_CA', N1, N2, FILE_KOMA_CA)
	  CALL  WHAT_Y ('OE','F_KOMA_BOUNCE', N1, N2, F_KOMA_BOUNCE)
      	  CALL	WHAT_R ('OE','X_RIP_AMP', N1, N2, X_RIP_AMP)
     	  CALL	WHAT_R ('OE','X_RIP_WAV', N1, N2, X_RIP_WAV)
     	  CALL	WHAT_R ('OE','X_PHASE', N1, N2, X_PHASE)
      	  CALL	WHAT_R ('OE','Y_RIP_AMP', N1, N2, Y_RIP_AMP)
     	  CALL	WHAT_R ('OE','Y_RIP_WAV', N1, N2, Y_RIP_WAV)
     	  CALL	WHAT_R ('OE','Y_PHASE', N1, N2, Y_PHASE)
	  CALL  WHAT_R ('OE','ROUGH_X', N1, N2, ROUGH_X)
	  CALL  WHAT_R ('OE','ROUGH_Y', N1, N2, ROUGH_Y)
          CALL	WHAT_I	('OE','OE_NUMBER', N1, N2, OE_NUMBER)

c
c  get number of screens
c
	  CALL LASTONE ( N1, NCOUNTSCR)
     	  IF (NCOUNTSCR.NE.0) THEN
     	    F_SCREEN = 1
     	    N_SCREEN = NCOUNTSCR
     	  ELSE
     	    F_SCREEN = 0
     	    N_SCREEN = 0
     	  END IF
c
c  now for the screen corresponding to this optical element
c  get next screen variable
c
	 DO N2=1,NCOUNTSCR
     	    CALL	WHAT_R ('SCR','THICK', N1, N2, THICK(N2))
     	    CALL	WHAT_R ('SCR','RX_SLIT', N1, N2, RX_SLIT(N2))
     	    CALL	WHAT_R ('SCR','RZ_SLIT', N1, N2, RZ_SLIT(N2))
     	    CALL	WHAT_R ('SCR','CX_SLIT', N1, N2, CX_SLIT(N2))
     	    CALL	WHAT_R ('SCR','CZ_SLIT', N1, N2, CZ_SLIT(N2))
     	    CALL	WHAT_R ('SCR','SL_DIS', N1, N2, SL_DIS(N2))
     	    CALL	WHAT_I ('SCR','SCR_NUMBER',N1,N2,SCR_NUMBER(N2))
#if HP_F77_BUGGY_NAMELIST
     	    CALL	WHAT_A ('SCR','FILABS', N1, N2, FILABS(N2))
     	    CALL	WHAT_A ('SCR','FILSCR', N1, N2, FILSCR(N2))
#else
     	    CALL	WHAT_A ('SCR','FILE_ABS', N1, N2, FILE_ABS(N2))
     	    CALL	WHAT_A ('SCR','FILE_SCR_EXT', N1, N2, 
     $				FILE_SCR_EXT(N2))
#endif
     	    CALL	WHAT_I ('SCR','I_SCREEN', N1, N2, I_SCREEN(N2))
     	    CALL	WHAT_Y ('SCR','I_ABS', N1, N2, I_ABS(N2))
     	    CALL	WHAT_I ('SCR','I_STOP', N1, N2, I_STOP(N2))
      	    CALL	WHAT_Y ('SCR','I_SLIT', N1, N2, I_SLIT(N2))
     	    CALL	WHAT_I ('SCR','K_SLIT', N1, N2, K_SLIT(N2))
     	 END DO
C
C All the variables are defined; write them out
C
     	  CALL	RWNAME (NEWNAME(1:LFIL), 'W_OE', IFLAG)
     	 IF (IFLAG.EQ.0) RETURN
C
C-----------------------------------------------------------------------
C
C SOURCE CASE
C
     	ELSE IF (WHAT.EQ.'SOURCE') THEN
     	  CALL	WHAT_Y	('SRC','F_NEW', N1, N2, F_NEW)
     	  CALL	WHAT_I	('SRC','FDISTR', N1, N2, FDISTR)
     	  CALL	WHAT_I	('SRC','FGRID', N1, N2, FGRID)
     	  CALL	WHAT_I	('SRC','FSOUR', N1, N2, FSOUR)
     	  CALL	WHAT_I	('SRC','FSOURCE_DEPTH', N1, N2, FSOURCE_DEPTH)
      	  CALL	WHAT_I	('SRC','F_COHER', N1, N2, F_COHER)
     	  CALL	WHAT_I	('SRC','F_COLOR', N1, N2, F_COLOR)
     	  CALL	WHAT_I	('SRC','F_PHOT', N1, N2, F_PHOT)
     	  CALL	WHAT_I	('SRC','F_POL', N1, N2, F_POL)
     	  CALL	WHAT_Y	('SRC','F_BOUND_SOUR', N1, N2, F_BOUND_SOUR)
     	  CALL	WHAT_Y	('SRC','F_POLAR', N1, N2, F_POLAR)
     	  CALL	WHAT_Y	('SRC','F_OPD', N1, N2, F_OPD)
     	  CALL	WHAT_I	('SRC','F_WIGGLER', N1, N2, F_WIGGLER)
     	  CALL	WHAT_I	('SRC','F_SR_TYPE', N1, N2, F_SR_TYPE)
      	  CALL	WHAT_I	('SRC','IDO_VX', N1, N2, IDO_VX)
     	  CALL	WHAT_I	('SRC','IDO_VZ', N1, N2, IDO_VZ)
     	  CALL	WHAT_I	('SRC','IDO_X_S', N1, N2, IDO_X_S)
     	  CALL	WHAT_I	('SRC','IDO_Y_S', N1, N2, IDO_Y_S)
      	  CALL	WHAT_I	('SRC','IDO_Z_S', N1, N2, IDO_Z_S)
      	  CALL	WHAT_I	('SRC','IDO_XL', N1, N2, IDO_XL)
      	  CALL	WHAT_I	('SRC','IDO_XN', N1, N2, IDO_XN)
      	  CALL	WHAT_I	('SRC','IDO_ZL', N1, N2, IDO_ZL)
      	  CALL	WHAT_I	('SRC','IDO_ZN', N1, N2, IDO_ZN)
     	  CALL	WHAT_I	('SRC','ISTAR1', N1, N2, ISTAR1)
     	  CALL	WHAT_I	('SRC','NPOINT', N1, N2, NPOINT)
     	  CALL	WHAT_I	('SRC','N_CIRCLE', N1, N2, N_CIRCLE)
     	  CALL	WHAT_I	('SRC','N_COLOR', N1, N2, N_COLOR)
     	  CALL	WHAT_I	('SRC','N_CONE', N1, N2, N_CONE)
      	  CALL	WHAT_R	('SRC','CONV_FACT', N1, N2, CONV_FACT)
      	  CALL	WHAT_R	('SRC','CONE_MAX', N1, N2, CONE_MAX)
     	  CALL	WHAT_R	('SRC','CONE_MIN', N1, N2, CONE_MIN)
     	  CALL	WHAT_R	('SRC','EPSI_DX', N1, N2, EPSI_DX)
     	  CALL	WHAT_R	('SRC','EPSI_DZ', N1, N2, EPSI_DZ)
     	  CALL	WHAT_R	('SRC','EPSI_X', N1, N2, EPSI_X)
     	  CALL	WHAT_R	('SRC','EPSI_Z', N1, N2, EPSI_Z)
     	  CALL	WHAT_R	('SRC','HDIV1', N1, N2, HDIV1)
     	  CALL	WHAT_R	('SRC','HDIV2', N1, N2, HDIV2)
     	  CALL	WHAT_R	('SRC','PH1', N1, N2, PH1)
     	  CALL	WHAT_R	('SRC','PH2', N1, N2, PH2)
     	  CALL	WHAT_R	('SRC','PH3', N1, N2, PH3)
     	  CALL	WHAT_R	('SRC','PH4', N1, N2, PH4)
     	  CALL	WHAT_R	('SRC','PH5', N1, N2, PH5)
     	  CALL	WHAT_R	('SRC','PH6', N1, N2, PH6)
     	  CALL	WHAT_R	('SRC','PH7', N1, N2, PH7)
     	  CALL	WHAT_R	('SRC','PH8', N1, N2, PH8)
     	  CALL	WHAT_R	('SRC','PH9', N1, N2, PH9)
     	  CALL	WHAT_R	('SRC','PH10', N1, N2, PH10)
     	  CALL	WHAT_R	('SRC','RL1', N1, N2, RL1)
     	  CALL	WHAT_R	('SRC','RL2', N1, N2, RL2)
     	  CALL	WHAT_R	('SRC','RL3', N1, N2, RL3)
     	  CALL	WHAT_R	('SRC','RL4', N1, N2, RL4)
     	  CALL	WHAT_R	('SRC','RL5', N1, N2, RL5)
     	  CALL	WHAT_R	('SRC','RL6', N1, N2, RL6)
     	  CALL	WHAT_R	('SRC','RL7', N1, N2, RL7)
     	  CALL	WHAT_R	('SRC','RL8', N1, N2, RL8)
     	  CALL	WHAT_R	('SRC','RL9', N1, N2, RL9)
     	  CALL	WHAT_R	('SRC','RL10', N1, N2, RL10)
     	  CALL	WHAT_R	('SRC','SIGXL1', N1, N2, SIGXL1)
     	  CALL	WHAT_R	('SRC','SIGXL2', N1, N2, SIGXL2)
     	  CALL	WHAT_R	('SRC','SIGXL3', N1, N2, SIGXL3)
     	  CALL	WHAT_R	('SRC','SIGXL4', N1, N2, SIGXL4)
     	  CALL	WHAT_R	('SRC','SIGXL5', N1, N2, SIGXL5)
     	  CALL	WHAT_R	('SRC','SIGXL6', N1, N2, SIGXL6)
     	  CALL	WHAT_R	('SRC','SIGXL7', N1, N2, SIGXL7)
     	  CALL	WHAT_R	('SRC','SIGXL8', N1, N2, SIGXL8)
     	  CALL	WHAT_R	('SRC','SIGXL9', N1, N2, SIGXL9)
     	  CALL	WHAT_R	('SRC','SIGXL10', N1, N2, SIGXL10)
     	  CALL	WHAT_R	('SRC','SIGZL1', N1, N2, SIGZL1)
     	  CALL	WHAT_R	('SRC','SIGZL2', N1, N2, SIGZL2)
     	  CALL	WHAT_R	('SRC','SIGZL3', N1, N2, SIGZL3)
     	  CALL	WHAT_R	('SRC','SIGZL4', N1, N2, SIGZL4)
     	  CALL	WHAT_R	('SRC','SIGZL5', N1, N2, SIGZL5)
     	  CALL	WHAT_R	('SRC','SIGZL6', N1, N2, SIGZL6)
     	  CALL	WHAT_R	('SRC','SIGZL7', N1, N2, SIGZL7)
     	  CALL	WHAT_R	('SRC','SIGZL8', N1, N2, SIGZL8)
     	  CALL	WHAT_R	('SRC','SIGZL9', N1, N2, SIGZL9)
     	  CALL	WHAT_R	('SRC','SIGZL10', N1, N2, SIGZL10)
     	  CALL	WHAT_R	('SRC','BENER', N1, N2, BENER)
      	  CALL	WHAT_R	('SRC','POL_ANGLE', N1, N2, POL_ANGLE)
     	  CALL	WHAT_R	('SRC','POL_DEG', N1, N2, POL_DEG)
     	  CALL	WHAT_R	('SRC','R_ALADDIN', N1, N2, R_ALADDIN)
     	  CALL	WHAT_R	('SRC','R_MAGNET', N1, N2, R_MAGNET)
     	  CALL	WHAT_R	('SRC','SIGDIX', N1, N2, SIGDIX)
     	  CALL	WHAT_R	('SRC','SIGDIZ', N1, N2, SIGDIZ)
      	  CALL	WHAT_R	('SRC','SIGMAX', N1, N2, SIGMAX)
     	  CALL	WHAT_R	('SRC','SIGMAY', N1, N2, SIGMAY)
     	  CALL	WHAT_R	('SRC','SIGMAZ', N1, N2, SIGMAZ)
     	  CALL	WHAT_R	('SRC','VDIV1', N1, N2, VDIV1)
     	  CALL	WHAT_R	('SRC','VDIV2', N1, N2, VDIV2)
     	  CALL	WHAT_R	('SRC','WXSOU', N1, N2, WXSOU)
     	  CALL	WHAT_R	('SRC','WYSOU', N1, N2, WYSOU)
     	  CALL	WHAT_R	('SRC','WZSOU', N1, N2, WZSOU)
     	  CALL	WHAT_R	('SRC','PLASMA_ANGLE', N1, N2, PLASMA_ANGLE)
          CALL	WHAT_A	('SRC','FILE_BOUND', N1, N2, FILE_BOUND)
          CALL	WHAT_A	('SRC','FILE_SOURCE', N1, N2, FILE_SOURCE)
          CALL	WHAT_A	('SRC','FILE_TRAJ', N1, N2, FILE_TRAJ)
C
C all the variables are defined; write out
C
     	  CALL	RWNAME ( NEWNAME(1:LFIL), 'W_SOUR', IFLAG)
     	END IF
     	RETURN
     	END
