C +++
C
C Source: src/tools/math/tpol.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	tpol.f
C Revision 1.1  90/07/17  13:55:08  khan
C Initial revision
C 
C 
C ---

C+++
C	PROGRAM		TPOL
C
C	PURPOSE		TO TEST PORTHO1
C
C---
     	CHARACTER*80	OUTFIL
     	DIMENSION	COEFF(20)
     	WRITE(6,*)'Output file ?'
     	READ (5,1000)	OUTFIL
1000	FORMAT (A)
     	WRITE(6,*)'Enter Xmin,Xmax,NN'
     	READ(5,*)XMIN,XMAX,NN
     	WRITE(6,*)'Max order ?'
     	READ(5,*)NORD
     	DO 10 I=1,NORD+1
     	WRITE(6,*)'Coeff for Pol of order: ',I-1
     	READ(5,*)COEFF(I)
10      CONTINUE
     	WRITE (34,*) COEFF
     	STEP = (XMAX -XMIN)/(NN-1)
     	DO 20 J=1,NN
     	  VAL = 0.0D0
     	  X = (J-1)*STEP
     	 DO 30 I=0,NORD
     	  VAL = VAL + COEFF(I+1)*BPOL(X,I)
30       CONTINUE
     	WRITE (33,*) X*(XMAX-XMIN)+XMIN,VAL
20      CONTINUE
     	END
C+++
C	FUNCTION	BPOL (X,J)
C
C	Purpose		Computes the shifted Legendre polinomials of 
C			degree J at point X
C
C	Algorithm	Direct definition of the shifted Legendre
C			polinomials.
C
C	Limits		Argument domain must be within [ 0,1 ]
C
C---
     	FUNCTION	BPOL (X,J)
     	DIMENSION	XTEMP (20)
     	IF (X.GT.1.0.OR.X.LT.0.0)	WRITE(6,*)'Invalid argument ',X,J

	XTEMP(1)	=   1
C 	ZERO DEGREE

	XTEMP(2)	=   1 - 2*X
	XTEMP(3)	=   1 - 6*X + 6*X**2
	XTEMP(4)	=   1 - 12*X + 30*X**2 - 20*X**3
	XTEMP(5)	=   1 - 20*X + 90*X**2 - 140*X**3 + 70*X**4
     	IF (J.LT.5) THEN
     	  BPOL	= XTEMP(J+1)
     	  RETURN
     	END IF
c
c uses recurrence formulae for terms greater than 4
c
     	DO 10 I=6,J+1
     	 XTEMP(I) = (XTEMP(I-1)*(2*I-1-(4*I-2)*X)
     $			 - XTEMP(I-2)*(I-1))/I
10      CONTINUE
     	BPOL = XTEMP(J+1)
     	RETURN
     	END
