C +++
C
C Source: src/source/bm/white.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: white.F
C Revision 1.9  1991/04/22  00:12:05  khan
C Fixed #include quotes
C
C Revision 1.8  1991/04/05  14:22:21  cwelnak
C changed quotes on #include
C
C Revision 1.7  91/03/21  14:26:04  cwelnak
C SUN version -- changes INCLUDE to #include
C 
C Revision 1.6  90/11/13  14:00:49  khan
C Cleanup and SAVE statements
C 
C Revision 1.5  90/07/23  21:53:00  khan
C Renamed RCDF to be unique for each
C 
C Revision 1.4  90/07/18  19:13:19  khan
C Removed most of the subroutines to BM library (libbm.a) since these are
C called by most of the other programs.
C Also added #if vms ... #elif unix ... to OPEN statements.
C 
C Revision 1.3  90/07/14  22:39:20  khan
C All global include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.2  90/07/11  15:52:22  khan
C Fixed to read binary SR* files as with the VMS system. The ascii option
C is commented out.
C 
C Revision 1.1  90/07/10  14:57:41  khan
C Initial revision
C 
C 
C ---

C+++
C	SUBROUTINE	WHITE
C
C	PURPOSE		IER = 0, initialization and set up the splines of
C				 inverted cdf.
C			IER > 0, interpolate for the photon energy,vertical
C				 angle,and the degree of polarization.
C			IER < 0, purge away the longer arrays.
C
C---
	SUBROUTINE	WHITE	(RAD1,RAD2,A_PSEED,
     $				 A_ASEED,A_WAVE_NO,A_PSI,A_POLAR,IER)
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
	COMMON /CDFINDEX/	IMAX_1,IMIN_1,IINT_1,NKOL,
     $				IMAX_2,IMIN_2,IINT_2,IST
	REAL*8		PHOT(5,1010),PHOT_INV(5,1010)
	REAL*8		XPHOT(251),PSI_INV(5,21,251),PSI_POL(2,21,251)
	COMMON /SPL_ARR/	PHOT,PHOT_INV,XPHOT,PSI_INV,PSI_POL
	REAL*8		PORDER(10),RAD1,RAD2
	REAL*8		PSEED,ASEED,PSI,POLAR
	IF (IER.EQ.0.0D0)	GO TO 100
	IF (IER.LT.0.0D0)	GO TO 200
     	PSEED	=  A_PSEED
     	ASEED   =  A_ASEED
	CALL WHTICDF (RAD1,RAD2,PSEED,ASEED,
     $			A_WAVE_NO,PSI,POLAR)
     	A_PSI	=  PSI
     	A_POLAR	=  POLAR
	RETURN
C
C First arrange the photon energy in ascending order.
C
100	IF (F_COLOR.NE.1) THEN
     	  IF (F_COLOR.EQ.2) THEN
	    NKOL	= N_COLOR
	  ELSE IF (F_COLOR.EQ.3) THEN
	    NKOL 	= 2
	  END IF
	  DO  10 J = 1, NKOL
	    IPMIN = 1
	    DO 15 I = 2, NKOL
	      IF (PHOTON(I).LT.PHOTON(IPMIN))	IPMIN = I
15	    CONTINUE
	    PORDER(J)	 = PHOTON(IPMIN)
	    PHOTON(IPMIN)  = 1D20
10	  CONTINUE
          DO 20 J = 1, NKOL
            PHOTON(J)	= PORDER(J)
20          CONTINUE
     	ELSE
          NKOL	= 2
          PHOTON(2)	= PHOTON(1)
     	END IF
	CALL WHTRCDF (RAD1,RAD2)
	RETURN
200	CONTINUE
#ifdef vms
	MPURGE(1)	= %LOC(PHOT_INV(1,1))
        MPURGE(2)	= %LOC(PHOT_INV(5,1010))
	CALL SYS$PURGWS	(MPURGE)	
	MPURGE(1)	= %LOC(XPHOT(1))
	MPURGE(2)	= %LOC(XPHOT(251))
	CALL SYS$PURGWS	(MPURGE)	
	MPURGE(1)	= %LOC(PSI_INV(1,1,1))

	CALL SYS$PURGWS	(MPURGE)	
	MPURGE(1)	= %LOC(PSI_POL(1,1,1))
	MPURGE(2)	= %LOC(PSI_POL(2,21,251))
	CALL SYS$PURGWS	(MPURGE)	
#endif
	RETURN
	END

C ------------------------------------------------------------------------
C+++
C	SUBROUTINE	WHTRCDF
C
C	PURPOSE		To read the unformatted CDF for SR radiation, and
C			produce the spline coefficients for the 
C			original photon energy CDF (PHOT), the
C			inverted photon energy CDF (PHOT_INV) and the
C			inverted vertical angle CDF (PSI_INV).
C
C---
	SUBROUTINE	WHTRCDF  (RAD_MIN,RAD_MAX)
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
	REAL*8		PHOT(5,1010),PHOT_INV(5,1010)
	REAL*8		XPHOT(251),PSI_INV(5,21,251),PSI_POL(2,21,251)
	COMMON /SPL_ARR/	PHOT,PHOT_INV,XPHOT,PSI_INV,PSI_POL
     	REAL*8		Y(1010)
        REAL*8		PORDER(10),RAD_MIN,RAD_MAX
     	REAL*8		WORKG(5,21),WORKY(21)
	REAL*8		EMAX,EMIN,CMAX,CMIN,EDIFF,CDIFF,PDIFF,DUMM
	COMMON  /CDFINDEX/	IMAX_1,IMIN_1,IINT_1,NKOL,
     $				IMAX_2,IMIN_2,IINT_2,IST
	CHARACTER*132	SRSPEC, SRDISTR
C
C Get the data file path using either SHADOW$DATA or Unix SHADOW_DATA_DIR
C environment variable. Also, check for existence in the routine itself.
C
	IFLAG = 1
	CALL DATAPATH ('SRSPEC', SRSPEC, IFLAG) 
	IF (IFLAG.NE.0) THEN
	    CALL LEAVE ('WHITE', 'SRSPEC file not found', IFLAG)
	ENDIF
	IFLAG = 1
	CALL DATAPATH ('SRDISTR', SRDISTR, IFLAG) 
	IF (IFLAG.NE.0) THEN
	    CALL LEAVE ('WHITE', 'SRDISTR file not found', IFLAG)
	ENDIF
C
C Define the useful parameters. Note that we now set the maximum energy
C to 100*lam_c, instead of 10*Lam_C (EX_UPP = 1.0D) as it used to be.
C 
	EX_LOW	= -5.0D0	
	EX_UPP	= 2.0D0
	EX_STEP	= (EX_UPP - EX_LOW)*1.0D-3
	GAMMA	= 1957.0D0*BENER
	RAD_MIN	= ABS(RAD_MIN)
	RAD_MAX	= ABS(RAD_MAX)
C	R_LAM	= 4.0D0*PI*RAD/3.0D0/GAMMA**3*1.0D10	!Angstroms
	IF (F_COLOR.NE.3) THEN
	  C_PHOT	= TOANGS/4.0D0/PI/RAD_MIN*3.0D0*GAMMA**3*1.0D-10
	  DO  10 I = 1, NKOL
	    PORDER(I)	= PHOTON(I)/C_PHOT
10	  CONTINUE
	  EMAX	= PORDER(NKOL)
	  EMIN	= PORDER(1)	
	ELSE 
	  C_PHOT_MIN	= TOANGS/4.0D0/PI/RAD_MAX*3.0D0*GAMMA**3*1.0D-10
	  C_PHOT_MAX	= TOANGS/4.0D0/PI/RAD_MIN*3.0D0*GAMMA**3*1.0D-10
	  EMAX	= PHOTON(2)/C_PHOT_MIN
	  EMIN	= PHOTON(1)/C_PHOT_MAX
	END IF
C Calculate the appropriate index for EMAX and EMIN
C	IF (EMAX.GT.10.0**EX_UPP) CALL LEAVE
C     $	  ('WHTRCDF','Maximum photon energy is too large.',0)
C	IF (EMIN.LT.10.0**EX_LOW) CALL LEAVE
C     $	  ('WHTRCDF','Minimum photon energy is too small.',0)
C
#ifdef vms
     	OPEN	(20, FILE=SRDISTR, STATUS='OLD', 
     $		 READONLY,FORM='UNFORMATTED')
#else
     	OPEN	(20, FILE=SRDISTR(1:IBLANK(SRDISTR)), STATUS='OLD', 
     $		FORM='UNFORMATTED')
#endif
	READ 	(20)	ICOL,NP
	IMIN	= NP - (EX_UPP - LOG10(EMIN))/EX_STEP
	IMAX	= NP - (EX_UPP - LOG10(EMAX))/EX_STEP
	IMAX_1	= IMAX + 20
	IMIN_1	= IMIN - 20
	IF (IMAX_1.GT.NP) 	IMAX_1 = NP
	IF (IMIN_1.LT.1)	IMIN_1 = 1
	IINT_1	= IMAX_1 - IMIN_1 + 1
C Reads in the total flux distribution
     	IF (F_COLOR.EQ.1)	GO TO 200
	DO  15 I = IMAX_1+1, NP
	  READ 	(20) 	
15	CONTINUE
	IF (F_SR_TYPE.EQ.0) THEN
	  DO 25 I = IINT_1, 1, -1
	    READ(20)	PHOT(1,I),Y(I),DUMM
	    Y(I)	= 1.0D0 - Y(I)
25	  CONTINUE
	ELSE
	  DO 35 I = IINT_1, 1, -1
	    READ	(20)	PHOT(1,I),DUMM,Y(I)
	    Y(I)	= 1.0D0 - Y(I)
35	  CONTINUE
	END IF
	CLOSE 	(20)

C
C Produces the original cdf curve of photon energy (PHOT).
C
	IER	= 0
	CALL CUBSPL  (PHOT,Y,IINT_1,IER)
	IF (F_COLOR.EQ.2) THEN
	  DO 45 I = 2, NKOL
	    WORKY(I)	= PORDER(I) - PORDER(I-1)
45	  CONTINUE
	  WORKY(1)	= PORDER(1) - PHOT(1,1)
	  WORKY(NKOL+1)	= PHOT(1,IINT_1) - PORDER(NKOL)
	  PDIFF		= WORKY(1)
	  DO 55 I = 2, NKOL+1
	    PDIFF	= MIN(PDIFF,WORKY(I))
55	  CONTINUE
	  PDIFF		= PDIFF/2.0D0
	  WORKY(1)	= 0.0D0
	  Y(1)		= 1.0D0
C
C For discrete energy, find the probability within +/- PDIFF of each energy.
C
	  DO 65 I = 1, NKOL
	    CALL SPL_INT (PHOT,IINT_1,PORDER(I)-PDIFF,CMIN,IER)
	    CALL SPL_INT (PHOT,IINT_1,PORDER(I)+PDIFF,CMAX,IER)
	    WORKY(I+1)	= WORKY(I) + CMAX - CMIN
	    Y(I+1)	= I + 1.0D0
65	  CONTINUE
	  DO 75 I = 1, NKOL+1
	    PHOT_INV(1,I)	= WORKY(I)/WORKY(NKOL+1)
75	  CONTINUE
	ELSE
C	  IF (EMAX.GT.10.0**EX_UPP) THEN
C	    CMAX	= 1.0D0
C	  ELSE	
C	    CALL SPL_INT (PHOT,IINT_1,EMAX,CMAX,IER)
C	  END IF
C	  IF (EMAX.LT.10.0**EX_LOW) THEN
C	    CMIN	= 0.0D0
C	  ELSE
C	    CALL SPL_INT (PHOT,IINT_1,EMIN,CMIN,IER)
C	  END IF
C	  CDIFF	= CMAX - CMIN
C	  EDIFF	= EMAX - EMIN
C	  IF (CDIFF.LT.1.0E-8) THEN
C	    IF (EDIFF.LT.1.0E-8) THEN
C	      DO I = 1, IINT_1
C	        Y(I)		= (EMAX + EMIN)/2.0D0
C	        PHOT_INV(1,I)	= I - 2
C	      CONTINUE
C	    ELSE	
C	      DO I = 1, IINT_1
C	        Y(I)		= PHOT(1,I)
C	        PHOT_INV(1,I)	= (PHOT(1,I) - EMIN)/EDIFF
C	      CONTINUE
C	    END IF
C	  ELSE
	    DO 85 I = 1, IINT_1
	      PHOT_INV(1,I) 	= Y(I)
	      Y(I)		= PHOT(1,I)
85	    CONTINUE
C	  END IF
	  IER	= 0
	  CALL CUBSPL  (PHOT_INV,Y,IINT_1,IER)
	END IF
C------------------------------------------------------------------------------
C Now the angle data !
C------------------------------------------------------------------------------
C First calculate the appropriate indices
200	CONTINUE
#ifdef vms
     	OPEN	(30, FILE=SRSPEC, STATUS='OLD', 
     $		 READONLY,FORM='UNFORMATTED')
#else
     	OPEN	(30, FILE=SRSPEC(1:IBLANK(SRSPEC)), STATUS='OLD',
     $		FORM='UNFORMATTED')
#endif
     	READ	(30)	NPHOT,ICOL,IST
	ITRY	= ((NP - IMIN_1)/IST) + 2
	IMIN_2  = ((NP - IMAX_1)/IST) + 1
	ITOT	= NP/IST + 1
	IF (ITRY.GT.ITOT) THEN
	  IMAX_2	= ITOT
	ELSE
	  IMAX_2	= ITRY
	END IF
	IINT_2	= IMAX_2 - IMIN_2 + 1
C Reads in the angle data for the desired polarization
	DO 90 I = 1, IMIN_2-1
	  DO 95 J = 1, 22
	    READ (30)
95	  CONTINUE
90	CONTINUE
	IF (F_POL.EQ.1) THEN
	  DO 110 I = IINT_2, 1, -1
	    READ (30)	XPHOT(I),DUMM
	    DO 105 J = 1, 21
	      READ (30)PSI_POL(1,J,I), PSI_INV(1,J,I),DUMM, DUMM, 
     $				PSI_POL(2,J,I)
105	    CONTINUE
110	  CONTINUE
	ELSE IF (F_POL.EQ.2) THEN
	  DO 120 I = IINT_2, 1, -1
	    READ (30)	XPHOT(I),DUMM
	    DO 115 J = 1, 21
	      READ (30)PSI_POL(1,J,I), DUMM, PSI_INV(1,J,I),DUMM,
     $				PSI_POL(2,J,I)
115	    CONTINUE
120	  CONTINUE
	ELSE
	  DO 130 I = IINT_2, 1, -1
	    READ (30)	XPHOT(I),DUMM
	    DO 125 J = 1, 21
	      READ (30)PSI_POL(1,J,I), DUMM, DUMM, PSI_INV(1,J,I),
     $				PSI_POL(2,J,I)
125	    CONTINUE
	    PSI_INV(1,21,I)	= 0.5D0
130	  CONTINUE
	END IF
	CLOSE	(30)
C For each photon energy (XPHOT), generate the spline on angles
	DO 140 I = 1, IINT_2
	  DO 135 J = 1, 21
	    PSI_POL(1,J,I)	= PSI_POL(1,J,I)/GAMMA		!Radians
	    WORKG(1,J)	= PSI_INV(1,J,I)
	    WORKY(J)	= PSI_POL(1,J,I)
135	  CONTINUE
	  IER	= 0
	  CALL CUBSPL (WORKG,WORKY,21,IER)
	  DO 136 J = 1, 21
	    DO 137 K = 2, 5
	      PSI_INV(K,J,I)	= WORKG(K,J)
137	    CONTINUE
136	  CONTINUE
140	CONTINUE
C
C Erase some useless memory spaces
C
#ifdef vms
	MPURGE(1)	= %LOC(Y(1))
	MPURGE(2)	= %LOC(Y(1010))
	CALL SYS$PURGWS (MPURGE)
#endif
C
	RETURN 
	END	
C+++
C	SUBROUTINE	WHTICDF
C
C	PURPOSE		To interpolate the photon energy from random 
C			number and then the vertical angle at that 
C			photon energy.
C---
	SUBROUTINE	WHTICDF	(RAD,CORREC,PSEED,
     $				 ASEED,WAVE_NO,PSI,POLAR)
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
	REAL*8		PHOT(5,1010),PHOT_INV(5,1010)
	REAL*8		XPHOT(251),PSI_INV(5,21,251),PSI_POL(2,21,251)
	COMMON /SPL_ARR/	PHOT,PHOT_INV,XPHOT,PSI_INV,PSI_POL
	REAL*8		EPOLAR(2),WORKG(5,21),WORKP(4),WORKX(5,4)	
	REAL*8		PSEED,ASEED,ASEEDH,ATRY,PSI,POLAR,SLOPE,
     $			PDIFF
	COMMON  /CDFINDEX/	IMAX_1,IMIN_1,IINT_1,NKOL,
     $				IMAX_2,IMIN_2,IINT_2,IST
C Define some useful data
	DATA		EX_UPP	/2.0D0/
	DATA		EX_LOW	/-5.0D0/
	EX_STEP	= (EX_UPP - EX_LOW)*1.0D-3
C	RAD	= ABS(R_MAGNET)
	GAMMA	= 1957.0D0*BENER
	R_LAM	= 4.0D0*PI*RAD/3.0D0/GAMMA**3*1.0D2		!cm
	C_PHOT	= TOCM/R_LAM
C Interpolate for the photon energy
     	IF (F_COLOR.EQ.1) THEN
          WAVE_NO	= TWOPI*PHOTON(1)/TOCM			!cm-1
     	  PE		= PHOTON(1)/C_PHOT/CORREC
	ELSE IF (F_COLOR.EQ.2) THEN
	  I = 1
11	  IF (PHOT_INV(1,I).LT.PSEED) THEN
	    I = I + 1
	  GOTO 11
      END IF
	  WAVE_NO	= TWOPI*PHOTON(I-1)/TOCM		!cm-1
	  PE		= PHOTON(I-1)/C_PHOT/CORREC
	ELSE
C
C Re-scale PSEED so that it only cover the range EMIN to EMAX.
C
	  EMIN	= PHOTON(1)/C_PHOT
	  IF (EMIN.LT.PHOT(1,1))	EMIN = PHOT(1,1)
	  EMAX	= PHOTON(2)/C_PHOT
	  IF (EMAX.GT.PHOT(1,IINT_1))	EMAX = PHOT(1,IINT_1)
	  CALL SPL_INT (PHOT,IINT_1,EMIN,CMIN,IER)
	  CALL SPL_INT (PHOT,IINT_1,EMAX,CMAX,IER)
	  PSEED	= CMIN + PSEED*(CMAX-CMIN)
	  CALL SPL_INT (PHOT_INV,IINT_1,PSEED,PE,IER)
          WAVE_NO	= TWOPI*PE/R_LAM*CORREC			!cm-1
	END IF
C For the angle, first find the indices of 'neighboring erergy' on XPHOT
	IPE	= IMAX_2 - (EX_UPP - LOG10(PE))/EX_STEP/IST
	IF (IPE-1.LT.1) THEN
	  ISTART = 1
	  IEND   = 4
	  IPOL	 = 1
	ELSE IF (IPE+2.GT.IINT_2) THEN
	  IEND   = IINT_2
	  ISTART = IEND - 3
	  IPOL   = IINT_2 - 1
	ELSE
	  ISTART = IPE - 1
	  IEND   = IPE + 2
	  IPOL	 = IPE
	END IF
	IF (ASEED.GT.0.5) THEN
	  ASEEDH = 1.0D0 - ASEED
	ELSE
	  ASEEDH = ASEED
	END IF
C Interpolate the angles correspond to the four 'neighboring energy'
	DO 21 I = ISTART, IEND
	  DO  31 J = 1, 21 
	    DO 41 K = 1, 5
	      WORKG(K,J) = PSI_INV(K,J,I)
41	    CONTINUE
31	  CONTINUE
	  CALL SPL_INT (WORKG,21,ASEEDH,ATRY,IER)
	  WORKP(I-ISTART+1)	= ATRY
	  WORKX(1,I-ISTART+1)	= XPHOT(I)
21	CONTINUE
C Use the four energy and their corresponding angles to interpolate for 
C the angle at PE
	IER	= 0
	CALL CUBSPL  (WORKX,WORKP,4,IER)
	CALL SPL_INT (WORKX,4,PE,PSI,IER)
	IF (ASEED.GT.0.5)	PSI = -PSI		!Radians
C Now the polarization
	IF (F_POL.EQ.1) THEN
	  POLAR	= 1.0D0
	ELSE IF (F_POL.EQ.2) THEN
	  POLAR	= 0.0D0
	ELSE
	  DO 51 I = IPOL, IPOL+1
	    J = 1
61 	    IF (-ABS(PSI).GT.PSI_POL(1,J,I)) THEN
	      J = J + 1
		GOTO 61
		END IF
	    IF (J.EQ.1) THEN
	      EPOLAR(I-IPOL+1)  = PSI_POL(2,1,I)
	    ELSE
	      SLOPE = (PSI_POL(2,J,I)-PSI_POL(2,J-1,I))/
     $			(PSI_POL(1,J,I)-PSI_POL(1,J-1,I))
	      PDIFF = -ABS(PSI) - PSI_POL(1,J-1,I)
	      EPOLAR(I-IPOL+1)	= SLOPE*PDIFF + PSI_POL(2,J-1,I)
	    END IF
51	  CONTINUE
	  SLOPE	= (EPOLAR(2)-EPOLAR(1))/(XPHOT(IPOL+1)-XPHOT(IPOL))
	  PDIFF = PE - XPHOT(IPOL)
	  POLAR = SLOPE*PDIFF + EPOLAR(1)
	END IF 
	RETURN
	END
