C +++
C
C Source: src/source/bm/rcdf.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	rcdf.F
C Revision 1.3  90/11/13  14:00:45  khan
C Cleanup and SAVE statements
C 
C Revision 1.2  90/07/19  14:56:22  khan
C Use SHADOW_SR_DIR env variable to find SRSPEC. 
C 
C Revision 1.1  90/07/18  16:16:33  khan
C Initial revision
C 
C 
C ---

C+++
C	SUBROUTINE	RCDF
C
C	PURPOSE		To read the unformatted CDF for SR angular
C			distribution and produce the spline coefficients
C---
	SUBROUTINE	RCDF  (BENER,RAD,PMIN,PMAX)
C test of implicit statement
	IMPLICIT REAL*8 (A-H,O-Z) 
C	REAL*8		PSI_INT(21,251),PSI(5,21,251),XPHOT(251)
	DIMENSION	PSI_INT(21,251),PSI(5,21,251),XPHOT(251)
C     	REAL*8		WORKG(5,21),WORKY(21), DUMM
     	DIMENSION	WORKG(5,21),WORKY(21)
	COMMON  /CDFINDEX/	IMAX_2,IMIN_2,IINT_2,IST
	COMMON	/ARRAY/		PSI,XPHOT	
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64769 25287 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /
	CHARACTER*132	SRSPEC
C
C Get the data file path using either SHADOW$DATA or Unix SHADOW_DATA_DIR
C environment variable. Also, check for existence in the routine itself.
C
	IFLAG = 1
	CALL DATAPATH ('SRSPEC', SRSPEC, IFLAG) 
	IF (IFLAG.NE.0) THEN
	    CALL LEAVE ('RCDF', 'SRSPEC file not found', IFLAG)
	ENDIF

C Define the useful parameters
	NP	= 1001
	EX_LOW	= -5.0D0	
	EX_UPP	= 2.0D0
	EX_STEP	= (EX_UPP - EX_LOW)/(NP - 1)
	GAMMA	= 1957.0D0*BENER
	R_LAM	= 4.0D0*PI*RAD/3.0D0/GAMMA**3*1.0D10	!Angstroms
	C_PHOT	= TOANGS/R_LAM
	EMAX	= PMAX/C_PHOT
	EMIN	= PMIN/C_PHOT	
C Calculate the appropriate index for EMAX and EMIN
	IF (EMAX.GT.10.0D0**EX_UPP) CALL LEAVE
     $	  ('RCDF','Maximum photon energy is too large.',0)
	IF (EMIN.LT.10.0D0**EX_LOW) CALL LEAVE
     $	  ('RCDF','Minimum photon energy is too small.',0)
	IMIN	= NP - (EX_UPP - LOG10(EMIN))/EX_STEP
	IMAX	= NP - (EX_UPP - LOG10(EMAX))/EX_STEP
	IMAX_1	= IMAX + 20
	IMIN_1	= IMIN - 20
	IF (IMAX_1.GT.NP) 	IMAX_1 = NP
	IF (IMIN_1.LT.1)	IMIN_1 = 1
	IINT_1	= IMAX_1 - IMIN_1 + 1
C------------------------------------------------------------------------------
C Now the angle data !
C------------------------------------------------------------------------------
C First calculate the appropriate indices
200	CONTINUE

#ifdef vms
     	OPEN	(30, FILE=SRSPEC, STATUS='OLD', 
     $		 READONLY,FORM='UNFORMATTED')
#else
     	OPEN	(30, FILE=SRSPEC(1:IBLANK(SRSPEC)), STATUS='OLD', 
     $		FORM='UNFORMATTED')
#endif
     	READ	(30)	NPHOT,ICOL,IST
	ITRY	= ((NP - IMIN_1)/IST) + 2
	IMIN_2  = ((NP - IMAX_1)/IST) + 1
	ITOT	= NP/IST + 1
	IF (ITRY.GT.ITOT) THEN
	  IMAX_2	= ITOT
	ELSE
	  IMAX_2	= ITRY
	END IF
	IINT_2	= IMAX_2 - IMIN_2 + 1
C Reads in the angle data for the desired polarization
	DO 99 I = 1, IMIN_2-1
	  DO 99 J = 1, 22
	    READ (30)
 99	CONTINUE
	DO 199 I = IINT_2, 1, -1
	    READ (30)	XPHOT(I),DUMM
	    DO 199 J = 1, 21
	      READ (30)		PSI(1,J,I), DUMM, DUMM, PSI_INT(J,I),
     $				DUMM
 199	CONTINUE
	CLOSE	(30)
C For each photon energy (XPHOT), generate the spline on angles
	DO 299 I = 1, IINT_2
	  DO 399 J = 1, 21
	    PSI(1,J,I)	= PSI(1,J,I)/GAMMA		!Radians
	    WORKG(1,J)	= PSI(1,J,I)
	    WORKY(J)	= PSI_INT(J,I)
 399	  CONTINUE
	  CALL CUBSPL (WORKG,WORKY,21,IER)
	  DO 499 J = 1, 21
	    DO 499 K = 2, 5
	      PSI(K,J,I)	= WORKG(K,J)
 499	    CONTINUE
 299	CONTINUE
	RETURN 
	END	
