c +++
c
c fopenr.F: Open a file to read in FORTRAN
c
c Source: src/lib/fopenr.F
c
c Author: Mumit Khan <khan@xraylith.wisc.edu>
c
c
c ----------------------------------------------
c                SHADOW
c      Center for X-ray Lithography
c     University of Wisconsin-Madison
c  3731 Schneider Dr., Stoughton, WI, 53589
c ----------------------------------------------
c
c Copyright(c) 1997 Mumit Khan
c 
c ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

c+++
c	SUBROUTINE	fopenr (iUnit,fname,form,ierr,iostat)
c
c	PURPOSE		To open a file for reading. 
c
c	INPUT	
c	    iUnit:	FORTRAN unit number of the file. If iUnit >= 0,
c			then fopenr will call OPEN with iUnit; if < 0,
c			it will try to find a unused Unit number before
c			calling OPEN and return the new iUnit if
c			successful.
c
c	    fname: 	Filename to open.
c
c	    form:	"formatted" or "unformatted"
c
c	OUTPUT
c	    iUnit:	if iUnit was < 0 on entry, fopenr will provide the
c			actual iUnit used to open the file if successful.
c
c	    ierr:	0 - aok
c			1 - file not found
c			2 - error opening file (eg., permission denied)
c			3 - no possible unit found (when iUnit < 0)
c
c	    iostat:	Actual iostat returned by OPEN. 0 is ok.
c
c	IMPLEMENTATION	
c			Self explanatory, right ;-)
c
c---
	subroutine	fopenr (iUnit, fname, form, ierr, iostat)
	implicit	none
	integer		iUnit, ierr, iostat
	character*(*)	fname, form
c
c local variables used.
c
	logical		ok
	integer		unit, unit_min, unit_max
c
c units 5 and 6 are taken, so we start at 7 and let's just assume 64 is a
c good max number of units that can be open.
c
	parameter 	(unit_min = 7, unit_max = 64)
	data	ok	/.false./
c
c check for existence first.
c
	inquire (file = fname, exist = ok, iostat = iostat)
	if (.not. ok) then
	  ierr = 1
	  goto 99
	endif
c
c now if iUnit < 0, then try to find an appropriate iUnit that will work.
c start at "unit_min" and go upto "unit_max" looking for an unopened unit.
c Return with ierr = 3 if none found.
c
	if (iUnit .le. 0) then
	  unit = unit_min
 10	  inquire (unit = unit, opened = ok)
	  if (ok) then
	    if (unit .lt. unit_max) then
	      unit = unit + 1
	      goto 10
	    else
	      ierr = 3
	      goto 99
	    endif
	  endif
	  iUnit = unit
	endif
c
#ifdef vms
# define READONLY READONLY
#else
# define READONLY
#endif
	open (unit=iUnit, file=fname, form=form, iostat=iostat,
     $		status='old' READONLY)
	if (iostat .ne. 0) then
	  ierr = 2
	  goto 99
	endif
c
c all error bound stuff should've jumped directly to 99, so everything is
c ok if we get there.
c
	ierr = 0
c
 99	continue
	return
	end
