C +++
C
C Source: src/lib/fileinfo.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: fileinfo.F
C Revision 1.4  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.3  91/04/05  13:54:19  cwelnak
C changed quotes on #include
C 
C Revision 1.2  91/03/22  12:12:56  cwelnak
C SUN version -- INC to #inc
C 
C Revision 1.1  90/11/01  12:05:21  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

#if defined(vms)

c+++
c	subroutine	fileinfo
c
c  These routines return filenames and creation dates selected
c    by wildcard expressions
c
c  The first call initializes certain control blocks.  An illegal
c    file specification causes a fatal error.
c
c  Subsequent calls to NEXTFILE (filename,creationdate) returns a
c    file name and file creation date.  When the last file is found
c    the filename is set to blanks.
c
c !!! NOTE: ONLY IMPLEMENTED FOR SHADOW/VMS FOR NOW !!!
c---
	subroutine fileinfo (wildname_in)
	implicit integer*4 (a-z)
	character*(*) wildname_in,next_file_name,creation_date
	character*80 wildname
	integer bindates (2,3)
	character*17 ascdates (3)
	integer file_attr (8)
c
	external fab_a
	external ss$_normal
c
c  copy input parameter to local storage
c
	wildname=wildname_in
c
c  address of file access block
c
	fab=%loc(fab_a)
c
c  do parse and initialize fab and nam blocks
c
	icode=isearch_init (fab,wildname,' ')
	if (.not. icode) call leave ('FILEINFO',' ',icode)
c
	return
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
	entry nextfile (next_file_name,creation_date)
c
 100	creation_date=' '
	icode=isearch_next (fab,next_file_name)
	if (next_file_name .eq. ' ') goto 900
	if (.not. icode) call leave ('FILEINFO',' ',icode)
c
c  found a file
c
 110	icode=ifile_info_read (fab,file_attr,bindates,uic)
	if (.not. icode) call leave ('FILEINFO',' ',icode)
	do 120 i=1,1
	  icode=sys$asctim (,ascdates(i),bindates(1,i),%val(0))
	  if (.not. icode) call leave ('FILEINFO',' ',icode)
 120	continue
	creation_date=ascdates(1)
c
 900	return
	end
c
c
#elif defined(unix) || defined(_WIN32)

#ifndef PATH_SEP
# if defined(unix) || defined(__CYGWIN32__)
#  define PATH_SEP '/'
# else
#  define PATH_SEP '\\'
# endif
#endif
c
c !!! NOTE: NON-VMS systems do not support wildcards and creation date !!!
c
	subroutine fileinfo (wildname_in)
	implicit integer*4 (a-z)
	character*(*) wildname_in,next_file_name,creation_date
	character*80 filename, curdir
	save filename
c
c  copy input parameter to local storage
c
	filename=wildname_in
c
	return
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
	entry nextfile (next_file_name,creation_date)
c
c if the filename is absolute, simply return the name. else get the
c current directory from unix. If fails, report the error and
c simply return '.' as the current directory.
c
	creation_date=' '
	if (filename(1:1) .eq. PATH_SEP) then
	  next_file_name = filename(1:iblank(filename))
	else
c
c first try to see if CWD env variable is set; if not, then try to get
c it from Unix using getcwd(). CWD is the preferable one since it works
c well with automounted paths.
c
	  call getenv('PWD', curdir)
	  if (curdir(1:1) .eq. ' ') then
	    retcode = getcwd (curdir)
	    if (retcode .ne. 0) then
		write(*,*) 'Error: No current working directory!'
		curdir = '.'
	    endif
	  endif
c
c now simply append the FILEIN to the CWD.
c
	  next_file_name = curdir(1:iblank(curdir)) // 
     $		PATH_SEP // filename
        endif
c	
	return
	end
c
#else
c #warning fileinfo (lib/fileinfo.F) has not been ported to this system
c
c Not a known system!
c
	subroutine fileinfo (wildname_in)
	implicit integer*4 (a-z)
	character*(*) wildname_in,next_file_name,creation_date
	character*80 filename
c
c  copy input parameter to local storage
c
	filename=wildname_in
c
	return
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
	entry nextfile (next_file_name,creation_date)
	creation_date = ' '
	next_file_name = filename
	return
	end
#endif
