C +++
C
C Source: src/tools/opcon/readlib.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	readlib.F
C Revision 1.5  91/04/05  14:52:30  cwelnak
C changed quotes in #inlcude
C 
C Revision 1.4  91/03/21  15:58:56  cwelnak
C SUN version -- INCLUDE to #include
C 
C Revision 1.3  90/11/13  14:02:48  khan
C Cleanup and SAVE statements
C 
C Revision 1.2  90/10/10  11:29:05  khan
C Added Unix environment string SHADOW_OPCON for F12LIB.* files.
C 
C Revision 1.1  90/10/08  21:50:31  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	READLIB
C
C	PURPOSE		To read f1 and f2 of an element from the indexed 
C			library F12LIB.FULL generated by the program GENLIB.FOR
C
C---

	SUBROUTINE 	READLIB	(ELEMENT,NZ,ATWT,C1,C2,ENG,F1,F2)

C
C DEFINITION OF ARGUMENTS
C ELEMENT - 2 LETTER ATOMIC SYMBOL (INPUT)
C NZ      - ATOMIC NUMBER (RETURNED)
C ATWT    -ATOMIC WEIGHT (RETURNED)
C C1      MU(BARNS/ATOM)/MU(CM2/GM) (RETURNED)
C C2	  E*MU(E)/F2                (RETURNED)
C ENG     - ENERGY ARRAY(EV)  (RETURNED)
C F1      - F1 ARRAY      (RETURNED)
C F2      - F2 ARRAY      (RETURNED)
C
	DIMENSION ENG(420),F1(420),F2(420)
	DIMENSION REALBUF(844)
	CHARACTER*2	ELEMENT
        CHARACTER*2     ELE

C       NEW ADDITIONS FOR BINARY SEARCH
        CHARACTER*80 LIST(92)
        INTEGER LOOKUP(92)
        INTEGER POS, R
C
C This remembers if this routines already been visited at least once. Then
C Skip a few of the environment management steps.
C
C	LOGICAL		LVISITED
C	COMMON		/ RDLIBCM /	LVISITED
C	DATA		LVISITED	/ .FALSE. /
C
	CHARACTER*132	F12LIB, INDEXF
C
C	LVISITED = .TRUE.
C
C If user specified 'HH' according to old version, change it to 'H ' instead.
C
	IF (ELEMENT(1:1).EQ.ELEMENT(2:2))	ELEMENT(2:2)	= ' '

C
C OPEN TkE LIBRARY FILE
C
C Get the data file path using either SHADOW$DATA or Unix SHADOW_DATA_DIR
C environment variable. Also, check for existence in the routine itself.
C
	IFLAG = 1
	CALL DATAPATH ('F12LIB.INDEX', INDEXF, IFLAG)
	IF (IFLAG .NE. 0) THEN
	    CALL LEAVE ('READLIB', 'F12LIB.INDEX not found', 1)
	ENDIF
	IFLAG = 1
	CALL DATAPATH ('F12LIB.FULL', F12LIB, IFLAG)
	IF (IFLAG .NE. 0) THEN
	    CALL LEAVE ('READLIB', 'F12LIB.FULL not found', 1)
	ENDIF
#ifndef vms
	OPEN(UNIT=71,FILE=F12LIB,
     $	ACCESS='DIRECT',RECL=3376, STATUS = 'OLD')

C OPEN AND READ THE FILE STORING CHEMICAL SYMBOLS OF ELEMENTS
	open (unit=11, file=INDEXF, status = 'OLD')
#else
	OPEN(UNIT=71,FILE=F12LIB,
     $	ACCESS='DIRECT',RECL=3376, STATUS = 'OLD', readonly)

C OPEN AND READ THE FILE STORING CHEMICAL SYMBOLS OF ELEMENTS
	open (unit=11, file=INDEXF, status = 'OLD', readonly)
#endif

	read (11, 5) (LIST(I), LOOKUP(I), I = 1, 92)
5	format (A2, I15)
        
C
C First read the energy array. It is assumed that the first record is  
C the energy array.
C
	READ	(71,REC=1)	 REALBUF
	DO 11 I = 1, 420
	  ENG(I)	= REALBUF(I)
11 	CONTINUE
C
C READ THE DATA OUT OF THE LIBRARY FILE
C DATA IS ASSUMED TO BE SORTED IN ORDER OF ENTERIES IN 'FILES' IN LIBRARY FILE
C
        CALL BINARY(LIST, 1, 92, ELEMENT, POS)
C	READ	(71, REC= (LOOKUP(POS)+1)) REALBUF
	R = LOOKUP(POS) + 1
	READ	(71, REC= R) REALBUF
C
C PUT THE DATA INTO THE SUBROUTINE ARGUMENTS
C
	NZ=REALBUF(1)
	ATWT=REALBUF(2)
	C1=REALBUF(3)
	C2=REALBUF(4)
C
C F1 ARRAY
C
	DO 20 I=1, 420
	F1(I)=REALBUF(I+4)
   20	CONTINUE
C F2 ARRAY
	DO 30 I=1, 420
	F2(I)=REALBUF(I+424)
   30	CONTINUE
	CLOSE (71)
        CLOSE (11)

	RETURN

	END


	subroutine binary(data, lb, ub, item, loc)

C   Here data is a sorted array with lower bound lb and upper bound ub,
C   and item is a given item of information.  The variables beg, fin and
C   mid denote, respectively, the beginning, end and middle locations
C   of a segment of elements of data.  This algorithm finds the location
C   loc of item in data or set loc = null.
	 integer lb, ub, loc, mid, beg, fin, i
	 character*(*) item
	 character*(*) data(ub)

	 beg = lb
	 fin = ub
	 mid = (beg+fin)/2
30	 do 10 i = 1, 10
C   Check if search successful
	  if (item .EQ. data(mid)) then
	     go to 20
C   If search unsuccessful, find new range
	  else if ( item  .LT. data(mid) ) then
	       fin = mid - 1
	  else
	       beg = mid + 1
	  endif

	  mid = (beg+fin)/2

C   Check if termination condition reached
	  if (beg .LE. fin) then
	     go to 30
	  else
	     go to 40
	  endif

10       continue

C   Successful search, return the location of element
20       loc = mid
	 return
C   Unsuccessful search, return NULL for location of element
40	 loc = 0
	 return
	 END
