/* 
 * glib - a set of library routines for misc stuff.
 *
 * Author: Mumit Khan <khan@xraylith.wisc.edu>
 *
 * Source: src/utils/io/misc.c
 *
 * Log:	misc.c
 * Revision 1.3  90/08/30  18:03:09  khan
 * About to add my own hashing routines.
 * 
 * Revision 1.2  90/05/01  14:31:51  khan
 * routine
 * 
 * Revision 1.1  90/04/12  21:36:22  khan
 * Initial revision
 * 
 * Revision 1.4  90/04/12  20:48:33  khan
 * Cleanup
 * 
 * Revision 1.1  90/03/18  20:44:30  khan
 * Initial revision
 * 
 * Revision 1.2  90/01/08  19:16:26  khan
 * Checkin for the Modeling distribution copy.
 * 
 * Revision 1.1  89/10/24  15:58:22  khan
 * Initial revision
 * 
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "libcxrl.h"

#define STATIC static
#define PUBLIC 

/*
 * Ultrix 3.0 has a much better and faster malloc in libmalloc.a.
 * See malloc (3X).
 */

#if !defined(ibm032) && !defined(__CYGWIN32__)
#include <malloc.h>
#endif /*!defined(ibm032)*/

/*
 * xmalloc - a smart malloc.
 *
 */

#define ALIGN_BOUNDARY (sizeof (int))


PUBLIC char *xmalloc (size)
unsigned int size;
{
    register char *local;
    register unsigned int al_size = size; /* aligned size */
     
    if (!(local = (char *) malloc (al_size))) {
	error ("Xmalloc: memory allocation failed\n");
	exit (1);
    }
    return (local);
}

PUBLIC void xfree (ptr)
char *ptr;
{
    if (!ptr) {
	error ("Xfree: Freeing NULL Pointer\n");
	exit (1);
    }
    free (ptr);
}

/*
 * error - error reporting interface.
 * should be expanded to take variable number of strings and formatting
 * commands. Also should take error_level into account.
 * The errmsg can have embedded formatting commands and in that argn are
 * the arguments.
 *
 */

PUBLIC error (errmsg, arg1, arg2, arg3, arg4)
char *errmsg;
long arg1, arg2, arg3, arg4;
{
    
    fflush (stdout);
    fprintf (stderr, "\nError: ");
    fprintf (stderr, errmsg, arg1, arg2, arg3, arg4);
    fprintf (stderr, "\n\n");
    fflush (stderr);
}

PUBLIC warn (wmsg, arg1, arg2, arg3, arg4)
char *wmsg;
long arg1, arg2, arg3, arg4;
{
    
    fflush (stdout);
    fprintf (stderr, "\nWarning: ");
    fprintf (stderr, wmsg, arg1, arg2, arg3, arg4);
    fprintf (stderr, "\n\n");
    fflush (stderr);
}

internal_error (routine, file, errmsg, line_no, code)
char *routine;
char *file;
char *errmsg;
int line_no;
int code;
{
    fprintf (stderr,"\nFatal Internal Error : %s\n", errmsg);
    fprintf (stderr,"\tFile    : %s\n", file);
    fprintf (stderr,"\tRoutine : %s\n", routine);
    fprintf (stderr,"\tLine    : %d\n", line_no);
    fprintf (stderr,"\tCode    : %d\n", code);
    fprintf (stderr,"Please notify the Bug-exterminators ASAP\n\n");
    fflush (stderr);
    exit (1);
}


internal_warn (routine, file, errmsg, line_no, code)
char *routine;
char *file;
char *errmsg;
int line_no;
int code;
{
    fprintf (stderr,"\tInternal nWarning : %s\n", errmsg);
    fprintf (stderr,"\tFile    : %s\n", file);
    fprintf (stderr,"\tRoutine : %s\n", routine);
    fprintf (stderr,"\tLine    : %d\n", line_no);
    fprintf (stderr,"\tCode    : %d\n", code);
    fprintf (stderr,"Please notify the Bug-Exterminators\n\n");
    fflush (stderr);
}

    

