//
// daemon.cc: unix daemon implementation
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//

// ====================================================================== //

// 
// unix daemon startup routines stolen from Stevens book
//

#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/param.h>		// for NOFILE
#include <sys/stat.h>		// for umask
#include <sys/wait.h>

#include "daemon.h"

// ====================================================================== //
//
// daemon_start:
//
// Start a daemon process and detach it from login session context.
//
//
// ====================================================================== //

int UnixDaemon::start (const char* rootdir) {

    pid_t pid;
    if ((pid = fork()) < 0)
	return -1;

    if (pid == 0) {
	if ((pid = fork()) < 0)
	    return -1;
	else if (pid > 0)
	    exit (0);		// parent from second fork == 1st child.

	// child continues ... 

	// close all open file descriptors, except for 0-2 
	for (int fd = 3; fd < NOFILE; fd++)
	    close (fd);

	if (errno == EBADF)		// probably got set from a close 
	    errno = 0;

	setsid();			// session leader

	// cd to "/" so file systems can be unmounted w/out having to kill 
	chdir (rootdir);

	// files are created with the modes specified
	umask (0);

	return 0;
    }
#if 0
    else {
	if (waitpid (pid, NULL, 0) != pid)
	    exit(1);
    }
#endif
    
    exit (0);
}

// ====================================================================== //
