C +++
C
C Source: src/utils/post/focnew.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: focnew.F
C Revision 1.8  1992/01/15  16:45:41  cwelnak
C 6000 changes
C
C Revision 1.7  91/07/06  19:43:52  khan
C Grenoble Changes ...
C 
C Revision 1.6  91/07/06  14:06:49  khan
C Grenoble changes...
C 
C Revision 1.5  91/04/05  15:50:40  cwelnak
C changed quotes in #includes
C 
C Revision 1.4  91/04/01  16:44:42  cwelnak
C FORMAT troubles -- tabbing backwards.
C 
C Revision 1.3  91/03/25  15:55:58  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:47:12  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:40  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C 	Program		F0CUS
C
C	21-JAN-85	VRS.	5.3
C
C This program locates the waists in the output of SHADOW. This is done
C by minimizing the variance of the beam respect to the optical axis.
C
C If Xi is the coordinate of the i-th ray on the image plane and Vi its
C direction vector, then the variance will be:
C
C		SIG(t)	=  (SUM ( Xi + Vi*t )**2)/NPOINT
C
C By expanding the sum, we have
C		SIG(t)  =  { A1*t**2 + A2*t + A3 } /NPOINT
C
C It is then a simple matter to find the minimum, as SIG(t) is just a
C parabola.
C
C An option switch lets the user to choose the origin as center of the
C distribution, or specify an alternative.
C---
	IMPLICIT	REAL*8	(A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
     	REAL*8		RAY (12,N_DIM),AP(3,N_DIM),PHASE(3,N_DIM)
     	DIMENSION	X(N_DIM),Y(N_DIM)
     	DIMENSION	TEST(6),RLOW(12),RUPP(12)
     	REAL*8		XMEAN(6),STDEV(6),VAR(6),XEXTER,ZEXTER
     	CHARACTER *80	IFILE,RSTRING
     	EXTERNAL	RSTRING
     	CHARACTER *7	ROOT
     	CHARACTER *9	FILOUT
     	CHARACTER *2	HEADER
     	CHARACTER * 60		FILETEXT
     	CHARACTER * 17		DATETEXT
     	CHARACTER * 10		NMODE (3)
    	DATA	NMODE(1)	/'Origin'/
    	DATA	NMODE(2)	/'Baricenter'/
    	DATA	NMODE(3)	/'External'/

C
C KLOSS is really never used here, but I'm setting it to zero in case
C the program expects it to be, which it probably does. Only check for
C good rays as a result -- MK
C
	KLOSS = 0

	CALL CLSCREEN
102    	IFILE	=   RSTRING ('Input file ? ')
#ifdef vms
     	CALL	FILEINFO  (IFILE)
     	CALL	NEXTFILE  (FILETEXT,DATETEXT)
#else
	filetext = ' '
	datetext = ' '
	call get_file_text(filetext,IFILE)
#endif
     	CALL	RBEAM (IFILE,RAY,PHASE,AP,NCOL,NN,IFLAG,IERR)
     	IF (IERR.NE.0) STOP	'Error reading ray file.'
     	KK	=  0
     	DO 99 I=1,NN
     	IF (RAY(10,I).LT.0.0) 	KK = KK + 1
99     	CONTINUE
200	CONTINUE
     	NN = I-1
     	KK = NN - KK
     	WRITE(6,*)'We have ',KK,' good points out of ',NN
C
C Computes the center of gravity of the ray
C
     	RLOW(1) =   1.0D+20
     	RUPP(1) = - 1.0D+20
     	RLOW(2) =   1.0D+20
     	RUPP(2) = - 1.0D+20
     	RLOW(3) =   1.0D+20
     	RUPP(3) = - 1.0D+20

     	RLOW(4) =   1.0D+20
     	RUPP(4) = - 1.0D+20
     	RLOW(5) =   1.0D+20
     	RUPP(5) = - 1.0D+20
     	RLOW(6) =   1.0D+20
     	RUPP(6) = - 1.0D+20
     	DO 300 I=1,NN
	 IF (KLOSS.EQ.0) THEN
	   IF (RAY(10,I).LT.0.0D0)   GO TO 300
	 ELSE IF (KLOSS.EQ.1) THEN
     	   IF (RAY(10,I).GE.0.0D0)   GO TO 300
     	 ELSE
     	 END IF
     	TEST(1)	=   RAY(1,I)
     	TEST(2)	=   RAY(2,I)
     	TEST(3)	=   RAY(3,I)
     	TEST(4)	=   RAY(4,I)
     	TEST(5)	=   RAY(5,I)
     	TEST(6)	=   RAY(6,I)
     	RLOW(1)= MIN(RLOW(1),TEST(1))
     	RUPP(1)= MAX(RUPP(1),TEST(1))
     	RLOW(2)= MIN(RLOW(2),TEST(2))
     	RUPP(2)= MAX(RUPP(2),TEST(2))
     	RLOW(3)= MIN(RLOW(3),TEST(3))
        RUPP(3)= MAX(RUPP(3),TEST(3))
     	RLOW(4)= MIN(RLOW(4),TEST(4))
     	RUPP(4)= MAX(RUPP(4),TEST(4))
     	RLOW(5)= MIN(RLOW(5),TEST(5))
     	RUPP(5)= MAX(RUPP(5),TEST(5))
     	RLOW(6)= MIN(RLOW(6),TEST(6))
300     RUPP(6)= MAX(RUPP(6),TEST(6))
C
C computes centers and variance
C
     	NPOINT = NN
     	DO 11 JCOL=1,6
     	  XMEAN(JCOL)	= 0.0D0
     	  VAR(JCOL)	= 0.0D0
     	 DO 12 I=1,NPOINT
     	   XMEAN(JCOL) 	= XMEAN(JCOL) + RAY(JCOL,I)
     	   VAR(JCOL)	= VAR(JCOL) + RAY(JCOL,I)**2
12     	 CONTINUE
     	  XMEAN(JCOL) = XMEAN(JCOL)/NPOINT
     	  VAR(JCOL)   = VAR(JCOL)/NPOINT - XMEAN(JCOL)**2
     	 IF (VAR(JCOL).GE.0.0) THEN
     	   STDEV(JCOL) = SQRT(VAR(JCOL))
     	 ELSE
     	   STDEV(JCOL) = 0.0D0
     	 END IF
11     	CONTINUE
     	WRITE (6,*)
     	WRITE (6,2001)
     	WRITE (6,*)
     	WRITE (6,2010) 1,'X ',RLOW(1),RUPP(1),XMEAN(1),STDEV(1)
     	WRITE (6,2010) 2,'Y ',RLOW(2),RUPP(2),XMEAN(2),STDEV(2)
     	WRITE (6,2010) 3,'Z ',RLOW(3),RUPP(3),XMEAN(3),STDEV(3)
     	WRITE (6,2010) 4,'X''',RLOW(4),RUPP(4),XMEAN(4),STDEV(4)
     	WRITE (6,2010) 5,'Y''',RLOW(5),RUPP(5),XMEAN(5),STDEV(5)
     	WRITE (6,2010) 6,'Z''',RLOW(6),RUPP(6),XMEAN(6),STDEV(6)

2001	FORMAT (//,T2,'Row',T5,' Par',T10,'Minimum:',T25,'Maximum:',
     $		T40,'Center:',T55,'St. Dev.:')
2010	FORMAT (1X,T2,I2,T5,A3,T10,G12.5,T25,G12.5,T40,G12.5,T55,G12.5)
     	WRITE(6,*)'Options: '
     	WRITE(6,*)'center at origin              [ 0 ] '
     	WRITE(6,*)'center at center of gravity   [ 1 ] '
     	WRITE(6,*)'external                      [ 2 ] '
     	ICENTER = IRINT ('Then ?')
     	XCENTER = 0.0D0
     	ZCENTER = 0.0D0
     	IF (ICENTER.EQ.2) THEN
     	  XEXTER = RNUMBER ('X-center : ')
     	  ZEXTER = RNUMBER ('Z-center : ')
     	 DO 13 JJ=1,NN
     	   RAY(1,JJ) = RAY(1,JJ) - XEXTER
     	   RAY(3,JJ) = RAY(3,JJ) - ZEXTER
13     	 CONTINUE
     	END IF
     	CALL FINDOUT (3,NN,AZ1,AZ2,AZ3,AZ4,AZ5,AZ6,RAY)
	ZBAR	=  AZ4
	VZBAR	=  AZ6
	IF (ICENTER.NE.1) THEN
	  AZ4	=  0
	  AZ5	=  0
	  AZ6	=  0
	END IF
	IF (ABS(AZ1-AZ6).GT.1.0E-30) THEN
     	  TPARZ	=  (AZ5 - AZ2) / (AZ1 - AZ6)
	ELSE
	  TPARZ	=  0.0D0
	END IF
     	CALL FINDOUT (1,NN,AX1,AX2,AX3,AX4,AX5,AX6,RAY)
	XBAR	=  AX4
	VXBAR	=  AX6
	TBAR	=  ZBAR + XBAR
	VTBAR	=  VZBAR + VXBAR
	IF (ICENTER.NE.1) THEN
	  AX4	=  0
	  AX5	=  0
	  AX6	=  0
	END IF
	IF (ABS(AX1-AX6).GT.1.0E-30) THEN
     	  TPARX	=  (AX5 - AX2) / (AX1 - AX6)
	ELSE
	  TPARX =   0.0D0
	END IF
     	AT1	=   AX1 + AZ1
     	AT2	=   AX2 + AZ2
     	AT3	=   AX3 + AZ3
     	AT4	=   AX4 + AZ4
     	AT5	=   AX5 + AZ5
     	AT6	=   AX6 + AZ6
	IF (ABS(AT1-AT6).GT.1.0E-30) THEN
     	  TPART	=  (AT5 - AT2) / (AT1 - AT6) 
	ELSE
	  TPART =   0.0D0
	END IF
	SIGX	=   DSQRT(DABS( AX1*TPARX**2 + 2.0D0*AX2*TPARX + AX3 
     $			- ( AX4 + 2.0D0*AX5*TPARX + AX6*TPARX**2)))
	SIGZ	=   DSQRT(DABS( AZ1*TPARZ**2 + 2.0D0*AZ2*TPARZ + AZ3 
     $			- ( AZ4 + 2.0D0*AZ5*TPARZ + AZ6*TPARZ**2)))
	SIGT	=   DSQRT(DABS( AT1*TPART**2 + 2.0D0*AT2*TPART + AT3 
     $			- ( AT4 + 2.0D0*AT5*TPART + AT6*TPART**2)))
     	SIGX0	=   DSQRT(DABS(AX3 - AX4))
     	SIGZ0	=   DSQRT(DABS(AZ3 - AZ4))
     	SIGT0	=   DSQRT(DABS(AT3 - AT4))
	WRITE (6,1035)
	WRITE (6,*) 'Searching file : ',IFILE
	WRITE (6,1055) FILETEXT,DATETEXT
	WRITE (6,1035)
     	WRITE (6,*) 'Center at :', NMODE(ICENTER+1)
     	WRITE (6,*) 'X = ',XEXTER,'    Z = ',ZEXTER
     	WRITE (6,1035)
     	WRITE (6,*) '.............   S A G I T T A L   ............'
     	WRITE (6,1000) AX1,AX2,AX3
     	WRITE (6,1012) SQRT(ABS(XBAR)),SQRT(ABS(VXBAR))
     	WRITE (6,1010)	TPARX
	WRITE (6,1015)	SIGX
     	WRITE (6,1060)  SIGX0
     	WRITE (6,*) '.............  T A N G E N T I A L  .............'
     	WRITE (6,1020) AZ1,AZ2,AZ3
     	WRITE (6,1012) SQRT(ABS(ZBAR)),SQRT(ABS(VZBAR))
     	WRITE (6,1030)	TPARZ
	WRITE (6,1015)	SIGZ
     	WRITE (6,1060)	SIGZ0
     	WRITE (6,*) '.............  LEAST CONFUSION  ...............'
     	WRITE (6,1040) AT1,AT2,AT3
     	WRITE (6,1012) SQRT(ABS(TBAR)),SQRT(ABS(VTBAR))
     	WRITE (6,1050) TPART
	WRITE (6,1015)	SIGT
     	WRITE (6,1060)	SIGT0
     	WRITE(6,*)'All done. File out data.'
#ifdef vms
     	OPEN (23,FILE='FOCUS',STATUS='NEW',CARRIAGECONTROL='LIST')
#else
     	OPEN (23,FILE='focus',STATUS='UNKNOWN')
	REWIND (23)
#endif
	WRITE (23,1035)
	WRITE (23,*) 'Searching file : ',IFILE
	WRITE (23,1055) FILETEXT,DATETEXT
	WRITE (23,1035)
     	WRITE (23,*) 'Center at :', NMODE(ICENTER+1)
     	WRITE (23,*) 'X = ',XEXTER,'    Z = ',ZEXTER
	WRITE (23,1035)
     	WRITE (23,1070) KK,NN
     	WRITE (23,*) '.............. S A G I T T A L  ..............'
     	WRITE (23,1000) AX1,AX2,AX3
     	WRITE (23,1012) SQRT(ABS(XBAR)),SQRT(ABS(VXBAR))
     	WRITE (23,1010)	TPARX
	WRITE (23,1015) SIGX
     	WRITE (23,1060)	SIGX0
     	WRITE (23,*) '.............. T A N G E N T I A L .............'
     	WRITE (23,1020) AZ1,AZ2,AZ3
     	WRITE (23,1012) SQRT(ABS(ZBAR)),SQRT(ABS(VZBAR))
     	WRITE (23,1030)	TPARZ
	WRITE (23,1015) SIGZ
     	WRITE (23,1060)	SIGZ0
     	WRITE (23,*) '..............   LEAST CONFUSION  .............'
     	WRITE (23,1040) AT1,AT2,AT3
     	WRITE (23,1012) SQRT(ABS(TBAR)),SQRT(ABS(VTBAR))
     	WRITE (23,1050) TPART
	WRITE (23,1015) SIGT
     	WRITE (23,1060)	SIGT0
     	CLOSE (23)
1000	FORMAT	(1X,'X coefficients : ',3(1X,G17.10))
1012	FORMAT  (1X,'Center :',G17.10,T30,'Average versor :',G17.10)
1010	FORMAT (1X,'Sagittal   focus at       : ',G17.10)
1015	FORMAT (1X,'Waist size at best focus (rms)	: ',G17.10)
1060	FORMAT (1X,'Waist size at origin                : ',G17.10)
1020	FORMAT	(1X,'Z coefficients : ',3(1x,G17.10))
1030	FORMAT (1X,'Tangential focus at       : ',G17.10)
1040	FORMAT	(1X,'T coefficients : ',3(1x,G17.10))
1050	FORMAT (1X,'Circle of least confusion : ',G17.10)
1035	FORMAT (1X,'---------------------------------------------------
     $--------------------------')
1055	FORMAT (1X,A60,T62,A17)
1070	FORMAT (1X,'Working with ',I4,' "good" rays out of ',I4)
     	
     	IANSW = IYES ('Do you want a plottable file ? ')
     	IF (IANSW.EQ.1) THEN
101	CONTINUE
     	WRITE(6,*)'Enter :'
     	WRITE(6,*)'1	for X'
     	WRITE(6,*)'2	for Z'
     	WRITE(6,*)'3	for T'
     	WRITE(6,*)'4	for all'
     	IPLOT = IRINT (' Then ? ')
     	WRITE(6,*)'Please specify Limits [ YMIN, YMAX, STEP ] ?'
     	YMIN	= RNUMBER ('Ymin ? ')
     	YMAX 	= RNUMBER ('Ymax ? ')
     	YSTEP 	= RNUMBER ('Ystep ? ')
     	NPL	=   (YMAX-YMIN)/YSTEP + 1
     	IOLD	=  0
     	IF (IPLOT.NE.4) THEN
     	 IFILE = RSTRING ('File-name ? ')
     	ELSE
     	 ROOT = RSTRING (' File root [ 7 letters max ] ? ')
     	 IOLD	=  4
     	 IPLOT	=  1
     	 KOUNT	=  1
     	END IF
105	DO 16 I=1,NPL
     	 X(I) = YMIN + (I-1)*YSTEP
     	 IF (IPLOT.EQ.1) THEN
     	  Y(I) = SQRT(ABS( AX1*X(I)**2 + 2.0D0*AX2*X(I) + AX3 
     $			-(AX4 + 2.0D0*AX5*X(I) + AX6*X(I)**2)))
     	 ELSE IF (IPLOT.EQ.2) THEN
     	  Y(I) = SQRT(ABS( AZ1*X(I)**2 + 2.0D0*AZ2*X(I) + AZ3
     $			-(AZ4 + 2.0D0*AZ5*X(I) + AZ6*X(I)**2)))
     	 ELSE IF (IPLOT.EQ.3) THEN
     	  Y(I) = SQRT(ABS( AT1*X(I)**2 + 2.0D0*AT2*X(I) + AT3
     $			-(AT4 + 2.0D0*AT5*X(I) + AT6*X(I)**2))) 
     	 END IF
16     	CONTINUE
     	IF (IOLD.EQ.4) THEN
     	 IF (KOUNT.EQ.1)	FILOUT	= 'FX'//ROOT
     	 IF (KOUNT.EQ.2)	FILOUT	= 'FZ'//ROOT
     	 IF (KOUNT.EQ.3) 	FILOUT	= 'FT'//ROOT
#ifdef vms
     	 OPEN (23,FILE=FILOUT,STATUS='NEW')
#else
     	 OPEN (23,FILE=FILOUT,STATUS='UNKNOWN')
	 REWIND (23)
#endif
     	ELSE
#ifdef vms
     	 OPEN (23,FILE=IFILE,STATUS='NEW')
#else
     	 OPEN (23,FILE=IFILE,STATUS='UNKNOWN')
	 REWIND (23)
#endif
     	END IF
     	DO 14 I=1,NPL
     	WRITE (23,*)	X(I),Y(I)
14     	CONTINUE
     	CLOSE (23)
     	IF (IOLD.EQ.4.AND.KOUNT.LT.3) THEN
     	KOUNT = KOUNT + 1
     	IPLOT = IPLOT + 1
     	GO TO 105
     	END IF
     	END IF
     	WRITE(6,*)'Enter :'
     	WRITE(6,*)'0	for another plot'
     	WRITE(6,*)'1	to restart'
     	WRITE(6,*)'2	to exit'
     	KGO = IRINT (' Then ? ')
     	GO TO (101,102,103)	KGO+1
103	STOP
     	END
C+++
C
C	SUBROUTINE	FINDOUT
C
C	INPUT	:	KOL	Column to be analyzed
C			NT	number of points
C			RAY	Data array
C
C	OUTPUT	:	CHI-Square coefficients for that data array,
C			referred to the origin
C
C--
     	SUBROUTINE	FINDOUT	(KOL,NT,A1,A2,A3,A4,A5,A6,RAY)
	IMPLICIT	REAL*8	(A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
     	REAL*8		RAY(12,N_DIM)
     	A1	=	0.0D0
     	A2	=	0.0D0
     	A3	=	0.0D0
     	A4	=	0.0D0
     	A5	=	0.0D0
     	A6	=	0.0D0
     	K	=	0
    	  DO 100 I=1,NT
     	  IF (RAY(10,I).LT.0.0) GO TO 100
     	  K	=	K + 1
	  DVECTOR	=	RAY(KOL+3,I)/RAY(5,I)
     	  A1	=   A1 + DVECTOR**2
     	  A2	=   A2 + RAY(KOL,I)*DVECTOR
     	  A3	=   A3 + RAY(KOL,I)**2
     	  A4	=   A4 + RAY(KOL,I)
     	  A6	=   A6 + DVECTOR
100	  CONTINUE
          A1	=   A1/K
          A2	=   A2/K
          A3	=   A3/K
          A4	=   A4/K
          A6	=   A6/K
          A5	=   A6*A4
          A4	=   A4**2
          A6	=   A6**2
      	RETURN
     	END
