C +++
C
C Source: src/source/bm/machine_par.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	machine_par.F
C Revision 1.2  90/07/18  19:11:46  khan
C Removed most of the subroutines to BM library (libbm.a) since these are
C called by most of the other programs.
C Also added #if vms ... #elif unix ... to OPEN statements.
C 
C Revision 1.1  90/07/11  10:44:57  khan
C Initial revision
C 
C 
C ---

C+++
C	PROGRAM		MACHINE_PAR
C
C	PURPOSE		To compute some of the machine parameters at
C			various gammas and R
C
C---
     	PROGRAM		MACHINE_PAR
     	CHARACTER*80	OUTFIL,RSTRING
     	IWHAT	= IRINT	('[ 0 ] energy, [ 1 ] field, [ 2 ] wavel. ')
     	ISCALE	= IRINT ('[ 0 ] linear, [ 1 ] logarithmic ')
     	IF (IWHAT.EQ.1) THEN
     	  RLOW	=	RNUMBER ('Lower Field  limit [ Kgauss ] ? ')
     	  RUPP	=	RNUMBER	('Upper Field  limit [ kgauss ] ? ')
     	  N_RAD	=	IRINT	('How many points ? ')
     	ELSE IF (IWHAT.EQ.0) THEN
     	  RLOW	=	RNUMBER ('Lower Cr. Energy limit [ eV ] ? ')
     	  RUPP	=	RNUMBER	('Upper Cr. Energy limit [ eV ] ? ')
     	  N_RAD	=	IRINT	('How many points ? ')
     	ELSE
     	  RLOW	=	RNUMBER ('Lower Cr. Energy limit [ Angs ] ? ')
     	  RUPP	=	RNUMBER	('Upper Cr. Energy limit [ Angs ] ? ')
     	  N_RAD	=	IRINT	('How many points ? ')
     	END IF
     	ELOW	=	RNUMBER ('Lower Energy [ GeV ] ? ')
     	EUPP	= 	RNUMBER	('Upper Energy [ GeV ] ? ')
     	N_ENER	=	IRINT 	('How many points ? ')
     	OUTFIL	=	RSTRING	('Output file name ? ')
C
C Precalculations
C
     	ESTEP	=	(EUPP - ELOW)/(N_ENER - 1)
     	IF (ISCALE.EQ.0) THEN
       	  RSTEP	=	(RUPP - RLOW)/(N_RAD  - 1)
     	ELSE
     	  RSTEP	=	(ALOG(RUPP)-ALOG(RLOW))/(N_RAD-1)
     	END IF
C
C Performs calculations
C
     	PI	=      3.141592
#ifdef vms
     	OPEN	(20,FILE=OUTFIL,STATUS='NEW')
#else
     	OPEN	(20,FILE=OUTFIL,STATUS='UNKNOWN')
	REWIND (20)
#endif
     	DO 10 I=1,N_RAD
     	 IF (ISCALE.EQ.0) THEN
     	   RAD = RLOW + RSTEP*(I-1)
     	 ELSE
     	   RAD = ALOG(RLOW) + RSTEP*(I-1)
     	   RAD = 10**RAD
     	 END IF
     	 DO 10 J=1,N_ENER
     	   ENER = ELOW + ESTEP*(J-1)
     	   GAMMA = 1957*ENER
     	  IF (IWHAT.EQ.1) THEN
     	   FIELD = RAD
     	   RADIUS = 33.35*ENER/FIELD
     	   R_LAM = 4/3.0*PI*RADIUS/GAMMA**3
     	  ELSE IF (IWHAT.EQ.0) THEN
     	   R_LAM = 12398.2/RAD*1.0E-10
     	   RADIUS = 3.0/4*GAMMA**3/PI*R_LAM
     	   FIELD = 33.35*ENER/RADIUS
     	  ELSE
     	   R_LAM = RAD*1.0E-10
     	   RADIUS = 3.0/4*GAMMA**3/PI*R_LAM
     	   FIELD = 33.35*ENER/RADIUS
     	  END IF
     	   WRITE (20,*)	RADIUS,ENER,R_LAM*1.0E10,FIELD
 20    	 CONTINUE
     	  WRITE (20,*) 'JOIN'
 10    	CONTINUE
     	CLOSE (20)
     	END
