C +++
C
C Source: src/lib/uertst.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	uertst.f
C Revision 1.3  92/01/23  16:51:02  cwelnak
C 6000 changes.
C 
C Revision 1.2  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.1  90/07/10  14:57:35  khan
C Initial revision
C 
C 
C ---

C   IMSL ROUTINE NAME   - UERSET                                        UERS0010
C                                                                       UERS0020
C-----------------------------------------------------------------------UERS0030
C                                                                       UERS0040
C   COMPUTER            - VAX/SINGLE                                    UERS0050
C                                                                       UERS0060
C   LATEST REVISION     - JANUARY 1, 1978                               UERS0070
C                                                                       UERS0080
C   PURPOSE             - SET MESSAGE LEVEL FOR IMSL ROUTINE UERTST     UERS0090
C                                                                       UERS0100
C   USAGE               - CALL UERSET (LEVEL,LEVOLD)                    UERS0110
C                                                                       UERS0120
C   ARGUMENTS    LEVEL  - NEW VALUE FOR MESSAGE LEVEL. (INPUT)          UERS0130
C                           OUTPUT FROM IMSL ROUTINE UERTST IS          UERS0140
C                           CONTROLLED SELECTIVELY AS FOLLOWS,          UERS0150
C                             LEVEL = 4 CAUSES ALL MESSAGES TO BE       UERS0160
C                                       PRINTED,                        UERS0170
C                             LEVEL = 3 MESSAGES ARE PRINTED IF IER IS  UERS0180
C                                       GREATER THAN 32,                UERS0190
C                             LEVEL = 2 MESSAGES ARE PRINTED IF IER IS  UERS0200
C                                       GREATER THAN 64,                UERS0210
C                             LEVEL = 1 MESSAGES ARE PRINTED IF IER IS  UERS0220
C                                       GREATER THAN 128,               UERS0230
C                             LEVEL = 0 ALL MESSAGE PRINTING IS         UERS0240
C                                       SUPPRESSED.                     UERS0250
C                LEVOLD - PREVIOUS MESSAGE LEVEL. (OUTPUT)              UERS0260
C                                                                       UERS0270
C   PRECISION/HARDWARE  - SINGLE/ALL                                    UERS0280
C                                                                       UERS0290
C   REQD. IMSL ROUTINES - UERTST,UGETIO                                 UERS0300
C                                                                       UERS0310
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           UERS0320
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      UERS0330
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  UERS0340
C                                                                       UERS0350
C   COPYRIGHT           - 1978 BY IMSL, INC. ALL RIGHTS RESERVED.       UERS0360
C                                                                       UERS0370
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN UERS0380
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    UERS0390
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        UERS0400
C                                                                       UERS0410
C-----------------------------------------------------------------------UERS0420
C                                                                       UERS0430
      SUBROUTINE UERSET (LEVEL,LEVOLD)                                  UERS0440
C                                  SPECIFICATIONS FOR ARGUMENTS         UERS0450
      INTEGER            LEVEL,LEVOLD                                   UERS0460
C                                  FIRST EXECUTABLE STATEMENT           UERS0470
      LEVOLD = LEVEL                                                    UERS0480
      CALL UERTST (LEVOLD,6HUERSET)                                     UERS0490
      RETURN                                                            UERS0500
      END                                                               UERS0510
C   IMSL ROUTINE NAME   - UERTST                                        UERT0010
C                                                                       UERT0020
C-----------------------------------------------------------------------UERT0030
C                                                                       UERT0040
C   COMPUTER            - VAX/SINGLE                                    UERT0050
C                                                                       UERT0060
C   LATEST REVISION     - JUNE 1, 1982                                  UERT0070
C                                                                       UERT0080
C   PURPOSE             - PRINT A MESSAGE REFLECTING AN ERROR CONDITION UERT0090
C                                                                       UERT0100
C   USAGE               - CALL UERTST (IER,NAME)                        UERT0110
C                                                                       UERT0120
C   ARGUMENTS    IER    - ERROR PARAMETER. (INPUT)                      UERT0130
C                           IER = I+J WHERE                             UERT0140
C                             I = 128 IMPLIES TERMINAL ERROR MESSAGE,   UERT0150
C                             I =  64 IMPLIES WARNING WITH FIX MESSAGE, UERT0160
C                             I =  32 IMPLIES WARNING MESSAGE.          UERT0170
C                             J = ERROR CODE RELEVANT TO CALLING        UERT0180
C                                 ROUTINE.                              UERT0190
C                NAME   - A CHARACTER STRING OF LENGTH SIX PROVIDING    UERT0200
C                           THE NAME OF THE CALLING ROUTINE. (INPUT)    UERT0210
C                                                                       UERT0220
C   PRECISION/HARDWARE  - SINGLE/ALL                                    UERT0230
C                                                                       UERT0240
C   REQD. IMSL ROUTINES - UGETIO,USPKD                                  UERT0250
C                                                                       UERT0260
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           UERT0270
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      UERT0280
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  UERT0290
C                                                                       UERT0300
C   REMARKS      THE ERROR MESSAGE PRODUCED BY UERTST IS WRITTEN        UERT0310
C                TO THE STANDARD OUTPUT UNIT. THE OUTPUT UNIT           UERT0320
C                NUMBER CAN BE DETERMINED BY CALLING UGETIO AS          UERT0330
C                FOLLOWS..   CALL UGETIO(1,NIN,NOUT).                   UERT0340
C                THE OUTPUT UNIT NUMBER CAN BE CHANGED BY CALLING       UERT0350
C                UGETIO AS FOLLOWS..                                    UERT0360
C                                NIN = 0                                UERT0370
C                                NOUT = NEW OUTPUT UNIT NUMBER          UERT0380
C                                CALL UGETIO(3,NIN,NOUT)                UERT0390
C                SEE THE UGETIO DOCUMENT FOR MORE DETAILS.              UERT0400
C                                                                       UERT0410
C   COPYRIGHT           - 1982 BY IMSL, INC. ALL RIGHTS RESERVED.       UERT0420
C                                                                       UERT0430
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN UERT0440
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    UERT0450
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        UERT0460
C                                                                       UERT0470
C-----------------------------------------------------------------------UERT0480
C                                                                       UERT0490
      SUBROUTINE UERTST (IER,NAME)                                      UERT0500
C                                  SPECIFICATIONS FOR ARGUMENTS         UERT0510
      INTEGER            IER                                            UERT0520
      INTEGER            NAME(1)                                        UERT0530
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   UERT0540
      INTEGER            I,IEQ,IEQDF,IOUNIT,LEVEL,LEVOLD,NAMEQ(6),      UERT0550
     *                   NAMSET(6),NAMUPK(6),NIN,NMTB                   UERT0560
      DATA               NAMSET/1HU,1HE,1HR,1HS,1HE,1HT/                UERT0570
      DATA               NAMEQ/6*1H /                                   UERT0580
      DATA               LEVEL/4/,IEQDF/0/,IEQ/1H=/                     UERT0590
C                                  UNPACK NAME INTO NAMUPK              UERT0600
C                                  FIRST EXECUTABLE STATEMENT           UERT0610
C *update* . this is a bug.  for some reason the 6000 cannot handle the
C following call to USPKD.  this should be fixed!
      CALL USPKD (NAME,6,NAMUPK,NMTB)                                   UERT0620
C                                  GET OUTPUT UNIT NUMBER               UERT0630
      CALL UGETIO(1,NIN,IOUNIT)                                         UERT0640
C                                  CHECK IER                            UERT0650
      IF (IER.GT.999) GO TO 25                                          UERT0660
      IF (IER.LT.-32) GO TO 55                                          UERT0670
      IF (IER.LE.128) GO TO 5                                           UERT0680
      IF (LEVEL.LT.1) GO TO 30                                          UERT0690
C                                  PRINT TERMINAL MESSAGE               UERT0700
      IF (IEQDF.EQ.1) WRITE(IOUNIT,35) IER,NAMEQ,IEQ,NAMUPK             UERT0710
      IF (IEQDF.EQ.0) WRITE(IOUNIT,35) IER,NAMUPK                       UERT0720
      GO TO 30                                                          UERT0730
    5 IF (IER.LE.64) GO TO 10                                           UERT0740
      IF (LEVEL.LT.2) GO TO 30                                          UERT0750
C                                  PRINT WARNING WITH FIX MESSAGE       UERT0760
      IF (IEQDF.EQ.1) WRITE(IOUNIT,40) IER,NAMEQ,IEQ,NAMUPK             UERT0770
      IF (IEQDF.EQ.0) WRITE(IOUNIT,40) IER,NAMUPK                       UERT0780
      GO TO 30                                                          UERT0790
   10 IF (IER.LE.32) GO TO 15                                           UERT0800
C                                  PRINT WARNING MESSAGE                UERT0810
      IF (LEVEL.LT.3) GO TO 30                                          UERT0820
      IF (IEQDF.EQ.1) WRITE(IOUNIT,45) IER,NAMEQ,IEQ,NAMUPK             UERT0830
      IF (IEQDF.EQ.0) WRITE(IOUNIT,45) IER,NAMUPK                       UERT0840
      GO TO 30                                                          UERT0850
   15 CONTINUE                                                          UERT0860
C                                  CHECK FOR UERSET CALL                UERT0870
      DO 20 I=1,6                                                       UERT0880
         IF (NAMUPK(I).NE.NAMSET(I)) GO TO 25                           UERT0890
   20 CONTINUE                                                          UERT0900
      LEVOLD = LEVEL                                                    UERT0910
      LEVEL = IER                                                       UERT0920
      IER = LEVOLD                                                      UERT0930
      IF (LEVEL.LT.0) LEVEL = 4                                         UERT0940
      IF (LEVEL.GT.4) LEVEL = 4                                         UERT0950
      GO TO 30                                                          UERT0960
   25 CONTINUE                                                          UERT0970
      IF (LEVEL.LT.4) GO TO 30                                          UERT0980
C                                  PRINT NON-DEFINED MESSAGE            UERT0990
      IF (IEQDF.EQ.1) WRITE(IOUNIT,50) IER,NAMEQ,IEQ,NAMUPK             UERT1000
      IF (IEQDF.EQ.0) WRITE(IOUNIT,50) IER,NAMUPK                       UERT1010
   30 IEQDF = 0                                                         UERT1020
      RETURN                                                            UERT1030
   35 FORMAT(19H *** TERMINAL ERROR,10X,7H(IER = ,I3,                   UERT1040
     1       20H) FROM IMSL ROUTINE ,6A1,A1,6A1)                        UERT1050
   40 FORMAT(27H *** WARNING WITH FIX ERROR,2X,7H(IER = ,I3,            UERT1060
     1       20H) FROM IMSL ROUTINE ,6A1,A1,6A1)                        UERT1070
   45 FORMAT(18H *** WARNING ERROR,11X,7H(IER = ,I3,                    UERT1080
     1       20H) FROM IMSL ROUTINE ,6A1,A1,6A1)                        UERT1090
   50 FORMAT(20H *** UNDEFINED ERROR,9X,7H(IER = ,I5,                   UERT1100
     1       20H) FROM IMSL ROUTINE ,6A1,A1,6A1)                        UERT1110
C                                                                       UERT1120
C                                  SAVE P FOR P = R CASE                UERT1130
C                                    P IS THE PAGE NAMUPK               UERT1140
C                                    R IS THE ROUTINE NAMUPK            UERT1150
   55 IEQDF = 1                                                         UERT1160
      DO 60 I=1,6                                                       UERT1170
   60 NAMEQ(I) = NAMUPK(I)                                              UERT1180
   65 RETURN                                                            UERT1190
      END                                                               UERT1200
C   IMSL ROUTINE NAME   - UGETIO                                        UGET0010
C                                                                       UGET0020
C-----------------------------------------------------------------------UGET0030
C                                                                       UGET0040
C   COMPUTER            - VAX/SINGLE                                    UGET0050
C                                                                       UGET0060
C   LATEST REVISION     - JUNE 1, 1981                                  UGET0070
C                                                                       UGET0080
C   PURPOSE             - TO RETRIEVE CURRENT VALUES AND TO SET NEW     UGET0090
C                           VALUES FOR INPUT AND OUTPUT UNIT            UGET0100
C                           IDENTIFIERS.                                UGET0110
C                                                                       UGET0120
C   USAGE               - CALL UGETIO(IOPT,NIN,NOUT)                    UGET0130
C                                                                       UGET0140
C   ARGUMENTS    IOPT   - OPTION PARAMETER. (INPUT)                     UGET0150
C                           IF IOPT=1, THE CURRENT INPUT AND OUTPUT     UGET0160
C                           UNIT IDENTIFIER VALUES ARE RETURNED IN NIN  UGET0170
C                           AND NOUT, RESPECTIVELY.                     UGET0180
C                           IF IOPT=2, THE INTERNAL VALUE OF NIN IS     UGET0190
C                           RESET FOR SUBSEQUENT USE.                   UGET0200
C                           IF IOPT=3, THE INTERNAL VALUE OF NOUT IS    UGET0210
C                           RESET FOR SUBSEQUENT USE.                   UGET0220
C                NIN    - INPUT UNIT IDENTIFIER.                        UGET0230
C                           OUTPUT IF IOPT=1, INPUT IF IOPT=2.          UGET0240
C                NOUT   - OUTPUT UNIT IDENTIFIER.                       UGET0250
C                           OUTPUT IF IOPT=1, INPUT IF IOPT=3.          UGET0260
C                                                                       UGET0270
C   PRECISION/HARDWARE  - SINGLE/ALL                                    UGET0280
C                                                                       UGET0290
C   REQD. IMSL ROUTINES - NONE REQUIRED                                 UGET0300
C                                                                       UGET0310
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           UGET0320
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      UGET0330
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  UGET0340
C                                                                       UGET0350
C   REMARKS      EACH IMSL ROUTINE THAT PERFORMS INPUT AND/OR OUTPUT    UGET0360
C                OPERATIONS CALLS UGETIO TO OBTAIN THE CURRENT UNIT     UGET0370
C                IDENTIFIER VALUES. IF UGETIO IS CALLED WITH IOPT=2 OR  UGET0380
C                IOPT=3, NEW UNIT IDENTIFIER VALUES ARE ESTABLISHED.    UGET0390
C                SUBSEQUENT INPUT/OUTPUT IS PERFORMED ON THE NEW UNITS. UGET0400
C                                                                       UGET0410
C   COPYRIGHT           - 1978 BY IMSL, INC. ALL RIGHTS RESERVED.       UGET0420
C                                                                       UGET0430
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN UGET0440
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    UGET0450
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        UGET0460
C                                                                       UGET0470
C-----------------------------------------------------------------------UGET0480
C                                                                       UGET0490
      SUBROUTINE UGETIO(IOPT,NIN,NOUT)                                  UGET0500
C                                  SPECIFICATIONS FOR ARGUMENTS         UGET0510
      INTEGER            IOPT,NIN,NOUT                                  UGET0520
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   UGET0530
      INTEGER            NIND,NOUTD                                     UGET0540
      DATA               NIND/1/,NOUTD/2/                               UGET0550
C                                  FIRST EXECUTABLE STATEMENT           UGET0560
      IF (IOPT.EQ.3) GO TO 10                                           UGET0570
      IF (IOPT.EQ.2) GO TO 5                                            UGET0580
      IF (IOPT.NE.1) GO TO 9005                                         UGET0590
      NIN = NIND                                                        UGET0600
      NOUT = NOUTD                                                      UGET0610
      GO TO 9005                                                        UGET0620
    5 NIND = NIN                                                        UGET0630
      GO TO 9005                                                        UGET0640
   10 NOUTD = NOUT                                                      UGET0650
 9005 RETURN                                                            UGET0660
      END                                                               UGET0670
C   IMSL ROUTINE NAME   - UHELP                                         UHLP0010
