#if defined(__CYGWIN32__) || defined(USE_C_IO)

/*
 * Source: src/lib/rbeam18_cygwin32.c
 *
 */

#include <stdio.h>
#include <string.h>
#include <dim.h>

#ifdef _MSC_VER
# define F77_NAME(name) __stdcall name
#else
# if !NO_FORT_UNDERSCORE
#  define F77_NAME(name) name ## _
# else
#  define F77_NAME(name) name
# endif
#endif

#ifdef _MSC_VER
# define RBEAM18 F77_NAME(RBEAM18)
#else
# define RBEAM18 F77_NAME(rbeam18)
#endif

/*
C+++
C	SUBROUTINE	RBEAM18	(FNAME,RAY,NCOL,NPOINT,IFLAG,IERR)
C
C	purpose		The same as RBEAM, except return everything in
C			one single array RAY(18,N_DIM) instead of three
C			separate arrays.
C
C	Input	:	FNAME	(character*(*))	Input file name
C	
C	Output  :	RAY	Array which contains the 18 columns that
C				defined each ray
C			NCOL	Number of columns for each ray 
C			NPOINT	Number of rays
C			IFLAG	A flag which is stored on the input file
C			IERR = 0, normal return
C			     = 1, error opening file
C			     = 2, error reading file
C
C---
	SUBROUTINE	RBEAM18	(FNAME,RAY,NCOL,NPOINT,IFLAG,IERR)
     	CHARACTER*(*)	FNAME
     	REAL*8		RAY(18, N_DIM)
*/

void RBEAM18 (
    const char* fort_fname, 		/* filename to write to */
    double ray[N_DIM][18],
    int *ncol, int *npoint, int *iflag, int *ierr,
    unsigned long fname_len		/* thank you FORTRAN! */
) {
    extern void leave_();
    extern void mssg_();
    FILE *fp;
    int i, j;

    int io_dummy[5];
    int reclen;
    char fname[256];

    /* fix fortran filename */
    for(i = fname_len; fort_fname[i-1] == ' '; --i)
	;
    strncpy(fname, fort_fname, i);
    fname[i] = '\0';

    *ierr = 0;

    fp = fopen(fname, "rb");
    if (!fp) {
	*ierr = 1;
        mssg_ ("RBEAM18:: Error opening ", fname, ierr,
            strlen("RBEAM18:: Error opening "), i
	);
	return;
    }
    if (fread(io_dummy, sizeof(int), 5, fp) != 5) {
        *ierr = 2;
	fclose(fp);
	return;
    }
    /*
     * io_dummy[0] and io_dummy[4] are the F77 record lengths, so ignore.
     */
    *ncol = io_dummy[1];
    *npoint = io_dummy[2];
    *iflag = io_dummy[3];

    if (*ncol != 12 && *ncol != 13 && *ncol != 18) {
	mssg_("RBEAM18", "Invalid number of columns.", *ncol,
	    strlen("RBEAM18"), strlen("Invalid number of columns.")
	);
    }
    reclen = *ncol * sizeof(double);
    for (i = 0; i < *npoint; ++i) {
	fread(&reclen, sizeof(int), 1, fp);
	for (j = 0; j < *ncol; ++j) {
	    fread(&ray[i][j], sizeof(double), 1, fp);
	}
	fread(&reclen, sizeof(int), 1, fp);
    }
    fclose(fp);
    return;
}

#else /* __CYGWIN32__ || USE_C_IO */

static int rbeam18_c_dummy;

#endif
