#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C
C
C	INPUT		A ray file generated by SHADOWIT or REFLAG containing 
C			the BEGIN.DAT file with the lost rays so labeled. 
C
C	OUTPUT	        the approximate source efficiency	
C
C	ALGORITHM	The program will create three arrays that
C			are filled with 1's when at least one ray falls
C			within the limits.
C---
        program qeff
	implicit real*8 (a-h,o-z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif
	integer total, good
     	CHARACTER*80	INFILE, RSTRING
	character*80 optfile

	integer         ox(10000),oy(10000),oz(10000)
     	DIMENSION	RAY (12, N_DIM), PHASE(3, N_DIM)
	DIMENSION 	AP(3, N_DIM), TEST(6)

	common /stuff/
     $      xmin,x1min,ymin,y1min,zmin,z1min,xs,xs1,ys,ys1,zs,zs1,
     $      nx,nx1,ny,ny1,nz,nz1 

     	INFILE	=  RSTRING ('Source file ? ')
	optfile = rstring('Optimization file? ')
     	CALL	RBEAM (INFILE, RAY, PHASE, AP, NCOL, NPOINT, IFLAG, IERR)
     	IF (IERR.NE.0) STOP

	call readoptarray(optfile,ox,oy,oz)
        call histo(ray,npoint,ox,oy,oz,good)
	total = npoint
	ratio = real(good)/real(total)
	write(*,*) ratio
	call exit (0)
	end





C+++
C
C
C    subroutine histo
C
C---
	subroutine histo(ray,npoint,ox,oy,oz,good)
	implicit real*8 (a-h,o-z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif
	integer good
	integer nx,ny,nz,nx1,ny1,nz1
	integer ox(nx,nx1),oy(ny,ny1),oz(nz,nz1)
	real*8 xmin,ymin,zmin,x1min,y1min,z1min
	real*8 xs,ys,zs,xs1,ys1,zs1
	integer npoint
	integer jx,jy,jz,jx1,jy1,jz1
	dimension ray(12,N_DIM)

	common /stuff/
     $      xmin,x1min,ymin,y1min,zmin,z1min,xs,xs1,ys,ys1,zs,zs1,
     $      nx,nx1,ny,ny1,nz,nz1 


     	DO 12 I=1,NPOINT
     	 IF (RAY(10,I).GE.0.0) THEN
      	   JX  = 1
     	   JY  = 1
     	   JZ  = 1
     	   JX1 = 1
     	   JY1 = 1
     	   JZ1 = 1
     	  IF (ABS(XS).GT.1.0D-10)  JX  = (RAY(1,I) - XMIN)   /XS  + 1
     	  IF (ABS(XS1).GT.1.0D-10) JX1 = (RAY(4,I) - X1MIN) /XS1 + 1
     	  IF (ABS(YS).GT.1.0D-10)  JY  = (RAY(2,I) - YMIN)   /YS  + 1
     	  IF (ABS(YS1).GT.1.0D-10) JY1 = (RAY(5,I) - Y1MIN) /YS1 + 1
     	  IF (ABS(ZS).GT.1.0D-10)  JZ  = (RAY(3,I) - ZMIN)   /ZS  + 1
     	  IF (ABS(ZS1).GT.1.0D-10) JZ1 = (RAY(6,I) - Z1MIN) /ZS1 + 1
	  if ((jx .le. nx) .and. (jx1 .le. nx1) .and.
     $	     (jy .le. ny) .and. (jy1 .le. ny1) .and.
     $	     (jz .le. nz) .and. (jz1 .le. nz1) .and.
     $	     (jx .ge. 1) .and. (jx1 .ge. 1) .and.
     $	     (jy .ge. 1) .and. (jy1 .ge. 1) .and.
     $	     (jz .ge. 1) .and. (jz1 .ge. 1)) then
	      if ((ox(jx,jx1) .eq. 1).and.(oy(jy,jy1).eq.1).and.
     $                                (oz(jz,jz1).eq.1)) then
	          good = good + 1
	      endif
	  endif
	endif
12     	CONTINUE
        return
	end


C+++
C
C
C
C---
	subroutine readoptarray(infile, xarray, yarray, zarray)
	implicit none
	integer Xbins, X1Bins
	integer YBins, Y1Bins
	integer ZBins, Z1Bins
	integer Xarray(10000)
	integer Yarray(10000)
	integer Zarray(10000)
	real*8 XBinSize, X1BinSize
	real*8 YBinSize, Y1BinSize
	real*8 ZBinSize, Z1BinSize
        real*8 XStartPosition, X1StartPosition
        real*8 YStartPosition, Y1StartPosition
        real*8 ZStartPosition, Z1StartPosition
	logical liformat
	character*(*) infile
	integer unitnum
	common / stuff / 
     $     XStartPosition, X1StartPosition,
     $     YStartPosition, Y1StartPosition, ZStartPosition,
     $     Z1StartPosition,
     $     XbinSize, X1BinSize, YBinSize, Y1BinSize, ZBinsize,
     $     Z1BinSize,
     $     xbins,x1bins,ybins,y1bins,zbins,z1bins
                

        unitnum = 10
	liformat = .true.
        open(file = infile,status = 'unknown',unit = 10)
	read(10,*) Xbins, XStartPosition, XbinSize
	read(10,*) X1Bins, X1StartPosition, X1BinSize 
	read(10,*) Ybins, YStartPosition, YbinSize
	read(10,*) Y1Bins, Y1StartPosition, Y1BinSize
	read(10,*) ZBins, ZStartPosition, ZBinSize
	read(10,*) Z1Bins, Z1StartPosition, Z1BinSize
	call lowread(Xarray,Yarray, Zarray, Xbins,X1bins,Ybins,Y1bins,
     $    zbins, Z1bins,unitnum,liformat)
        close(unit = unitnum)
        return
	end

C+++
C
C
C
C     low level readarray subroutine
C
C
C---
	subroutine lowread(Xarray,Yarray, Zarray, Xmax, X1max,
     $    Ymax, Y1max,
     $    zmax, Z1max,unitnum,liformat)
        implicit none
	integer i,j
	integer unitnum
	integer Xmax, X1max
	integer Ymax, Y1max
        integer Zmax, Z1max
	logical liformat
	integer xarray(xmax, x1max)
	integer yarray(ymax, y1max)
	integer zarray(zmax, z1max)
	if (liformat .eqv. .false.) then
	    do 100 i = 1, Xmax
	        read(unitnum) (Xarray(i,j), j = 1, X1max)
100	    continue
	    do 200 i = 1, ymax
	        read(unitnum) (Yarray(i,j), j = 1, Y1max)
200	    continue
	    do 300 i = 1, zmax
	        read(unitnum) (zarray(i,j), j = 1, z1max)
300  	    continue
	else
	    do 400 i = 1, Xmax
	        read(unitnum,*) (Xarray(i,j), j = 1, X1max)
400	    continue
	    do 500 i = 1, ymax
	        read(unitnum,*) (Yarray(i,j), j = 1, Y1max)
500	    continue
	    do 600 i = 1, zmax
	        read(unitnum,*) (zarray(i,j), j = 1, z1max)
600  	    continue
	endif
        return
	end

