C +++
C
C Source: src/utils/pre/bragg.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: bragg.F
C Revision 1.12  1995/03/09  16:55:52  cwelnak
C changes to avoid overflow on HP.  700 -> 100.
C
C Revision 1.11  1993/05/18  18:34:42  cwelnak
C laue crystal changes
C M.S.Rio
C
C Revision 1.10  1992/01/17  13:41:33  cwelnak
C 6000 -- line length changes.
C
C Revision 1.9  92/01/16  14:34:39  cwelnak
C 6000 changes
C 
C Revision 1.8  91/07/06  14:09:47  khan
C Grenoble changes...
C 
C Revision 1.7  91/04/11  16:52:08  cwelnak
C changed WRITE statement to reflect READ statements in
C CRYSTAL.  
C 
C Revision 1.6  91/04/05  15:57:17  cwelnak
C changed quotes on #includes
C 
C Revision 1.5  91/03/26  14:32:21  cwelnak
C READ/WRITE statements now agree btwn BRAGG and CRYSTAL
C 
C Revision 1.4  91/03/25  16:24:43  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.3  91/03/15  16:03:37  khan
C Getting  ready for sun port...
C 
C Revision 1.2  91/01/25  16:50:13  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/10  13:12:54  khan
C Added Pre-processor directives for Unix/VMS compilations
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		BRAGG
C
C	PURPOSE		To generate the reflectivity of a Bragg
C			reflection for an ideal crystal, in a format
C			to be used by SHADOW.
C
C	ALGORITHM	Uses formulaes from Zachariasen, Warren,
C			and Handbook of SR books.
C
C---
     	PROGRAM		BRAGG

     	IMPLICIT	REAL*8	(A-H,O-Z)
     	
     	DATA	PI	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64679 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA    TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS  /  1.239 852    D+4		     /
     	DATA	E2_MC2	/  2.817939 D-13		     /
	DATA	AVOG	/  6.022098 D+23		     /
     	CHARACTER *80	OUTFIL,RSTRING
	COMPLEX*16	CI,FA,FB,STRUCT,F_0,REFRAC
	COMPLEX*16	RCS1_O,RCP1_O,RCS2_O,RCP2_O,RCS_O,RCP_O
	COMPLEX*16	RCS1_H,RCP1_H,RCS2_H,RCP2_H,RCS_H,RCP_H
	COMPLEX*16	SSVAR,SPVAR,QS,QP,QS1,QP1,QS2,QP2
	COMPLEX*16	GA,GA_BAR,GB,GB_BAR,FH,FH_BAR
	complex*16	psi_h,psi_hbar,psi_0,psi_conj
	complex*16	cry_q,cry_z,ctemp
	complex*16	br_c1,br_c2,br_delta1,br_delta2,br_x1,br_x2
	complex*16	br_ref
     	DIMENSION	M_REF(3),XA(3),YA(3),CA(3),XB(3),YB(3),CB(3)
	REAL*4		ENERGY(420),FP_A(420),FPP_A(420),FP_B(420),FPP_B(420)
	REAL*4		ATWT,RMU,EMF
	CHARACTER*2	ELEA,ELEB
	INTEGER*4	ATNUM_A,ATNUM_B
	CI	= (0.0D0,1.0D0)
C
C Inquires about the cell geometry
C
	WRITE(6,*) 
     $	'All crystal structures are refered to a cubic unit cell.'
     	WRITE(6,*) 'Bravais lattice type : '
     	WRITE(6,*) '0	for 	ZincBlende'
     	WRITE(6,*) '1	for 	Rocksalt'
     	WRITE(6,*) '2	for	simple FCC'
	WRITE(6,*) '3       for     CsCl structure'
        WRITE(6,*) 'hexagonal Bravais lattice type: '
        WRITE(6,*) '4       for     Hexagonal Close-Packed structure'
        WRITE(6,*) '5       for     Hexagonal Graphite structure'
        I_LATT  = IRINT ('Then ? ')
        IF ((I_LATT.EQ.4).OR.(I_LATT.EQ.5) ) THEN
         D_LATT_A = RNUMBER('Lattice constant a (Angs) ? ')
         D_LATT_C = RNUMBER('Lattice constant c (Angs) ? ')
         D_LATT_A = D_LATT_A*1.0D-8
         D_LATT_C = D_LATT_C*1.0D-8
        ELSE
         D_LATT = RNUMBER('Lattice constant (Angs) ? ')
         D_LATT = D_LATT*1.0D-8
        END IF
C
C Computes # of unit cell per cm^3
C
        IF ((I_LATT.EQ.4).OR.(I_LATT.EQ.5) ) THEN
        R_NATOM = 1.0/(D_LATT_C*SQRT(3.0D0/4.0D0)*D_LATT_A**2)
        ELSE
        R_NATOM =  D_LATT**(-3)
        END IF
C
C inquires about reflection indeces
C
     	WRITE(6,*) 'Index of crystal plane of reflection H,K,L : '
     	READ(*,*) M_REF(1),M_REF(2),M_REF(3)
C
C Computes lattice planes spacing
C
     	RMILL	=  M_REF(1)**2 + M_REF(2)**2 + M_REF(3)**2
        IF ((I_LATT.EQ.4).OR.(I_LATT.EQ.5)) THEN
        SP_HKL  =  1.0D0/SQRT(4.0D0/3.0D0*(
     $(M_REF(1)**2+M_REF(2)**2+M_REF(1)*M_REF(2))/D_LATT_A**2
     $+ 3.0D0/4.0D0*M_REF(3)**2/D_LATT_C**2 ))
        ELSE
        SP_HKL  =  D_LATT/SQRT(RMILL)
        END IF
C
     	IF (I_LATT.EQ.0) THEN
	  WRITE(6,*) 
     $	  '***********************************************************'
	  WRITE(6,*) 
     $	  'The ZINCBLENDE structure is defined by atom A located at '
	  WRITE(6,*) 
     $	  '(0,0,0) and atom B at (1/4,1/4,1/4) of the fcc lattice.'
	  WRITE(6,*) 
     $	  '***********************************************************'
	  ELEA	= RSTRING
     $		('Enter atomic symbol (capitalized) for atom A : ')
	  ELEB	= RSTRING
     $		('Enter atomic symbol (capitalized) for atom B : ')
	ELSE IF (I_LATT.EQ.1) THEN
	  WRITE(6,*) 
     $	  '***********************************************************'
	  WRITE(6,*) 
     $	  'The ROCKSALT structure is defined by atom A located at '
	  WRITE(6,*) 
     $	  '(0,0,0) and atom B at (1/2,1/2,1/2) of the fcc lattice.'
	  WRITE(6,*) 
     $	  '***********************************************************'
	  ELEA	= RSTRING
     $		('Enter atomic symbol (capitalized) for atom A : ')
	  ELEB	= RSTRING
     $		('Enter atomic symbol (capitalized) for atom B : ')
	ELSE IF (I_LATT.EQ.2) THEN
	  WRITE(6,*) 
     $	  '***********************************************************'
	  WRITE(6,*) 'Simple FCC structure'
	  WRITE(6,*) 
     $	  '***********************************************************'
	  ELEA	= RSTRING
     $		('Enter atomic symbol (capitalized) for the basis atom : ')
	ELSE IF (I_LATT.EQ.3) THEN
	  WRITE(6,*) 
     $	  '***********************************************************'
	  WRITE(6,*) 'The CsCl structure is defined by atom A located at '
	  WRITE(6,*) 
     $	  '(0,0,0) and atom B at (1/2,1/2,1/2) of the cubic lattice.'
	  WRITE(6,*) 'If atom A = B, then it is a bcc lattice.'
	  WRITE(6,*) 
     $	  '***********************************************************'
	  ELEA	= RSTRING
     $		('Enter atomic symbol (capitalized) for atom A : ')
	  ELEB	= RSTRING
     $		('Enter atomic symbol (capitalized) for atom B : ')
        ELSE IF (I_LATT.EQ.4) THEN
	  WRITE(6,*) 
     $	  '***********************************************************'
          WRITE(6,*) 'The HEXAGONAL CLOSED-PACKED structure is defined by
     $an atom A located at (1/3,2/3,1/4) and (2/3,1/3,3/4) of the prism
     $ cell'
	  WRITE(6,*) 
     $	  '**********************************************************'
          ELEA  = RSTRING
     $        ('Enter atomic symbol (capitalized) for the basis atom :')
        ELSE IF (I_LATT.EQ.5) THEN
	  WRITE(6,*) 
     $	  '**********************************************************'
          WRITE(6,*) ' GRAPHITE structure '
	  WRITE(6,*) 
     $	  '**********************************************************'
          ELEA  = RSTRING
     $        ('Enter atomic symbol (capitalized) for the basis atom :')
     	END IF
C
C Inquires about fo for the basis atoms.
C
	RATIO	= 0.5D0/SP_HKL*1.0E-8
	WRITE(6,*) 
     $	'***********************************************************'
	WRITE(6,*) 
     $	'Atomic scattering factor is defined by fo + f'' + if", where'
	WRITE(6,*) 
     $	'    fo = fo(SIN(theta)/Lambda) is the non-dispersive part'
	WRITE(6,*) '    f'', f" (Lambda) are the dispersive part.'
	WRITE(6,*) 
     $	'***********************************************************'
	WRITE(6,*) 
     $	'We need fo at 3 different values of SIN(theta)/Lambda, which'
	WRITE(6,*) 
     $	'should cover the range of interest and center around :'
     	WRITE(6,*) 'SIN(theta)/Lambda = ',RATIO,' ratio.'
	WRITE(6,*) 
     $	'***********************************************************'
	WRITE(6,*) 'Please enter 1) SIN(theta)/Lambda, 2) fo ,'
        IF ((I_LATT.NE.2).AND.(I_LATT.NE.4).AND.(I_LATT.NE.5)) THEN
105	  WRITE(6,*) 'For atom A, first set : '
	  READ(*,*) XA(1),YA(1)
	  WRITE(6,*) '          , second set : '
	  READ(*,*) XA(2),YA(2)
	  WRITE(6,*) '          , third set : '
	  READ(*,*) XA(3),YA(3)
	  CALL	POLY_2	(XA,YA,CA,IFLAG)
	  IF (IFLAG.EQ.-1) THEN
	    WRITE(6,*) 'Error in range of input value. Try again.'
	    GO TO 105
	  END IF
106	  WRITE(6,*) 'For atom B, first set : '
	  READ(*,*) XB(1),YB(1)
	  WRITE(6,*) '          , second set : '
	  READ(*,*) XB(2),YB(2)
	  WRITE(6,*) '          , third set : '
	  READ(*,*) XB(3),YB(3)
	  CALL	POLY_2	(XB,YB,CB,IFLAG)
	  IF (IFLAG.EQ.-1) THEN
	    WRITE(6,*) 'Error in range of input value. Try again.'
	    GO TO 106
	  END IF
	ELSE
107	  WRITE(6,*) 'For basis atom, first set : '
	  READ(*,*) XA(1),YA(1)
	  WRITE(6,*) '              , second set : '
	  READ(*,*) XA(2),YA(2)
	  WRITE(6,*) '              , third set : '
	  READ(*,*) XA(3),YA(3)
	  CALL	POLY_2	(XA,YA,CA,IFLAG)
	  IF (IFLAG.EQ.-1) THEN
	    WRITE(6,*) 'Error in range of input value. Try again.'
	    GO TO 107
	  END IF
	  CB(1)	= 0.0D0
	  CB(2)	= 0.0D0
	  CB(3)	= 0.0D0
	END IF
C
C defines wavelengths
C
	WRITE(6,*) 
     $	'***********************************************************'
	WRITE(6,*) 
     $	'f'', f" is furnished from optical constant library within ...'
 	EMIN	= RNUMBER ('minimum photon energy (eV) : ')
 	EMAX	= RNUMBER ('maximum photon energy (eV) : ')
	ESTEP	= RNUMBER ('energy step (eV) : ')
50	NPOINT	= (EMAX - EMIN)/ESTEP + 1
	IF (NPOINT.GT.1000) THEN
	  WRITE(6,*) 
     $	  'Too many points (1000 max).  Please increase step size.'
	  GO TO 50
	END IF
	I_ABSORP = IYES 
     $	    ('Do you want to include crystal absorption [1/0] ? ')
	TEMPER	= RNUMBER ('Temperature (Debye-Waller) factor : ')
C
C Compute the geometrical part G's of the structure factor and get f', f"
C from the optical constant library.
C
	IF (I_LATT.EQ.0) THEN
	  GA = (1.0D0,0.0D0) + CDEXP(CI*PI*(M_REF(1)+M_REF(2))) 
     $	  		     + CDEXP(CI*PI*(M_REF(1)+M_REF(3))) 
     $			     + CDEXP(CI*PI*(M_REF(2)+M_REF(3)))
	  GB = GA * CDEXP(CI*PIHALF*(M_REF(1)+M_REF(2)+M_REF(3)))
	  CALL	READLIB(ELEA,ATNUM_A,ATWT,RMU,EMF,ENERGY,FP_A,FPP_A)
	  CALL	READLIB(ELEB,ATNUM_B,ATWT,RMU,EMF,ENERGY,FP_B,FPP_B)
	ELSE IF (I_LATT.EQ.1) THEN
	  GA = (1.0D0,0.0D0) + CDEXP(CI*PI*(M_REF(1)+M_REF(2))) 
     $			     + CDEXP(CI*PI*(M_REF(1)+M_REF(3))) 
     $			     + CDEXP(CI*PI*(M_REF(2)+M_REF(3)))
	  GB = GA * CDEXP(CI*PI*(M_REF(1)+M_REF(2)+M_REF(3)))
	  CALL	READLIB(ELEA,ATNUM_A,ATWT,RMU,EMF,ENERGY,FP_A,FPP_A)
	  CALL	READLIB(ELEB,ATNUM_B,ATWT,RMU,EMF,ENERGY,FP_B,FPP_B)
	ELSE IF (I_LATT.EQ.2) THEN
	  GA = (1.0D0,0.0D0) + CDEXP(CI*PI*(M_REF(1)+M_REF(2))) 
     $			     + CDEXP(CI*PI*(M_REF(1)+M_REF(3))) 
     $			     + CDEXP(CI*PI*(M_REF(2)+M_REF(3)))
	  GB = (0.0D0,0.0D0)
	  CALL	READLIB(ELEA,ATNUM_A,ATWT,RMU,EMF,ENERGY,FP_A,FPP_A)
	ELSE IF (I_LATT.EQ.3) THEN
	  GA = (1.0D0,0.0D0) 
	  GB = CDEXP(CI*PI*(M_REF(1)+M_REF(2)+M_REF(3)))
	  CALL	READLIB(ELEA,ATNUM_A,ATWT,RMU,EMF,ENERGY,FP_A,FPP_A)
	  CALL	READLIB(ELEB,ATNUM_B,ATWT,RMU,EMF,ENERGY,FP_B,FPP_B)
        ELSE IF (I_LATT.EQ.4) THEN
          GA = CDEXP(CI*TWOPI*((1.0D0/3.0D0)*M_REF(1)+
     $              (2.0D0/3.0D0)*M_REF(2)+(1.0D0/4.0D0)*M_REF(3)))+
     $  CDEXP(CI*TWOPI*((2.0D0/3.0D0)*M_REF(1)+(1.0D0/3.0D0)*M_REF(2)+
     $              (3.0D0/4.0D0)*M_REF(3)))
          GB = (0.0D0,0.0D0)
          CALL  READLIB(ELEA,ATNUM_A,ATWT,RMU,EMF,ENERGY,FP_A,FPP_A)
        ELSE IF (I_LATT.EQ.5) THEN
          GA=(1.0d0,0.0d0) + CDEXP(CI*PI*M_REF(3)) +
     $ CDEXP(CI*TWOPI*((1.0D0/3.0D0)*M_REF(1)+(2.0D0/3.0D0)*M_REF(2))) +
     $ CDEXP(CI*TWOPI*((2.0D0/3.0D0)*M_REF(1)+(1.0D0/3.0D0)*M_REF(2)+
     $ (1.0D0/2.0D0)*M_REF(3)))
          GB = (0.0D0,0.0D0)
          CALL  READLIB(ELEA,ATNUM_A,ATWT,RMU,EMF,ENERGY,FP_A,FPP_A)
	END IF
	GA_BAR	= CONJG(GA)
	GB_BAR	= CONJG(GB)
	RN	= E2_MC2*R_NATOM
C
C Crystal absorption.
C
	IF (I_ABSORP.EQ.0) THEN
	  DO 199 I = 1,420
	    FPP_A(I)	= 0.0D0
	    FPP_B(I)	= 0.0D0
 199	  CONTINUE
	END IF
C
C Now prepare the file for SHADOW.
C
	OUTFIL	= RSTRING ('Output file name (for SHADOW) : ')
#ifdef vms
	OPEN	(25,FILE=OUTFIL,STATUS='NEW',FORM='FORMATTED')
#else
	OPEN	(25,FILE=OUTFIL,STATUS='UNKNOWN',FORM='FORMATTED')
	REWIND (25)
#endif
	WRITE	(25,*)	I_LATT,RN,SP_HKL
	WRITE	(25,*)	ATNUM_A,ATNUM_B,TEMPER
	WRITE	(25,*)	GA
	WRITE   (25,*)  GA_BAR
	WRITE	(25,*)  GB
	WRITE	(25,*)  GB_BAR
	WRITE	(25,*)	CA(1),CA(2),CA(3)
	WRITE   (25,*)  CB(1),CB(2),CB(3)
	WRITE	(25,*)	NPOINT

	ELFACTOR	= LOG10(1.0E4/30.0)/300.0
	DO 299 I = 1, NPOINT
	  PHOT	= EMIN + (I-1)*ESTEP
	  NENER	= LOG10(PHOT/30.0E0)/ELFACTOR + 1
	  F1A	= FP_A(NENER) + (FP_A(NENER+1) - FP_A(NENER)) * 
     $		  (PHOT - ENERGY(NENER)) / (ENERGY(NENER+1) - ENERGY(NENER))
	  F2A	= FPP_A(NENER) + (FPP_A(NENER+1) - FPP_A(NENER)) * 
     $		  (PHOT - ENERGY(NENER)) / (ENERGY(NENER+1) - ENERGY(NENER))
	  F1B	= FP_B(NENER) + (FP_B(NENER+1) - FP_B(NENER)) * 
     $		  (PHOT - ENERGY(NENER)) / (ENERGY(NENER+1) - ENERGY(NENER))
	  F2B	= FPP_B(NENER) + (FPP_B(NENER+1) - FPP_B(NENER)) * 
     $		  (PHOT - ENERGY(NENER)) / (ENERGY(NENER+1) - ENERGY(NENER))
	  WRITE	(25,*)	PHOT, F1A-ATNUM_A, F2A 
	  WRITE (25,*)  F1B-ATNUM_B, F2B
 299	  CONTINUE
	CLOSE	(25)
C
C Rocking curve for immediate check.
C
	I_ROCK	= IYES ('Do you want to generate a rocking curve [1/0] ? ')
	IF (I_ROCK.EQ.0) go to 20
	write (6,*) 'What do you want to calculate ?: '
	write (6,*) '[1] Diffracted beam in Transmission (Laue) geometry '
	write (6,*) '[2] Diffracted beam in Reflection (Bragg) geometry  '
	write (6,*) '[3] like [2] using thick crystal approximation'
cc	write (6,*) '[4] Transmitted beam in Laue case'
cc	write (6,*) '[5] Transmitted beam in Bragg case'
	i_mode = irint(' <?> ') 
30	PHOT	= RNUMBER ('... at what energy (eV) ? ')
	NENER	= LOG10(PHOT/30.0E0)/ELFACTOR + 1
	F1A	= FP_A(NENER) + (FP_A(NENER+1) - FP_A(NENER)) * 
     $		  (PHOT - ENERGY(NENER)) / (ENERGY(NENER+1) - ENERGY(NENER))
	F2A	= FPP_A(NENER) + (FPP_A(NENER+1) - FPP_A(NENER)) * 
     $		  (PHOT - ENERGY(NENER)) / (ENERGY(NENER+1) - ENERGY(NENER))
	F1B	= FP_B(NENER) + (FP_B(NENER+1) - FP_B(NENER)) * 
     $		  (PHOT - ENERGY(NENER)) / (ENERGY(NENER+1) - ENERGY(NENER))
	F2B	= FPP_B(NENER) + (FPP_B(NENER+1) - FPP_B(NENER)) * 
     $		  (PHOT - ENERGY(NENER)) / (ENERGY(NENER+1) - ENERGY(NENER))
	FOA	= CA(3)*RATIO**2 + CA(2)*RATIO + CA(1)
	FOB	= CB(3)*RATIO**2 + CB(2)*RATIO + CB(1)
	FA	= FOA + (F1A - ATNUM_A) + CI*F2A
	FB	= FOB + (F1B - ATNUM_B) + CI*F2B
	R_LAM0 	= TOCM/PHOT
     	SIN_GRA	= R_LAM0/SP_HKL/2
     	GRAZE	= TODEG*(ASIN(SIN_GRA))
C
C Compute the absorption coefficient and Fo.
C
	IF (I_LATT.EQ.0) THEN
	  ABSORP = 2.0D0*RN*R_LAM0*(4.0D0*(DIMAG(FA)+DIMAG(FB)))
     	  F_0 = 4*((F1A + F1B) + CI*(F2A + F2B))
	ELSE IF (I_LATT.EQ.1) THEN
	  ABSORP = 2.0D0*RN*R_LAM0*(4.0D0*(DIMAG(FA)+DIMAG(FB)))
     	  F_0 = 4*((F1A + F1B) + CI*(F2A + F2B))
	ELSE IF (I_LATT.EQ.2) THEN
	  FB	 = (0.0D0,0.0D0)
	  ABSORP = 2.0D0*RN*R_LAM0*(4.0D0*DIMAG(FA))
     	  F_0 = 4*(F1A + CI*F2A)
	ELSE IF (I_LATT.EQ.3) THEN
	  ABSORP = 2.0D0*RN*R_LAM0*(DIMAG(FA)+DIMAG(FB))
     	  F_0 = (F1A + F1B) + CI*(F2A + F2B)
        ELSE IF (I_LATT.EQ.4) THEN
          FB     = (0.0D0,0.0D0)
          ABSORP = 2.0D0*RN*R_LAM0*(2.0D0*(DIMAG(FA)))
          F_0 = 2*(F1A+ CI*F2A )
        ELSE IF (I_LATT.EQ.5) THEN
          FB     = (0.0D0,0.0D0)
          ABSORP = 2.0D0*RN*R_LAM0*(4.0D0*(DIMAG(FA)))
          F_0 = 4*(F1A + CI*F2A )
	END IF
C	
C FH and FH_BAR are the structure factors for (h,k,l) and (-h,-k,-l).
C
	FH 	= (GA * FA) + (GB * FB)
	FH_BAR	= (GA_BAR * FA) + (GB_BAR * FB)
	STRUCT 	= SQRT(FH * FH_BAR) 
C
C computes refractive index.
C
     	REFRAC = (1.0D0,0.0D0) - R_LAM0**2*RN*F_0/TWOPI
	DELTA  = 1.0D0 - DREAL(REFRAC)
	BETA   = -DIMAG(REFRAC)
C
C THETA_B is the Bragg angle corrected for refraction
C
	THETA_B = R_LAM0/(1 - (DELTA/SIN_GRA**2))/2.0D0/SP_HKL
	THETA_B = TODEG*(ASIN(THETA_B))
	WRITE(6,*) ' '
     	WRITE(6,*) 'So far, we are working with:'
     	WRITE(6,*) 'Lambda 		 = ',R_LAM0*1.0E8,' Angstroms'
     	WRITE(6,*) 'Theta (graz) 	 = ',GRAZE,' degrees'
	WRITE(6,*) 'Bragg angle      = ',THETA_B,' degrees'
	WRITE(6,*) 'Structure factor  = ',STRUCT
	WRITE(6,*) 'Refraction index = 1 - delta - i*beta :'
	WRITE(6,*) '           delta = ',DELTA
	WRITE(6,*) '            beta = ',BETA
	WRITE(6,*) 'Absorption coeff = ',ABSORP,' cm-1'
     	WRITE(6,*) ' '
C
C S%VAR is the variable "s" of C BVAR is the variable "b" of Warren.
C
	SSVAR	= RN*(R_LAM0**2)*STRUCT*TEMPER/PI/SIN(TORAD*2.0D0*GRAZE)
	SPVAR	= SSVAR*ABS(COS(TORAD*2.0D0*GRAZE))
	SSR	= DREAL(SSVAR)
	SPR	= DREAL(SPVAR)
	BVAR	= ABSORP*R_LAM0/TWOPI/SIN(TORAD*2.0D0*GRAZE)
C
C Inquires about mosaic crystal calculation
C
        i_mosaic = irint('Do you want to calculate a mosaic crystal ?')
        if (i_mosaic.eq.1) then
         spread  = RNUMBER('mosaic angle spread (FWHM) [deg] ? ')
         spread = torad*spread/2.35
        else
         i_mosaic = 0
c        thick    = 0.0d0
         spread   = 0.0d0
        end if
C
C Inquires crystal Thickness
C
	if (i_mode.ne.3) then
	  thick = RNUMBER('thickness of the crystal [cm] ? ')
	endif
C
C Inquires about asymmetrical diffraction
C
	IF (I_MOSAIC.NE.1) THEN
     	  WRITE(6,*) 'Asymmetric cut angle (deg) between face ',
     $'and bragg planes (CW)= '
	  READ(*,*) A_BRAGG 
	if (a_bragg.eq.0.0) then
	  i_asym = 0
	else 
	  i_asym = 1
	endif
	ENDIF
C
C <<calculation for perfect crystal>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C
	IF (I_MOSAIC.NE.1) THEN
C
C Define the angles
C
	if (i_mode.eq.5.or.i_mode.eq.3.or.i_mode.eq.2) then !bragg
	   THETA_O	= GRAZE + A_BRAGG
	   THETA_H	= GRAZE - A_BRAGG
	else if (i_mode.eq.4.or.i_mode.eq.1) then           !laue
	   theta_o	= abs( - graze + a_bragg )
	   theta_h	= abs(   graze + a_bragg )
	endif
	SIN_O	= SIN(TORAD*THETA_O)
	SIN_H	= SIN(TORAD*THETA_H)
	COS_A   = COS(TORAD*A_BRAGG)
	SIN_G   = SIN(TORAD*GRAZE)
	COS_G   = COS(TORAD*GRAZE)
	ASS_FAC	= abs(SIN_O/SIN_H)
	SQR_FAC = SQRT(ASS_FAC)
	if (i_mode.eq.2.or.i_mode.eq.3.or.i_mode.eq.5) 
     $      ass_fac = -1.0d0*ass_fac
C
C Define the q variables of Warren, useful lfor calculating the RC width.
C
	QS	= RN*R_LAM0*STRUCT*TEMPER*SP_HKL
	QS1	= QS*COS_A/SIN_O
	QS2	= QS*COS_A/SIN_H
	QP	= QS*ABS(COS(TORAD*2.0D0*GRAZE))
	QP1	= QP*COS_A/SIN_O
	QP2	= QP*COS_A/SIN_H

	SSS	= DREAL(SSVAR)*1.0D6
	PPP	= DREAL(SPVAR)*1.0D6

	IF (I_ASYM.NE.1) THEN
#ifdef vms
	 OPEN	(20,FILE='ROCK_CURVE.S',STATUS='NEW')
	 OPEN	(21,FILE='ROCK_CURVE.P',STATUS='NEW')
#else
	 OPEN	(20,FILE='rock_curve.s',STATUS='UNKNOWN')
	 REWIND (20)
	 OPEN	(21,FILE='rock_curve.p',STATUS='UNKNOWN')
	 REWIND (21)
#endif
	 WRITE(6,*) '1/2 width of Rock Curve  s-pol  =  : ',
     $         	    SSS,' microradians'
	 WRITE(6,*) '1/2 width of Rock Curve  p-pol  =  : ',
     $         	    PPP,' microradians'
	ELSE IF (I_ASYM.EQ.1) THEN
#ifdef vms
	 OPEN	(20,FILE='ROCK_CURVE_INC.S',STATUS='NEW')
	 OPEN	(21,FILE='ROCK_CURVE_INC.P',STATUS='NEW')
	 OPEN	(27,FILE='ROCK_CURVE_REF.S',STATUS='NEW')
	 OPEN	(28,FILE='ROCK_CURVE_REF.P',STATUS='NEW')
#else
	 OPEN	(20,FILE='rock_curve_inc.s',STATUS='UNKNOWN')
	 REWIND (20)
	 OPEN	(21,FILE='rock_curve_inc.p',STATUS='UNKNOWN')
	 REWIND (21)
	 OPEN	(27,FILE='rock_curve_ref.s',STATUS='UNKNOWN')
	 REWIND (27)
	 OPEN	(28,FILE='rock_curve_ref.p',STATUS='UNKNOWN')
	 REWIND (28)
#endif
	 WRITE(6,*) 
     $	 'The width of the Rock Curve in function of incident angle is'
	 WRITE(6,*) 
     $	 '1/2 width for s-pol  =  : ',SSS/SQR_FAC,' microradians'
	 WRITE(6,*) 
     $	 '1/2 width for p-pol  =  : ',PPP/SQR_FAC,' microradians'
	 WRITE(6,*) 
     $	 'The width of the Rock Curve in function of reflected angle is'
	 WRITE(6,*) 
     $	 '1/2 width for s-pol  =  : ',SSS*SQR_FAC,' microradians'
	 WRITE(6,*) 
     $	 '1/2 width for p-pol  =  : ',PPP*SQR_FAC,' microradians'
	 WRITE(6,*) 'Asymmetric factor b=  : ',ass_fac
	END IF
	WRITE(6,*) '    '
C
C
C
	EPRANGE	= RNUMBER ('+/- how many microradians : ')
	EPRANGE	= EPRANGE * 1.0D-6
	NPOINT	= IRINT ('How many points : ')
	ESTEP	= 2.0D0*EPRANGE/(NPOINT-1)
C
C Calculation of corrected angles for asymmetrical diffraction
C following Handbook of SR
C
	THETA_INC = (THETA_B - GRAZE)	
	THETA_INC_O = 0.5D0*(1.0D0-1.0D0/ASS_FAC)*THETA_INC
	THETA_INC_H = 0.5D0*(1.0D0-ASS_FAC)*THETA_INC
	if (i_mode.eq.5.or.i_mode.eq.3.or.i_mode.eq.2) then 
	   THETA_B_O	= GRAZE + A_BRAGG + THETA_INC_O
	   THETA_B_H	= GRAZE - A_BRAGG + THETA_INC_H
	else if (i_mode.eq.4.or.i_mode.eq.1) then
	   theta_b_o	= abs( - graze + a_bragg - theta_inc_o)
	   theta_b_h	= abs(   graze + a_bragg + theta_inc_h)
	endif
C
C RCS, RCP are the complex reflection coefficient for s- and p- component.
C The two reflectivities are written out.
C
C
C Inquire about units
C
	MUL_FAC = 1.0D0
	I_SEC = IYES ('Do you want to use sec [1/0] ? ')
	IF (I_SEC.EQ.1) MUL_FAC=180.0*3600.0/PI
	I_DES = IYES ('Do you want the R.C. centered [1/0] ? ')
	DES_FAC_O=THETA_INC_O*TORAD
	DES_FAC_H=THETA_INC_H*TORAD
C
C Begins loop along the angular points
C
	DO 399 I = 1, NPOINT
	  EP	= (I-1)*ESTEP - EPRANGE
C
C New crystal formulation Aug 92 G.J.Chen , M. S. del Rio Nov 92.
C
	if (i_mode.ne.3) then
	
c
c definition of sin_q_ang, sin_q_ref and sin_brg to be consistent
c with the CRYSTAL module.
c
	sin_brg = -1.0d0*dsin(graze*torad-ep)
c
c sin_q_ang is the sine of the angle between the incident ray and
c the crystal surface: 
c Laue case: q_ang = [90 - (ep+graze+90-a_bragg) =>
c sin_q_ang = -sin(ep+graze-a_bragg)
c Bragg case: q_ang = graze + a_bragg
c the EP is not critical
c
	if (i_mode.eq.1.or.i_mode.eq.4) then                ! laue
	  sin_q_ang =-1.0d0*dsin(ep+(graze-a_bragg)*torad) 
	else if (i_mode.eq.2.or.i_mode.eq.5) then           ! bragg
	  sin_q_ang = dsin(ep+(graze+a_bragg)*torad)
	endif
c
c sin_q_ref is the sine of the angle between the outcoming ray and
c the crystal surface: q_ref = ep' + graze + a_bragg  =>
c
	if (i_mode.eq.1.or.i_mode.eq.4) then              ! laue
	  sin_q_ref = -1.0D0*dsin(torad*(graze+a_bragg))
	else if (i_mode.eq.2.or.i_mode.eq.5) then         ! bragg
	  sin_q_ref = dsin(torad*(graze-a_bragg))
	endif
c
c gamma_0 is the director cosine between the incident ray and the
c surface normal: cos (180 - q_ang) = cos (180 - [graze + 90 - a_bragg])
c = sin (graze-a_bragg) = -sin_a_ang
c gamma_h = cos (90+a_bragg+graze)=-sin(graze+a_bragg)=sin_g_ref
c
	gamma_0 = -1.0d0*sin_q_ang
	gamma_h = sin_q_ref
	cry_b = gamma_0/gamma_h
	d_spacing = sp_hkl
	cry_t0 = thick
	cry_t = 0.5*(1./abs(gamma_0) +1./abs(gamma_h))*cry_t0 
	cry_a = pi/r_lam0*(cry_t0/gamma_0)
	cry_alpha = ((r_lam0/d_spacing)**2+2*r_lam0*
     $sin_brg/d_spacing)

	psi_h = rn*r_lam0**2/pi*fh
	psi_hbar = rn*r_lam0**2/pi*fh_bar
	psi_0 = rn*r_lam0**2/pi*f_0
	psi_conj = rn*r_lam0**2/pi*dconjg(fh)

	cry_q = cry_b*psi_h*psi_hbar
	cry_z = (1.-cry_b)*0.5*psi_0 + cry_b*0.5*cry_alpha

c
c	new formulation based on formulae [3.137] (laue) and
c	[3.130] (bragg) of Zachariasen's book. MSR Nov 1992.
c	We allow also to calculate the transmitted beam in both
c	laue case [3.131] and bragg case [3.138] (i_mode 4 and 5
c	respectively)
c

c
c s-polarization
c
	ctemp = cdsqrt(cry_q  + cry_z**2)
	br_x1 = (-1.0d0*cry_z+ctemp)/psi_hbar
	br_x2 = (-1.0d0*cry_z-ctemp)/psi_hbar
	br_delta1 = 0.5d0*(psi_0-cry_z+ctemp)
	br_delta2 = 0.5d0*(psi_0-cry_z-ctemp)
	br_c1 = -1.0d0*ci*thick*twopi/(-1.0*abs(gamma_0))/r_lam0*br_delta1
	br_c2 = -1.0d0*ci*thick*twopi/(-1.0*abs(gamma_0))/r_lam0*br_delta2
c
c a very big exponential produces numerical overflow. If so, the value
c is changed artificially to avoid the overflow. This is equivalent to 
c use the thick crystal approximation
c
C 700 -> 100 to reduce overflow on HP.
C
	if (dreal(br_c1).gt.100.or.dreal(br_c2).gt.100) then 
	  if (dreal(br_c1).gt.100) br_c1 = 100.0d0+ci*dimag(br_c1)
	  if (dreal(br_c2).gt.100) br_c2 = 100.0d0+ci*dimag(br_c2)
	endif

	br_c1 = cdexp(br_c1)
	br_c2 = cdexp(br_c2)

	if (i_mode.eq.1) then 
	  br_ref = br_x1*br_x2*(br_c1-br_c2)/(br_x2-br_x1)             ! laue
	else if (i_mode.eq.2) then
	  br_ref = br_x1*br_x2*(br_c1-br_c2)/(br_c2*br_x2-br_c1*br_x1) ! bragg
	else if (i_mode.eq.4) then
	  br_ref = (br_x2*br_c1-br_x1*br_c2)/(br_x2-br_x1)             ! laueT
	else if (i_mode.eq.5) then
	  br_ref = br_c1*br_c2*(br_x2-br_x1)/(br_c2*br_x2-br_c1*br_x1) ! braggT
	endif

	r_s = br_ref*dconjg(br_ref)
	if (i_mode.eq.1.or.i_mode.eq.2) r_s = (1.0d0/abs(cry_b))*r_s
c
c p-polarization
c
	c_ppol = abs(cos(torad*2.0d0*graze))

	ctemp = cdsqrt(cry_q*c_ppol**2  + cry_z**2)
	br_x1 = (-1.0d0*cry_z+ctemp)/(psi_hbar*c_ppol)
	br_x2 = (-1.0d0*cry_z-ctemp)/(psi_hbar*c_ppol)
	br_delta1 = 0.5d0*(psi_0-cry_z+ctemp)
	br_delta2 = 0.5d0*(psi_0-cry_z-ctemp)
	br_c1 = -1.0d0*ci*thick*twopi/(-1.0*abs(gamma_0))/r_lam0*br_delta1
	br_c2 = -1.0d0*ci*thick*twopi/(-1.0*abs(gamma_0))/r_lam0*br_delta2
c
c a very big exponential produces numerical overflow. If so the value
c is changed to avoid the overflow. This is equivalent to the thick
c crystal approximation
c
C 700 -> 100 to reduce overflow on HP.
C
	if (dreal(br_c1).gt.100.or.dreal(br_c2).gt.100) then 
	  if (dreal(br_c1).gt.100) br_c1 = 100.0d0+ci*dimag(br_c1)
	  if (dreal(br_c2).gt.100) br_c2 = 100.0d0+ci*dimag(br_c2)
	endif

	br_c1 = cdexp(br_c1)
	br_c2 = cdexp(br_c2)

	if (i_mode.eq.1) then
	  br_ref = br_x1*br_x2*(br_c1-br_c2)/(br_x2-br_x1)             ! laue
	else if (i_mode.eq.2) then
	  br_ref = br_x1*br_x2*(br_c1-br_c2)/(br_c2*br_x2-br_c1*br_x1) ! bragg
	else if (i_mode.eq.4) then
	  br_ref = (br_x2*br_c1-br_x1*br_c2)/(br_x2-br_x1)             ! laueT
	else if (i_mode.eq.5) then
	  br_ref = br_c1*br_c2*(br_x2-br_x1)/(br_c2*br_x2-br_c1*br_x1) ! braggT
	endif

	r_p = br_ref*dconjg(br_ref)
	if (i_mode.eq.1.or.i_mode.eq.2) r_p = (1.0d0/abs(cry_b))*r_p



	if (i_des.eq.1) then                         !centered
	  WRITE	(20,*)	(EP-des_fac_o)*MUL_FAC,r_s
	  WRITE	(21,*)	(EP-des_fac_o)*MUL_FAC,r_p
	else                                         !not centered
	  WRITE	(20,*)	EP*MUL_FAC,r_s
	  WRITE	(21,*)	EP*MUL_FAC,r_p
	endif
c
c if asymmetric, the exit rock curve
c
	if (i_asym.eq.1) then
	   epp = (ep-des_fac_o)*abs(cry_b)
	   if (i_des.ne.1) epp = epp + des_fac_h
	   WRITE  (27,*)  EPP*MUL_FAC,r_s
 	   WRITE  (28,*)  EPP*MUL_FAC,r_p
	endif
C
C OLD BRAGG CASE ===============================================
C Main calculation (symmetrical case and asym incident case)
C
	else if (i_mode.eq.3) then
C
C Variable h (for absorption)
C
	HH	= ABSORP*SP_HKL/2.0D0
	SIN_OO	= 1.0D0/SIN_O
	SIN_HH	= 1.0D0/SIN_H
	H	= 0.5D0*HH*COS_A*(SIN_OO+SIN_HH)
C
	  UVE_O	= PI*SP_HKL*COS_G*(1.0D0-ASS_FAC)*EP/R_LAM0
	  RCS1_O= CI*QS2/(H+CI*UVE_O+SQRT(QS1*QS2+(H+CI*UVE_O)**2))
	  RCP1_O= CI*QP2/(H+CI*UVE_O+SQRT(QP1*QP2+(H+CI*UVE_O)**2))
	  RCS2_O= CI*QS2/(H+CI*UVE_O-SQRT(QS1*QS2+(H+CI*UVE_O)**2))
	  RCP2_O= CI*QP2/(H+CI*UVE_O-SQRT(QP1*QP2+(H+CI*UVE_O)**2))
c
	  IF (((CDABS(RCS1_O))**2).LE.-1.*ASS_FAC) THEN
	    RCS_O	= RCS1_O/SQR_FAC
	  ELSE 
	    RCS_O	= RCS2_O/SQR_FAC
	  END IF
	  RCS_O	= RCS_O*SQRT(FH/FH_BAR)
	  IF (((CDABS(RCP1_O))**2).LE.-1.*ASS_FAC) THEN
	    RCP_O	= RCP1_O/SQR_FAC
	  ELSE 
	    RCP_O	= RCP2_O/SQR_FAC
	  END IF
	  RCP_O	= RCP_O*SQRT(FH/FH_BAR)
C
	  IF (GRAZE.GT.45) 	RCP_O = -RCP_O
	if (i_des.eq.1) then                         !centered
	  WRITE	(20,*)	EP*MUL_FAC,(CDABS(RCS_O))**2
	  WRITE	(21,*)	EP*MUL_FAC,(CDABS(RCP_O))**2
	else                                         !not centered
	  WRITE	(20,*)	(EP+DES_FAC_O)*MUL_FAC,(CDABS(RCS_O))**2
	  WRITE	(21,*)	(EP+DES_FAC_O)*MUL_FAC,(CDABS(RCP_O))**2
	endif
C
C Only for asymmetrical case (the reflected R.C)
C
	IF (I_ASYM.EQ.1) THEN
	 UVE_H	= PI*SP_HKL*COS_G*(1.0D0-1.0D0/ASS_FAC)*EP/R_LAM0
	 RCS1_H= CI*QS2/(H+CI*UVE_H+SQRT(QS1*QS2+(H+CI*UVE_H)**2))
	 RCP1_H= CI*QP2/(H+CI*UVE_H+SQRT(QP1*QP2+(H+CI*UVE_H)**2))
	 RCS2_H= CI*QS2/(H+CI*UVE_H-SQRT(QS1*QS2+(H+CI*UVE_H)**2))
	 RCP2_H= CI*QP2/(H+CI*UVE_H-SQRT(QP1*QP2+(H+CI*UVE_H)**2))
C
	  IF (((CDABS(RCS1_H))**2).LE.-1.*ASS_FAC) THEN
	    RCS_H	= RCS1_H/SQR_FAC
	  ELSE 
	    RCS_H	= RCS2_H/SQR_FAC
	  END IF
	 RCS_H	= RCS_H*SQRT(FH/FH_BAR)
	  IF (((CDABS(RCP1_H))**2).LE.-1.*ASS_FAC) THEN
	    RCP_H	= RCP1_H/SQR_FAC
	  ELSE 
	    RCP_H	= RCP2_H/SQR_FAC
	  END IF
C
	 RCP_H	= RCP_H*SQRT(FH/FH_BAR)
	  IF (GRAZE.GT.45) 	RCP_H = -RCP_H
C
	if (i_des.eq.1) then                         !centered
	 WRITE	(27,*)	EP*MUL_FAC,(CDABS(RCS_H))**2
 	 WRITE	(28,*)	EP*MUL_FAC,(CDABS(RCP_H))**2
	else                                         !not centered
	 WRITE	(27,*)	(EP+DES_FAC_H)*MUL_FAC,(CDABS(RCS_H))**2
 	 WRITE	(28,*)	(EP+DES_FAC_H)*MUL_FAC,(CDABS(RCP_H))**2
	endif
	END IF
	endif
 399    CONTINUE
C
C <<calculation for mosaic crystal>>
C
        ELSE if (i_mosaic.eq.1) then
C
#ifdef vms
	 OPEN	(20,FILE='ROCK_CURVE.S',STATUS='NEW')
	 OPEN	(21,FILE='ROCK_CURVE.P',STATUS='NEW')
#else
	 OPEN	(20,FILE='rock_curve.s',STATUS='UNKNOWN')
	 REWIND (20)
	 OPEN	(21,FILE='rock_curve.p',STATUS='UNKNOWN')
	 REWIND (21)
#endif
        qs_mosaic = (sin(torad*2.0d0*graze))*(ssr*pi)**2/r_lam0
        qp_mosaic = (sin(torad*2.0d0*graze))*(spr*pi)**2/r_lam0
	if (i_mode.eq.3.or.i_mode.eq.2) then
           a_mosaic = thick*absorp/sin(torad*graze)    !bragg
	else if (i_mode.eq.1) then
           a_mosaic = thick*absorp/cos(torad*graze)    !laue(alpha=90)
	endif

          omega_0      = (1/sqrt(twopi))*(1/spread)
          aas_mosaic_0 = omega_0*qs_mosaic/absorp
          aap_mosaic_0 = omega_0*qp_mosaic/absorp
          refmax_s  = aas_mosaic_0/(1+aas_mosaic_0+
     $sqrt(1+2*aas_mosaic_0))
          refmax_p  = aap_mosaic_0/(1+aap_mosaic_0+
     $sqrt(1+2*aap_mosaic_0))
          tmax      = cos(torad*graze)*dexp(1+2*aas_mosaic_0)/2/
     $aas_mosaic_0/absorp
        texts= r_lam0**2/pi/sin(torad*2*graze)/ssr/2/sp_hkl
        textp= r_lam0**2/pi/sin(torad*2*graze)/spr/2/sp_hkl
        tabs_mosaic = sin(torad*graze)/absorp
	ABSSECS_MOSAIC = OMEGA_0*QS_MOSAIC
	ABSSECP_MOSAIC = OMEGA_0*QP_MOSAIC
	ABSEXTS_MOSAIC = SIN(TORAD*GRAZE)/TEXTS
	ABSEXTP_MOSAIC = SIN(TORAD*GRAZE)/TEXTP
	TSECS_MOSAIC = SIN(TORAD*GRAZE)/ABSSECS_MOSAIC
	TSECP_MOSAIC = SIN(TORAD*GRAZE)/ABSSECP_MOSAIC
        ratio_mosaic = tabs_mosaic/texts
	EPRANGE_mosaic  = 1.5d0*2.35*spread
        NPOINT_mosaic   = 200
        ESTEP_mosaic    = 2.0D0*EPRANGE_mosaic/(NPOINT_mosaic-1)

        DO I = 1, NPOINT_mosaic
         EP    = (I-1)*ESTEP_mosaic - EPRANGE_mosaic
         omega = (1/sqrt(twopi))*(1/spread)*dexp(-ep*ep/2/spread/spread)
         aas_mosaic = omega*qs_mosaic/absorp
         aap_mosaic = omega*qp_mosaic/absorp
c
c reflection (bragg) case
c
	if (i_mode.eq.3.or.i_mode.eq.2) then
         rs_mosaic = 1+aas_mosaic+(sqrt(1+2*aas_mosaic))/
     $               tanh(a_mosaic*sqrt(1+2*aas_mosaic))
         rp_mosaic = 1+aap_mosaic+(sqrt(1+2*aap_mosaic))/
     $               tanh(a_mosaic*sqrt(1+2*aap_mosaic))
         rs_mosaic = aas_mosaic / rs_mosaic
         rp_mosaic = aap_mosaic / rp_mosaic
c
c transmission (laue) case
c
	else if (i_mode.eq.1) then
	 rs_mosaic = sinh(aas_mosaic*a_mosaic)*
     $               exp(-a_mosaic*(1.0+aas_mosaic))
	 rp_mosaic = sinh(aap_mosaic*a_mosaic)*
     $               exp(-a_mosaic*(1.0+aap_mosaic))
	endif

         write (20,*) ep,rs_mosaic
         write (21,*) ep,rp_mosaic
        end do
C <<end of mosaic and perfect calculations>>
        END IF
C
C Write out the parameters used.
C
#ifdef vms
	OPEN	(23,FILE='ROCK_CURVE.PAR',STATUS='NEW')
#else
	OPEN	(23,FILE='rock_curve.par',STATUS='UNKNOWN')
	REWIND (23)
#endif
	IF (I_LATT.EQ.0) THEN
	  WRITE	(23,*)	'ZincBlende structure :'
	  WRITE	(23,*)	'For atom A, fo + f'' + if" = ',FA
	  WRITE	(23,*)	'         B,               = ',FB
	ELSE IF (I_LATT.EQ.1) THEN
	  WRITE	(23,*)	'Rocksalt structure :'
	  WRITE	(23,*)	'For atom A, fo + f'' + if" = ',FA
	  WRITE	(23,*)	'         B,               = ',FB
	ELSE IF (I_LATT.EQ.2) THEN
	  WRITE	(23,*)	'Simple FCC structure :'
	  WRITE	(23,*)	'For basis atom, fo + f'' + if" = ',FA
	ELSE IF (I_LATT.EQ.3) THEN
	  WRITE	(23,*)	'CsCl structure :'
	  WRITE	(23,*)	'For atom A, fo + f'' + if" = ',FA
	  WRITE	(23,*)	'         B,               = ',FB
        ELSE IF (I_LATT.EQ.4) THEN
          WRITE (23,*)  'Hexagonal close-packed structure :'
          WRITE (23,*)  'For atom A, fo + f'' + if" = ',FA
          WRITE (23,*)  '         B,               = ',FB
        ELSE IF (I_LATT.EQ.5) THEN
          WRITE (23,*)  'Graphite structure :'
          WRITE (23,*)  'For atom basis, fo + f'' + if" = ',FA
        END IF
        IF ((I_LATT.EQ.4).OR.(I_LATT.EQ.5)) THEN
         WRITE (23,*) 'Lattice constant A =',D_LATT_A*1.0D8,' Angstroms'
         WRITE (23,*) 'Lattice constant C =',D_LATT_C*1.0D8,' Angstroms'
        ELSE
         WRITE  (23,*)  'Lattice constant = ',D_LATT*1.0D8,' Angstroms'
        END IF
	WRITE	(23,*)	'crystal thickness = ',thick,' cm'
	WRITE	(23,*)	'd-spacing        = ',SP_HKL*1.0D8,' Angstroms'
	WRITE	(23,*)	'Photon energy  = ',PHOT,' eV'
     	WRITE	(23,*)	'Lambda 		 = ',R_LAM0*1.0E8,' Angstroms'
     	WRITE	(23,*)	'SIN(theta)/Lambda = ',0.5D0/SP_HKL*1.0E-8,' ratio.'
	WRITE	(23,*)	'Refraction index = 1 - delta - i*beta :'
	WRITE	(23,*)	'           delta = ',DELTA
	WRITE	(23,*)	'            beta = ',BETA
	WRITE	(23,*)	'Absorption coeff = ',ABSORP,' cm-1'
	WRITE 	(23,*)  'Temperature factor = ',TEMPER
	WRITE	(23,*)	'Structure factor F(000) = ',F_0
	WRITE	(23,*)	'Structure factor F(hkl) = ',STRUCT
	if (i_mosaic.ne.1)
     $  WRITE	(23,*)	'Asymmetric factor b=  : ',ass_fac
        write	(23,*)  'lenght primary extinction (s-pol) =',
     $			textp*1d4,' microns'
        write	(23,*)  'lenght primary extinction (p-pol) =',
     $			texts*1d4,' microns'
	IF (I_ASYM.NE.1) THEN
	 if (i_mosaic.ne.1) then
	 WRITE  (23,*) 'The width of the Rock Curve is'
	 WRITE  (23,*) '1/2 width for s-pol  =  : ',SSS,' microradians'
	 WRITE  (23,*) '1/2 width for p-pol  =  : ',PPP,' microradians'
	 endif
      	 WRITE	(23,*)	'Theta (graz) 	     = ',GRAZE,' degrees'
	 WRITE	(23,*)	'Bragg angle(corr)   = ',THETA_B,' degrees'
	ELSE IF (I_ASYM.EQ.1) THEN
	 WRITE(23,*) ' '
	 WRITE(23,*) 'Rocking Curve parameters for the symmetrical case:'
	 WRITE(23,*) '1/2 width for s-pol  =  : ',SSS,' microradians'
	 WRITE(23,*) '1/2 width for p-pol  =  : ',PPP,' microradians'
      	 WRITE(23,*) 'Theta (graz) 	     = ',GRAZE,' degrees'
	 WRITE(23,*) 'Bragg angle(corr)   = ',THETA_B,' degrees'
	 WRITE(23,*) ' '
	 WRITE(23,*)'Width of Rock Curve in function of incident angle:'
	 WRITE(23,*)'1/2 width for s-pol = : ',SSS/SQR_FAC,' microrad'
	 WRITE(23,*)'1/2 width for p-pol = : ',PPP/SQR_FAC,' microrad'
	 WRITE(23,*)'Incident Grazing angle  = ',theta_o,' degrees'
	 WRITE(23,*)'Incident corrected angle   = ',THETA_B_O,' degrees'
	 WRITE(23,*) ' '
	 WRITE(23,*)'Width of Rock Curve in function of reflected angle:'
	 WRITE(23,*)'1/2 width for s-pol = : ',SSS*SQR_FAC,' microrad'
	 WRITE(23,*)'1/2 width for p-pol = : ',PPP*SQR_FAC,' microrad'
	 WRITE(23,*)'Reflected Grazing angle = ',theta_h,' degrees'
	 WRITE(23,*)'Reflected corrected angle  = ',THETA_B_H,' degrees'
	 WRITE(23,*)'Angle between face and bragg planes (CW)=',A_BRAGG,
     $        ' degrees'
	 CLOSE	(27)
	 CLOSE	(28)
	END IF
        IF (I_MOSAIC.EQ.1) THEN
         write (23,*) '  '
         write (23,*) '***********  MOSAIC PARAMETERS  ***************'
         write (23,*) '  '
         write (23,*) 'spread= ',2.35*spread/TORAD ,'deg fwhm'
         write (23,*) 'true absorp lenght = ',tabs_mosaic*1d4,' microns'
         write (23,*) 'peak thickness = ',tmax,' cm'
         write (23,*) 'For parallel polarization we have: '
         write (23,*) '   Q 	 = ',qs_mosaic,' cm-1 '
         write (23,*) '   lenght secn ext =',tsecs_mosaic*1d4,' microns'
         write (23,*) '   abs coef prim ext =',absexts_mosaic,'cm-1'
         write (23,*) '   abs coef secn ext =',abssecs_mosaic,'cm-1'
         write (23,*) '   peak refl = ',refmax_s
         write (23,*) 'For perpendicular polarization we have: '
         write (23,*) '   Q     = ',qp_mosaic,' cm-1 '
         write (23,*) '   lenght secn ext =',tsecp_mosaic*1d4,' microns'
         write (23,*) '   abs coef prim ext =',absextp_mosaic,'cm-1'
         write (23,*) '   abs coef secn ext =',abssecp_mosaic,'cm-1'
         write (23,*) '   peak refl = ',refmax_p
         write (23,*) '  '
D        CLOSE  (31)
D        CLOSE  (32)
        END IF
	CLOSE	(20)
	CLOSE	(21)
	CLOSE	(23)
	I_AGAIN	= IYES ('Do you want to try another energy [1/0] ? ')
	IF (I_AGAIN.EQ.1) GO TO 30
20	END
******************************************************************************
C+++
C	SUBROUTINE	POLY_2
C
C	PURPOSE		INPUT	3 pairs of data points (x,y)
C
C			OUTPUT	coefficients of a second degree polynomial
C				which passes through the 3 points (x,y)
C---
	SUBROUTINE	POLY_2	(X,Y,A,IFLAG)
	REAL*8		X(3),Y(3),A(3),C1,C2,C3
	IF (X(1).EQ.X(2).OR.X(1).EQ.X(3).OR.X(2).EQ.X(3)) THEN
	  IFLAG	= -1
	  RETURN
	END IF
	C1	= Y(1)/(X(1) - X(2))/(X(1) - X(3))
	C2	= Y(2)/(X(2) - X(3))/(X(2) - X(1))
	C3	= Y(3)/(X(3) - X(1))/(X(3) - X(2))
C
C Quadratic term
C
	A(3)	= C1 + C2 + C3
C
C Linear term
C
	A(2)	= -C1*(X(2)+X(3)) - C2*(X(3)+X(1)) - C3*(X(1)+X(2))
C
C Constant term
C
	A(1)	= C1*X(2)*X(3) + C2*X(3)*X(1) + C3*X(1)*X(2)
	IFLAG	= 1
	RETURN
	END
