C +++
C
C Source: src/utils/post/plotfoc.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: plotfoc.F
C Revision 1.6  1992/01/16  09:49:12  cwelnak
C 6000 changes
C
C Revision 1.5  1991/07/06  19:43:52  khan
C Grenoble Changes ...
C
C Revision 1.4  91/04/05  15:50:46  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  15:56:14  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:47:31  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:44  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		PLOTFOC
C
C	PURPOSE		To display the rays near an image plane
C
C---
      	PROGRAM		PLOTFOC
      	IMPLICIT	REAL*8(A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
C      	IMPLICIT	REAL*8(A-H,O-Z)
      	CHARACTER*80	INFIL,OUTFIL,RSTRING
      	DIMENSION	RAY(12,N_DIM),PHASE(3,N_DIM),AP(3,N_DIM)
10	INFIL	=  RSTRING ('Input  file ? ')
      	OUTFIL 	=  RSTRING ('Output file ? ')
      	CALL	RBEAM	(INFIL,RAY,PHASE,AP,NCOL,NP,IFLAG,IERR)
	IF (IERR.NE.0)	STOP	'Error in reading ray file.'
      	WRITE(*,*)'Read ',NP,' points.'
      	YLOW = RNUMBER ('Distance before plane [ <0 ] : ')
      	YUPP = RNUMBER ('         after        [ >0 ] : ')
      	IWHAT = IRINT  ('Two dimension [ 0 ] or three [ 1 ] ?')
      	 IF (IWHAT.EQ.0) THEN
      	   IKOL = IRINT ('Row to write out ? ')
      	 END IF
      	IFLAG = IRINT  ('Only good rays [ 0 ] or all [ 1 ] ? ')
      	WRITE(*,*)'OK. Here we go.'
#ifdef vms
      	OPEN	(33, FILE=OUTFIL, STATUS='NEW')
#else
      	OPEN	(33, FILE=OUTFIL, STATUS='UNKNOWN')
	REWIND (33)
#endif
      	DO 100 I=1,NP
      	 IF (IFLAG.EQ.0.AND.RAY(10,I).LT.0.0D0) GO TO 100
      	 IF (IWHAT.EQ.0) THEN
  	   X1 = YLOW
      	   Y1 = RAY(IKOL,I) + YLOW/RAY(5,I)*RAY(IKOL+3,I)
      	   X2 = YUPP
      	   Y2 = RAY(IKOL,I) + YUPP/RAY(5,I)*RAY(IKOL+3,I)
      	   WRITE (33,*) X1,Y1
      	   WRITE (33,*) X2,Y2
#ifdef vms
      	   WRITE (33,*) 'JOIN 1'
#else
	   WRITE (33,*) ' '
#endif
      	 ELSE
  	   X1 = YLOW
      	   Y1 = RAY(1,I) + YLOW/RAY(5,I)*RAY(4,I)
      	   Z1 = RAY(3,I) + YLOW/RAY(5,I)*RAY(6,I)
      	   X2 = YUPP
      	   Y2 = RAY(1,I) + YUPP/RAY(5,I)*RAY(4,I)
      	   Z2 = RAY(3,I) + YUPP/RAY(5,I)*RAY(6,I)
      	   WRITE (33,*) X1,Y1,Z1
      	   WRITE (33,*) X2,Y2,Z2
#ifdef vms
      	   WRITE (33,*) 'JOIN 1'
#else
	   WRITE (33,*) ' '
#endif
      	 END IF
100	CONTINUE
      	CLOSE (33)
      	STOP
      	END
