C +++
C
C Source: src/utils/optics/dose.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	dose.F
C Revision 1.6  92/01/15  16:06:27  cwelnak
C 6000 changes
C 
C Revision 1.5  91/07/06  19:42:54  khan
C Grenoble Changes ...
C 
C Revision 1.4  91/04/05  15:21:22  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  15:52:08  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/03/25  15:48:44  khan
C Getting ready for SUN port ...
C 
C Revision 1.1  90/10/10  13:32:52  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		DOSE
C
C	PURPOSE		To compute the absorbed energy, in J/cm3, for
C			a given material in function of the depth.
C
C	INPUT		A power spectrum file
C			An absorption coefficient file
C
C	OUTPUT		The absorbed energy density versus the depth
C
C---
      	PROGRAM		DOSETOT

#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif

      	DIMENSION	POWER(N_DIM),COEFF(N_DIM),ENER(N_DIM),Z(1000)
      	DIMENSION	DOSE(1000)
        REAL*8		RNUMBER
      	CHARACTER*80	NAME(3),RSTRING
C
C Reads in files
C
      	NAME(1)	=   RSTRING ('Power density file ? ')
      	NAME(2) =   RSTRING ('Absorption Coefficient File ? ')
      	NAME(3) =   RSTRING ('Output file ? ')
#ifdef vms
      	OPEN (20, FILE=NAME(1), STATUS='OLD', READONLY)
#else
      	OPEN (20, FILE=NAME(1), STATUS='OLD')
#endif
      	I = 0
	IERR = 0
      	DO WHILE (IERR.EQ.0)
      	  I = I + 1
      	  READ (20,*,IOSTAT=IERR) ENER(I),POWER(I)
      	END DO
      	N1 = I - 1
      	CLOSE (20)
#ifdef vms
      	OPEN (20, FILE=NAME(2), STATUS='OLD', READONLY)
#else
      	OPEN (20, FILE=NAME(2), STATUS='OLD')
#endif
      	I = 0
      	IERR = 0
      	DO WHILE (IERR.EQ.0)
      	  I =  I + 1
      	  READ (20,*,IOSTAT=IERR) ENER(I),COEFF(I)
      	END DO
      	N2 = I - 1
      	IF (N1.NE.N2) THEN
      	  WRITE(6,*) N1,N2
      	  STOP 'Different number of data points.'
      	END IF
      	CLOSE (20)
      	NP = N1
      	WRITE(6,*) 'Files read OK.'
10	THICK = RNUMBER ('Thickness (MICRONS) ? ')
      	STEP =  RNUMBER ('Step size (MICRONS) ? ')
      	AREA =  RNUMBER ('Area over which power is spread [ cm2 ] ? ')
      	NSTEP = THICK/STEP + 1
      	IF (NSTEP.GE.1000) THEN
      	  WRITE(6,*) 'Too many steps.'
      	  GO TO 10
      	END IF
      	ESTEP = ENER(2) - ENER(1)
      	DO I=1,NSTEP
      	  DOSE(I) = 0.0
      	  Z(I) = (I-1)*STEP*1.0E-4
      	 DO J=1,NP
      	   ATTEN = EXP( -(Z(I)*COEFF(J)) )
      	   DOSE(I) = DOSE(I) + POWER(J)*ESTEP*COEFF(J)*ATTEN
      	 END DO
      	END DO
      	WRITE(6,*) 'All calculations completed'
#ifdef vms
      	OPEN (20, FILE=NAME(3), STATUS='NEW')
#else
      	OPEN (20, FILE=NAME(3), STATUS='UNKNOWN')
	REWIND (20)
#endif
      	 DO I=1,NSTEP
      	   WRITE (20,*) Z(I)*1.0E4,DOSE(I)/AREA
      	 END DO
      	CLOSE (20)
      	END
