C +++
C
C Source: src/utils/gen/filex.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: filex.F
C Revision 1.2  1991/07/06  19:40:17  khan
C Grenoble Changes ...
C
C Revision 1.1  90/10/08  15:01:10  khan
C Initial revision
C 
C 
C ---

     	PROGRAM			FILE
     	implicit	real*8	(a-h,o-z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif
C
C This is a file manipulation program
C
     	CHARACTER*80	INLINE
     	CHARACTER*30	FILE1,FILE2,FILE3,INFIL1,INFIL2,OUTFIL
     	DIMENSION	X(N_DIM),Y(N_DIM),Y1(N_DIM),Y2(N_DIM),X1(N_DIM)
	REAL*4		XPLOT(N_DIM),YPLOT(N_DIM)
	LOGICAL		FLAG

	IPLOT	= 0
1     	WRITE (6,*) 'FILEX > '
     	READ (5,1000,END=1111)	INLINE

     	IF (INLINE(1:1).EQ.'?') THEN
C#if vms
C     	 CALL LIB$ERASEPAGE(1,1)
C#elif unix
C         call system('clear')
C#endif
	 CALL CLSCREEN
     	  OPEN (30, FILE='filexhlp.txt', 
     $		STATUS='OLD')
     	 DO 10 JJ=1,100
     	   READ (30, 92, ERR=91) INLINE
     	   WRITE(6,*)INLINE
10     	 CONTINUE
91	  CLOSE (30)
92	FORMAT (A)
     	  GO TO 1
     	END IF
     	CALL	FIRST 	(INLINE,0,I1)
     	CALL	RNAME	(INLINE,I1,IEND,FILE1)
     	CALL	FIRST 	(INLINE,IEND,I2)
     	CALL	SYMB	(INLINE,IFLAG1,I2)
     	CALL	FIRST	(INLINE,I2,I3)
     	CALL	RNAME	(INLINE,I3,IEND,FILE2)
C
C Check for Exit. Added 11/4/94, clw.
C
	FLAG	= FILE1(1:5).EQ.'%EXIT'
	FLAG	= FILE1(1:5).EQ.'%exit'.OR.FLAG
	FLAG	= FILE1(1:5).EQ.'%Exit'.OR.FLAG
	IF (FLAG) GOTO 5000
C
C Check for plotting.
C
	FLAG	= FILE1(1:5).EQ.'%PLOT'
	FLAG	= FILE1(1:5).EQ.'%plot'.OR.FLAG
	FLAG	= FILE1(1:5).EQ.'%Plot'.OR.FLAG
	IF (FLAG) THEN
	  OPEN	(40, FILE=FILE2, STATUS='OLD')
	  DO 20 I = 1, N_DIM
	    READ	(40,*,END=101)	XPLOT(I),YPLOT(I)
20	  CONTINUE
101	  NN	= I - 1
	  CLOSE (40)
	  IF (IPLOT.EQ.0) THEN
#ifdef vms
	    CALL	SET_SCREEN	('FILEX >',0,ITERM)
#endif
	    IPLOT	= 1
	  ELSE
#ifdef vms
	    CALL	SET_SCREEN	('FILEX >',-1,ITERM)
#endif
	  END IF
#ifdef vms 
	  CALL	TDNEWP
	  CALL	TDPLOT	(NN,XPLOT,YPLOT)
	  CALL	SET_SCREEN	(' ',1,ITERM)
#endif
	  GO TO 1
	END IF
C
C
     	CALL	FIRST	(INLINE,IEND,I4)
     	CALL	SYMB	(INLINE,IFLAG2,I4)
     	IF (IFLAG2.GE.6) THEN
     	IREAD	= 0
     	GO TO 5
     	END IF
     	CALL	FIRST	(INLINE,I4,I5)
     	CALL	RNAME	(INLINE,I5,IEND,FILE3)
     	IREAD = 1
     	IF (FILE3(1:1).EQ.'%') THEN
     	 READ (FILE3(2:30),3333) FACTOR
3333	 FORMAT (BN,F29.0)
     	 INFIL1 = FILE2
 	 OUTFIL = FILE1
         IREAD  = 0
     	END IF
5     	IF (IFLAG1.EQ.5)  THEN
	OUTFIL	=  FILE1
     	INFIL1	=  FILE2
     	INFIL2	=  FILE3
     	ELSE	IF (IFLAG2.EQ.5) THEN
     	OUTFIL	=  FILE3
     	INFIL1	=  FILE1
     	INFIL2	=  FILE2
     	END IF
     	OPEN (23, FILE=INFIL1, STATUS='OLD', ERR=2)
     	IF (IREAD.NE.0) 
     $		OPEN 	(24, FILE=INFIL2, STATUS='OLD', ERR=3)
     	DO 30 I=1,N_DIM
     	READ (23,*,END=100)	X(I),Y1(I)
     	IF (IREAD.NE.0) READ (24,*,END=100)	DUMMY,Y2(I)
30     	CONTINUE
100	NN = I-1
     	CLOSE (23)
     	CLOSE (24)
     	WRITE (6,*)	'FILEX > read ',NN,' records.'
     	IF (IFLAG1.EQ.5)  ICOMP	=  IFLAG2
     	IF (IFLAG2.EQ.5)  ICOMP	=  IFLAG1
     	IF (ICOMP.LT.6) THEN
     	DO  40 I=1,NN
     	 IF (IREAD.NE.0) THEN
     	  IF (ICOMP.EQ.1) THEN
     	    Y(I)	=  Y1(I) + Y2(I)
     	  ELSE IF (ICOMP.EQ.2) THEN
     	    Y(I)	=  Y1(I) - Y2(I)
     	  ELSE IF (ICOMP.EQ.3) THEN
     	    Y(I)	=  Y1(I)/Y2(I)
     	  ELSE IF (ICOMP.EQ.4) THEN
     	    Y(I)	=  Y1(I)*Y2(I)
     	  END IF
     	 ELSE
     	  IF (ICOMP.EQ.1) THEN
     	    Y(I)	=  Y1(I) + FACTOR
     	  ELSE IF (ICOMP.EQ.2) THEN
     	    Y(I)	=  Y1(I) - FACTOR
     	  ELSE IF (ICOMP.EQ.3) THEN
     	    Y(I)	=  Y1(I)/FACTOR
     	  ELSE IF (ICOMP.EQ.4) THEN
     	    Y(I)	=  Y1(I)*FACTOR
     	  END IF
     	 END IF
40     	CONTINUE
     	ELSE 
     	 IF (ICOMP.EQ.6) THEN
C Sum of columns (histogram)
     	   XVAL	= 0.0
     	   YVAL1	= 0.0
      	  DO 50 I=1,NN
     	    XVAL	=   XVAL + X(I)
     	    YVAL1	=   YVAL1 + Y1(I)
50     	  CONTINUE
     	WRITE (6,*) 'FILEX > Sum of ',FILE2,' X column : ',XVAL
     	WRITE (6,*) 'FILEX > Sum of ',FILE2,' Y column : ',YVAL1
     	 ELSE IF (ICOMP.EQ.7) THEN
C Sum of columns, initial conditions 
     	  DO  60 I=1,NN
	   IF (Y1(I).NE.0.0) THEN
	    Y(I) = 1.0/Y1(I)
	   ELSE
	    Y(I) = 1.0E30
	   END IF
60     	  CONTINUE
	  GO TO 7
     	 ELSE IF (ICOMP.EQ.8) THEN
C Derivative
	  Y(1)	= (Y1(2) - Y1(1))/(X(2) - X(1))
     	  DO  70 I=2,NN-1
     	    YVAL1	=   ( Y1(I)   - Y1(I-1))
     	    YVAL2	=   ( Y1(I+1) - Y1(I))
     	    XVAL1	=   ( X(I)   - X(I-1))
     	    XVAL2	=   ( X(I+1) - X(I))
     	    Y(I)	=   0.5*((YVAL2/XVAL2) + (YVAL1/XVAL1))
70     	  CONTINUE
	  Y(NN)	= (Y1(NN) - Y1(NN-1))/(X(NN) - X(NN-1))
     	  GO TO 7
     	 ELSE IF (ICOMP.EQ.9) THEN
     	   YVAL	=   0.0
     	   Y(1) =  0.0
     	  DO 80 I=2,NN
     	    YVAL	=   YVAL + (Y1(I)+Y1(I-1))*(X(I)-X(I-1))/2
     	    Y(I)	=   YVAL
80     	  CONTINUE
     	WRITE (6,*) 'FILEX > Integral of ',FILE1,' is: ',YVAL
     	  GO TO 7
     	 ELSE IF (ICOMP.EQ.10) THEN
     	  DO  90 I=1,NN
     	    Y(I)	=   X(I)
     	    X(I)	=   Y1(I)
90     	  CONTINUE
     	  GO TO 7
     	 ELSE IF (ICOMP.EQ.11) THEN
     	  DO 11 I=1,NN
     	    X1(I) = X(I)
11     	  CONTINUE
     	  DO 12 I=1,NN
     	    X(I) = X1(NN-I+1)
     	    Y(I) = Y1(NN-I+1)
12     	  CONTINUE
     	  GO TO 7
     	 ELSE IF (ICOMP.EQ.12) THEN
     	  DO 13 I=1,NN
     	   Y(I) = SQRT(ABS(Y1(I)))
13     	  CONTINUE
     	  GO TO 7
     	 ELSE IF (ICOMP.EQ.13) THEN
     	  DO 14 I=1,NN
     	   Y(I) = Y1(I)*X(I)
14     	  CONTINUE
     	  GO TO 7
C Calculate the mean and st. dev. of X, using Y1 as probability.
     	 ELSE IF (ICOMP.EQ.14) THEN
	  AVERAGE	= 0.0D0
	  PROB		= 0.0D0
	  VARIANCE	= 0.0D0
     	  DO 15 I=1,NN
	   PROB = PROB + Y1(I)
     	   AVERAGE = AVERAGE + Y1(I)*X(I)
	   VARIANCE = VARIANCE + Y1(I)*(X(I)**2)
15     	  CONTINUE
	  AVERAGE = AVERAGE/PROB
	  VARIANCE = VARIANCE/PROB - AVERAGE**2
	  WRITE	(6,*)	'FILEX > Mean     : ',AVERAGE
	  WRITE	(6,*)	'FILEX > St. Dev. : ',SQRT(VARIANCE)
     	  GO TO 6
C
C Take natural Log (ln(Y))
C
	 ELSE IF (ICOMP.EQ.15) THEN
     	  DO 16 I=1,NN
     	   Y(I) = LOG(Y1(I))
16     	  CONTINUE
     	  GO TO 7
     	 END IF
      	END IF
 	IF (ICOMP.GE.6) GO TO 6
7    	OPEN (22, FILE=OUTFIL, STATUS='NEW')
     	DO 17 I=1,NN
     	WRITE (22,*)	X(I),Y(I)
17     	CONTINUE
     	CLOSE (22)

6     	WRITE (6,*)	'FILEX > Succesful completion'
     	GO TO 1
1000	FORMAT (A)
1111	STOP
2	WRITE (6,*)	'FILEX > ERROR OPEN ',FILE2
     	GO TO 1
3	WRITE (6,*)	'FILEX > ERROR OPEN ',FILE3
     	GO TO 1
5000	CONTINUE
     	END


     	SUBROUTINE	SYMB	(LINE,IVAL,I)
     	CHARACTER *80	LINE
     	IF (LINE(I:I).EQ.'+')	IVAL	= 1
     	IF (LINE(I:I).EQ.'-')	IVAL	= 2
     	IF (LINE(I:I).EQ.'/')	IVAL	= 3
     	IF (LINE(I:I).EQ.'*')	IVAL	= 4
     	IF (LINE(I:I).EQ.'=')	IVAL	= 5
     	IF (LINE(I:I).EQ.'&')	IVAL	= 6
     	IF (LINE(I:I).EQ.'#')	IVAL	= 7
     	IF (LINE(I:I).EQ.'^')	IVAL	= 8
     	IF (LINE(I:I).EQ.'@')	IVAL	= 9
     	IF (LINE(I:I).EQ.'"')	IVAL	= 10
    	IF (LINE(I:I).EQ.'\\')   IVAL    = 11
     	IF (LINE(I:I).EQ.'~')	IVAL	= 12
     	IF (LINE(I:I).EQ.'|')   IVAL	= 13
     	IF (LINE(I:I).EQ.'[')   IVAL	= 14
     	IF (LINE(I:I).EQ.'!')   IVAL	= 15
     	RETURN
     	END

     	SUBROUTINE	FIRST	(LINE,ISTART,IWHERE)
     	CHARACTER *80	LINE
     	DO 18 IWHERE=ISTART+1,80
     	IF (LINE(IWHERE:IWHERE).NE.' ')	RETURN
18     	CONTINUE
     	IWHERE = -1
     	RETURN
     	END

     	SUBROUTINE	RNAME (LINE,ISTART,IEND,NAME)
     	CHARACTER *80	LINE
     	CHARACTER *30	NAME
     	DO 19 I=1,30
     	IND	=   ISTART + I - 1
     	IF (LINE(IND:IND).EQ.' ')	GO TO 100
     	NAME(I:I) = LINE (IND:IND)
     	IEND	=   ISTART + I
19     	CONTINUE
100	NAME (I:) = ' '
     	RETURN
     	END
