C +++
C
C Source: src/tools/tek-graphics/contour.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: contour.F
C Revision 1.3  1991/04/22  00:06:47  khan
C Fixed #include quotes
C
C Revision 1.2  1991/03/25  14:41:06  khan
C SUN port -- INCLUDE -> #include
C
C Revision 1.1  90/11/01  17:16:30  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C
C SUBROUTINE CONTOUR(X,Y,DATA,XYLIM,NX,NY,ICONT,Z,IPLOT)
C
C PURPOSE:
C   THIS SUBROUTINE IS WRITTEN FOR GENERATING CONTOUR PROFILE.
C   THE OUTPUT IS SUITABLE FOR TOP-DRAWER.
C
C SPECIFICATIONS:
C   NX --- NUMBER OF X
C   NY --- NUMBER OF Y
C   X(NX) --- COORDINATE OF X
C   Y(NY) --- COORDINATE OF Y
C   DATA(NX*NY) --- VALUE AT (X,Y)
C
C   XYLIM(4) --- TOP-DRAWER X,Y LIMITS CONTROLLER
C     XYLIM(1) => X LOWER LIMIT
C     XYLIM(2) =>   UPPER
C     XYLIM(3) => Y LOWER LIMIT
C     XYLIM(4) =>   UPPER
C
C   ICONT(10) --- FOR CONTROLLING THE INPUT 
C     ICONT(1) .EQ. 0 => DEFAULT, TEN SELF-ADJUSTED CONTOUR VALUES
C              .GT. 0 => NUMBER OF CONTOUR VALUES, AND THE VALUES
C                        ARE GIVEN IN ARRAY "Z"
C		      ** MAX OF 20 CONTOUR VALUES
C     ICONT(2) .EQ. 0 => DO NOT WANT LABEL ON CURVE
C              .EQ. 1 => WANT LABEL ON CURVE
C     ICONT(3)           OUTPUT DEVICE NUMBER OF TD.FIL
C     ICONT(4)	      => Type of graphics terminal as return by SET_SCREEN.
C			 In particular, 3 = TEK 4107 which is color.
C
C   IPLOT(10) --- FOR CONTROLLING THE OUTPUT
C     IPLOT(1) .EQ. 0 => OUTPUT TO TERMINAL ONLY
C              .EQ. 1 => OUTPUT ALSO TO TD.FIL
C     IPLOT(2) IS THE JOIN LEVEL IN TOP-DRAWER
C     IPLOT(3) .EQ. 0 => NO LABELS ON AXES
C              .EQ. 1 =>    LABELS ON AXES
C
C COMMENTS:
C   (1) THE VALUES IN X AND Y MUST BE IN MONOTONIC ASCENDING OR
C       DESCENDING ORDER
C   (2) THE VALUES IN DATA MUST BE ARRANGED IN ROW ORDER. IT MEANS
C       VARY X THEN Y.
C       
C
C MARCH 1,1986
C
C VERSION 86.7
C
C !!! NOTE: ONLY USED FOR SHADOW/VMS !!!
C
C---
       	SUBROUTINE CONTOUR(X,Y,DATA,XYLIM,NX,NY,ICONT,Z,IPLOT)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif
C
     	EXTERNAL CALC
     	CHARACTER*80 TEXT
     	REAL NUMFAC,VALUE,TARR(3),TX(N_DIM),TY(N_DIM),TEMP(2,2)
     	REAL DMAX,DMIN,DEL,X(NX),Y(NY),DATA(NX*NY),Z(20),XYLIM(4)
     	REAL INPUT(3,100000),CNTOUR(3,N_DIM),CONARR(3,N_DIM),CONVAL(20)
     	REAL DELX,DELY,DELR,TDELX,TDELY,TDELR
     	INTEGER NCV,NUMCV,NUMDAT,NX,NY,WANT,TRIAL,LEVEL,OUTDV,ITERM
     	INTEGER TPTR,BOTPTR,PTR,RUNPTR,TYPE,ICONT(10),IPLOT(10),IPTR(4)
     	INTEGER N,M,I,J,K,TUSED(4),USED(4),NUMHIT,N1,N2,N3,N4
	CHARACTER*20 FILEOUT
	INTEGER CHECKCV(20),ICON
C
C READ IN DATA
C
     	NUMDAT = NX*NY
     	IF (NUMDAT .GT. 100000) THEN
     	  WRITE(6,*) ' ERROR:CONTOUR: '
     	  WRITE(6,*) ' ***** INPUT DATA MORE THAN 100,000 *****'
     	  GOTO 999
     	END IF
     	DO 1001 I = 1,NY
     	  DO 1002 J = 1,NX
     	    K = (I - 1)*NX + J
     	    INPUT(1,K) = X(J)
     	    INPUT(2,K) = Y(I)
     	    INPUT(3,K) = DATA(K)
1002	  CONTINUE
1001	CONTINUE
     	DELX = X(1) - X(2)
     	DELY = Y(1) - Y(2)
     	DELR = DELX**2 + DELY**2
     	NUMCV = ICONT(1)
     	WANT  = ICONT(2)
#ifdef vms
     	OUTDV = ICONT(3)
#else
	OUTDV = 35
#endif
	ITERM = ICONT(4)
     	LEVEL = IPLOT(2)
     	IF (NUMCV .EQ. 0) THEN
     	  NUMCV = 10
     	  DMAX = DATA(1)
     	  DMIN = DATA(1)
     	  DO 1003 I = 1,NUMDAT
     	    IF (DMAX .LT. DATA(I)) THEN
     	      DMAX = DATA(I)
     	    ELSE IF (DMIN .GT. DATA(I)) THEN
     	      DMIN = DATA(I)
     	    END IF
1003	  CONTINUE
     	  DEL = (DMAX - DMIN)/(NUMCV + 1)
     	  DO 1004 I = 1,NUMCV
     	    Z(I) = DMIN + DEL*I
1004	  CONTINUE
     	END IF
     	DO 1055 I = 1,NUMCV
     	  CONVAL(I) = Z(I)
	  CHECKCV(I) = 0
1055 	CONTINUE
C
C SET THE LIMITS AND THE LABELS ON AXES
C
#ifdef vms
     	WRITE(TEXT,505) XYLIM(1),XYLIM(2),XYLIM(3),XYLIM(4)
 505	FORMAT ('SET LIMIT X ',2E12.4,' Y ',2E12.4,' ; ')
     	CALL TDSET(%REF(TEXT))
	IF (IPLOT(3) .EQ. 0) THEN
	  TEXT	= 'LABELS ALL OFF ;'
	ELSE
	  TEXT	= 'LABELS BOTTOM ON LEFT ON ;'
	END IF
	CALL TDSET(%REF(TEXT))
	IF (IPLOT(1) .EQ. 1) THEN
     	  WRITE(OUTDV,*) 'SET LIMIT X ',XYLIM(1),' ',XYLIM(2)
	  WRITE(OUTDV,*) 'SET LIMIT Y ',XYLIM(3),' ',XYLIM(4)
	  IF (IPLOT(3) .EQ. 0) THEN
	    TEXT = 'LABELS ALL OFF '
	  ELSE
	    TEXT = 'LABELS BOTTOM ON LEFT ON '
	  END IF
	  WRITE(OUTDV,*) TEXT
	END IF
#else
	WRITE(OUTDV,2001) XYLIM(1),XYLIM(2),XYLIM(3),XYLIM(4)	
2001	FORMAT ('xyrange(',F15.8,',',F15.8,',',F15.8,',',F15.8,')')
	IF (IPLOT(3).EQ.0) THEN
	  WRITE(OUTDV,*) 'box("bcst",0,0,"bcst",0,0)'
	ELSE
	  WRITE(OUTDV,*) 'box("bcnst",0,0,"bcnstv",0,0)'
	ENDIF
#endif

C
C GENERATE DATA POINT FOR EACH CONTOUR VALUE
C
     	DO 1005 NCV = 1,NUMCV
     	  VALUE = CONVAL(NCV)
     	  INDEX = 1
     	  DO 1006 I = 1,NY
     	    DO 1007 J = 1,NX
     	      P2 = (I-1)*NX+J+1
     	      P1 = (I-1)*NX+J
     	      Z2 = INPUT(3,P2)
     	      Z1 = INPUT(3,P1)
     	      IF (Z1 .EQ. VALUE) THEN
     		CONARR(1,INDEX) = INPUT(1,P1)
     		CONARR(2,INDEX) = INPUT(2,P1)
     		CONARR(3,INDEX) = 0.0
     		INDEX = INDEX + 1
     	      ELSE IF((J.NE.NX).AND.((Z1.LT.VALUE).AND.(VALUE.LT.Z2)))
     *		   THEN
     		X2 = INPUT(1,P2)
     		X1 = INPUT(1,P1)
     		CONARR(1,INDEX) = CALC(X1,X2,Z1,Z2,VALUE)
     		CONARR(2,INDEX) = INPUT(2,P1)
     		CONARR(3,INDEX) = 0.0
     		INDEX = INDEX + 1
     	      ELSE IF((J.NE.NX).AND.((Z1.GT.VALUE).AND.(VALUE.GT.Z2)))
     *		   THEN
     		X2 = INPUT(1,P2)
     		X1 = INPUT(1,P1)
     		CONARR(1,INDEX) = CALC(X1,X2,Z1,Z2,VALUE)
     		CONARR(2,INDEX) = INPUT(2,P1)
     		CONARR(3,INDEX) = 0.0
     		INDEX = INDEX + 1
     	      END IF
1007	    CONTINUE
     	    DO 1008 J = 1,NX
     	      P2 = I*NX+J
     	      P1 = (I-1)*NX+J
     	      Z2 = INPUT(3,P2)
     	      Z1 = INPUT(3,P1)
     	      IF ((I.NE.NY).AND.((Z1.LT.VALUE).AND.(VALUE.LT.Z2)))THEN
     		Y2 = INPUT(2,P2)
     		Y1 = INPUT(2,P1)
     		CONARR(1,INDEX) = INPUT(1,P1)
     		CONARR(2,INDEX) = CALC(Y1,Y2,Z1,Z2,VALUE)
     		CONARR(3,INDEX) = 0.0
     		INDEX = INDEX + 1
     	      ELSE IF((I.NE.NY).AND.((Z1.GT.VALUE).AND.(VALUE.GT.Z2)))
     *		   THEN
     		Y2 = INPUT(2,P2)
     		Y1 = INPUT(2,P1)
     		CONARR(1,INDEX) = INPUT(1,P1)
     		CONARR(2,INDEX) = CALC(Y1,Y2,Z1,Z2,VALUE)
     		CONARR(3,INDEX) = 0.0
     		INDEX = INDEX + 1
     	      END IF
1008	    CONTINUE
1006	  CONTINUE
C
C PUT ALL THE BOUNDARY POINTS TO THE TOP OF THE LIST (CONARR)
C
     	  BOTPTR = INDEX - 1
 10       DO 1009 PTR = 1,BOTPTR
     	    IF (CONARR(1,PTR) .EQ. INPUT(1,1)) THEN
     	      TARR(1) = CONARR(1,PTR)
     	      TARR(2) = CONARR(2,PTR)
     	      TARR(3) = CONARR(3,PTR)
     	      DO 1010 TPTR = PTR,2,-1
     	        CONARR(1,TPTR) = CONARR(1,TPTR-1)
     		CONARR(2,TPTR) = CONARR(2,TPTR-1)
     		CONARR(3,TPTR) = CONARR(3,TPTR-1)
1010	      CONTINUE
     	      CONARR(1,1) = TARR(1)
     	      CONARR(2,1) = TARR(2)
     	      CONARR(3,1) = TARR(3)
     	    END IF
1009	  CONTINUE
 20       DO 1011 PTR = 1,BOTPTR
     	    IF (CONARR(2,PTR) .EQ. INPUT(2,NX*NY)) THEN
     	      TARR(1) = CONARR(1,PTR)
     	      TARR(2) = CONARR(2,PTR)
     	      TARR(3) = CONARR(3,PTR)
     	      DO 1012 TPTR = PTR,2,-1
     	        CONARR(1,TPTR) = CONARR(1,TPTR-1)
     		CONARR(2,TPTR) = CONARR(2,TPTR-1)
     		CONARR(3,TPTR) = CONARR(3,TPTR-1)
1012	      CONTINUE
     	      CONARR(1,1) = TARR(1)
     	      CONARR(2,1) = TARR(2)
     	      CONARR(3,1) = TARR(3)
     	    END IF
1011	  CONTINUE
 30       DO 1013 PTR = 1,BOTPTR
     	    IF ((CONARR(1,PTR) .EQ. INPUT(1,NX)) .AND.
     * 	        (CONARR(2,PTR) .NE. INPUT(2,NX))) THEN 
     	      TARR(1) = CONARR(1,PTR)
     	      TARR(2) = CONARR(2,PTR)
     	      TARR(3) = CONARR(3,PTR)
     	      DO 1014 TPTR = PTR,2,-1
     	        CONARR(1,TPTR) = CONARR(1,TPTR-1)
     		CONARR(2,TPTR) = CONARR(2,TPTR-1)
     		CONARR(3,TPTR) = CONARR(3,TPTR-1)
1014	      CONTINUE
     	      CONARR(1,1) = TARR(1)
     	      CONARR(2,1) = TARR(2)
     	      CONARR(3,1) = TARR(3)
     	    END IF
1013	  CONTINUE
C+
C
C MAIN SECTION:
C TRACE OUT THE CONTOUR CURVE
C
C-
 	  INDEX = 1
 99       TYPE = 0
	  DO 1015 I = 1,INDEX-1
	    DO 1016 J = 1,3
	      CNTOUR(J,I) = 0.0
1016	    CONTINUE
1015	  CONTINUE
     	  DO 1017 I = 1,4
     	    TUSED(I) = 0
     	    USED(I) = 0
	    IPTR(I) = 0
1017	  CONTINUE
     	  INDEX = 1
C
C SEARCH FOR THE BEGINNING OF A CONTOUR CURVE
C
     	  DO 1018 PTR = 1,BOTPTR
     	    IF (CONARR(3,PTR) .EQ. 0.0) THEN
     	      IF (CONARR(1,PTR) .EQ. INPUT(1,1)) THEN
C
C LEFT BOUNDARY (4)
C
     		DO 1019 I = NY,2,-1
     		  IF (((INPUT(2,(I-1)*NX) .LT. CONARR(2,PTR)) .AND.
     *		       (CONARR(2,PTR) .LE. INPUT(2,I*NX))) .OR.
     *		      ((INPUT(2,(I-1)*NX) .GT. CONARR(2,PTR)) .AND.
     *		       (CONARR(2,PTR) .GE. INPUT(2,I*NX)))) THEN
     		    N = I - 1
     		    M = 1
     		    USED(2) = 1
     		    GOTO 111
     		  END IF
1019		CONTINUE
     	      ELSE IF (CONARR(2,PTR) .EQ. INPUT(2,1)) THEN
C 
C TOP BOUNDARY (1) 
C
     	 	DO 1020 J = 1,NX-1
     		  IF (((INPUT(1,J) .LE. CONARR(1,PTR)) .AND.
     *		       (CONARR(1,PTR) .LT. INPUT(1,J+1))) .OR.
     *		      ((INPUT(1,J) .GE. CONARR(1,PTR)) .AND.
     *		       (CONARR(1,PTR) .GT. INPUT(1,J+1)))) THEN
     		    N = 1
     		    M = J
     		    USED(3) = 1
     		    GOTO 111
     		  END IF
1020		CONTINUE
     	      ELSE IF (CONARR(1,PTR) .EQ. INPUT(1,NX)) THEN
C
C RIGHT BOUNDARY (2)
C
     		DO 1021 I = 1,NY-1
     		  IF (((INPUT(2,I*NX) .LE. CONARR(2,PTR)) .AND.
     *		       (CONARR(2,PTR) .LT. INPUT(2,(I+1)*NX))) .OR.
     *                ((INPUT(2,I*NX) .GE. CONARR(2,PTR)) .AND.
     *		       (CONARR(2,PTR) .GT. INPUT(2,(I+1)*NX)))) THEN
     		    N = I
     		    M = NX - 1
     		    USED(4) = 1
     		    GOTO 111
     		  END IF
1021		CONTINUE
     	      ELSE IF (CONARR(2,PTR) .EQ. INPUT(2,NX*NY)) THEN
C
C BOTTOM BOUNDARY (3)
C
     	        DO 1022 J = NX,2,-1
     		  IF (((INPUT(1,(NY-1)*NX+J-1) .LT. CONARR(1,PTR)) .AND.
     *		       (CONARR(1,PTR) .LE. INPUT(1,(NY-1)*NX+J))) .OR.
     *		      ((INPUT(1,(NY-1)*NX+J-1) .GT. CONARR(1,PTR)) .AND.
     *		       (CONARR(1,PTR) .GE. INPUT(1,(NY-1)*NX+J)))) THEN
     		    N = NY - 1
     		    M = J - 1
     		    USED(1) = 1
     		    GOTO 111
     	          END IF
1022		CONTINUE
     	      ELSE 
C 
C CENTER
C
     		DO 1023 I = 2,NY-1
     	          IF (CONARR(2,PTR) .EQ. INPUT(2,I*NX)) THEN
     	 	    DO 1024 J = 1,NX-1
     		      IF (((INPUT(1,(I-1)*NX+J) .LE. CONARR(1,PTR)).AND.
     *		         (CONARR(1,PTR) .LT. INPUT(1,(I-1)*NX+J+1))).OR.
     *	  	          ((INPUT(1,(I-1)*NX+J) .GE. CONARR(1,PTR)).AND.
     *		        (CONARR(1,PTR) .GT. INPUT(1,(I-1)*NX+J+1))))THEN
     		        N = I 
     		        M = J
     			USED(3) = 1
     		        GOTO 111
     		      END IF
1024		    CONTINUE
     		  END IF
1023		CONTINUE
     	      END IF
     	    END IF
1018	  CONTINUE
     	  GOTO 222
 111      CNTOUR(1,INDEX) = CONARR(1,PTR)
     	  CNTOUR(2,INDEX) = CONARR(2,PTR)
     	  CNTOUR(3,INDEX) = VALUE
     	  CONARR(3,PTR) = 1.0
     	  TYPE = 1
     	  INDEX = INDEX + 1
C
C SEARCH FOR SUBSEQUENT POINT
C
C FIRST TRIAL BEGINS HERE
C
 222	  TRIAL = 1
     	  DO 1025 I = 1,4
     	    TUSED(I) = USED(I)
     	    USED(I) = 0
	    IPTR(I) = 0
1025	  CONTINUE
C
C SECOND AND THIRD TRIAL BEGIN HERE
C
 333      N1 = (N-1)*NX+M
     	  N2 = N1+1
     	  N3 = N*NX+M+1
     	  N4 = N3-1
          DO 1026 RUNPTR = 1,BOTPTR
     	    IF (CONARR(3,RUNPTR) .EQ. 0.0) THEN
     	      IF ((((INPUT(1,N1) .LE. CONARR(1,RUNPTR)) .AND.
     *		    (CONARR(1,RUNPTR) .LT. INPUT(1,N2))) .OR.
     *		   ((INPUT(1,N1) .GE. CONARR(1,RUNPTR)) .AND.
     *		    (CONARR(1,RUNPTR) .GT. INPUT(1,N2)))) .AND.
     * 		    (INPUT(2,N1) .EQ. CONARR(2,RUNPTR))) THEN
C SIDE (1)
     		CNTOUR(1,INDEX) = CONARR(1,RUNPTR)
     		CNTOUR(2,INDEX) = CONARR(2,RUNPTR)
     		CNTOUR(3,INDEX) = VALUE
     		CONARR(3,RUNPTR) = 1.0
     		INDEX = INDEX + 1
     		USED(1) = 1
		IPTR(1) = RUNPTR
     	      ELSE IF ((((INPUT(2,N2) .LE. CONARR(2,RUNPTR)) .AND.
     *		         (CONARR(2,RUNPTR) .LT. INPUT(2,N3))) .OR.
     *                  ((INPUT(2,N2) .GE. CONARR(2,RUNPTR)) .AND.
     *		         (CONARR(2,RUNPTR) .GT. INPUT(2,N3)))) .AND.
     *		         (INPUT(1,N2) .EQ. CONARR(1,RUNPTR))) THEN
C SIDE (2)
     		CNTOUR(1,INDEX) = CONARR(1,RUNPTR)
     		CNTOUR(2,INDEX) = CONARR(2,RUNPTR)
     		CNTOUR(3,INDEX) = VALUE
     		CONARR(3,RUNPTR) = 1.0
     		INDEX = INDEX + 1
     		USED(2) = 1
		IPTR(2) = RUNPTR
     	      ELSE IF ((((INPUT(1,N4) .LT. CONARR(1,RUNPTR)) .AND.
     *		         (CONARR(1,RUNPTR) .LE. INPUT(1,N3))) .OR.
     *		        ((INPUT(1,N4) .GT. CONARR(1,RUNPTR)) .AND.
     *		         (CONARR(1,RUNPTR) .GE. INPUT(1,N3)))) .AND.
     *		         (INPUT(2,N3) .EQ. CONARR(2,RUNPTR))) THEN
C SIDE (3)
 		CNTOUR(1,INDEX) = CONARR(1,RUNPTR)
     		CNTOUR(2,INDEX) = CONARR(2,RUNPTR)
     		CNTOUR(3,INDEX) = VALUE
     		CONARR(3,RUNPTR) = 1.0
     		INDEX = INDEX + 1
     		USED(3) = 1
		IPTR(3) = RUNPTR
     	      ELSE IF ((((INPUT(2,N1) .LT. CONARR(2,RUNPTR)) .AND.
     *		         (CONARR(2,RUNPTR) .LE. INPUT(2,N4))) .OR.
     *		        ((INPUT(2,N1) .GT. CONARR(2,RUNPTR)) .AND.
     *		         (CONARR(2,RUNPTR) .GE. INPUT(2,N4)))) .AND. 
     *		         (INPUT(1,N4) .EQ. CONARR(1,RUNPTR))) THEN
C SIDE (4)
     		CNTOUR(1,INDEX) = CONARR(1,RUNPTR)
     		CNTOUR(2,INDEX) = CONARR(2,RUNPTR)
     		CNTOUR(3,INDEX) = VALUE
     		CONARR(3,RUNPTR) = 1.0
     		INDEX = INDEX + 1
     		USED(4) = 1
		IPTR(4) = RUNPTR
     	      END IF
     	    END IF
1026	  CONTINUE
C
C IF THREE POINTS IN A SQUARE, THEN WRITE THE ERROR MESSAGE.
C OTHERWISE, CONTINUE THE SEARCH.
C
C ROTATING SEQUENCES FOR DIFFERENT SIDES
C (1) N  ,M   (2) N  ,M   (3) N  ,M   (4) N  ,M
C     N-1,M       N  ,M+1     N+1,M       N  ,M-1
C     N-1,M-1     N-1,M+1     N+1,M+1     N+1,M-1
C     N  ,M-1     N-1,M       N  ,M+1     N+1,M
C
 444   	  NUMHIT = 0
 	  DO 1027 K = 1,4
     	    NUMHIT = NUMHIT + USED(K)
1027	  CONTINUE
     	  IF (NUMHIT .EQ. 0) THEN 
     	    TDELX = CNTOUR(1,INDEX-1) - CNTOUR(1,1)
     	    TDELY = CNTOUR(2,INDEX-1) - CNTOUR(2,1)
     	    TDELR = TDELX**2 + TDELY**2
     	    IF (TDELR .LE. DELR) THEN 
	      GOTO 888
	    ELSE IF (TRIAL .EQ. 1) THEN
C 
C SECOND TRIAL
C
     	      IF (TUSED(1) .EQ. 1) THEN
     	        M = M - 1
                TRIAL = TRIAL + 1
     	        GOTO 333
     	      ELSE IF (TUSED(2) .EQ. 1) THEN
     	        N = N - 1
     	        TRIAL = TRIAL + 1
     	        GOTO 333
     	      ELSE IF (TUSED(3) .EQ. 1) THEN
     	        M = M + 1
     	        TRIAL = TRIAL + 1
     	        GOTO 333
     	      ELSE IF (TUSED(4) .EQ. 1) THEN
     	        N = N + 1
     	        TRIAL = TRIAL + 1
     	        GOTO 333
     	      END IF
	    ELSE IF (TRIAL .EQ. 2) THEN
C
C THIRD TRIAL
C
	      IF (TUSED(1) .EQ. 1) THEN
	        N = N + 1
	        TRIAL = TRIAL + 1
	        GOTO 333
	      ELSE IF (TUSED(2) .EQ. 1) THEN
	        M = M - 1
	        TRIAL = TRIAL + 1
	        GOTO 333
	      ELSE IF (TUSED(3) .EQ. 1) THEN
	        N = N - 1
	        TRIAL = TRIAL + 1
	        GOTO 333
	      ELSE IF (TUSED(4) .EQ. 1) THEN
	        M = M + 1
 	        TRIAL = TRIAL + 1
	        GOTO 333
	      END IF
	    END IF
     	  ELSE IF (NUMHIT .EQ. 2) THEN
     	    TDELX = CNTOUR(1,INDEX-1) - CNTOUR(1,1)
     	    TDELY = CNTOUR(2,INDEX-1) - CNTOUR(2,1)
     	    TDELR = TDELX**2 + TDELY**2
     	    IF (TDELR .LE. DELR) THEN 
	      GOTO 888
	    ELSE
     	      WRITE(6,*) ' ERROR:CONTOUR: '
     	      WRITE(6,*) ' ***** THREE POINTS IN A SQUARE ! *****'
     	      WRITE(6,*) '      PLEASE ADJUST THE GRID SIZE' 
	      WRITE(6,*) '        TRIAL :',TRIAL
     	      GOTO 999
	    END IF
	  ELSE IF (NUMHIT .EQ. 3) THEN
	    IF (TUSED(1) .EQ. 1) THEN
	      IF (INPUT(3,N3) .GT. VALUE) THEN
		CNTOUR(1,INDEX-3) = CONARR(1,IPTR(2))
	        CNTOUR(2,INDEX-3) = CONARR(2,IPTR(2))
		CONARR(3,IPTR(1)) = 0.0
		CONARR(3,IPTR(4)) = 0.0
		USED(1) = 0
		USED(4) = 0
	      ELSE IF (INPUT(3,N4) .GE. VALUE) THEN
		CNTOUR(1,INDEX-3) = CONARR(1,IPTR(4))
		CNTOUR(2,INDEX-3) = CONARR(2,IPTR(4))
		CONARR(3,IPTR(1)) = 0.0
		CONARR(3,IPTR(2)) = 0.0
		USED(1) = 0
		USED(2) = 0
	      END IF
	    ELSE IF (TUSED(2) .EQ. 1) THEN
	      IF (INPUT(3,N4) .GT. VALUE) THEN
		CNTOUR(1,INDEX-3) = CONARR(1,IPTR(3))
	        CNTOUR(2,INDEX-3) = CONARR(2,IPTR(3))
		CONARR(3,IPTR(1)) = 0.0
		CONARR(3,IPTR(2)) = 0.0
	        USED(1) = 0
		USED(2) = 0
	      ELSE IF (INPUT(3,N1) .GE. VALUE) THEN
		CNTOUR(1,INDEX-3) = CONARR(1,IPTR(1))
		CNTOUR(2,INDEX-3) = CONARR(2,IPTR(1))
		CONARR(3,IPTR(2)) = 0.0
		CONARR(3,IPTR(3)) = 0.0
		USED(2) = 0
		USED(3) = 0
	      END IF
	    ELSE IF (TUSED(3) .EQ. 1) THEN
	      IF (INPUT(3,N1) .GT. VALUE) THEN
		CNTOUR(1,INDEX-3) = CONARR(1,IPTR(4))
	        CNTOUR(2,INDEX-3) = CONARR(2,IPTR(4))
		CONARR(3,IPTR(2)) = 0.0
		CONARR(3,IPTR(3)) = 0.0
		USED(2) = 0
		USED(3) = 0
	      ELSE IF (INPUT(3,N2) .GE. VALUE) THEN
		CNTOUR(1,INDEX-3) = CONARR(1,IPTR(2))
		CNTOUR(2,INDEX-3) = CONARR(2,IPTR(2))
		CONARR(3,IPTR(3)) = 0.0	
		CONARR(3,IPTR(4)) = 0.0
		USED(3) = 0
		USED(4) = 0
	      END IF
	    ELSE IF (TUSED(4) .EQ. 1) THEN
	      IF (INPUT(3,N2) .GT. VALUE) THEN
		CNTOUR(1,INDEX-3) = CONARR(1,IPTR(1))
		CNTOUR(2,INDEX-3) = CONARR(2,IPTR(1))
		CONARR(3,IPTR(3)) = 0.0
		CONARR(3,IPTR(4)) = 0.0
		USED(3) = 0
		USED(4) = 0
	      ELSE IF (INPUT(3,N3) .GE. VALUE) THEN
		CNTOUR(1,INDEX-3) = CONARR(1,IPTR(3))
	        CNTOUR(2,INDEX-3) = CONARR(2,IPTR(3))
		CONARR(3,IPTR(1)) = 0.0
		CONARR(3,IPTR(4)) = 0.0
		USED(1) = 0
		USED(4) = 0
	      END IF
	    END IF
 	    DO 1028 II = 1,2
	      DO 1029 JJ = 1,3
	        CNTOUR(JJ,INDEX-II) = 0
1029	      CONTINUE
1028	    CONTINUE
	    INDEX = INDEX - 2
	    GOTO 444
C 
C IF THE SEARCHED POINT IS A BOUNDARY POINT,
C THEN END THE SEARCH AND START A NEW SEARCH.
C OTHERWISE, KEEP ON SEARCHING
C
	  ELSE IF (NUMHIT .EQ. 1) THEN
   	    IF (USED(1) .EQ. 1) THEN
C SIDE (1)
     	      IF (CNTOUR(2,INDEX-1) .EQ. INPUT(2,1)) THEN
     	        TYPE = 2
     	        GOTO 888
     	      ELSE 
     	        N = N - 1
     	        M = M
     	        GOTO 222
     	      END IF
     	    ELSE IF (USED(2) .EQ. 1) THEN
C SIDE (2)
     	      IF (CNTOUR(1,INDEX-1) .EQ. INPUT(1,NX)) THEN
     	        TYPE = 2
     	        GOTO 888
     	      ELSE 
     	        N = N
     	        M = M + 1
     	        GOTO 222
     	      END IF
     	    ELSE IF (USED(3) .EQ. 1) THEN
C SIDE(3)
     	      IF (CNTOUR(2,INDEX-1) .EQ. INPUT(2,NX*NY)) THEN
     	        TYPE = 2
     	        GOTO 888
     	      ELSE 
     	        N = N + 1
     	        M = M
     	        GOTO 222
     	      END IF
     	    ELSE IF (USED(4) .EQ. 1) THEN
C SIDE(4)
     	      IF (CNTOUR(1,INDEX-1) .EQ. INPUT(1,1)) THEN
     	        TYPE = 2
     	        GOTO 888
     	      ELSE
     	        N = N
     	        M = M - 1
     	        GOTO 222
     	      END IF
	    END IF
     	  END IF
C
C WRITE THE DATA FOR EACH CONTOUR CURVE
C
 888	  IF ((TYPE .EQ. 2) .AND. (WANT .EQ. 0)) THEN
     	    DO 1030 J = 1,INDEX-1
   	      TX(J) = CNTOUR(1,J)
     	      TY(J) = CNTOUR(2,J)
1030 	    CONTINUE
#ifdef vms
	    IF (ITERM.EQ.3)	CALL	SET_COLOR (NCV)
     	    CALL TDJOIN(INDEX-1,TX,TY,0,0,LEVEL)
#else
	    IF (CHECKCV(NCV).EQ.0) THEN
	      ICON = 100*NCV + CHECKCV(NCV)
	      CHECKCV(NCV) = 1
	    ELSE IF (CHECKCV(NCV).NE.0) THEN
	      ICON = 100*NCV + CHECKCV(NCV)
	      CHECKCV(NCV) = CHECKCV(NCV) + 1
	    END IF
	    CALL FNAME(FILEOUT,'con',ICON,4)
	    OPEN(36,FILE=FILEOUT,STATUS='UNKNOWN')
	    DO 1050 J =1,INDEX-1
	      WRITE(36,*) TX(J),TY(J)
1050	    CONTINUE
	    CLOSE(36)
	    WRITE(35,*) 'color(',NCV,')'
	    WRITE(35,2005) FILEOUT
2005	    FORMAT('plotl("',A8,'")')
#endif
     	    IF (IPLOT(1) .EQ. 1) THEN
     	      DO 1031 J = 1,INDEX-1
     	        WRITE (OUTDV,*) (CNTOUR(I,J) ,I=1,3)
1031	      CONTINUE
     	      WRITE (OUTDV,*) ' JOIN ',LEVEL
    	    END IF
     	    GOTO 99
     	  ELSE IF ((TYPE .EQ. 1) .AND. (WANT .EQ. 0))THEN 
     	    TDELX = CNTOUR(1,INDEX-1) - CNTOUR(1,1)
     	    TDELY = CNTOUR(2,INDEX-1) - CNTOUR(2,1)
     	    TDELR = TDELX**2 + TDELY**2
     	    IF (TDELR .LE. DELR) THEN
     	      CNTOUR(1,INDEX) = CNTOUR(1,1)
              CNTOUR(2,INDEX) = CNTOUR(2,1)
     	      CNTOUR(3,INDEX) = CNTOUR(3,1)
     	      INDEX = INDEX + 1
     	    END IF
     	    DO 1032 J = 1,INDEX-1
   	      TX(J) = CNTOUR(1,J)
     	      TY(J) = CNTOUR(2,J)
1032 	    CONTINUE
#ifdef vms
	    IF (ITERM.EQ.3)	CALL	SET_COLOR (NCV)
     	    CALL TDJOIN(INDEX-1,TX,TY,0,0,LEVEL)
#else
	    IF (CHECKCV(NCV).EQ.0) THEN
	      ICON = 100*NCV + CHECKCV(NCV)
	      CHECKCV(NCV) = 1
	    ELSE IF (CHECKCV(NCV).NE.0) THEN
	      ICON = 100*NCV + CHECKCV(NCV)
	      CHECKCV(NCV) = CHECKCV(NCV) + 1
	    END IF
	    CALL FNAME(FILEOUT,'con',ICON,4)
	    OPEN(36,FILE=FILEOUT,STATUS='UNKNOWN')
	    DO 1051 J = 1,INDEX-1
	      WRITE(36,*) TX(J),TY(J)
1051	    CONTINUE
	    CLOSE(36)
	    WRITE(35,*) 'color(',NCV,')'
	    WRITE(35,2005) FILEOUT
#endif
     	    IF (IPLOT(1) .EQ. 1) THEN
     	      DO 1033 J = 1,INDEX-1
     	        WRITE (OUTDV,*) (CNTOUR(I,J) ,I=1,3)
1033	      CONTINUE
     	      WRITE (OUTDV,*) ' JOIN ',LEVEL
     	    END IF
     	    GOTO 99
     	  ELSE IF ((TYPE .EQ. 2) .AND. (WANT .EQ. 1)) THEN
     	    DO 1034 J = 1,INDEX-1
     	      TX(J) = CNTOUR(1,J)
     	      TY(J) = CNTOUR(2,J)
1034	    CONTINUE
     	    N = (INDEX-1)/2.0 + 0.5
#ifdef vms
     	    CALL TDTSET(1.5,0,0,1)
     	    WRITE(TEXT,303) NCV
 303	    FORMAT (I2,';')
	    IF (ITERM.EQ.3)	CALL	SET_COLOR (NCV)
     	    CALL TDTITL(%REF(TEXT),TX(N),TY(N))
     	    CALL TDJOIN(INDEX-1,TX,TY,0,0,LEVEL)
#else
	    IF (CHECKCV(NCV).EQ.0) THEN
	      ICON = 100*NCV + CHECKCV(NCV)
	      CHECKCV(NCV) = 1
	    ELSE IF (CHECKCV(NCV).NE.0) THEN
	      ICON = 100*NCV + CHECKCV(NCV)
	      CHECKCV(NCV) = CHECKCV(NCV) + 1
	    END IF
	    CALL FNAME(FILEOUT,'con',ICON,4)
	    OPEN(36,FILE=FILEOUT,STATUS='UNKNOWN')
	    DO 1052 J = 1,INDEX-1
	      WRITE(36,*) TX(J),TY(J)
1052	    CONTINUE
	    CLOSE(36)
	    WRITE(35,*) 'color(',NCV,')'
	    WRITE(35,2005) FILEOUT
	    WRITE(OUTDV,2002) TX(N),TY(N),NCV
2002	    FORMAT('gtext(',F15.8,',',F15.8,',0,0,0,"',I2,'")')
#endif
     	    IF (IPLOT(1) .EQ. 1) THEN
     	      DO 1035 J = 1,INDEX-1
     	        WRITE (OUTDV,*) (CNTOUR(I,J) ,I=1,3)
1035	      CONTINUE
     	      WRITE (OUTDV,*) ' JOIN ',LEVEL
     	      N = (INDEX-1)/2.0 + 0.5
     	      WRITE (TEXT,101) NCV
 101	      FORMAT ('''',I2,'''')
     	      WRITE (OUTDV,*) 'TITLE',CNTOUR(1,N),CNTOUR(2,N),' DATA ',
     *	  		    TEXT(1:4),' SIZE 1.5 '
       	    END IF
	    GO TO 99
     	  ELSE IF ((TYPE .EQ. 1) .AND. (WANT .EQ. 1)) THEN
     	    TDELX = CNTOUR(1,INDEX-1) - CNTOUR(1,1)
     	    TDELY = CNTOUR(2,INDEX-1) - CNTOUR(2,1)
     	    TDELR = TDELX**2 + TDELY**2
     	    IF (TDELR .LE. DELR) THEN
     	      CNTOUR(1,INDEX) = CNTOUR(1,1)
              CNTOUR(2,INDEX) = CNTOUR(2,1)
     	      CNTOUR(3,INDEX) = CNTOUR(3,1)
     	      INDEX = INDEX + 1
     	    END IF
     	    DO 1036 J = 1,INDEX-1
     	      TX(J) = CNTOUR(1,J)
     	      TY(J) = CNTOUR(2,J)
1036	    CONTINUE
     	    N = (INDEX-1)/2.0 + 0.5
#ifdef vms
     	    CALL TDTSET(1.5,0,0,1)
     	    WRITE(TEXT,404) NCV
 404	    FORMAT (I2,';')
	    IF(ITERM.EQ.3)	CALL	SET_COLOR (NCV)
     	    CALL TDTITL(%REF(TEXT),TX(N),TY(N))
     	    CALL TDJOIN(INDEX-1,TX,TY,0,0,LEVEL)
#else
	    IF (CHECKCV(NCV).EQ.0) THEN
	      ICON = 100*NCV + CHECKCV(NCV)
	      CHECKCV(NCV) = 1
	    ELSE IF (CHECKCV(NCV).NE.0) THEN
	      ICON = 100*NCV + CHECKCV(NCV)
	      CHECKCV(NCV) = CHECKCV(NCV) + 1
	    END IF
	    CALL FNAME(FILEOUT,'con',ICON,4)
	    OPEN(36,FILE=FILEOUT,STATUS='UNKNOWN')
	    DO 1053 J = 1,INDEX-1
	      WRITE(36,*) TX(J),TY(J)
1053	    CONTINUE
	    CLOSE(36)
	    WRITE(35,*) 'color(',NCV,')'
	    WRITE(35,2005) FILEOUT
	    WRITE(OUTDV,2003) TX(N),TY(N),NCV
2003	    FORMAT('gtext(',F15.8,',',F15.8,',0,0,0,"',I2,'")')
	    
#endif
     	    IF (IPLOT(1) .EQ. 1) THEN
     	      DO 1037 J = 1,INDEX-1
     	        WRITE (OUTDV,*) (CNTOUR(I,J) ,I=1,3)
1037	      CONTINUE
     	      WRITE (OUTDV,*) ' JOIN ',LEVEL
     	      N = (INDEX-1)/2.0 + 0.5
     	      WRITE (TEXT,202) NCV
 202	      FORMAT ('''',I2,'''')
     	      WRITE (OUTDV,*) 'TITLE',CNTOUR(1,N),CNTOUR(2,N),' DATA ',
     *			   TEXT(1:4),' SIZE 1.5 '
     	    END IF
	    GO TO 99
     	  END IF
1005	CONTINUE
#ifdef vms
	IF (ITERM.EQ.3)	CALL	SET_COLOR (1)
#endif
 999	RETURN
     	END
C
C
C FUNCTION CALC:
C
C USE LINEAR INTERPOLATION TO APPROXIMATE
C FOR THE LOCATION OF CONTOUR CURVE.
C
C
     	REAL FUNCTION CALC(X1,X2,Z1,Z2,DEL)
     	REAL X1,X2,Z1,Z2,DEL,SLOPE
     	IF (Z2 .EQ. DEL) THEN
     	  CALC = X2
     	ELSE
     	  SLOPE = (Z1 - Z2)/(X1 - X2)
     	  CALC = X2 + (DEL - Z2)/SLOPE
     	END IF
     	RETURN
     	END
