C+++
C	With revised algorithm for interpolate and Getcoords.
C
C
C---
C  	PROGRAM MAIN
C	implicit none
C	real ran
C	real*8 dx,dy
C	real x,y
C	integer seed
C	integer i, ierr

C        seed = 123
C	call spgs_init('test.dat')
C	open(file = 'test.out',status = 'unknown',unit = 10)
C	do 100 i = 1,10000
C	    x = ran(seed)
C	    y = ran(seed)
C	    dx = x
C	    dy = y
C	    call generate(dx,dy,ierr)
C	    write(10,*) dx,dy
C100     continue
C        close(unit = 10)
C	call exit
C	end



C+++
C
C     spgs_init - reads info from a file and initializes the stochastic
C     process generator with it.
C
C---
        subroutine spgs_init(infilename)
	implicit none
	character*(*) infilename
	real*8 c1(150),c2(150,150)
	real*8 p1(150),p2(150,150)
	real*8 s0,s1(150),s2(150,150)
	real*8 xoffset,yoffset
	integer nx,ny

	common /spgs_info/ nx,ny,xoffset,yoffset,c1,c2,p1,p2,s0,s1,s2

	call readarray(infilename,nx,ny,c1,c2,p2,xoffset,yoffset)
	call accumulate(nx,ny,c1,c2,p1,p2,s0,s1,s2)
	return
	end



	
C+++
C
C       subroutine readarray - reads a two dimensional array
C       from a file and stores the values in a format the
C       stochastic process generator can accept.
C
C---
	subroutine readarray(fname,nx,ny,c1,c2,p2,xoffset,yoffset)
	implicit none
	integer nx,ny
	integer x,y
	real*8 c1(150),c2(150,150)
	real*8 p2(150,150)
	real*8 xstart,ystart
	real*8 xstep, ystep
	real*8 xoffset,yoffset
	character*(*) fname

	open(unit=10,file = fname,status = 'unknown')
	read(10,*) nx
	read(10,*) xstart
	read(10,*) xstep
	read(10,*) ny
	read(10,*) ystart
	read(10,*) ystep
	xoffset = xstart
	yoffset = ystart
	do 100 y = 1,ny
	    do 200 x = 1,nx
		read(10,*) p2(y,x)
		c1(x) = (x-1) * xstep
		c2(y,x) = (y-1) * ystep 
200         continue
100     continue
	close(unit= 10)
	return
	end



C+++
C
C       A two dimentional, linear integrating, parabolic interpolating
C       version of the stochastic process generator.
C
C	C's are coordinate arrays, P's are probability, S's are
C	CDF's
C
C+++
    	SUBROUTINE Accumulate ( nx, ny, C1, C2, P1, P2,
     $				 S0, S1, S2 )
	implicit none

     	REAL*8 C1(150), C2(150,150), P1(150), P2(150,150)
     	REAL*8 S0, S1(150), S2(150,150)
     	INTEGER X, Y, nx, ny
     	DO 100 X = 1, nx
     		DO 110 Y = 1,ny
     			CALL Integrate2(X,Y,C2,P2,S2)
110		CONTINUE
     		P1(X) = S2(ny, X)
100	CONTINUE
     	DO 120 X = 1,nx
     		CALL Integrate1(X,C1,P1,S1)
120	CONTINUE
     	S0 = S1(nx)
     	RETURN
     	END

C+++
C
C
C---
     	SUBROUTINE Integrate2(X,Y,C2,P2,S2)
	implicit none
C
C
     	REAL*8 C2(150,150), P2(150,150)
     	REAL*8 S2(150,150)
     	INTEGER X, Y
C
     	IF ( Y .eq. 1 ) THEN
     		S2(Y,X) = 0
     	ELSE
		S2(Y,X) = S2(Y-1,X) + (C2(Y,X)-C2(Y-1,X))*(P2(Y,X) + 
     $		P2(Y-1,X))/2
      	ENDIF
     	C2(Y,X) = C2(Y,X)
      	RETURN
     	END
     	   

C+++
C
C
C---
     	SUBROUTINE  Integrate1(X,C1,P1,S1)
	implicit none
C
C
     	INTEGER X
     	REAL*8 C1(150), P1(150), S1(150)
C
     	If (X .eq. 1) THEN 
     		S1(X) = 0
     	ELSE
     		S1(X) = S1(X-1) +  (C1(X) - C1(X-1))*(P1(X) + 
     $		P1(X-1))/2
     	ENDIF
     	RETURN
     	END
 
C+++
C
C	Generate.
C
C       take a pair of values xand y, which are initialized to 
C       random variables on input, and use a cdf to map them
C       into the domain space of the pdf supplied to the program.
C
C
C---
     	SUBROUTINE Generate (x,y,ierr )
	implicit none
     	real*8 C1(150), C2(150,150), S0, S1(150), S2(150,150),
     $	Vin(2), Vout(2), C2Temp(150), P2Temp(150), S2Temp(150)
	real*8 p1(150),p2(150,150)
	integer nx,ny
	integer xless,yless
	integer ierr
	real*8 x,y
	real*8 xoffset,yoffset
	common /spgs_info/ nx,ny,xoffset,yoffset,c1,c2,p1,p2,s0,s1,s2
C
        vin(1) = x
	vin(2) = y
       	CALL Locate1(nx, C1, P1, S0, S1, Vin(1) , Vout(1), Xless) 
       	CALL Interpolate1(ny, Vout, Xless, C1, C2, P1, P2, S1, S2,
     $		C2Temp, P2Temp, S2Temp )
     	CALL Locate1(ny, C2Temp, P2Temp, S2Temp(ny), S2Temp,
     $		 Vin(2), Vout(2), Yless)
	x = vout(1) + xoffset
	y = vout(2) + yoffset
	ierr = 0
     	RETURN
     	END

C+++
C
C	Locate1, scans a line in the first dimension, looking
C		for the intersection of Vin and  s1(x1) (x1 is
C		is a space coordinate)
C
C		This is a parabolic interpolation algorithm
C
C---
     	SUBROUTINE Locate1(Xmax, C1, P1, S0, S1, Vin, Vout, Nless)
	implicit none
C
C	NOTE: Vin is only a real number here, not an array, same with
C		Vout
C
     	INTEGER Xmax, Nless, Above, Below
     	REAL*8 S0, S1(42), C1(42), P1(42), Vin, Vout
	real*8 a,b,c

     	Vin = Vin * S0
     	IF ( Vin .lt. 0) THEN
     		Vin = 0
     	ENDIF
      	Below = 1
     	Above = Xmax
100    	IF (Below .ne. Above) THEN
     		IF (Vin .lt. S0/2) THEN
     			IF (S1(Below + 1) .le. Vin) THEN 
     				Below = Below + 1
     				GOTO 100
     			ELSE IF (S1(Above - 1) .ge. Vin) THEN
     				Above = Above - 1
     				GOTO 100
     			ENDIF
     		ELSE
     			IF (S1(Above - 1) .ge. Vin) THEN
     				Above = Above - 1
     				GOTO 100
     		 	ELSE IF (S1(Below + 1) .le. Vin) THEN 
     				Below = Below + 1
     				GOTO 100
     			ENDIF
     		ENDIF	 
     	ENDIF
     	IF (Above .eq. Below) THEN 
     		Vout = C1(Below)
     	ELSE IF (abs(C1(above) - C1(below)).gt. 1e-28 ) then
     		A = 0.5 * ( P1(above) - P1(below))/(C1(above) -
     $          C1(below) )
		B = (P1(below) * C1(above) - P1(above) * C1(below))/
     $		(C1(above) - C1(below) )
    		C = -1.0 *( A * C1(below) * C1(below) + B * C1(below))  
  	  	IF (Abs(P1(above) - P1(below)) .gt. 1e-28 ) then
			Vout = ((-1.0 * B ) + sqrt(B**2 - (4.0* A * 
     $ 			( C + S1(Below) - Vin ))))/( 2* A)
     		ELSE
     			Vout = 2.0 * ( Vin - S1(Below))/(P1(above) - P1(below))
     $			+ C1(below)
     		ENDIF
	else 
		Vout = C1(below)
     	ENDIF
     	Nless = Below
     	IF ((vout .gt. c1(above)) .or. (vout .lt. c1(below))) THEN
c      		WRITE (6,*) 'LF', C1(Below), Vout, C1(above), P1(below),
c     $		P1(above)
		write(6,*) a,b,c, vout
     	ENDIF
     	RETURN
     	END

     	 

     	 
C+++
C
C	Interpolate1
C
C	someday all these will be one routine, but no they are
C	separate for ease of codification.
C	This will take a point between C1(X) and C1(X+1) and generate 
C	a CDF that is the interpolation of the two adjacent CDF's
C	at the point specified.
C
C---
 	SUBROUTINE Interpolate1(Ymax, Vout, Xless, C1, C2, P1, P2, S1,
     $				 S2, C2Temp, P2Temp, S2Temp)
	implicit none
        Real*8 Vout(2), C1(150), C2(150,150), S1(150)
	real*8 S2(150,150), P1(150),
     $			P2(150,150),
     $			C2Temp(150), S2Temp(150), P2Temp(150)
     	INTEGER Ymax, Xless, Tab     	
	real*8 separation
	real*8 delta

C
C	Note: this routine will have to be changed if the C's are ever
C	shifted from the equal probability lines.
C

     	DO 150 Tab = 1,Ymax
     		Separation = C1(XLess + 1) - C1(XLess)
     		Delta = Vout(1) - C1(XLess)
     		C2Temp(Tab) = C2(Tab, Xless) + ( C2(Tab, XLess + 1 )  
     $		- C2(Tab, XLess)) * ( Delta / Separation)
     		S2Temp(Tab) = S2(Tab, XLess) + ( S2(Tab, XLess + 1 )
     $		- S2(Tab, XLess)) * ( Delta / Separation)
     		P2Temp(Tab) = P2(Tab, XLess) + ( P2(Tab, XLess + 1 )
     $		- P2(Tab, XLess)) * ( Delta / Separation) 
150	CONTINUE
     	RETURN
     	END

     		

