	subroutine read_synonyms (filename)
	implicit integer (a-z)
c++
c	subroutine read_synonyms (filename)
c
c  Synonyms give symbolic names to numbers
c  For example the variable MIRROR_SHAPE might have 
c     PLANE=1 ELLIPSE=2 TOROID=3
c
c  The current implementation uses a linear list of variable names,
c    synonyms, and values.  In the future it should be speeded up
c    using a hash or binary tree technique
c
c--
#if defined(unix) || HAVE_F77_CPP
#	include "parms.inc"
#	include "syn.inc"
#	include "io.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'syn.inc'
	include 'io.inc'
#endif
c
c  temporary variables to contain the data read in
c   
	character*80	     data
	character*(l_name)   name
	character*(l_symbol) symbol
c
c  check entire file for conversion errors before aborting
c    conv_error counts number of errors
c
	conv_error=0
c
c  count the records for error messages (record)
c  count the number of records stored (n_syn)
c
	n_syn=0
	record=0
c
c  read another record from file
c  check that it contains only printing characters
c
 100	record=record+1
	read (menu_unit,1000,end=150) data
 1000	format (a)
	if (data(1:1) .eq. ' ' .or. data(1:1) .eq. '*') goto 100
	if (data(1:1) .eq. '=') goto 300
	call verify (data,code)
	if (code .lt. 0) then
	  write (message,1030) record
	  call warning 
	  conv_error=conv_error+1
	  goto 100
	endif
c
c  now decode record
c
	read (data,1005,err=200) name,symbol,value
 1005	format (a16,a16,i2)
c
c  translate to upper case 
c
	call upcase (name)
	call upcase (symbol)

c
c  only positive numbers allowed for value
c 
	if (value .lt. 0) then
	  write (message,1025) record,name
	  call warning 
	  conv_error=conv_error+1
	  goto 100
	endif
c
c is there rooom in the arrays for the data
c
	if (n_syn .lt. max_syn) then
	  n_syn=n_syn+1
	  syn_name(n_syn)=name
	  syn_symbol(n_syn)=symbol
	  syn_value(n_syn)=value
	else
	  write (message,1010) n_syn
	  call fatal 
	endif
	goto 100
c
c  end-of-file
c
 150	write (message,1035) record
	call fatal 
c
c  conversion error
c
 200	conv_error=conv_error+1
	write (message,1015) record,name,symbol
	call warning 
	goto 100
c
c  check for any conversion errors before exit
c
 300	if (conv_error .ne. 0) then
	  write (message,1020) 
	  call fatal 
	endif
c
 999	return
c
 1010	format ('READ_SYNONYMS: Too many synonym definitions - ',
     *		'Can''t handle more than ',i4)
 1015	format ('READ_SYNONYMS: Error reading record ',i4,
     *		' of the Synonym file - ',
     *		' Name is "',a,'" Symbol is "',a,'"')
 1020	format ('READ_SYNONYMS: One or more errors reading Synonym file')
 1025	format ('READ_SYNONYMS: Error reading record ',i4,
     *		' of the Synonym file ',
     *		'Name is "',a,'" - value must not be negative')
 1030	format ('READ_SYNONYMS: Record ',i4,' contains non-printing ',
     *		'characters (tabs, formfeeds, etc. are illegal)')
 1035	format ('READ_SYNONYMS: Unexpected end-of-file - expected "$"')
	end

	subroutine translate_synonym (name,symbol,value,full_symbol)
	implicit integer (a-z)
c++
c
c	subroutine translate_synonym (name,symbol,value,full_symbol)
c
c  Try to find an entry in the synonym table which has an exact match
c  to the name and is an unambiguous prefix of the symbol.  If such
c  an unambiguous match is found the corresponding integer is returned.
c
c  If no match the value returned is (-1)
c  If an ambiguous match then value returned is (-2)
c
c  This routine assumes that everything has been translated to the
c  proper case (upper or lower) consistently and that there are no
c  leading spaces.
c
c	name		- input/string
c			  to match syn_name (*) exactly
c
c	symbol		- input/string
c			  to match syn_symbol (*) unambiguously
c
c	value		- output/integer
c			  translation of symbol
c			  a value of (-1) means no match
c			  a value of (-2) means ambiguous match
c			  a value of (-3) means no name match found
c			     this is usually a fatal error
c
c	full_symbol	- output/string
c			  if match is found the full name is returned
c			    for example if symbol is "ELL" then
c			    full symbol might be "ELLIPSE"
c--
	character*(*) name,symbol,full_symbol
c
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "syn.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'syn.inc'
#endif
c
c  arguments better not be blanks
c
	if (name .eq. ' ') then
	  message='TRANSLATE_SYNONYM: Name must not be blank'
	  call fatal
	endif
	if (symbol .eq. ' ') then
	  message='TRANSLATE_SYNONYM: Symbol must not be blank'
	  call fatal
	endif
c
c  assume no match
c
	name_match=0
	value=-1
	full_symbol=' '
c
c  trailing spaces aren't important - don't compare them
c
	l=min ( ltrim(symbol) , l_symbol)
c
	do i=1,n_syn
	  if (syn_name(i) .eq.  name) then
	    name_match=1
	    if (syn_symbol(i) (1:l) .eq. symbol(1:l)) then
	      if (value .lt. 0) then
		value=syn_value(i)
		full_symbol=syn_symbol(i)
	      else
c
c  More than one match - answer is ambiguous
c
	        value=-2
		full_symbol=' '
	        goto 999
	      endif
	    endif
	  endif
	enddo
c
c  Was there a match to the name (if not the symbol
c
	if (name_match .eq. 0) value=-3
c
 999	return
	end

	subroutine list_synonym (name,symbol)
	implicit integer (a-z)
c++
c	subroutine list_synonym (name,symbol)
c
c  name		- input/string
c		  name of variable to look up in table
c
c  symbol	- input/string
c		  symbol to be matched
c--
	character*(*) name,symbol
c
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "syn.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'syn.inc'
#endif
c
c  make a list of all matching names/values in syn tables
c
	l=ltrim(symbol)
	if (symbol .ne. ' ') then
	  do i=1,n_syn
	    if (name .eq. syn_name(i)) then
	      if (symbol(:l) .eq. syn_symbol(i)(:l)) then
	        call pushStr (syn_symbol(i))
	      endif
	    endif
	  enddo
	else
	  do i=1,n_syn
	    if (name .eq. syn_name(i)) then
	      call pushStr (syn_symbol(i))
	    endif
	  enddo
	endif
c
 999	return
	end

	subroutine format_e (name,value,string)
	implicit integer (a-z)
c++
c	subroutine format_e (name,value,string)
c
c  Converts integer representing enumeration value to the corresponding
c  string.  If no match puts in number
c
c	name		- input/string
c			  name of synonym variable
c
c	value		- input/integer
c			  number representing value
c
c	string		- output/string
c			  string representation of value
c--
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "syn.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'syn.inc'
#endif
c
	character*(*) name,string
c
	do i=1,n_syn	
	  if (syn_name(i) .eq. name .and.
     *		 syn_value(i) .eq. value) goto 100
	enddo
c
c  no match
c
	call format_i (value,string)
	goto 999
c
c  match
c
 100	string=syn_symbol(i)
c
 999	return
	end
