	subroutine convert (name,datatype,value,code)
	implicit integer (a-z)
c++
c	subroutine convert (name,datatype,value,code)
c
c  Calls the appropriate translation/conversion routine
c    for each datatype
c
c  Results are generally stored in ACC.INC variables
c
c  Assumes that leading blanks have been removed
c  String may have trailing blanks
c  Assumes that string is no longer than L_VAL characters
c
c	name		- input/string
c			  name of variable
c
c	datatype	- input/character*1
c			  datatype of variable (A/E/I/R/Y)
c
c	value		- input/string
c			  value to be converted
c			  must not be blank
c
c	code		- output/integer
c			    0 => success
c			    negative => failure
c			    positive not used
c--
	character*(*)	name
	character*(*)	value
	character*1	datatype
c
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "pushstr.inc"
#       include "acc.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'pushstr.inc'
	include 'acc.inc'
#endif
c
c
c  local copy of value
c
	character*(l_val) local
c
c  valid data types
c
	character*1 valid_type (5)
	data valid_type /'A','E','I','R','Y'/
c
c  handling of yes/no
c
	character*5 yesno_abbrev (10)
	data yesno_abbrev /'Y','YE','YES','ON','N','NO','OFF',
     *				'MAYBE','GUESS','DUNNO'/
	integer yesno_val (10)
	data yesno_val     / 1 , 1  , 1   , 1  , 0 , 0  , 0   ,
     *				 0     , 0     , 0     /
c
c  standard error messages
c
	character*60  et (6)
	data et(1)/'String contains non-printing characters'/
	data et(2)/'Not a recognized symbol or abbreviation'/
	data et(3)/'Abbreviation is ambiguous'/
	data et(4)/'Not an integer or not representable in 32 bits'/
	data et(5)/'Not a number or not representable as D.P. real'/
	data et(6)/'Acceptable responses are YES, NO, ON, or OFF'/
c
c  zero return values
c
	acc_int=0
	acc_real=0.0
	acc_string=' '
c
c  local copy of value
c
	local=value
c
c why does the following exist? Check/Fixme/Todo -- MK 11/18/96
c
#ifdef vms
	call upcase (local)
#else
	if (datatype .ne. 'A') then
	    call upcase (local)
	endif
#endif
c
c  get the string length
c
	l=ltrim (local)
c
c  find the datatype
c
	do i=1,5
	  if (datatype .eq. valid_type(i)) goto 20
	end do
c
c  fatal error - unrecognized data type
c
	write (message,1005) datatype,name
 1005	format ('CONVERT: Unrecognized datatype ("',a,'") for ',
     *		'variable "',a,'"')
	call fatal 
c
c  dispatch to proper routine
c
 20	goto (100,200,300,400,500),i
c
c  alphanumeric
c
 100	call verify (local,code)
	if (code .lt. 0) then
	  acc_err=-1
	else
          acc_string=local
	  acc_err=0
	endif
	goto 995
c
c  synonym
c    first check for non-printing characters
c
 200	call verify (local,code)
	if (code .lt. 0) then
	  acc_err=-1
	  goto 995
	endif
c
c  now check table
c
	call translate_synonym (name,local,acc_int,acc_string)
	if (acc_int .eq. -1) then
	  lpushstring=0
	  call pushStr('Use')
	  call list_synonym (name,' ')
	  acc_err=-2
	  acc_message=pushString(:lpushString)
	  goto 999
	else if (acc_int .eq. -2) then
	  lpushstring=0
	  call pushStr ('Ambiguous - Use')
	  call list_synonym (name,local)
	  acc_message=pushString(:lpushString)
	  acc_err=-3
	  goto 999
	else if (acc_int .eq. -3) then
	  write (message,205) local
 205	  format ('CONVERT: Name "',a,'" not in synonym table')
	  call fatal 
	else
	  acc_err=0
	endif
	goto 995
c
c  Integer
c
 300	read (local,1100,err=310) acc_int
#if defined(_AIX) || defined(rs6000) || defined(F2C) || defined(G77)
 1100	format (BN,i20)
#else
 1100	format (BN,i<l_val>)
#endif
	acc_err=0
	write (acc_string,1101) acc_int
#if defined(_AIX) || defined(rs6000) || defined(F2C) || defined(G77)
 1101	format (i20)
#else
 1101	format (i<l_val>)
#endif
	goto 995
c
c  Integer conversion error
c
 310	acc_err=-4
	goto 995
c
c  Validate default local for double precision fields
c
 400	read (local,1105,err=410) acc_real
#if defined(_AIX) || defined(rs6000) || defined(F2C) || defined(G77)
 1105	format (BN,D20.0)
#else
 1105	format (BN,D<l_val>.0)
#endif
	acc_err=0
	write (acc_string,1106) acc_real
 1106	format (g20.13)
	goto 995
c
c  Double precision conversion error
c
 410	acc_err=-5
	goto 995
c
c  Validate YES/NO field
c
 500	do i=1,10
	  if (local .eq. yesno_abbrev(i)) goto 510
	enddo
c
c  No match
c
	acc_err=-6
	goto 995
c
 510	acc_int=yesno_val (i)
	if (acc_int .eq. 0) then
	   acc_string='NO'
	else
	   acc_string='YES'
	endif
	acc_err=0
c
 995	if (acc_err .lt. 0) then
c
c  check that the problem isn't due to nonprinting characters
c
	  call verify (local,code)
	  if (code .eq. 0) then
	    acc_message=et (-acc_err)
	  else
	    acc_message=et (1)
	  endif
	else
	  call leftjustify (acc_string)
	  acc_message=' '
	endif
c
 999	code=acc_err
	return
	end
