/*
 * getarg.c - Routines to access argument line parameters from FORTRAN
 * Library  - Uses library libcxrl.olb (VMS)
 * 
 * Author: Mumit Khan <khan@xraylith.wisc.edu>
 *
 * Source: src/utils/io/getarg.c
 *
 * Log:	getarg.c
 * Revision 1.7  90/05/09  12:01:13  khan
 * Cleanup
 * 
 * Revision 1.6  90/05/01  14:31:02  khan
 * routine
 * 
 * Revision 1.5  90/04/12  20:48:29  khan
 * Cleanup
 * 
 * Revision 1.4  90/01/09  18:38:26  khan
 * Used GNU Malloc to avoid a SEGMENTATION VIOLATION error from malloc. It 
 * could be:
 *     a: My error (but very,very subtle).
 *     b: Bug in malloc (I don't know about that. It's pretty simple).
 *     c: Bug in Fortran compiler (More likely than b).
 * 
 * Revision 1.3  89/10/28  11:23:38  khan
 * Cleaned up extraneous stuff. Ignore.
 * 
 * Revision 1.2  89/10/28  11:09:55  khan
 * Fixed the bug in passing string descriptor to LIB$GET_FOREIGN. VMS
 * deals differently when the descriptor has dynamic string!!! I had
 * to fix the array size to use the LIB$ routine (instead of malloccing
 * the string space).
 * 
 * Revision 1.1  89/10/24  17:17:41  khan
 * Initial revision
 * 
 */

#ifdef VMS

#include <stdio.h>
#include <ssdef.h>
#include <descrip.h>
#include <string.h>
#include <stdlib.h>

#include "libcxrl.h"

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef NULL
#define NULL 0
#endif

#define STATIC static
#define PUBLIC 

#define MAXLINE BUFSIZ

#undef malloc
#undef calloc
#undef cfree
#undef free
#define malloc VAXC$MALLOC_OPT
#define calloc VAXC$CALLOC_OPT
#define free   VAXC$FREE_OPT
#define cfree  VAXC$CFREE_OPT

STATIC char **argv = NULL;
STATIC int argc = 0;
STATIC int args_read = FALSE;
STATIC char *routine;

PUBLIC int iargc ();
PUBLIC int getarg ();

typedef struct dsc$descriptor_s DESCRIPTOR;

PUBLIC int iargc () {

    char *args; 
    char arg_line [MAXLINE];
    $DESCRIPTOR (args_text, arg_line);
    int status;

    routine = (char *) xmalloc (sizeof ("iargc"));
    strcpy (routine, "iargc");

    if (args_read)
	return argc;
    else
	args_read = TRUE;

    if ((status = LIB$GET_FOREIGN (&args_text)) != SS$_NORMAL) {
	LIB$SIGNAL (status);
	LIB$STOP (1);
    }

    /* Null-terminate the string so C can deal with it */

    args = args_text.dsc$a_pointer;
    *(args + (int)args_text.dsc$w_length) = '\0';
    args = trim_leading_white (args);
    args = trim_trailing_white (args);

    /* now parse and install the damn thing */
    install (args);

    free (routine);
    return argc;
}

PUBLIC int getarg (index, arg)
int *index;
DESCRIPTOR *arg;
{

    int no_error = TRUE;

    routine = (char *) xmalloc (sizeof ("getarg"));
    strcpy (routine, "getarg");

    if (!args_read)
	iargc ();

    if ((*index > argc) || (*index < 0)) {
	error ("%s: Invalid argument index %d\n", routine, *index); 
	no_error = FALSE;
    }

    if (no_error)
	fix_fort_str (argv[*index-1], arg -> dsc$a_pointer, 
	    arg -> dsc$w_length);
    free (routine);
    return *index;
}

STATIC install (arglist)
char *arglist;
{
    
    register int done = FALSE;
    register char *temp = (char *) xmalloc (MAXLINE);

    if (!(temp = strtok (arglist, " ,"))) {
	argc = 0;
	return;
    }

    install_node (temp);
    argc = 1;

    while (temp = strtok (NULL, " ,")) {
	install_node (temp);
	argc ++;
    }

    /* now that all of them are installed in a link, create **argv */
    creat_argv ();
}

/* The list containing the queries and the corresponding values */

typedef struct BUFFER {
    char *str;
    struct BUFFER *next;
} BUFFER;

STATIC BUFFER *head = (BUFFER *) NULL;

STATIC install_node (str)
char *str;
{
    BUFFER *temp = (BUFFER *) xmalloc (sizeof (BUFFER));

    temp -> str = str;
    if (head == (BUFFER *) NULL) {
	head = temp;
	head -> next = (BUFFER *) NULL;
    }
    else {
	temp -> next = head;
	head = temp;
    }
}

STATIC creat_argv () {
    
    register int i = argc;
    register BUFFER *buf = head;

    argv = (char *) calloc (argc, sizeof (char *));
    for (; i--; buf = buf -> next) 
	argv [i] = buf -> str;
}

#else  /* !VMS */
/*
 * Keep certain compilers from complaining about empty compilation units
 * Damn you AIX xlc.
 */
static int junk_getarg_dummy;
#endif
