//
// job.h: EXCON Batch job interface.
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1991-1996 Mumit Khan
//
//

#ifndef excon_batch_job_h
#define excon_batch_job_h

#include <sys/types.h>		// for pid_t definition
#include "xrtypes.h"

/**************************************************************************/

class Stq;

/**************************************************************************/

class Job {
public:
    Job(const char* name, int jobid, pid_t pid);
    ~Job();

    int getjobid()		{ return jobid_; }
    pid_t getpid()		{ return pid_; }
    const char* getname()	{ return name_; }

    int getstatus()		{ return status_; }
    void setstatus(int status)	{ status_ = status; }

private:
    char* name_;
    int jobid_;
    pid_t pid_;
    int status_;
};

/**************************************************************************/

class JobMgr {
public:
    JobMgr(unsigned concurrent_limit = 1);
    ~JobMgr();

    bool freecpu();
    int execute_job(const char* scriptfile, int jobid);
    int wait_for_completed_job();
    int njobs_running();
    int reap_job(int& status);

private:
    Job* getjob(pid_t pid);
    void removejob(const Job* job);
    Job* addjob(const char* jobname, int jobid, pid_t pid);

private:
    int limit_;
    Stq* joblist_;		// List of 'Job's.
    Stq* donejobs_;		// waiting to be reaped by client.
};

/**************************************************************************/

#endif/*excon_batch_job_h*/
