C +++
C
C Source: src/source/id/undul_set.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: undul_set.F
C Revision 1.7  1992/01/22  21:55:34  cwelnak
C VMS devel updates/ B. Lai
C
C Revision 1.6  1992/01/21  17:34:42  cwelnak
C 6000 changes
C
C Revision 1.5  91/07/06  20:03:58  khan
C Grenoble and after. Minor changes
C 
C Revision 1.4  90/10/30  00:01:46  khan
C Fix Ultrix -> VMS things that got screwed up in VMS -> Ultrix.
C 
C Revision 1.3  90/07/18  19:40:19  khan
C Using Unix environment variable SHADOW_ENV_FILE and others to communicate
C with the shell script. 
C 
C Revision 1.2  90/07/17  23:10:08  khan
C Fix File OPEN=NEW to UNKNOWN for Unix.
C Replace the use of VMS LOGICALS to communicate with the driver script
C with "known" exit codes. Depending on the particular exit code, the
C driver (make_id, undul, etc) takes appropriate action. Caveat is,
C of course, that the exit code used in the programs MUST be kept the
C same as the ones used in the driver scripts.
C 
C Revision 1.1  90/07/17  15:36:38  khan
C Initial revision
C 
C 
C ---

C+++
C
C	PROGRAM		UNDUL_SET
C
C	PURPOSE		This is the program to
C			a) define all the parameters
C			b) write the (energy, theta, phi) array
C			c) write the parameters in a nemalist
C
C
C---
	PROGRAM		UNDUL_SET
	IMPLICIT	REAL*8	(A-H,O-Z)
C
C For unix, we cannot set symbol for the parent process to communicate
C as in VMS, so we pull the classic BSD kludge of writing the environment
C strings to a temporary file and then source'ing the file in the driver
C to script to export to the parent environment. The temporary file is
C given by SHADOW_ENV_FILE environment variable, and must be set before
C this program is called. This is usually set in the driver script that
C calls this program.
C
#ifndef vms
	CHARACTER*133	ENV_FILE
#endif
C

	DIMENSION	UPHI(31,31,51),UTHETA(31,51),UENER(51)
	DIMENSION	TSTART(10),TEND(10)
	LOGICAL		FLAG1,FLAG2

	CHARACTER*80	RSTRING,FNAME

#if defined(unix) || HAVE_F77_CPP
#	include 	"pre_rad.blk"
#elif defined(vms)
	INCLUDE		'PRE_RAD.BLK/LIST'
#endif

	NAMELIST	/PARAIN/	NCOMP,RCURR,ICOMP,BPASS,
     $					IANGLE,IAPERTURE,IEXTERNAL,
     $					FOUT,FIN,FTRAJ,EMIN,EMAX,
     $					THEMIN,THEMAX,PHIMIN,PHIMAX,
     $					NE,NT,NP,NCHECK,IOPT,ITER,IPASS,
     $					I_EDIV,EDIVX,EDIVY,FINT,IINT
C
C Read in namelist and trajectory file from EPATH
C
	WRITE(6,*) ' '
	WRITE(6,*) '*********************** UNDULATOR RADIATION ',
     $'***********************'
	WRITE(6,*) ' '
	write(6,*) 'Parameters from : '
	write(6,*) '	User interactive process   (0) '
	write(6,*) '	NAMELIST file		   (1) '
	INAME 		= IYES ('Choice : ')
C
	if (INAME.eq.1) then
C
C Read in the namelist file of parameters
C
	   FNAME	= RSTRING ('Namelist file : ')
	   OPEN	(31, FILE=FNAME, STATUS='OLD')
	   READ	(31,NML=PARAIN)
	   CLOSE	(31)
	else
	   CALL	UNDUL_SHADOW_IO
	   ITER	= 0
	end if
C
C Get parameters for REPORT
C
     	WRITE(6,*) 'How often do you want a report on calculations ?'
     	NCHECK	= IRINT ('E.G., 20, 50,... ? ')
C
C Set the symbol F_EXTERNAL to communicate with VMS command procedure.
C
#ifdef vms
	IF (IEXTERNAL.EQ.0) THEN
	  IRET	= LIB$SET_SYMBOL	('F_EXTERNAL','INTERNAL')
	ELSE
	  IRET	= LIB$SET_SYMBOL	('F_EXTERNAL','EXTERNAL')
	END IF
#else
C
C Write the environment strings to a file, so the driver script can source
C it. If tset can use this kludge, so can I.
C                 **GROSS HACK ALERT**
C
	CALL GETENV ('SHADOW_ENV_FILE', ENV_FILE)
	IF (ENV_FILE(1:10).EQ.'          ') THEN
	    WRITE (*,*) 
     $      'UNDUL_SET: Must set SHADOW_ENV_FILE environment string'
	    CALL EXIT (1)
	ENDIF
	OPEN (11, FILE=ENV_FILE, STATUS='UNKNOWN')
	REWIND (11)
	IF (IEXTERNAL.EQ.0) THEN
	  WRITE (11,*) 'setenv F_EXTERNAL INTERNAL'
	ELSE
	  WRITE (11,*) 'setenv F_EXTERNAL EXTERNAL'
	END IF
	CLOSE (11)
#endif
C
C Set the counters
C
	IPASS	= 0
C
C Read in the trajectory parameters.
C
	CALL	UREAD
C
C  compute the number of points and step size
C
	IF (EMAX.EQ.EMIN) THEN
	   NE    = 1
	   ESTEP = 0.0D0
	ELSE
     	   ESTEP  = (EMAX-EMIN)/(NE-1)
	END IF
C     	BDEL	= ABS(ESTEP)
C
     	IF (PHIMAX.EQ.PHIMIN) THEN
	  NP      = 1
	  PHISTEP = 0.0D0
     	ELSE	
     	 IF (NP.GT.1) THEN
	  PHISTEP   = (PHIMAX-PHIMIN)/(NP-1)	! open string of points
						! for 1 quadrant.
     	 ELSE
     	  PHISTEP = ABS ( PHIMAX - PHIMIN )
     	 END IF
     	END IF
C
     	IF (THEMAX.EQ.THEMIN) THEN
	  NT      = 1
	  THESTEP = 0.0D0
     	ELSE
     	 IF (NT.GT.1) THEN
 	  THESTEP   = (THEMAX-THEMIN)/(NT-1)	! open string of points
     	 ELSE
     	  THESTEP = ABS ( THEMAX - THEMIN )
     	 END IF
     	END IF
C
C Fill the arrays
C
	DO 19 K = 1, NE
	  UENER(K)	= EMIN + (K-1)*ESTEP
	  DO 29 J = 1, NT
	    UTHETA(J,K)	= THEMIN + (J-1)*THESTEP
	    DO 39 I = 1, NP
	      UPHI(I,J,K) = PHIMIN + (I-1)*PHISTEP
39	    CONTINUE
29	  CONTINUE
19	CONTINUE
C
C For theta, we put them at the ith harmonics.  
C The number of available points in theta, NTEMP, is normally NT minus the 2 
C end points (THEMIN and THEMAX).
C
	DO 49 K = 1, NE
	  ENER		= UENER(K)
	  RLAMDA 	= 12398.52/ENER*1.0D-10			! meter
	  DI		= 2.0/NCOMP
	  NHAR		= 0
	  NTEMP		= NT - 2
	  JSTART	= 2
C
C Fill in TSTART(i) and TEND(i), the boundary of the ith harmonics.  It 
C includes up to the 2nd minimum on either side of the harmonics.
C
	  DO 59 I = 1, 10
	    THE_1	= (I-DI)*RLAMDA/RLAU*(2.0*GA0**2) - 1.0 - 0.5*(RK**2)
	    THE_2	= (I+DI)*RLAMDA/RLAU*(2.0*GA0**2) - 1.0 - 0.5*(RK**2)
	    IF (THE_1.GE.0.0)	THE_1 = SQRT(THE_1/GA0**2)
	    IF (THE_2.GE.0.0)	THE_2 = SQRT(THE_2/GA0**2)
	    FLAG1	= (THE_1.GE.THEMIN).AND.(THE_1.LE.THEMAX)
	    FLAG2	= (THE_2.GE.THEMIN).AND.(THE_2.LE.THEMAX)
	    IF (FLAG1.OR.FLAG2) THEN
	      NHAR	= NHAR + 1
	      IF (FLAG1) THEN
		TSTART(NHAR)	= THE_1
	      ELSE
	        TSTART(NHAR)	= THEMIN
		NTEMP		= NTEMP + 1
		JSTART		= 1
	      END IF
	      IF (FLAG2) THEN
		TEND(NHAR)	= THE_2
	      ELSE
	        TEND(NHAR)	= THEMAX
		NTEMP		= NTEMP + 1
	      END IF
	    END IF
59	  CONTINUE
C
C If catch no harmonics, just keep the uniform distribution.
C
	  IF (NHAR.EQ.0) THEN			
	  ELSE
C
C Check for the unlikely case of overlap.
C
	    DO 69 I = 2, NHAR
	      IF (TSTART(I).LT.TEND(I-1))THEN
	 	TAV		= (TSTART(I) + TEND(I-1))/2.0
		TSTART(I)	= TAV + 1.0E-6
		TEND(I-1)	= TAV
	      END IF
69	    CONTINUE
C
C Spread the available points NTEMP to the various harmonics.
C
	    ND2	= NTEMP/NHAR
	    ND1	= NTEMP - ND2*(NHAR-1)
	    DO 79 I = 1, NHAR
	      IF (I.EQ.1) THEN
		ND 	= ND1
	      ELSE
		ND 	= ND2
	      END IF

	      TSTEP	= (TEND(I) - TSTART(I))/(ND-1)

	      DO 89 II = 1, ND
		UTHETA(JSTART,K)	= TSTART(I) + (II-1)*TSTEP
		JSTART			= JSTART + 1
89	      CONTINUE
79	    CONTINUE
	    UTHETA(1,K)		= THEMIN
	    UTHETA(NT,K)	= THEMAX
	  END IF
49	CONTINUE

C
C If starting from scratch, we need to write out the initial (energy, theta, 
C phi) array; otherwise, it already exists.
C
	IF (ITER.EQ.0) THEN
#ifdef vms
	  OPEN	(20, FILE='UPHOT.DAT',STATUS='NEW',FORM='UNFORMATTED')
#else
	  OPEN	(20, FILE='uphot.dat', STATUS='UNKNOWN', 
     $		FORM='UNFORMATTED')
	  REWIND (20)
#endif
	  WRITE	(20)	NE, NT, NP
	  DO 15 K = 1,NE
	     WRITE	(20)	UENER(K)
15	  CONTINUE
	  DO 25 K = 1,NE
	     DO 35 J = 1,NT
	  	WRITE	(20) UTHETA(J,K)
35	     CONTINUE
25	  CONTINUE
	  DO 45 K = 1,NE
	     DO 55 J = 1,NT
		DO 65 I = 1,NP
	           WRITE (20)	UPHI(I,J,K)
65		CONTINUE
55	     CONTINUE
45	  CONTINUE
	  CLOSE	(20)
	END IF
C
C Finally the namelist file
C
#ifdef vms
	OPEN	(21, FILE='UPHOT.PAR', STATUS='NEW')
#else
	OPEN	(21, FILE='uphot.par', STATUS='UNKNOWN')
	REWIND	(21)
#endif
	WRITE	(21, NML=PARAIN)
	CLOSE	(21)

	END

