C +++
C
C Source: src/source/id/uinvert.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	uinvert.F
C Revision 1.6  91/07/06  20:03:58  khan
C Grenoble and after. Minor changes
C 
C Revision 1.5  91/04/01  10:33:54  khan
C Replace DO WHILE's with GOTO's.
C SUN port.
C 
C Revision 1.4  91/03/25  13:41:10  khan
C DO WHILE to GOTO's
C 
C Revision 1.3  90/10/30  00:01:43  khan
C Fix Ultrix -> VMS things that got screwed up in VMS -> Ultrix.
C 
C Revision 1.2  90/07/17  23:04:54  khan
C Fixed STATUS=NEW in OPEN statements to UNKNOWN for Unix.
C Substitue pre_rad.blk for PRE_RAD.BLK
C 
C Revision 1.1  90/07/17  15:36:37  khan
C Initial revision
C 
C 
C ---

C+++
C
C	SUBROUTINE		UINVERT
C
C	PURPOSE			1) invert the CDFs so that they are equal space 
C				   in the probability (Y-axis)
C				2) create a new set of (energy, theta, phi) 
C				   corresponds to the probability.
C
C	INPUT:			CDF0,CDF1,CDF2,UPHI,UTHETA,UENER
C
C	OUTPUT:			AENER,ATHETA,APHI
C
C---
	SUBROUTINE		UINVERT	(CDF0,CDF1,CDF2,UPHI,UTHETA,UENER,
     $					 APHI,ATHETA,AENER)
	
	IMPLICIT		REAL*8	(A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#	include 		"pre_rad.blk"
#elif defined(vms)
	INCLUDE			'PRE_RAD.BLK/LIST'
#endif

	DIMENSION		UPHI(31,31,51),UTHETA(31,51),UENER(51)
	DIMENSION		CDF0(31,31,51),CDF1(31,51),CDF2(51)
	DIMENSION		APHI(31,31,51),ATHETA(31,51),AENER(51)

	DIMENSION		XY(2,201),X_NEW(201)

C
C ADJUST is the allowed movement for INV_LINEAR.
C
	ADJUST	= 1.0/NCOMP

	IF (IPASS.EQ.0) THEN
	  GO TO 10
	ELSE IF (IPASS.EQ.1) THEN
	  DO 19 K = 1, NE
 19	    AENER(K)	= UENER(K)
	  GO TO 20
	ELSE IF (IPASS.EQ.2) THEN
	  DO 29 K = 1, NE
	    AENER(K)	= UENER(K)
	    DO 29 J = 1, NT
 29	      ATHETA(J,K)	= UTHETA(J,K)
	  GO TO 30
	END IF

C
C First invert the energy.
C	
10	DO 39 K = 1, NE
	  XY(1,K)	= UENER(K)
	  XY(2,K)	= CDF2(K)
 39	CONTINUE
	CALL	INV_LINEAR	(XY,NE,X_NEW,ADJUST)
	DO 49 K = 1, NE
 49	  AENER(K)	= X_NEW(K)
C
C Then theta.
C
20	KSTART	= 1
	DO 59 K = 1, NE
	  ENER	= AENER(K)

C +++
C Replace DO ... WHILE with standard stuff.
C
C	  DO WHILE (ENER.GT.UENER(KSTART))
C	    KSTART	= KSTART + 1
C	  END DO
C
C ---
 69	CONTINUE
	  IF (ENER.GT.UENER(KSTART)) THEN
	    KSTART	= KSTART + 1
	    GOTO 69
	  END IF

	  DO 79 J = 1, NT
	    XY(1,J)	= UTHETA(J,KSTART)
	    XY(2,J)	= CDF1(J,KSTART)
 79	CONTINUE
	  CALL	INV_LINEAR	(XY,NT,X_NEW,ADJUST)
	  DO 89 J = 1, NT
 89	    ATHETA(J,K)	= X_NEW(J)
 59	CONTINUE
C
C Now phi.
C
30	KSTART	= 1
	DO 99 K = 1, NE
	  ENER	= AENER(K)
C +++
C Replace DO ... WHILE with standard stuff.
C	  DO WHILE (ENER.GT.UENER(KSTART))
C	    KSTART	= KSTART + 1
C	  END DO
C ---
C
 109	  CONTINUE
	  IF (ENER.GT.UENER(KSTART)) THEN
	    KSTART	= KSTART + 1
	    GOTO 109
	  ENDIF
C
	  JSTART	= 1
	  DO 119 J = 1, NT
	    THETA	= ATHETA(J,K)
C +++
C Replace DO ... WHILE with standard stuff.
C
C	    DO WHILE (THETA.GT.UTHETA(JSTART,KSTART))
C	      JSTART	= JSTART + 1
C	    END DO
C ---
C
 129	    CONTINUE
	    IF (THETA.GT.UTHETA(JSTART,KSTART)) THEN
	      JSTART	= JSTART + 1
	      GOTO 129
	    ENDIF
C
	    DO 139 I = 1, NP
	      XY(1,I)	= UPHI(I,JSTART,KSTART)
	      XY(2,I)	= CDF0(I,JSTART,KSTART)
 139  	    CONTINUE
	    CALL	INV_LINEAR	(XY,NP,X_NEW,ADJUST)
	    DO 149 I = 1, NP
 149	      APHI(I,J,K)	= X_NEW(I) 
 119	CONTINUE
 99	CONTINUE

	RETURN

	END

