C+++
C     ..................................................................
C
C        SUBROUTINE SIMPSON
C
C        PURPOSE
C           To compute the integral using Simpson's rule.
C
C        USAGE
C           CALL QSF (H,Y,Z,NDIM)
C
C        DESCRIPTION OF PARAMETERS
C           H      - THE INCREMENT OF ARGUMENT VALUES.
C           Y      - THE INPUT VECTOR OF FUNCTION VALUES.
C           Z      - THE RESULTING INTEGRAL
C           NDIM   - THE DIMENSION OF VECTORS Y 
C
C     ..................................................................
C---
      	SUBROUTINE SIMPSON(H,Y,Z,NDIM)
	IMPLICIT REAL*8		(A-H,O-Z)
      	DIMENSION		Y(NDIM)
C
      	HT=1.0D0/3.0D0*H

	SUM	= Y(1) 
	DO 29 I = 2, NDIM-1, 2
	  SUM	= SUM + 4.0*Y(I)
	  SUM	= SUM + 2.0*Y(I+1)
29	CONTINUE	
	SUM 	= SUM - Y(NDIM)
	Z	= HT*SUM

	RETURN
      	END
