C +++
C
C Source: src/source/id/nphoton.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: nphoton.F
C Revision 1.6  1991/07/06  20:03:47  khan
C Elliptical Undulator by Sylvia Difonzo
C
C
C Revision 1.6 91/06/22  di fonzo - singh
C Added option for elliptical wiggler
C
C Revision 1.5  91/04/05  14:47:36  cwelnak
C changed quotes on #includes
C 
C Revision 1.4  91/03/21  15:24:43  cwelnak
C SUN version -- changes INCLUDE to #include
C 
C Revision 1.3  90/10/30  00:01:37  khan
C Fix Ultrix -> VMS things that got screwed up in VMS -> Ultrix.
C 
C Revision 1.2  90/07/17  23:04:51  khan
C Fixed STATUS=NEW in OPEN statements to UNKNOWN for Unix.
C 
C Revision 1.1  90/07/17  15:36:34  khan
C Initial revision
C 
C 
C ---

C+++
C	PROGRAM		NPHOTON
C
C	PURPOSE		To take the output from EPATH and compute the no. of
C			photons generated along the trajectory. The output is
C			a file for input to SOURCE running the wiggler case.
C
C	NOTE		Everything is in SHADOW's referance frame.
C---
	IMPLICIT	REAL*8	(A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#	include		<dim.par>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif
	DIMENSION	Y(N_DIM),BETAY(N_DIM),X(N_DIM),BETAX(N_DIM)
	DIMENSION	CURV(N_DIM),PHOT_NUM(N_DIM),PHOT_CDF(N_DIM)
	DIMENSION	Z(N_DIM),BETAZ(N_DIM),DS(N_DIM),S(N_DIM)
	DIMENSION	DX(N_DIM), DY(N_DIM), DZ(N_DIM)
        DIMENSION       TAUX(1001),TAUY(1001),TAUZ(1001)
        DIMENSION       BX(1001),BY(1001),BZ(1001)
        DIMENSION       ENX(1001),ENY(1001),ENZ(1001)
	CHARACTER*80	INFILE,OUTFILE,RSTRING
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64769 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /
C
C Read in the CDF of G0, and generated the spline coefficients.
C
	IFLAG	= -1
	CALL	NPHOTON (PNUM,RAD,BENER,EMIN,EMAX,IFLAG)
C
	WRITE(6,*) ' '
	WRITE(6,*) '************************ WIGGLER RADIATION ',
     $'*************************'
	WRITE(6,*) ' '
	INFILE	= RSTRING ('Name of input file : ')
C	
C	(I_WIG.EQ.1) implies normal wiggler.
C	(I_WIG.EQ.2) implies elliptical wiggler.
C
        WRITE(6,*) ' '
        WRITE(6,*) 'Type of Wiggler.'
        WRITE(6,*) 'Enter:'
        WRITE(6,*) 'for normal wiggler   [1]'
        WRITE(6,*) 'for elliptical wiggler [2]'
        I_WIG=IRINT('Then? ')
C
#ifdef vms
	OPEN	(20,FILE=INFILE,STATUS='OLD',READONLY)
#else
	OPEN	(20,FILE=INFILE,STATUS='OLD')
#endif
C
	DO 99 I = 1, N_DIM+1
	  READ	(20,*,END=101)	X(I),Y(I),Z(I),BETAX(I),BETAY(I),BETAZ(I),
     $    CURV(I)
 99	CONTINUE
	STOP 	'Too many points from input file.'
101	NP	= I - 1
	CLOSE	(20)
	WRITE(6,*) 'Read ',NP,' points from input file.'
	STEP	= SQRT((Y(2)-Y(1))**2 + (X(2)-X(1))**2 + (Z(2)-Z(1))**2)
C
C Compute gamma and the beam energy
C
	GAMMA	= 1/SQRT(1-(BETAY(1)**2)-(BETAX(1)**2)-(BETAZ(1)**2))
	BENER	= GAMMA*(9.109D-31)*(2.998d8**2)/(1.602e-19)*1.0d-9
 	WRITE(6,*) 'Beam energy (GeV) = ',BENER
C
C Figure out the limit of photon energy.
C
	CURV_MAX	= 0.0D0
	CURV_MIN	= 1.0D20
	DO 199 I = 1, NP
	  CURV_MAX	= MAX(ABS(CURV(I)),CURV_MAX)
	  CURV_MIN	= MIN(ABS(CURV(I)),CURV_MIN)
 199	CONTINUE
	WRITE(6,*) 'Radius of curvature (max.) = ',1/CURV_MIN,' m'
	WRITE(6,*) '                    (min.) = ',1/CURV_MAX,' m'
	PHOT_MIN	= TOANGS*3.0D0*GAMMA**3/4.0D0/PI/1.0D10*CURV_MIN
	PHOT_MAX	= TOANGS*3.0D0*GAMMA**3/4.0D0/PI/1.0D10*CURV_MAX
	WRITE(6,*) 'Critical Energy (max.) = ',PHOT_MAX,' eV'
	WRITE(6,*) '                (min.) = ',PHOT_MIN,' eV'
C	WRITE(6,*) 'Use photon energy between ',
C     $		PHOT_MAX*10,' eV and ',PHOT_MIN*1.0D-5,' eV'
C
	EMIN	= RNUMBER ('Initial photon energy [ eV ] : ')
	EMAX	= RNUMBER ('Final photon energy [ eV ]   : ')
	OUTFILE	= RSTRING ('Name of output file : ')
C
C NPHOTON computes the no. of photons per mrad (ANG_NUM) at each point.  
C It is then used to generate the no. of photons per axial length (PHOT_NUM)
C along the trajectory S.
C
	DO 299 I = 1, NP
	  IF (ABS(CURV(I)).LT.1.0D-10) THEN
	    ANG_NUM	= 0.0D0	
	  ELSE
	    RAD	= ABS(1.0D0/CURV(I))
	    IFLAG = 1
	    CALL	NPHOTON (ANG_NUM,RAD,BENER,EMIN,EMAX,IFLAG)
	  END IF
	  PHOT_NUM(I) = 
     $      ANG_NUM*ABS(CURV(I))*SQRT(1+(BETAX(I)/BETAY(I))**2+
     $    (BETAZ(I)/BETAY(I))**2)*1.0D3
C       WRITE(6,*) PHOT_NUM(I)
299     CONTINUE
C
C Computes CDF of the no. of photon along the trajectory S.
C In the elliptical case, the entire traversed path length (DS) is computed.
C In the normal case, only the component (Y) in the direction of propagation
C is computed.
C
	 DO 399 I = 2, NP
	IF (I_WIG.EQ.2) THEN
	  DS(1) = 0.0D0
		DX(I) = X(I) - X(I-1)
		DY(I) = Y(I) - Y(I-1)
		DZ(I) = Z(I) - Z(I-1)
		DS(I) = SQRT(DX(I)**2 + DY(I)**2 + DZ(I)**2) + DS(I-1)
C          WRITE(6,*)  DS(I)
	   PHOT_CDF(I)	= PHOT_CDF(I-1) + 
     $			(PHOT_NUM(I-1) + PHOT_NUM(I))*0.5D0*(DS(I) - DS(I-1))
C          WRITE(6,*) PHOT_CDF(I)
	ELSE
	   PHOT_CDF(I)	= PHOT_CDF(I-1) + 
     $			(PHOT_NUM(I-1) + PHOT_NUM(I))*0.5D0*(Y(I) - Y(I-1))
	END IF
 399     CONTINUE
	 TOT_NUM	= PHOT_CDF(NP)
	 WRITE(6,*) 'Total no.of photons = ',TOT_NUM
C
C Creates the binary file that serves as input to SHADOW.
C
#ifdef vms
	 OPEN	(21,FILE=OUTFILE,STATUS='NEW',FORM='UNFORMATTED')
#else
	 OPEN	(21,FILE=OUTFILE,STATUS='UNKNOWN',FORM='UNFORMATTED')
	 REWIND	(21)
#endif
	 WRITE	(21)	NP,STEP,BENER,1.0D0/CURV_MAX,1.0D0/CURV_MIN,EMIN,EMAX
	 DO 499 I = 1, NP
	   CDF		= PHOT_CDF(I)/TOT_NUM
         IF (I_WIG.EQ.2) THEN
           ANGLE1               = ATAN2 (BETAX(I),BETAY(I))
           ANGLE2               = ASIN  (BETAZ(I))
           WRITE        (21)    X(I),Y(I),Z(I),CDF,ANGLE1,ANGLE2,
     $                          CURV(I)
         ELSE
	   ANGLE		= ATAN2 (BETAX(I),BETAY(I))
	   WRITE	(21)	X(I),Y(I),CDF,ANGLE,CURV(I)
C
         ENDIF
 499	 CONTINUE
	CLOSE	(21)
	END
C+++
C	SUBROUTINE	NPHOTON
C
C	PURPOSE		IFLAG = -1, to read the unformatted CDF for SR 
C			radiation, and produce the spline coefficients for it.
C			
C			IFLAG = 1, to compute the number of photons emitted 
C			between	EMIN and EMAX.
C
C       ARGUMENTS       TOT_NUM, output, contains the # of photons
C                       per mrad of orbit.
C
C                       RAD, input, radius in m of the trajectory.
C
C                       BENER, beam energy in GeV.
C
C                       EMIN, input, initial photon energy
C
C                       EMAX, input, final photon energy
C
C                       IFLAG, on input, if = -1 sets up calculations;  
C                       if = 0, performs calculations; on output, if = 0
C                       everything is all right; if (IFLAG.NE.0), error status.
C---
	SUBROUTINE	NPHOTON (TOT_NUM,RAD,BENER,EIMIN,EIMAX,IFLAG)
	IMPLICIT	REAL*8	(A-H,O-Z)
     	REAL*8		PHOT_INV(5,1010),Y(1010)
	REAL*8		EMAX,EMIN,CMAX,CMIN,CDIFF
     	
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64769 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /
	COMMON	/LOCALNP/  NP
	CHARACTER*132	SRDISTR
	SAVE	PHOT_INV
C
C Define the useful parameters
C
	EX_LOW	= -5.0D0	
	EX_UPP	= 1.0D0
	EX_STEP	= (EX_UPP - EX_LOW)*1.0D-3
	
	IF (IFLAG.EQ.-1) THEN
C
C Get the data file path using either SHADOW$DATA or Unix SHADOW_DATA_DIR
C environment variable. Also, check for existence in the routine itself.
C
	  IFLAG = 1
	  CALL DATAPATH ('SRDISTR', SRDISTR, IFLAG) 
	  IF (IFLAG.NE.0) THEN
	    CALL LEAVE ('NPHOTON', 'SRDISTR file not found', IFLAG)
	  ENDIF
#ifndef vms
     	  OPEN	(20, FILE=SRDISTR(1:IBLANK(SRDISTR)), STATUS='OLD', 
     $		FORM='UNFORMATTED')
#else /* vms */
C
C Under VMS, there used to be individuals logicals for SR* files, and
C that is stupid. Now all common/shared data files are pointed to by
C SHADOW$DATA logical as in Ultrix version.
C
	  OPEN	(20, FILE=SRDISTR, STATUS='OLD', READONLY,
     $		 FORM='UNFORMATTED')
#endif
	  READ 	(20)	ICOL,NP
C
C Reads in the total flux distribution
C
	  DO 99 I = NP, 1, -1
	    READ	(20)	PHOT_INV(1,I),Y(I)
	    Y(I)	= 1.0 - Y(I)
 99	  CONTINUE
	  CLOSE 	(20)
C
C Produces the inverted cdf curve of photon energy
C
	  CALL CUBSPL  (PHOT_INV,Y,NP,IER)
	  RETURN
	ELSE
C
C Calculate the appropriate index for EIMAX and EIMIN
C
	  GAMMA	= 1957.0D0*BENER
	  R_LAM	= 4.0D0*PI*RAD/3.0D0/GAMMA**3*1.0D10	!Angstroms
	  C_PHOT= TOANGS/R_LAM
	  EMIN	= EIMIN/C_PHOT
	  EMAX	= EIMAX/C_PHOT
C
C Interpolate for the probability between EMIN and EMAX.
C
	  IF (EMAX.GT.10.0**EX_UPP) THEN
	    CMAX = 1.0D0
	  ELSE IF (EMAX.LT.10.0**EX_LOW) THEN
	    CALL LEAVE
     $	  ('NPHOTON','Maximum photon energy is too small.',0)
	    IFLAG	= -1
	    RETURN
	  ELSE
	    CALL SPL_INT (PHOT_INV,NP,EMAX,CMAX,IER)
	  END IF
	  IF (EMIN.GT.10.0**EX_UPP) THEN
	    CMIN = 1.0D0
	  ELSE IF (EMIN.LT.10.0**EX_LOW) THEN
	    CALL LEAVE
     $	  ('NPHOTON','Minimum photon energy is too small.',0)
	    IFLAG	= -1
	    RETURN
	  ELSE
	    CALL SPL_INT (PHOT_INV,NP,EMIN,CMIN,IER)
	  END IF
	  CDIFF	= CMAX - CMIN
C
C G0_TOT is the total area of the G0 curve.
C TOT_NUM is the Photons/sec/mA/mrad between EMIN and EMAX.
C
	  CDIFF		= CDIFF * 5.097721285019080
	  TOT_NUM	= CDIFF * 1.013D6 * TOANGS * GAMMA 
	  IFLAG	= 1
	  RETURN
	END IF
	END
